	title	'Boot loader module for CP/M 3.0 - CP/Mega88'
;
; I am using the original copyright messages in the code. I do realize
; ownership resides with someone else (currently Linero, I believe).
;

true equ -1
false equ not true

banked	equ true

	public	?init
	public	?ldccp,?rlccp,?time
	extrn	?pmsg,?conin
	extrn	@civec,@covec,@aivec,@aovec,@lovec
	extrn @cbnk,@bnkbf,@dtbl,@rdrv,?stbnk,mnttab
	extrn ?xmove,?move

SD$DSK	equ	10		; disk drive
SD$TKL	equ	11		; disk track low
SD$TKH	equ	12		; disk track high
SD$SEC	equ	13		; disk sector
SD$CMD	equ	14		; disk command
SD$STAT	equ	15		; disk status
DMA$L	equ	16		; dma address low
DMA$H	equ	17		; dma address high

bdos	equ 5
start$ccp		equ 36	; start sector of CCP on track 0
length$ccp	equ 25	; length of CCP in 128b blocks

	if banked
tpa$bank	equ 1
	else
tpa$bank	equ 0
	endif

	dseg	; init done from banked memory

?init:
	di
	lda 0 ! sta mnttab ! out SD$DSK	; retrieve and set boot volume
	inr a ! sta mnttab+1				; assign next two volumes
	inr a ! sta mnttab+2				; to b: and c:
	lxi h,8000h
	shld @civec ! shld @covec		; assign console to CON:
	mvi h,40h ! shld @lovec			; assign printer to LPT:
	mvi h,20h ! shld @aovec			; assign AUXOUT to PTP:
	mvi h,10h ! shld @aivec 		; assign AUXIN to PTR:

	lxi h,signon$msg ! call ?pmsg		; print signon message

	ret	

signon$msg:
	db 0Dh,0Ch,0Dh,0Ah
	db 'CP/Mega88 brainchild of Takashi Toyoshima',0Dh,0Ah
	db '61.5K CP/M 3.1 banked BIOS V1.2 (i8080)',0Dh,0Ah
	db 'CP/M 3.1 (c) 1982, Digital Research',0Dh,0Ah,0Dh,0Ah,0

	cseg	; boot loading must be done from resident memory
	; This version of the boot loader loads the CCP from a
	; reserved block of memory in bank 2.
	; This was put in place bij the bootloader on disk sector 0. 
    
?ldccp:
	lxi h,bios$msg ! call ?pmsg
?rlccp:
	; DE=source, HL=dest. return DE,HL after move 
	lxi d,100h ! lxi h,100h ! mvi b,26
rlnext:
  push b
	; destination bank in B source bank in C
  mvi b,tpa$bank ! mvi c,2 ! call ?xmove		; setup interbank move
	; BC = block size
  lxi b,80h ! call ?move			; perform interbank move
  pop b ! dcr b ! jnz rlnext	; do 26 times
	ret

?time:
	ret

bios$msg:
	db 0Dh,0Ah,0Dh,0Ah,'CCP Ver. 3.1',0Dh,0Ah,00

	end
