	title 'Character I/O handler - CP/Mega88'

; Character I/O for the Modular CP/M 3 BIOS


	public	?cinit,?ci,?co,?cist,?cost
	public	@ctbl

CON$ST	equ	0		; console status port
CON$D	equ	1		; console data port
LST$ST	equ	2		; printer status port
LST$D	equ	3		; printer data port
AUX$D	equ	5		; auxiliary data port
SD$DSK	equ	10		; disk drive
SD$TKL	equ	11		; disk track low
SD$TKH	equ	12		; disk track high
SD$SEC	equ	13		; disk sector
SD$CMD	equ	14		; disk command
SD$STAT	equ	15		; disk status
DMA$L	equ	16		; dma address low
DMA$H	equ	17		; dma address high
BANK	equ	18		; select memory bank

max$devices	equ 2

	cseg


?cinit:	ret

	; character input
?ci:	in CON$D
	ret

	; character input status
?cist:	in CON$ST
	ret

	; character output
?co:	mov a,c ! out CON$D
	ret

	; character output status
	; Status byte D2=TX Buff Empty, D0=RX char ready
?cost:	mvi a,0FFh
	ret

@ctbl:	db 'CRT   ',03h,00h	; in/out
	db 'LPT   ',02h,00h	; output
	db 'PTP   ',02h,00h	; output
	db 'PTR   ',01h,00h	; input
	db 00

	end
