	title 'SD-card driver - CP/Mega88'

;    CP/M-80 Version 3     --  Modular BIOS

;	Disk I/O Module for SD-card interface - CP/Mega88

	;	Version 1.2,

	dseg

    ; Disk drive dispatching tables for linked BIOS

	public	rhd0,rhd1,rhd2
	public	dmount,mnttab

    ; Variables containing parameters passed by BDOS

	extrn	@adrv,@rdrv
	extrn	@dma,@trk,@sect
	extrn	@cbnk,@dbnk
	extrn	@dtbl

    ; System Control Block variables

	extrn	@ermde,@media	; BDOS error mode, media flag

    ; Utility routines in standard BIOS

	extrn	?wboot	; warm boot vector
	extrn	?pmsg	; print message @<HL> up to 00, saves <BC> & <DE>
	extrn	?pdec	; print binary number in <A> from 0 to 99.
	extrn	?pderr	; print BIOS disk error header
	extrn	?conin,?cono	; con in and out
	extrn	?const		; get console status
	extrn	?bank

    ; Port Address Equates
CON$ST	equ	0		; console status port
CON$D	equ	1		; console data port
LST$ST	equ	2		; printer status port
LST$D	equ	3		; printer data port
AUX$D	equ	5		; auxiliary data port
SD$DSK	equ	10		; disk drive
SD$TKL	equ	11		; disk track low
SD$TKH	equ	12		; disk track high
SD$SEC	equ	13		; disk sector
SD$CMD	equ	14		; disk command
SD$STAT	equ	15		; disk status
DMA$L	equ	16		; dma address low
DMA$H	equ	17		; dma address high
BANK	equ	18		; select memory bank


    ; common control characters

cr	equ 13
lf	equ 10
bell	equ 7


    ; Extended Disk Parameter Headers (XPDHs)

	; disk A:
	dw sd$write
	dw sd$read
	dw sd$login
	dw sd$init
	db 0,0			; relative drive zero
rhd0:	dw 0			; XLT
	db 0,0,0,0,0,0,0,0,0	; null
	db 0			; MF
	dw dpbh			; DPB
	dw 0FFFEh		; CSV
	dw 0FFFEh		; ALV
	dw 0FFFEh		; DIRBCB
	dw 0FFFFh		; DTABCB -- no buffer needed
	dw 0FFFEh		; HASH
	db 0h		; HBANK

	; disk B:
	dw sd$write
	dw sd$read
	dw sd$login
	dw sd$init
	db 1,0			; relative drive one
rhd1:	dw 0			; XLT
	db 0,0,0,0,0,0,0,0,0	; null
	db 0			; MF
	dw dpbh			; DPB
	dw 0FFFEh		; CSV
	dw 0FFFEh		; ALV
	dw 0FFFEh		; DIRBCB
	dw 0FFFFh		; DTABCB
	dw 0FFFEh		; HASH
	db 0h		; HBANK

	; disk C:
	dw sd$write
	dw sd$read
	dw sd$login
	dw sd$init
	db 2,0		; relative drive two
rhd2:	dw 0			; XLT
	db 0,0,0,0,0,0,0,0,0	; null
	db 0			; MF
	dw dpbh			; DPB
	dw 0FFFEh		; CSV
	dw 0FFFEh		; ALV
	dw 0FFFEh		; DIRBCB
	dw 0FFFFh		; DTABCB
	dw 0FFFEh		; HASH
	db 0h		; HBANK


	cseg	; DPB must be resident

	; 8 MB, psize=512, pspt=32, tks=512, bls=4k, ndirs=512, off=1

dpbh:
	dw 128		; SPT - sectors per track
	db 5		; BSH - block shift factor
	db 31		; BLM - block mask
	db 1		; EXM - Extent mask
	dw 2043		; 2047-4) DSM - Storage size (blocks - 1)
	dw 511		; DRM - Number of directory entries - 1
	db 240		; AL0 - 1 bit set per directory block
	db 0		; AL1 -            "
	dw 8000h	; CKS - DIR check vector size (DRM+1)/4
	dw 1		; OFF - Reserved tracks
	db 0		; PSH - the virtual machine does block/deblock
	db 0		; PSM

mnttab:		; bank 0 and 1 are used for FAT-16 segment
	db -1		; A:
	db -1		; B:
	db -1		; C:
	db -1		; always find unmounted at the end


	dseg	; This is banked

sdtbl: dw rhd0,rhd1,rhd2	; shadow drivetable

dmount:		; on entry D=volume (0-FE), E=logical drive (0-2)
	lxi h,mnttab ! push h			; save for later
	mvi a,2 ! cmp e ! jc mount$nogo1	; drive > 2
	mov a,d ! mvi b,4
cpir: cmp m ! jz mount$nogo ! inx h  ; volume already mounted?
	dcr b ! jnz cpir

mount$go:					; a = volume number e=drive
	pop h					; reclaim mounttable
	mvi d,0 ! dad d ! mov m,a ! push psw	; update mounttable
	mov l,e ! mvi h,0 ! dad h ! push h	; create index from drive code
	lxi d,sdtbl ! dad d			; get pointer to shadow dtbl
	mov a,m ! inx h ! mov h,m ! mov l,a	; point at DPH
	push h
	xchg ! lxi h,11 ! dad d			; point at MF in DPH
	mvi a,0FFh ! mov m,a ! sta @media	; set media flags
	pop b ! lxi d,@dtbl ! pop h ! dad d	; DBH addr in BC; @dtbl in HL
	mov m,c ! inx h ! mov m,b		; store DPH address in dtbl
	pop psw ! ret				; DE is address mnttab, ok, ret
mount$nogo:
	pop h ! mvi d,0 ! dad d ! mov a,m ! ret	; DE is mnttab, nok, ret
mount$nogo1:
	pop h ! mvi a,-1 ! ret
	
	; Disk I/O routines for standardized BIOS interface

	; Disk initialization

	; called for first time initialization.


sd$init:
	ret

sd$login:
	ret				; no disk and return

	; Disk READ and WRITE entry points.

		; these entries are called with the following arguments:

			; relative drive number in @rdrv (8 bits)
			; absolute drive number in @adrv (8 bits)
			; disk transfer address in @dma (16 bits)
			; disk transfer bank	in @dbnk (8 bits)
			; disk track address	in @trk (16 bits)
			; disk sector address	in @sect (16 bits)
			; pointer to XDPH in <DE>

		; they transfer the appropriate data, perform retries
		; if necessary, then return an error code in <A>
		; -1=media error, 1=permanet error, 0=ok


	cseg	; bank switching ahead...

sd$read:
	xra a
	push psw
	jmp disk$io		; to perform the actual i/o

sd$write:
	mvi a,1
	push psw

disk$io:
	lhld @dma		; set DMA
	mov a,l ! out DMA$L
	mov a,h ! out DMA$H
	lda @adrv ! mov c,a	; set disk volume
	mvi b,0 ! lxi h,mnttab	; offset in mounttable
	dad b ! mov a,m ! out SD$DSK 
	lhld @trk		; set track
	mov a,l ! out SD$TKL
	mov a,h ! out SD$TKH
	lhld @sect		; set sector
	mov a,l ! out SD$SEC
	lda @dbnk ! call ?bank	; set bank
	pop psw ! out SD$CMD	; perform i/o action
	lda @cbnk ! call ?bank
	xra a 
	ret

	end
