	title 'bank & move module for CP/M3 linked BIOS - CP/Mega88'

	cseg

	public ?move,?xmove,?bank
	extrn @cbnk

;	maclib z80

    ; Port Address Equates
CON$ST	equ	0		; console status port
CON$D	equ	1		; console data port
LST$ST	equ	2		; printer status port
LST$D	equ	3		; printer data port
AUX$D	equ	5		; auxiliary data port
SD$DSK	equ	10		; disk drive
SD$TKL	equ	11		; disk track low
SD$TKH	equ	12		; disk track high
SD$SEC	equ	13		; disk sector
SD$CMD	equ	14		; disk command
SD$STAT	equ	15		; disk status
DMA$L	equ	16		; dma address low
DMA$H	equ	17		; dma address high
BANK	equ	18		; select memory bank



?xmove:		; destination bank in B source bank in C, no return values
	mov a,b ! sta xdst
	mov a,c ! sta xsrc
	mvi a,1 ! sta xflg
	ret

xdst:	ds 1		; stores destination bank
xsrc:	ds 1		; stores source bank
xflg:	db 0		; interbank transfer flag 0=local 1=xmove
xbuf:	ds 128	; common memory databuffer

?move:		; DE=source, HL=dest. return DE,HL after move 
	lda xflg ! dcr a ! jz movx	; check for ?xmove: go to interbank move
ldir:	ldax d ! mov m,a		; DE - source, HL = dest, BC = length
	inx d ! inx h ! dcx b 
	mov a,b ! ora c ! jnz ldir
	ret


movx:	; according to documentation the data is never more than 128 bytes
	xra a ! sta xflg					; reset flag
	lda xsrc ! call ?bank			; use source bank
	push h ! push b						; used for second part
	lxi h,xbuf ! call ldir		; dest = local buffer
	lda xdst ! call ?bank			; now use dest bank
	pop b ! pop h ! push d		; get dest and byte count. 
	lxi d,xbuf ! call ldir		; src = local buffer
	lda @cbnk ! call ?bank		; switch back to original bank
	pop d ! ret								; DE, HL new values


?bank:		; 32 k banks
	ana a ! jz bank$1 ! inr a	; 0 - 1 - 2 becomes
bank$1:	out BANK			; 0 - 2 - 3 (skip system bank)
	ret

	end
