; Boot sector for CP/Mega88 vm by Takashi Toyoshima
; This Z80 code is compatible with i8080.
; the whole system track is read starting from sector 0
; the upper part is the ccp which is stored in memory bank 3 
; Author Rienk H Koolstra

exec		equ 100h
;disk		equ 3
mccp		equ 1200h
lccp		equ 0D00h

CON_D	equ	1				; console data port
SD_DSK	equ	10		; disk drive
SD_TKL	equ	11		; disk track low
SD_TKH	equ	12		; disk track high
SD_SEC	equ	13		; disk sector
SD_CMD	equ	14		; disk command
SD_STAT	equ	15		; disk status
DMA_L	equ	16			; dma address low
DMA_H	equ	17			; dma address high
BANK	equ	18			; memory bank select

	org	0


	ld A,(100h)				; retrieve boot volume left by monitor
	ld (0FFFFh),A			; save up high for now
	out (SD_DSK),A		; set disk drive
	xor A			
	out (SD_TKL),A		; set track low
	out (SD_TKH),A		; set track high
	ld BC,7F01h				; set count and start sector (0 = boot loader)
	ld DE,80h					; block size
	ld HL,100h				; destination


load:	ld A,C				; get sector number
	out (SD_SEC),A		; set it
	ld A,L						; get low order destination address
	out (DMA_L),A			; set it
	ld A,H						; high order destination address
	out (DMA_H),A			; set it
	xor A							; set disk read operatiom
	out (SD_CMD),A		; sector data to destination address
	add HL,DE					; next destination address
	inc C							; point to next disk sector
	dec b
	jp nz,load				; 16 k read? if not repeat...

	; Track 0 is loaded into memory
	; boot sector 0x0000-0x007F rest 0x0100-0x407F
	
	ld de,8000h				; move everything to bank 1
	ld hl,0
	ld bc,4080h				; move all 16 k
nextbyteup:
	ld a,(hl)
	ld (de),a
	inc hl
	inc de
	dec bc
	ld a,b
	or c
	jp nz,nextbyteup

	; now the whole track is loaded in memory bank 1
	; boot sector is 0x8000 - 0x807F rest 0x8100 - 0x407F

	jp $+8003h				; jump to bank 1
	; we're at address 8003h now
	
	ld a,3
	out (BANK),a			; store ccp in lower bank 3
	ld de,100h				; destination address in bank 3
	ld hl,mccp+8080h	; here is where the CCP is located
	ld bc,lccp				; file length
nextbytedn:
	ld a,(hl)
	ld (de),a
	inc hl
	inc de
	dec bc
	ld a,b
	or c
	jp nz,nextbytedn+8000h
	xor a
	out (BANK),a			; still running in bank 1
	ld HL,message
print:	ld A,(HL)
	or A
	jp z,exec					; now start running xcpm3ldr
	out (CON_D),A			; send character to console
	inc HL
	jp print					; print: is in bank 0

message:
	db 'Boot phase 0',0

	; fill up to 128 bytes (full sector)
	org 7Fh
	db 0FFh					; tell xcpm3ldr which disk to use
	end
