mmu$select	equ 0F8h	; select 16k memory slot 0-3
mmu$frame	equ 0FDh	; select 16k SRAM bank 0-31 (512 MB)

	org FFD0h

blkst:	equ 0E000h	; block start
blklen: equ 02000h	; block length
destad: equ 0100h	; relocate to
execad: equ 0100h	; run from

cold$boot	equ $
; 8 bytes
	out 38h				; kill ROM
	db 0D9h				; exx
	pop psw ! mov b,a		; retrieve boot disk
	pop psw ! mov c,a	; retrieve active console
	db 0D9h				; exx : save for main program
; plus 21 bytes = 29
	xra a ! out mmu$select 	; base RAM
	mvi a,7 ! out mmu$frame		; frame 7
	lxi d,0h ! lxi h,0D000h ! lxi b,1000h
	db 0EDh,0B0h	; use Z80 block move instruction	
	xra a ! out mmu$frame		; restore momory
; plus 14 bytes = 43
	lxi d,destad			; destination address in DE
	lxi h,blkst			; block start address in HL
	lxi b,blklen			; block length in BC
	db 0EDh,0B0h			; ldir : move the lot
	jmp execad			; start the loader
; plus 5 bytes = 48
	db 0,0,0				; push to top of RAM. Total length = 48 bytes
	dw cold$boot			; tell ROM monitor where to begin

	end
