	title	'Boot loader module for CP/M 3.0'

true equ -1
false equ not true

banked	equ true

	public	?init
	public	?ldccp,?rlccp,?time,timint
	extrn	?pmsg,?conin,?bank
	extrn	@civec,@covec,@aivec,@aovec,@lovec
	extrn	@cbnk,@dtbl,?stbnk,mnttab
	extrn	@date,@hour,@min,@sec
	extrn ?cono

;	maclib ports
;	maclib z80

mmu$select	equ 0F8h	; select 16k memory slot 0-3
mmu$frame	equ 0FDh	; select 16k SRAM bank 0-31 (512 MB)

bdos	equ 5

	if banked
tpa$bank	equ 1
	else
tpa$bank	equ 0
	endif

	dseg	; init done from banked memory

?init:
	di
	db 0D9h					; exx get alternate register set
	mov a,b ! sta mnttab			; retrieve boot disk
	mov a,c		; c is CP/M IOBYTE
	db 0D9h
	inr a ! mov b,a ! mvi a,1
in0: rrc ! db 10h, in0-$-1	; a is 8, 4, 2 or 1
	mvi l,0 ! mov h,a
;	mvi l,0 ! mvi h,0C0h			; console on interface 1: and 2:
	shld @civec ! shld @covec
	mvi h,20h 							; assign AUX to interface 3:
	shld @aivec ! shld @aovec
	mvi h,10h ! shld @lovec ; assign LPT to interface 4:
	lxi h,@dtbl+2				; point to second drive
	xra a ! mov m,a ! inx h ! mov m,a 	; unmount B:
	inx h ! mov m,a ! inx h ! mov m,a 	; unmount C:
signon:	lxi h,signon$msg ! call ?pmsg		; print signon message
	jmp setint				; bankswitching from cseg

signon$msg:
	db 0Dh,0Ah,0Dh,0Ah
	db 'CP/M Version 3.0 BIOS (2016/9/13)',0Dh,0Ah
	db 'Original concept "FPGA Multicomputer"',0Dh,0Ah
	db 'by Grant Searle',0Dh,0Ah,0Ah,0Ah,0


	cseg

setint:
	mvi b,2			; 2 loops
si1:	mov a,b ! dcr a		; 2 banks (1 & 0)
	call ?bank
	mvi a,0F3h ! sta 38h	; opcode for DI
	mvi a,0C3h ! sta 39h	; opcode for JMP
	lxi h,timint ! shld 3Ah	; time interrupt service routine
	db 10h,si1-$-1		; djnz
	db 0EDh,056h		; im 1
	ei
	ret
	


;	ccp is loaded from high RAM bank 7 where the 
;	loader puts it. This makes a remount of drive A: possible. 
;	No fear of a missing CCP requiring a system reset

	;
	; memory map: |bank0|bank0|bank0|bank0|
	;                0     1     2     3
	;             |bank1|bank1|bank1|ccp  |
	;                4     5     6     7
	;
?ldccp:
?rlccp:
	mvi a,1 ! out mmu$select 	; select block 4000-7FFF
	mvi a,7 ! out mmu$frame		; map RAM block 7
	lxi d,100h ! lxi h,4000h ! lxi b,3200
	db 0EDh,0B0h	; use Z80 block move instruction	
	mvi a,1 ! out mmu$frame	; restore memory
	ret


?time:
	ret

; 20 ms interrupt service routine
timint:
	shld svdhl
	pop h ! shld svdret
	push psw
	lxi h,0 ! dad sp ! shld svdsp	; save users stack pointer
	lxi sp,lstintstk		; use local stack for interrupts
	push d ! push b

	lxi H,sec50			; 20 ms counter
	mvi C,50h ! call addone		; only returns when counter is full
	lxi H,@sec			; point into SCB
	mvi C,60h ! call addone		; count to 60 now
	dcx H ! call addone		; point to minutes
	dcx H				; point to hours
	mvi C,24h ! call addone		; count to 24

	lhld @date ! inx H ! shld @date	; welcome to a brand new day
	db 18h, intend-$-1

addone:	mov A,m ! adi 1			; add one (inc does not carry)
	daa ! mov m,A			; make BCD
	sub C 				; is counter full?
	db 20h,addend-$-1		; if not exit interrupt
	mov m,A ! ret			; store and do next counter
addend:	pop H				; get rid of return address

intend:	pop b ! pop d
	lhld svdsp ! sphl		; restore stack pointer
	pop psw 
	lhld svdret ! push h		; return address
	lhld svdhl ! ei
	db 0EDh,04Dh			; reti

sec50:	db 25h		; 20 ms counter in BCD

intstk:			; local intrpt stk
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h,0c7c7h
lstintstk:
svdhl:	dw 0
svdsp:	dw 0
svdret:	dw 0

bios$msg:
	db 0Dh,0Ah,0Dh,0Ah,'CCP Ver. 3.0',0Dh,0Ah,00
ccp$msg:
	db 0dh,0Ah,'BIOS Err ',00
ccp$fcb:
	db 1,'CCP     COM',0,0,0,0
	ds 16
fcb$nr:	db 0,0,0

	end
