	title 'Character I/O handler for z80 chip based system'

; Character I/O for the Modular CP/M 3 BIOS;


	public	?cinit,?ci,?co,?cist,?cost
	public	@ctbl

DIS$RTS		equ 0D5H
USE$RTS		equ 095H


max$devices	equ 5


	cseg


	; set baudrate and initiate serial devices c = device number 0-15
	; baud port disregards bits 3-7 effectively ANDing with 07h
?cinit:
	mov a,c ! cpi max$devices ! rp 	; no device
	mvi d,0 ! add a ! add a ! add a	; times 8
	mov e,a ! lxi h,@ctbl+7 ! dad d	; hl => baudrate in @ctbl
	mov a,m	! ana a ! rz !					; VDU requires no setup
	mov e,c ! lxi h,io$baud ! dad d	; hl => baud port in io$baud
	mov c,m ! db 0EDh,79h						; out (c),a - set baudrate
	lxi h,io$ctrl ! dad d ! mov c,m	; c is control port
	mvi a,USE$RTS ! db 0EDh,79h			; out (c),a - RTS active, low
	ret


	; character input b = device a <= data
?ci:	call ?cist ! jz ?ci		; in a,(c) status port
	inr c ! db 0EDh, 078h		; in a,(c) data port
	ret


	; character input status b = device
?cist:
	mov e,b ! mvi d,0 
	lxi h,io$ctrl ! dad d ! mov c,m
	db 0EDh,078h		; in a,(c) status port
	ani 1 ! rz
	mvi a,0FFh ! ret		; 


	; character output b = device, c => data
?co:
	mov a,c ! push psw 
co0:	call ?cost ! jz co0
	pop psw ! inr c ! db 0EDh, 079h		; out (c),a
	ret
 

	; character output status b = device
?cost:
	mov e,b ! mvi d,0
	lxi h,io$ctrl ! dad d ! mov c,m
	db 0EDh,078h		; in a,(c) status port
	ani 2 ! rz
	mvi a,0FFh ! ret		; 

; baudrates 1200, 2400, 4800, 9600, 19k2, 38k4, 57k6 & 117k2
; in @ctbl    8,    9,   10,   11,   12,   13,   14 &   15
; only lower 3 bits are used in setting the baud port

@ctbl:
	db 'TTY_01',15,15	; in,out,softbaud,serial device 0
	db 'VDU   ',3,0		; in,out device 1
	db 'TTY_02',15,15	; in,out,softbaud,serial device 2
	db 'TTY_03',15,11	; in,out,softbaud,serial device 3
	db 'TTY_04',15,11	; in,out,softbaud,serial device 4
	db 00

	; physical i/o ports 
io$baud:	db 7Bh,00h,7Ch,7Dh,7Eh
io$ctrl:	db 80h,82h,84h,86h,90h

	end
