PROGRAM SETBAUD;

type
  string6  = string[6];
  string10 = string[10];
  string30 = string[30];
 
const
  BAUD_PORT = $7B;

var
  version,console  : integer;
  iface,brate,i,j  : integer;
  IOBYTE           : byte absolute $0003;
  baudlist         : array[1..8] of string[6]; 
  baud             : string10;
  error            : string30;
  answer           : char;
  
procedure Help;
begin
  writeln('');
  writeln('Usage: SETBAUD interface,baudrate');
  writeln('');
  writeln('interface: 1, 3, 4 or 5');
  writeln('  interface 2 is VDU/Keybord');
  writeln('');
  writeln('baudrate: 1200, 2400, 4800, 9600 ');
  writeln('          19200, 38400, 57600 or 115200');
  writeln('you don'+chr($27)+'t need to type more than 2 characters');
  halt;
end;

procedure oops(error: string30);
begin
  writeln('');
  writeln(error);
  halt;
end;

BEGIN
  baudlist[1] := '1200';
  baudlist[2] := '2400';
  baudlist[3] := '4800';
  baudlist[4] := '9600';
  baudlist[5] := '19200';
  baudlist[6] := '38400';
  baudlist[7] := '57600';
  baudlist[8] := '115200';
  
  version := BDOSHL(12);
  
  if ((version>255) or (Version<$22)) then
    oops('Incompatible CP/M version');
 
  if (version>$29) then
    oops('Please use DEVICE.COM');

  if (paramcount < 1) then
    Help; 
 
  i := pos(',',paramstr(1));
  if i = 0 then 
    oops('missing comma separator');
      
  val(copy(paramstr(1),1,i-1),iface,j);
  if (j <> 0) or (iface < 1) or (iface = 2) or (iface > 5) then
    oops('Bad interface'); 
    
  baud := copy(paramstr(1),i+1,length(paramstr(1))-i);
  if (length(baud) < 2) or (length(baud) > 6) then
    oops('Bad baudrate');

  brate := -1;  
  for i := 1 to 8 do
    if copy(baudlist[i],1,length(baud)) = baud then
      brate := i;
  if brate < 0 then
    oops('Bad baudrate');
  
  console := IOBYTE and 3;
  if ( (iface - 1) = console) then
  begin
    writeln('This is your current console interface');
    write('Are you sure (y/N) ');
    read(answer);
    if (upcase(answer)) <> 'Y' then
      exit;
  end;
  
  iface := iface + BAUD_PORT - 1;
  port[iface] := brate - 1;
  writeln('Interface '+str(iface)+' set to'+baudlist[brate+1]+' baud');
  
END.
