
;**************************************************************
;*
;*             C P / M   VERSION   2 . 2
;*
;*   RECONSTRUCTED FROM MEMORY IMAGE ON FEBRUARY 27, 1981
;*
;*                BY CLARK A. CALKINS
;*
;**************************************************************
;
;   SET MEMORY LIMIT HERE. THIS IS THE AMOUNT OF CONTIGEOUS
; RAM STARTING FROM 0000. CP/M WILL RESIDE AT THE END OF THIS SPACE.
;
MEM	.EQU	60	;FOR A 62K SYSTEM (TS802 TEST - WORKS OK).
;
IOBYTE	.EQU	3	;I/O DEFINITION BYTE.
TDRIVE	.EQU	4	;CURRENT DRIVE NAME AND USER NUMBER.
ENTRY	.EQU	5	;ENTRY POINT FOR THE CP/M BDOS.
TFCB	.EQU	5CH	;DEFAULT FILE CONTROL BLOCK.
TBUFF	.EQU	80H	;I/O BUFFER AND COMMAND LINE STORAGE.
TBASE	.EQU	100H	;TRANSIANT PROGRAM STORAGE AREA.
;
;   SET CONTROL CHARACTER EQUATES.
;
CNTRLC	.EQU	3	;CONTROL-C
CNTRLE	.EQU	05H	;CONTROL-E
BS	.EQU	08H	;BACKSPACE
TAB	.EQU	09H	;TAB
LF	.EQU	0AH	;LINE FEED
FF	.EQU	0CH	;FORM FEED
CR	.EQU	0DH	;CARRIAGE RETURN
CNTRLP	.EQU	10H	;CONTROL-P
CNTRLR	.EQU	12H	;CONTROL-R
CNTRLS	.EQU	13H	;CONTROL-S
CNTRLU	.EQU	15H	;CONTROL-U
CNTRLX	.EQU	18H	;CONTROL-X
CNTRLZ	.EQU	1AH	;CONTROL-Z (END-OF-FILE MARK)
DEL	.EQU	7FH	;RUBOUT
;
;   SET ORIGIN FOR CP/M
;
	.ORG	(MEM-7)*1024
;
CBASE	JMP	COMMAND	;EXECUTE COMMAND PROCESSOR (CCP).
	JMP	CLEARBUF	;ENTRY TO EMPTY INPUT BUFFER BEFORE STARTING CCP.

;
;   STANDARD CP/M CCP INPUT BUFFER. FORMAT IS (MAX LENGTH),
; (ACTUAL LENGTH), (CHAR #1), (CHAR #2), (CHAR #3), ETC.
;
INBUFF	.DB	127	;LENGTH OF INPUT BUFFER.
	.DB	0	;CURRENT LENGTH OF CONTENTS.
	.DB	"COPYRIGHT"
;	DB	' 1979 (C) BY DIGITAL RESEARCH      '
	.DB	" 1979 (C) BY "
	.DB	"DIGITAL RESEARCH      "
	.DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
INPOINT	.DW	INBUFF+2;INPUT LINE POINTER
NAMEPNT	.DW	0	;INPUT LINE POINTER USED FOR ERROR MESSAGE. POINTS TO
;			;START OF NAME IN ERROR.
;
;   ROUTINE TO PRINT (A) ON THE CONSOLE. ALL REGISTERS USED.
;
PRINT	MOV	E,A	;SETUP BDOS CALL.
	MVI	C,2
	JMP	ENTRY
;
;   ROUTINE TO PRINT (A) ON THE CONSOLE AND TO SAVE (BC).
;
PRINTB	PUSH	B
	CALL	PRINT
	POP	B
	RET
;
;   ROUTINE TO SEND A CARRIAGE RETURN, LINE FEED COMBINATION
; TO THE CONSOLE.
;
CRLF	MVI	A,CR
	CALL	PRINTB
	MVI	A,LF
	JMP	PRINTB
;
;   ROUTINE TO SEND ONE SPACE TO THE CONSOLE AND SAVE (BC).
;
SPACE	MVI	A,' '
	JMP	PRINTB
;
;   ROUTINE TO PRINT CHARACTER STRING POINTED TO BE (BC) ON THE
; CONSOLE. IT MUST TERMINATE WITH A NULL BYTE.
;
PLINE	PUSH	B
	CALL	CRLF
	POP	H
PLINE2	MOV	A,M
	ORA	A
	RZ
	INX	H
	PUSH	H
	CALL	PRINT
	POP	H
	JMP	PLINE2
;
;   ROUTINE TO RESET THE DISK SYSTEM.
;
RESDSK	MVI	C,13
	JMP	ENTRY
;
;   ROUTINE TO SELECT DISK (A).
;
DSKSEL	MOV	E,A
	MVI	C,14
	JMP	ENTRY
;
;   ROUTINE TO CALL BDOS AND SAVE THE RETURN CODE. THE ZERO
; FLAG IS SET ON A RETURN OF 0FFH.
;
ENTRY1	CALL	ENTRY
	STA	RTNCODE	;SAVE RETURN CODE.
	INR	A	;SET ZERO IF 0FFH RETURNED.
	RET
;
;   ROUTINE TO OPEN A FILE. (DE) MUST POINT TO THE FCB.
;
OPEN	MVI	C,15
	JMP	ENTRY1
;
;   ROUTINE TO OPEN FILE AT (FCB).
;
OPENFCB	XRA	A	;CLEAR THE RECORD NUMBER BYTE AT FCB+32
	STA	FCB+32
	LXI	D,FCB
	JMP	OPEN
;
;   ROUTINE TO CLOSE A FILE. (DE) POINTS TO FCB.
;
CLOSE	MVI	C,16
	JMP	ENTRY1
;
;   ROUTINE TO SEARCH FOR THE FIRST FILE WITH AMBIGUEOUS NAME
; (DE).
;
SRCHFST	MVI	C,17
	JMP	ENTRY1
;
;   SEARCH FOR THE NEXT AMBIGEOUS FILE NAME.
;
SRCHNXT	MVI	C,18
	JMP	ENTRY1
;
;   SEARCH FOR FILE AT (FCB).
;
SRCHFCB	LXI	D,FCB
	JMP	SRCHFST
;
;   ROUTINE TO DELETE A FILE POINTED TO BY (DE).
;
DELETE	MVI	C,19
	JMP	ENTRY
;
;   ROUTINE TO CALL THE BDOS AND SET THE ZERO FLAG IF A ZERO
; STATUS IS RETURNED.
;
ENTRY2	CALL	ENTRY
	ORA	A	;SET ZERO FLAG IF APPROPRIATE.
	RET
;
;   ROUTINE TO READ THE NEXT RECORD FROM A SEQUENTIAL FILE.
; (DE) POINTS TO THE FCB.
;
RDREC	MVI	C,20
	JMP	ENTRY2
;
;   ROUTINE TO READ FILE AT (FCB).
;
READFCB	LXI	D,FCB
	JMP	RDREC
;
;   ROUTINE TO WRITE THE NEXT RECORD OF A SEQUENTIAL FILE.
; (DE) POINTS TO THE FCB.
;
WRTREC	MVI	C,21
	JMP	ENTRY2
;
;   ROUTINE TO CREATE THE FILE POINTED TO BY (DE).
;
CREATE	MVI	C,22
	JMP	ENTRY1
;
;   ROUTINE TO RENAME THE FILE POINTED TO BY (DE). NOTE THAT
; THE NEW NAME STARTS AT (DE+16).
;
RENAM	MVI	C,23
	JMP	ENTRY
;
;   GET THE CURRENT USER CODE.
;
GETUSR	MVI	E,0FFH
;
;   ROUTNE TO GET OR SET THE CURRENT USER CODE.
; IF (E) IS FF THEN THIS IS A GET, ELSE IT IS A SET.
;
GETSETUC:MVI	C,32
	JMP	ENTRY
;
;   ROUTINE TO SET THE CURRENT DRIVE BYTE AT (TDRIVE).
;
SETCDRV	CALL	GETUSR	;GET USER NUMBER
	ADD	A	;AND SHIFT INTO THE UPPER 4 BITS.
	ADD	A
	ADD	A
	ADD	A
	LXI	H,CDRIVE;NOW ADD IN THE CURRENT DRIVE NUMBER.
	ORA	M
	STA	TDRIVE	;AND SAVE.
	RET
;
;   MOVE CURRENTLY ACTIVE DRIVE DOWN TO (TDRIVE).
;
MOVECD	LDA	CDRIVE
	STA	TDRIVE
	RET
;
;   ROUTINE TO CONVERT (A) INTO UPPER CASE ASCII. ONLY LETTERS
; ARE AFFECTED.
;
UPPER	CPI	'A'	;CHECK FOR LETTERS IN THE RANGE OF 'A' TO 'Z'.
	RC
	CPI	'{'
	RNC
	ANI	5FH	;CONVERT IT IF FOUND.
	RET
;
;   ROUTINE TO GET A LINE OF INPUT. WE MUST CHECK TO SEE IF THE
; USER IS IN (BATCH) MODE. IF SO, THEN READ THE INPUT FROM FILE
; ($$$.SUB). AT THE END, RESET TO CONSOLE INPUT.
;
GETINP	LDA	BATCH	;IF =0, THEN USE CONSOLE INPUT.
	ORA	A
	JZ	GETINP1
;
;   USE THE SUBMIT FILE ($$$.SUB) WHICH IS PREPARED BY A
; SUBMIT RUN. IT MUST BE ON DRIVE (A) AND IT WILL BE DELETED
; IF AND ERROR OCCURES (LIKE EOF).
;
	LDA	CDRIVE	;SELECT DRIVE 0 IF NEED BE.
	ORA	A
	MVI	A,0	;ALWAYS USE DRIVE A FOR SUBMIT.
	CNZ	DSKSEL	;SELECT IT IF REQUIRED.
	LXI	D,BATCHFCB
	CALL	OPEN	;LOOK FOR IT.
	JZ	GETINP1	;IF NOT THERE, USE NORMAL INPUT.
	LDA	BATCHFCB+15;GET LAST RECORD NUMBER+1.
	DCR	A
	STA	BATCHFCB+32
	LXI	D,BATCHFCB
	CALL	RDREC	;READ LAST RECORD.
	JNZ	GETINP1	;QUIT ON END OF FILE.
;
;   MOVE THIS RECORD INTO INPUT BUFFER.
;
	LXI	D,INBUFF+1
	LXI	H,TBUFF	;DATA WAS READ INTO BUFFER HERE.
	MVI	B,128	;ALL 128 CHARACTERS MAY BE USED.
	CALL	HL2DE	;(HL) TO (DE), (B) BYTES.
	LXI	H,BATCHFCB+14
	MVI	M,0	;ZERO OUT THE 'S2' BYTE.
	INX	H	;AND DECREMENT THE RECORD COUNT.
	DCR	M
	LXI	D,BATCHFCB;CLOSE THE BATCH FILE NOW.
	CALL	CLOSE
	JZ	GETINP1	;QUIT ON AN ERROR.
	LDA	CDRIVE	;RE-SELECT PREVIOUS DRIVE IF NEED BE.
	ORA	A
	CNZ	DSKSEL	;DON'T DO NEEDLESS SELECTS.
;
;   PRINT LINE JUST READ ON CONSOLE.
;
	LXI	H,INBUFF+2
	CALL	PLINE2
	CALL	CHKCON	;CHECK CONSOLE, QUIT ON A KEY.
	JZ	GETINP2	;JUMP IF NO KEY IS PRESSED.
;
;   TERMINATE THE SUBMIT JOB ON ANY KEYBOARD INPUT. DELETE THIS
; FILE SUCH THAT IT IS NOT RE-STARTED AND JUMP TO NORMAL KEYBOARD
; INPUT SECTION.
;
	CALL	DELBATCH;DELETE THE BATCH FILE.
	JMP	CMMND1	;AND RESTART COMMAND INPUT.
;
;   GET HERE FOR NORMAL KEYBOARD INPUT. DELETE THE SUBMIT FILE
; INCASE THERE WAS ONE.
;
GETINP1	CALL	DELBATCH;DELETE FILE ($$$.SUB).
	CALL	SETCDRV	;RESET ACTIVE DISK.
	MVI	C,10	;GET LINE FROM CONSOLE DEVICE.
	LXI	D,INBUFF
	CALL	ENTRY
	CALL	MOVECD	;RESET CURRENT DRIVE (AGAIN).
;
;   CONVERT INPUT LINE TO UPPER CASE.
;
GETINP2	LXI	H,INBUFF+1
	MOV	B,M	;(B)=CHARACTER COUNTER.
GETINP3	INX	H
	MOV	A,B	;END OF THE LINE?
	ORA	A
	JZ	GETINP4
	MOV	A,M	;CONVERT TO UPPER CASE.
	CALL	UPPER
	MOV	M,A
	DCR	B	;ADJUST CHARACTER COUNT.
	JMP	GETINP3
GETINP4	MOV	M,A	;ADD TRAILING NULL.
	LXI	H,INBUFF+2
	SHLD	INPOINT	;RESET INPUT LINE POINTER.
	RET
;
;   ROUTINE TO CHECK THE CONSOLE FOR A KEY PRESSED. THE ZERO
; FLAG IS SET IS NONE, ELSE THE CHARACTER IS RETURNED IN (A).
;
CHKCON	MVI	C,11	;CHECK CONSOLE.
	CALL	ENTRY
	ORA	A
	RZ		;RETURN IF NOTHING.
	MVI	C,1	;ELSE GET CHARACTER.
	CALL	ENTRY
	ORA	A	;CLEAR ZERO FLAG AND RETURN.
	RET
;
;   ROUTINE TO GET THE CURRENTLY ACTIVE DRIVE NUMBER.
;
GETDSK	MVI	C,25
	JMP	ENTRY
;
;   SET THE STABDARD DMA ADDRESS.
;
STDDMA	LXI	D,TBUFF
;
;   ROUTINE TO SET THE DMA ADDRESS TO (DE).
;
DMASET	MVI	C,26
	JMP	ENTRY
;
;  DELETE THE BATCH FILE CREATED BY SUBMIT.
;
DELBATCH:LXI	H,BATCH	;IS BATCH ACTIVE?
	MOV	A,M
	ORA	A
	RZ
	MVI	M,0	;YES, DE-ACTIVATE IT.
	XRA	A
	CALL	DSKSEL	;SELECT DRIVE 0 FOR SURE.
	LXI	D,BATCHFCB;AND DELETE THIS FILE.
	CALL	DELETE
	LDA	CDRIVE	;RESET CURRENT DRIVE.
	JMP	DSKSEL
;
;   CHECK TO TWO STRINGS AT (PATTRN1) AND (PATTRN2). THEY MUST BE
; THE SAME OR WE HALT....
;
VERIFY	LXI	D,PATTRN1;THESE ARE THE SERIAL NUMBER BYTES.
	LXI	H,PATTRN2;DITTO, BUT HOW COULD THEY BE DIFFERENT?
	MVI	B,6	;6 BYTES EACH.
VERIFY1	LDAX	D
	CMP	M
	JNZ	HALT	;JUMP TO HALT ROUTINE.
	INX	D
	INX	H
	DCR	B
	JNZ	VERIFY1
	RET
;
;   PRINT BACK FILE NAME WITH A '?' TO INDICATE A SYNTAX ERROR.
;
SYNERR	CALL	CRLF	;END CURRENT LINE.
	LHLD	NAMEPNT	;THIS POINTS TO NAME IN ERROR.
SYNERR1	MOV	A,M	;PRINT IT UNTIL A SPACE OR NULL IS FOUND.
	CPI	' '
	JZ	SYNERR2
	ORA	A
	JZ	SYNERR2
	PUSH	H
	CALL	PRINT
	POP	H
	INX	H
	JMP	SYNERR1
SYNERR2	MVI	A,'?'	;ADD TRAILING '?'.
	CALL	PRINT
	CALL	CRLF
	CALL	DELBATCH;DELETE ANY BATCH FILE.
	JMP	CMMND1	;AND RESTART FROM CONSOLE INPUT.
;
;   CHECK CHARACTER AT (DE) FOR LEGAL COMMAND INPUT. NOTE THAT THE
; ZERO FLAG IS SET IF THE CHARACTER IS A DELIMITER.
;
CHECK	LDAX	D
	ORA	A
	RZ
	CPI	' '	;CONTROL CHARACTERS ARE NOT LEGAL HERE.
	JC	SYNERR
	RZ		;CHECK FOR VALID DELIMITER.
	CPI	'='
	RZ
	CPI	'_'
	RZ
	CPI	'.'
	RZ
	CPI	':'
	RZ
	CPI	$03B	; SEMICOLON ';'
	RZ
	CPI	'<'
	RZ
	CPI	'>'
	RZ
	RET
;
;   GET THE NEXT NON-BLANK CHARACTER FROM (DE).
;
NONBLANK:	LDAX	D
	ORA	A	;STRING ENDS WITH A NULL.
	RZ
	CPI	' '
	RNZ
	INX	D
	JMP	NONBLANK
;
;   ADD (HL)=(HL)+(A)
;
ADDHL	ADD	L
	MOV	L,A
	RNC	;TAKE CARE OF ANY CARRY.
	INR	H
	RET
;
;   CONVERT THE FIRST NAME IN (FCB).
;
CONVFST	MVI	A,0
;
;   FORMAT A FILE NAME (CONVERT * TO '?', ETC.). ON RETURN,
; (A)=0 IS AN UNAMBIGEOUS NAME WAS SPECIFIED. ENTER WITH (A) EQUAL TO
; THE POSITION WITHIN THE FCB FOR THE NAME (EITHER 0 OR 16).
;
CONVERT	LXI	H,FCB
	CALL	ADDHL
	PUSH	H
	PUSH	H
	XRA	A
	STA	CHGDRV	;INITIALIZE DRIVE CHANGE FLAG.
	LHLD	INPOINT	;SET (HL) AS POINTER INTO INPUT LINE.
	XCHG
	CALL	NONBLANK;GET NEXT NON-BLANK CHARACTER.
	XCHG
	SHLD	NAMEPNT	;SAVE POINTER HERE FOR ANY ERROR MESSAGE.
	XCHG
	POP	H
	LDAX	D	;GET FIRST CHARACTER.
	ORA	A
	JZ	CONVRT1
	SBI	'A'-1	;MIGHT BE A DRIVE NAME, CONVERT TO BINARY.
	MOV	B,A	;AND SAVE.
	INX	D	;CHECK NEXT CHARACTER FOR A ':'.
	LDAX	D
	CPI	':'
	JZ	CONVRT2
	DCX	D	;NOPE, MOVE POINTER BACK TO THE START OF THE LINE.
CONVRT1	LDA	CDRIVE
	MOV	M,A
	JMP	CONVRT3
CONVRT2	MOV	A,B
	STA	CHGDRV	;SET CHANGE IN DRIVES FLAG.
	MOV	M,B
	INX	D
;
;   CONVERT THE BASIC FILE NAME.
;
CONVRT3	MVI	B,08H
CONVRT4	CALL	CHECK
	JZ	CONVRT8
	INX	H
	CPI	'*'	;NOTE THAT AN '*' WILL FILL THE REMAINING
	JNZ	CONVRT5	;FIELD WITH '?'.
	MVI	M,'?'
	JMP	CONVRT6
CONVRT5	MOV	M,A
	INX	D
CONVRT6	DCR	B
	JNZ	CONVRT4
CONVRT7	CALL	CHECK	;GET NEXT DELIMITER.
	JZ	GETEXT
	INX	D
	JMP	CONVRT7
CONVRT8	INX	H	;BLANK FILL THE FILE NAME.
	MVI	M,' '
	DCR	B
	JNZ	CONVRT8
;
;   GET THE EXTENSION AND CONVERT IT.
;
GETEXT	MVI	B,03H
	CPI	'.'
	JNZ	GETEXT5
	INX	D
GETEXT1	CALL	CHECK
	JZ	GETEXT5
	INX	H
	CPI	'*'
	JNZ	GETEXT2
	MVI	M,'?'
	JMP	GETEXT3
GETEXT2	MOV	M,A
	INX	D
GETEXT3	DCR	B
	JNZ	GETEXT1
GETEXT4	CALL	CHECK
	JZ	GETEXT6
	INX	D
	JMP	GETEXT4
GETEXT5	INX	H
	MVI	M,' '
	DCR	B
	JNZ	GETEXT5
GETEXT6	MVI	B,3
GETEXT7	INX	H
	MVI	M,0
	DCR	B
	JNZ	GETEXT7
	XCHG
	SHLD	INPOINT	;SAVE INPUT LINE POINTER.
	POP	H
;
;   CHECK TO SEE IF THIS IS AN AMBIGEOUS FILE NAME SPECIFICATION.
; SET THE (A) REGISTER TO NON ZERO IF IT IS.
;
	LXI	B,11	;SET NAME LENGTH.
GETEXT8	INX	H
	MOV	A,M
	CPI	'?'	;ANY QUESTION MARKS?
	JNZ	GETEXT9
	INR	B	;COUNT THEM.
GETEXT9	DCR	C
	JNZ	GETEXT8
	MOV	A,B
	ORA	A
	RET
;
;   CP/M COMMAND TABLE. NOTE COMMANDS CAN BE EITHER 3 OR 4 CHARACTERS LONG.
;
NUMCMDS	.EQU	6	;NUMBER OF COMMANDS
CMDTBL	.DB	"DIR "
	.DB	"ERA "
	.DB	"TYPE"
	.DB	"SAVE"
	.DB	"REN "
	.DB	"USER"
;
;   THE FOLLOWING SIX BYTES MUST AGREE WITH THOSE AT (PATTRN2)
; OR CP/M WILL HALT. WHY?
;
PATTRN1	.DB	0,22,0,0,0,0;(* SERIAL NUMBER BYTES *).
;
;   SEARCH THE COMMAND TABLE FOR A MATCH WITH WHAT HAS JUST
; BEEN ENTERED. IF A MATCH IS FOUND, THEN WE JUMP TO THE
; PROPER SECTION. ELSE JUMP TO (UNKNOWN).
; ON RETURN, THE (C) REGISTER IS SET TO THE COMMAND NUMBER
; THAT MATCHED (OR NUMCMDS+1 IF NO MATCH).
;
SEARCH	LXI	H,CMDTBL
	MVI	C,0
SEARCH1	MOV	A,C
	CPI	NUMCMDS	;THIS COMMANDS EXISTS.
	RNC
	LXI	D,FCB+1	;CHECK THIS ONE.
	MVI	B,4	;MAX COMMAND LENGTH.
SEARCH2	LDAX	D
	CMP	M
	JNZ	SEARCH3	;NOT A MATCH.
	INX	D
	INX	H
	DCR	B
	JNZ	SEARCH2
	LDAX	D	;ALLOW A 3 CHARACTER COMMAND TO MATCH.
	CPI	' '
	JNZ	SEARCH4
	MOV	A,C	;SET RETURN REGISTER FOR THIS COMMAND.
	RET
SEARCH3	INX	H
	DCR	B
	JNZ	SEARCH3
SEARCH4	INR	C
	JMP	SEARCH1
;
;   SET THE INPUT BUFFER TO EMPTY AND THEN START THE COMMAND
; PROCESSOR (CCP).
;
CLEARBUF:XRA	A
	STA	INBUFF+1;SECOND BYTE IS ACTUAL LENGTH.
;
;**************************************************************
;*
;*
;* C C P  -   C O N S O L E   C O M M A N D   P R O C E S S O R
;*
;**************************************************************
;*
COMMAND	LXI	SP,CCPSTACK	;SETUP STACK AREA.
	PUSH	B	;NOTE THAT (C) SHOULD BE EQUAL TO:
	MOV	A,C	;(UUUUDDDD) WHERE 'UUUU' IS THE USER NUMBER
	RAR		;AND 'DDDD' IS THE DRIVE NUMBER.
	RAR
	RAR
	RAR
	ANI	0FH	;ISOLATE THE USER NUMBER.
	MOV	E,A
	CALL	GETSETUC;AND SET IT.
	CALL	RESDSK	;RESET THE DISK SYSTEM.
	STA	BATCH	;CLEAR BATCH MODE FLAG.
	POP	B
	MOV	A,C
	ANI	0FH	;ISOLATE THE DRIVE NUMBER.
	STA	CDRIVE	;AND SAVE.
	CALL	DSKSEL	;...AND SELECT.
	LDA	INBUFF+1
	ORA	A	;ANYTHING IN INPUT BUFFER ALREADY?
	JNZ	CMMND2	;YES, WE JUST PROCESS IT.
;
;   ENTRY POINT TO GET A COMMAND LINE FROM THE CONSOLE.
;
CMMND1	LXI	SP,CCPSTACK	;SET STACK STRAIGHT.
	CALL	CRLF	;START A NEW LINE ON THE SCREEN.
	CALL	GETDSK	;GET CURRENT DRIVE.
	ADI	'A'
	CALL	PRINT	;PRINT CURRENT DRIVE.
	MVI	A,'>'
	CALL	PRINT	;AND ADD PROMPT.
	CALL	GETINP	;GET LINE FROM USER.
;
;   PROCESS COMMAND LINE HERE.
;
CMMND2	LXI	D,TBUFF
	CALL	DMASET	;SET STANDARD DMA ADDRESS.
	CALL	GETDSK
	STA	CDRIVE	;SET CURRENT DRIVE.
	CALL	CONVFST	;CONVERT NAME TYPED IN.
	CNZ	SYNERR	;WILD CARDS ARE NOT ALLOWED.
	LDA	CHGDRV	;IF A CHANGE IN DRIVES WAS INDICATED,
	ORA	A	;THEN TREAT THIS AS AN UNKNOWN COMMAND
	JNZ	UNKNOWN	;WHICH GETS EXECUTED.
	CALL	SEARCH	;ELSE SEARCH COMMAND TABLE FOR A MATCH.
;
;   NOTE THAT AN UNKNOWN COMMAND RETURNS
; WITH (A) POINTING TO THE LAST ADDRESS
; IN OUR TABLE WHICH IS (UNKNOWN).
;
	LXI	H,CMDADR;NOW, LOOK THRU OUR ADDRESS TABLE FOR COMMAND (A).
	MOV	E,A	;SET (DE) TO COMMAND NUMBER.
	MVI	D,0
	DAD	D
	DAD	D	;(HL)=(CMDADR)+2*(COMMAND NUMBER).
	MOV	A,M	;NOW PICK OUT THIS ADDRESS.
	INX	H
	MOV	H,M
	MOV	L,A
	PCHL		;NOW EXECUTE IT.
;
;   CP/M COMMAND ADDRESS TABLE.
;
CMDADR	.DW	DIRECT,ERASE,TYPE,SAVE
	.DW	RENAME,USER,UNKNOWN
;
;   HALT THE SYSTEM. REASON FOR THIS IS UNKNOWN AT PRESENT.
;
HALT	LXI	H,76F3H	;'DI HLT' INSTRUCTIONS.
	SHLD	CBASE
	LXI	H,CBASE
	PCHL
;
;   READ ERROR WHILE TYPEING A FILE.
;
RDERROR	LXI	B,RDERR
	JMP	PLINE
RDERR	.DB	"READ ERROR",0
;
;   REQUIRED FILE WAS NOT LOCATED.
;
NONE	LXI	B,NOFILE
	JMP	PLINE
NOFILE	.DB	"NO FILE",0
;
;   DECODE A COMMAND OF THE FORM 'A>FILENAME NUMBER{ FILENAME}.
; NOTE THAT A DRIVE SPECIFIER IS NOT ALLOWED ON THE FIRST FILE
; NAME. ON RETURN, THE NUMBER IS IN REGISTER (A). ANY ERROR
; CAUSES 'FILENAME?' TO BE PRINTED AND THE COMMAND IS ABORTED.
;
DECODE	CALL	CONVFST	;CONVERT FILENAME.
	LDA	CHGDRV	;DO NOT ALLOW A DRIVE TO BE SPECIFIED.
	ORA	A
	JNZ	SYNERR
	LXI	H,FCB+1	;CONVERT NUMBER NOW.
	LXI	B,11	;(B)=SUM REGISTER, (C)=MAX DIGIT COUNT.
DECODE1	MOV	A,M
	CPI	' '	;A SPACE TERMINATES THE NUMERAL.
	JZ	DECODE3
	INX	H
	SUI	'0'	;MAKE BINARY FROM ASCII.
	CPI	10	;LEGAL DIGIT?
	JNC	SYNERR
	MOV	D,A	;YES, SAVE IT IN (D).
	MOV	A,B	;COMPUTE (B)=(B)*10 AND CHECK FOR OVERFLOW.
	ANI	0E0H
	JNZ	SYNERR
	MOV	A,B
	RLC
	RLC
	RLC	;(A)=(B)*8
	ADD	B	;.......*9
	JC	SYNERR
	ADD	B	;.......*10
	JC	SYNERR
	ADD	D	;ADD IN NEW DIGIT NOW.
DECODE2	JC	SYNERR
	MOV	B,A	;AND SAVE RESULT.
	DCR	C	;ONLY LOOK AT 11 DIGITS.
	JNZ	DECODE1
	RET
DECODE3	MOV	A,M	;SPACES MUST FOLLOW (WHY?).
	CPI	' '
	JNZ	SYNERR
	INX	H
DECODE4	DCR	C
	JNZ	DECODE3
	MOV	A,B	;SET (A)=THE NUMERIC VALUE ENTERED.
	RET
;
;   MOVE 3 BYTES FROM (HL) TO (DE). NOTE THAT THERE IS ONLY
; ONE REFERENCE TO THIS AT (A2D5H).
;
MOVE3	MVI	B,3
;
;   MOVE (B) BYTES FROM (HL) TO (DE).
;
HL2DE	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	HL2DE
	RET
;
;   COMPUTE (HL)=(TBUFF)+(A)+(C) AND GET THE BYTE THAT'S HERE.
;
EXTRACT	LXI	H,TBUFF
	ADD	C
	CALL	ADDHL
	MOV	A,M
	RET
;
;  CHECK DRIVE SPECIFIED. IF IT MEANS A CHANGE, THEN THE NEW
; DRIVE WILL BE SELECTED. IN ANY CASE, THE DRIVE BYTE OF THE
; FCB WILL BE SET TO NULL (MEANS USE CURRENT DRIVE).
;
DSELECT	XRA	A	;NULL OUT FIRST BYTE OF FCB.
	STA	FCB
	LDA	CHGDRV	;A DRIVE CHANGE INDICATED?
	ORA	A
	RZ
	DCR	A	;YES, IS IT THE SAME AS THE CURRENT DRIVE?
	LXI	H,CDRIVE
	CMP	M
	RZ
	JMP	DSKSEL	;NO. SELECT IT THEN.
;
;   CHECK THE DRIVE SELECTION AND RESET IT TO THE PREVIOUS
; DRIVE IF IT WAS CHANGED FOR THE PRECEEDING COMMAND.
;
RESETDR	LDA	CHGDRV	;DRIVE CHANGE INDICATED?
	ORA	A
	RZ
	DCR	A	;YES, WAS IT A DIFFERENT DRIVE?
	LXI	H,CDRIVE
	CMP	M
	RZ
	LDA	CDRIVE	;YES, RE-SELECT OUR OLD DRIVE.
	JMP	DSKSEL
;
;**************************************************************
;*
;*           D I R E C T O R Y   C O M M A N D
;*
;**************************************************************
;
DIRECT	CALL	CONVFST	;CONVERT FILE NAME.
	CALL	DSELECT	;SELECT INDICATED DRIVE.
	LXI	H,FCB+1	;WAS ANY FILE INDICATED?
	MOV	A,M
	CPI	' '
	JNZ	DIRECT2
	MVI	B,11	;NO. FILL FIELD WITH '?' - SAME AS *.*.
DIRECT1	MVI	M,'?'
	INX	H
	DCR	B
	JNZ	DIRECT1
DIRECT2	MVI	E,0	;SET INITIAL CURSOR POSITION.
	PUSH	D
	CALL	SRCHFCB	;GET FIRST FILE NAME.
	CZ	NONE	;NONE FOUND AT ALL?
DIRECT3	JZ	DIRECT9	;TERMINATE IF NO MORE NAMES.
	LDA	RTNCODE	;GET FILE'S POSITION IN SEGMENT (0-3).
	RRC
	RRC
	RRC
	ANI	60H	;(A)=POSITION*32
	MOV	C,A
	MVI	A,10
	CALL	EXTRACT	;EXTRACT THE TENTH ENTRY IN FCB.
	RAL		;CHECK SYSTEM FILE STATUS BIT.
	JC	DIRECT8	;WE DON'T LIST THEM.
	POP	D
	MOV	A,E	;BUMP NAME COUNT.
	INR	E
	PUSH	D
	ANI	03H	;AT END OF LINE?
	PUSH	PSW
	JNZ	DIRECT4
	CALL	CRLF	;YES, END THIS LINE AND START ANOTHER.
	PUSH	B
	CALL	GETDSK	;START LINE WITH ('A:').
	POP	B
	ADI	'A'
	CALL	PRINTB
	MVI	A,':'
	CALL	PRINTB
	JMP	DIRECT5
DIRECT4	CALL	SPACE	;ADD SEPERATOR BETWEEN FILE NAMES.
	MVI	A,':'
	CALL	PRINTB
DIRECT5	CALL	SPACE
	MVI	B,1	;'EXTRACT' EACH FILE NAME CHARACTER AT A TIME.
DIRECT6	MOV	A,B
	CALL	EXTRACT
	ANI	7FH	;STRIP BIT 7 (STATUS BIT).
	CPI	' '	;ARE WE AT THE END OF THE NAME?
	JNZ	DRECT65
	POP	PSW	;YES, DON'T PRINT SPACES AT THE END OF A LINE.
	PUSH	PSW
	CPI	3
	JNZ	DRECT63
	MVI	A,9	;FIRST CHECK FOR NO EXTENSION.
	CALL	EXTRACT
	ANI	7FH
	CPI	' '
	JZ	DIRECT7	;DON'T PRINT SPACES.
DRECT63	MVI	A,' '	;ELSE PRINT THEM.
DRECT65	CALL	PRINTB
	INR	B	;BUMP TO NEXT CHARACTER PSOITION.
	MOV	A,B
	CPI	12	;END OF THE NAME?
	JNC	DIRECT7
	CPI	9	;NOPE, STARTING EXTENSION?
	JNZ	DIRECT6
	CALL	SPACE	;YES, ADD SEPERATING SPACE.
	JMP	DIRECT6
DIRECT7	POP	PSW	;GET THE NEXT FILE NAME.
DIRECT8	CALL	CHKCON	;FIRST CHECK CONSOLE, QUIT ON ANYTHING.
	JNZ	DIRECT9
	CALL	SRCHNXT	;GET NEXT NAME.
	JMP	DIRECT3	;AND CONTINUE WITH OUR LIST.
DIRECT9	POP	D	;RESTORE THE STACK AND RETURN TO COMMAND LEVEL.
	JMP	GETBACK
;
;**************************************************************
;*
;*                E R A S E   C O M M A N D
;*
;**************************************************************
;
ERASE	CALL	CONVFST	;CONVERT FILE NAME.
	CPI	11	;WAS '*.*' ENTERED?
	JNZ	ERASE1
	LXI	B,YESNO	;YES, ASK FOR CONFIRMATION.
	CALL	PLINE
	CALL	GETINP
	LXI	H,INBUFF+1
	DCR	M	;MUST BE EXACTLY 'Y'.
	JNZ	CMMND1
	INX	H
	MOV	A,M
	CPI	'Y'
	JNZ	CMMND1
	INX	H
	SHLD	INPOINT	;SAVE INPUT LINE POINTER.
ERASE1	CALL	DSELECT	;SELECT DESIRED DISK.
	LXI	D,FCB
	CALL	DELETE	;DELETE THE FILE.
	INR	A
	CZ	NONE	;NOT THERE?
	JMP	GETBACK	;RETURN TO COMMAND LEVEL NOW.
YESNO	.DB	"ALL (Y/N)?",0
;
;**************************************************************
;*
;*            T Y P E   C O M M A N D
;*
;**************************************************************
;
TYPE	CALL	CONVFST	;CONVERT FILE NAME.
	JNZ	SYNERR	;WILD CARDS NOT ALLOWED.
	CALL	DSELECT	;SELECT INDICATED DRIVE.
	CALL	OPENFCB	;OPEN THE FILE.
	JZ	TYPE5	;NOT THERE?
	CALL	CRLF	;OK, START A NEW LINE ON THE SCREEN.
	LXI	H,NBYTES;INITIALIZE BYTE COUNTER.
	MVI	M,0FFH	;SET TO READ FIRST SECTOR.
TYPE1	LXI	H,NBYTES
TYPE2	MOV	A,M	;HAVE WE WRITTEN THE ENTIRE SECTOR?
	CPI	128
	JC	TYPE3
	PUSH	H	;YES, READ IN THE NEXT ONE.
	CALL	READFCB
	POP	H
	JNZ	TYPE4	;END OR ERROR?
	XRA	A	;OK, CLEAR BYTE COUNTER.
	MOV	M,A
TYPE3	INR	M	;COUNT THIS BYTE.
	LXI	H,TBUFF	;AND GET THE (A)TH ONE FROM THE BUFFER (TBUFF).
	CALL	ADDHL
	MOV	A,M
	CPI	CNTRLZ	;END OF FILE MARK?
	JZ	GETBACK
	CALL	PRINT	;NO, PRINT IT.
	CALL	CHKCON	;CHECK CONSOLE, QUIT IF ANYTHING READY.
	JNZ	GETBACK
	JMP	TYPE1
;
;   GET HERE ON AN END OF FILE OR READ ERROR.
;
TYPE4	DCR	A	;READ ERROR?
	JZ	GETBACK
	CALL	RDERROR	;YES, PRINT MESSAGE.
TYPE5	CALL	RESETDR	;AND RESET PROPER DRIVE
	JMP	SYNERR	;NOW PRINT FILE NAME WITH PROBLEM.
;
;**************************************************************
;*
;*            S A V E   C O M M A N D
;*
;**************************************************************
;
SAVE	CALL	DECODE	;GET NUMERIC NUMBER THAT FOLLOWS SAVE.
	PUSH	PSW	;SAVE NUMBER OF PAGES TO WRITE.
	CALL	CONVFST	;CONVERT FILE NAME.
	JNZ	SYNERR	;WILD CARDS NOT ALLOWED.
	CALL	DSELECT	;SELECT SPECIFIED DRIVE.
	LXI	D,FCB	;NOW DELETE THIS FILE.
	PUSH	D
	CALL	DELETE
	POP	D
	CALL	CREATE	;AND CREATE IT AGAIN.
	JZ	SAVE3	;CAN'T CREATE?
	XRA	A	;CLEAR RECORD NUMBER BYTE.
	STA	FCB+32
	POP	PSW	;CONVERT PAGES TO SECTORS.
	MOV	L,A
	MVI	H,0
	DAD	H	;(HL)=NUMBER OF SECTORS TO WRITE.
	LXI	D,TBASE	;AND WE START FROM HERE.
SAVE1	MOV	A,H	;DONE YET?
	ORA	L
	JZ	SAVE2
	DCX	H	;NOPE, COUNT THIS AND COMPUTE THE START
	PUSH	H	;OF THE NEXT 128 BYTE SECTOR.
	LXI	H,128
	DAD	D
	PUSH	H	;SAVE IT AND SET THE TRANSFER ADDRESS.
	CALL	DMASET
	LXI	D,FCB	;WRITE OUT THIS SECTOR NOW.
	CALL	WRTREC
	POP	D	;RESET (DE) TO THE START OF THE LAST SECTOR.
	POP	H	;RESTORE SECTOR COUNT.
	JNZ	SAVE3	;WRITE ERROR?
	JMP	SAVE1
;
;   GET HERE AFTER WRITING ALL OF THE FILE.
;
SAVE2	LXI	D,FCB	;NOW CLOSE THE FILE.
	CALL	CLOSE
	INR	A	;DID IT CLOSE OK?
	JNZ	SAVE4
;
;   PRINT OUT ERROR MESSAGE (NO SPACE).
;
SAVE3	LXI	B,NOSPACE
	CALL	PLINE
SAVE4	CALL	STDDMA	;RESET THE STANDARD DMA ADDRESS.
	JMP	GETBACK
NOSPACE	.DB	"NO SPACE",0
;
;**************************************************************
;*
;*           R E N A M E   C O M M A N D
;*
;**************************************************************
;
RENAME	CALL	CONVFST	;CONVERT FIRST FILE NAME.
	JNZ	SYNERR	;WILD CARDS NOT ALLOWED.
	LDA	CHGDRV	;REMEMBER ANY CHANGE IN DRIVES SPECIFIED.
	PUSH	PSW
	CALL	DSELECT	;AND SELECT THIS DRIVE.
	CALL	SRCHFCB	;IS THIS FILE PRESENT?
	JNZ	RENAME6	;YES, PRINT ERROR MESSAGE.
	LXI	H,FCB	;YES, MOVE THIS NAME INTO SECOND SLOT.
	LXI	D,FCB+16
	MVI	B,16
	CALL	HL2DE
	LHLD	INPOINT	;GET INPUT POINTER.
	XCHG
	CALL	NONBLANK;GET NEXT NON BLANK CHARACTER.
	CPI	'='	;ONLY ALLOW AN '=' OR '_' SEPERATOR.
	JZ	RENAME1
	CPI	'_'
	JNZ	RENAME5
RENAME1	XCHG
	INX	H	;OK, SKIP SEPERATOR.
	SHLD	INPOINT	;SAVE INPUT LINE POINTER.
	CALL	CONVFST	;CONVERT THIS SECOND FILE NAME NOW.
	JNZ	RENAME5	;AGAIN, NO WILD CARDS.
	POP	PSW	;IF A DRIVE WAS SPECIFIED, THEN IT
	MOV	B,A	;MUST BE THE SAME AS BEFORE.
	LXI	H,CHGDRV
	MOV	A,M
	ORA	A
	JZ	RENAME2
	CMP	B
	MOV	M,B
	JNZ	RENAME5	;THEY WERE DIFFERENT, ERROR.
RENAME2	MOV	M,B;	RESET AS PER THE FIRST FILE SPECIFICATION.
	XRA	A
	STA	FCB	;CLEAR THE DRIVE BYTE OF THE FCB.
RENAME3	CALL	SRCHFCB	;AND GO LOOK FOR SECOND FILE.
	JZ	RENAME4	;DOESN'T EXIST?
	LXI	D,FCB
	CALL	RENAM	;OK, RENAME THE FILE.
	JMP	GETBACK
;
;   PROCESS RENAME ERRORS HERE.
;
RENAME4	CALL	NONE	;FILE NOT THERE.
	JMP	GETBACK
RENAME5	CALL	RESETDR	;BAD COMMAND FORMAT.
	JMP	SYNERR
RENAME6	LXI	B,EXISTS;DESTINATION FILE ALREADY EXISTS.
	CALL	PLINE
	JMP	GETBACK
EXISTS	.DB	"FILE EXISTS",0
;
;**************************************************************
;*
;*             U S E R   C O M M A N D
;*
;**************************************************************
;
USER	CALL	DECODE	;GET NUMERIC VALUE FOLLOWING COMMAND.
	CPI	16	;LEGAL USER NUMBER?
	JNC	SYNERR
	MOV	E,A	;YES BUT IS THERE ANYTHING ELSE?
	LDA	FCB+1
	CPI	' '
	JZ	SYNERR	;YES, THAT IS NOT ALLOWED.
	CALL	GETSETUC;OK, SET USER CODE.
	JMP	GETBACK1
;
;**************************************************************
;*
;*        T R A N S I A N T   P R O G R A M   C O M M A N D
;*
;**************************************************************
;
UNKNOWN	CALL	VERIFY	;CHECK FOR VALID SYSTEM (WHY?).
	LDA	FCB+1	;ANYTHING TO EXECUTE?
	CPI	' '
	JNZ	UNKWN1
	LDA	CHGDRV	;NOPE, ONLY A DRIVE CHANGE?
	ORA	A
	JZ	GETBACK1;NEITHER???
	DCR	A
	STA	CDRIVE	;OK, STORE NEW DRIVE.
	CALL	MOVECD	;SET (TDRIVE) ALSO.
	CALL	DSKSEL	;AND SELECT THIS DRIVE.
	JMP	GETBACK1;THEN RETURN.
;
;   HERE A FILE NAME WAS TYPED. PREPARE TO EXECUTE IT.
;
UNKWN1	LXI	D,FCB+9	;AN EXTENSION SPECIFIED?
	LDAX	D
	CPI	' '
	JNZ	SYNERR	;YES, NOT ALLOWED.
UNKWN2	PUSH	D
	CALL	DSELECT	;SELECT SPECIFIED DRIVE.
	POP	D
	LXI	H,COMFILE	;SET THE EXTENSION TO 'COM'.
	CALL	MOVE3
	CALL	OPENFCB	;AND OPEN THIS FILE.
	JZ	UNKWN9	;NOT PRESENT?
;
;   LOAD IN THE PROGRAM.
;
	LXI	H,TBASE	;STORE THE PROGRAM STARTING HERE.
UNKWN3	PUSH	H
	XCHG
	CALL	DMASET	;SET TRANSFER ADDRESS.
	LXI	D,FCB	;AND READ THE NEXT RECORD.
	CALL	RDREC
	JNZ	UNKWN4	;END OF FILE OR READ ERROR?
	POP	H	;NOPE, BUMP POINTER FOR NEXT SECTOR.
	LXI	D,128
	DAD	D
	LXI	D,CBASE	;ENOUGH ROOM FOR THE WHOLE FILE?
	MOV	A,L
	SUB	E
	MOV	A,H
	SBB	D
	JNC	UNKWN0	;NO, IT CAN'T FIT.
	JMP	UNKWN3
;
;   GET HERE AFTER FINISHED READING.
;
UNKWN4	POP	H
	DCR	A	;NORMAL END OF FILE?
	JNZ	UNKWN0
	CALL	RESETDR	;YES, RESET PREVIOUS DRIVE.
	CALL	CONVFST	;CONVERT THE FIRST FILE NAME THAT FOLLOWS
	LXI	H,CHGDRV;COMMAND NAME.
	PUSH	H
	MOV	A,M	;SET DRIVE CODE IN DEFAULT FCB.
	STA	FCB
	MVI	A,16	;PUT SECOND NAME 16 BYTES LATER.
	CALL	CONVERT	;CONVERT SECOND FILE NAME.
	POP	H
	MOV	A,M	;AND SET THE DRIVE FOR THIS SECOND FILE.
	STA	FCB+16
	XRA	A	;CLEAR RECORD BYTE IN FCB.
	STA	FCB+32
	LXI	D,TFCB	;MOVE IT INTO PLACE AT(005CH).
	LXI	H,FCB
	MVI	B,33
	CALL	HL2DE
	LXI	H,INBUFF+2;NOW MOVE THE REMAINDER OF THE INPUT
UNKWN5	MOV	A,M	;LINE DOWN TO (0080H). LOOK FOR A NON BLANK.
	ORA	A	;OR A NULL.
	JZ	UNKWN6
	CPI	' '
	JZ	UNKWN6
	INX	H
	JMP	UNKWN5
;
;   DO THE LINE MOVE NOW. IT ENDS IN A NULL BYTE.
;
UNKWN6	MVI	B,0	;KEEP A CHARACTER COUNT.
	LXI	D,TBUFF+1;DATA GETS PUT HERE.
UNKWN7	MOV	A,M	;MOVE IT NOW.
	STAX	D
	ORA	A
	JZ	UNKWN8
	INR	B
	INX	H
	INX	D
	JMP	UNKWN7
UNKWN8	MOV	A,B	;NOW STORE THE CHARACTER COUNT.
	STA	TBUFF
	CALL	CRLF	;CLEAN UP THE SCREEN.
	CALL	STDDMA	;SET STANDARD TRANSFER ADDRESS.
	CALL	SETCDRV	;RESET CURRENT DRIVE.
	CALL	TBASE	;AND EXECUTE THE PROGRAM.
;
;   TRANSIANT PROGRAMS RETURN HERE (OR REBOOT).
;
	LXI	SP,BATCH	;SET STACK FIRST OFF.
	CALL	MOVECD	;MOVE CURRENT DRIVE INTO PLACE (TDRIVE).
	CALL	DSKSEL	;AND RESELECT IT.
	JMP	CMMND1	;BACK TO COMAND MODE.
;
;   GET HERE IF SOME ERROR OCCURED.
;
UNKWN9	CALL	RESETDR	;INPROPER FORMAT.
	JMP	SYNERR
UNKWN0	LXI	B,BADLOAD;READ ERROR OR WON'T FIT.
	CALL	PLINE
	JMP	GETBACK
BADLOAD	.DB	"BAD LOAD",0
COMFILE	.DB	"COM"	;COMMAND FILE EXTENSION.
;
;   GET HERE TO RETURN TO COMMAND LEVEL. WE WILL RESET THE
; PREVIOUS ACTIVE DRIVE AND THEN EITHER RETURN TO COMMAND
; LEVEL DIRECTLY OR PRINT ERROR MESSAGE AND THEN RETURN.
;
GETBACK	CALL	RESETDR	;RESET PREVIOUS DRIVE.
GETBACK1:CALL	CONVFST	;CONVERT FIRST NAME IN (FCB).
	LDA	FCB+1	;IF THIS WAS JUST A DRIVE CHANGE REQUEST,
	SUI	' '	;MAKE SURE IT WAS VALID.
	LXI	H,CHGDRV
	ORA	M
	JNZ	SYNERR
	JMP	CMMND1	;OK, RETURN TO COMMAND LEVEL.
;
;   CCP STACK AREA.
;
	.DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
CCPSTACK:	.EQU	$	;END OF CCP STACK AREA.
;
;   BATCH (OR SUBMIT) PROCESSING INFORMATION STORAGE.
;
BATCH	.DB	0	;BATCH MODE FLAG (0=NOT ACTIVE).
; BATCHFCB:DB	0,'$$$     SUB',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
BATCHFCB:	.DB	0,"$$$     SUB"
		.DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
;
;   FILE CONTROL BLOCK SETUP BY THE CCP.
;
;FCB	DB	0,'           ',0,0,0,0,0,'           ',0,0,0,0,0
FCB	.DB	0,"           ",0,0,0,0,0
	.DB	"           ",0,0,0,0,0
RTNCODE	.DB	0	;STATUS RETURNED FROM BDOS CALL.
CDRIVE	.DB	0	;CURRENTLY ACTIVE DRIVE.
CHGDRV	.DB	0	;CHANGE IN DRIVES FLAG (0=NO CHANGE).
NBYTES	.DW	0	;BYTE COUNTER USED BY TYPE.
;
;   ROOM FOR EXPANSION?
;
	.DB	0,0,0,0,0,0,0,0,0,0,0,0,0
;
;   NOTE THAT THE FOLLOWING SIX BYTES MUST MATCH THOSE AT
; (PATTRN1) OR CP/M WILL HALT. WHY?
;
PATTRN2	.DB	0,22,0,0,0,0;(* SERIAL NUMBER BYTES *).
;
;**************************************************************
;*
;*                    B D O S   E N T R Y
;*
;**************************************************************
;
FBASE	JMP	FBASE1
;
;   BDOS ERROR TABLE.
;
BADSCTR	.DW	ERROR1	;BAD SECTOR ON READ OR WRITE.
BADSLCT	.DW	ERROR2	;BAD DISK SELECT.
RODISK	.DW	ERROR3	;DISK IS READ ONLY.
ROFILE	.DW	ERROR4	;FILE IS READ ONLY.
;
;   ENTRY INTO BDOS. (DE) OR (E) ARE THE PARAMETERS PASSED. THE
; FUNCTION NUMBER DESIRED IS IN REGISTER (C).
;
FBASE1	XCHG		;SAVE THE (DE) PARAMETERS.
	SHLD	PARAMS
	XCHG
	MOV	A,E	;AND SAVE REGISTER (E) IN PARTICULAR.
	STA	EPARAM
	LXI	H,0
	SHLD	STATUS	;CLEAR RETURN STATUS.
	DAD	SP
	SHLD	USRSTACK;SAVE USERS STACK POINTER.
	LXI	SP,STKAREA;AND SET OUR OWN.
	XRA	A	;CLEAR AUTO SELECT STORAGE SPACE.
	STA	AUTOFLAG
	STA	AUTO
	LXI	H,GOBACK;SET RETURN ADDRESS.
	PUSH	H
	MOV	A,C	;GET FUNCTION NUMBER.
	CPI	NFUNCTS	;VALID FUNCTION NUMBER?
	RNC
	MOV	C,E	;KEEP SINGLE REGISTER FUNCTION HERE.
	LXI	H,FUNCTNS;NOW LOOK THRU THE FUNCTION TABLE.
	MOV	E,A
	MVI	D,0	;(DE)=FUNCTION NUMBER.
	DAD	D
	DAD	D	;(HL)=(START OF TABLE)+2*(FUNCTION NUMBER).
	MOV	E,M
	INX	H
	MOV	D,M	;NOW (DE)=ADDRESS FOR THIS FUNCTION.
	LHLD	PARAMS	;RETRIEVE PARAMETERS.
	XCHG		;NOW (DE) HAS THE ORIGINAL PARAMETERS.
	PCHL		;EXECUTE DESIRED FUNCTION.
;
;   BDOS FUNCTION JUMP TABLE.
;
NFUNCTS	.EQU	41	;NUMBER OF FUNCTIONS IN FOLLOWIN TABLE.
;
FUNCTNS	.DW	WBOOT,GETCON,OUTCON,GETRDR,PUNCH,LIST,DIRCIO,GETIOB
	.DW	SETIOB,PRTSTR,RDBUFF,GETCSTS,GETVER,RSTDSK,SETDSK,OPENFIL
	.DW	CLOSEFIL,GETFST,GETNXT,DELFILE,READSEQ,WRTSEQ,FCREATE
	.DW	RENFILE,GETLOG,GETCRNT,PUTDMA,GETALOC,WRTPRTD,GETROV,SETATTR
	.DW	GETPARM,GETUSER,RDRANDOM,WTRANDOM,FILESIZE,SETRAN,LOGOFF,RTN
	.DW	RTN,WTSPECL
;
;   BDOS ERROR MESSAGE SECTION.
;
ERROR1	LXI	H,BADSEC	;BAD SECTOR MESSAGE.
	CALL	PRTERR	;PRINT IT AND GET A 1 CHAR RESPONCE.
	CPI	CNTRLC	;RE-BOOT REQUEST (CONTROL-C)?
	JZ	0	;YES.
	RET		;NO, RETURN TO RETRY I/O FUNCTION.
;
ERROR2	LXI	H,BADSEL	;BAD DRIVE SELECTED.
	JMP	ERROR5
;
ERROR3	LXI	H,DISKRO	;DISK IS READ ONLY.
	JMP	ERROR5
;
ERROR4	LXI	H,FILERO	;FILE IS READ ONLY.
;
ERROR5	CALL	PRTERR
	JMP	0	;ALWAYS REBOOT ON THESE ERRORS.
;
BDOSERR	.DB	"BDOS ERR ON "
BDOSDRV	.DB	" : $"
BADSEC	.DB	"BAD SECTOR$"
BADSEL	.DB	"SELECT$"
FILERO	.DB	"FILE "
DISKRO	.DB	"R/O$"
;
;   PRINT BDOS ERROR MESSAGE.
;
PRTERR	PUSH	H	;SAVE SECOND MESSAGE POINTER.
	CALL	OUTCRLF	;SEND (CR)(LF).
	LDA	ACTIVE	;GET ACTIVE DRIVE.
	ADI	'A'	;MAKE ASCII.
	STA	BDOSDRV	;AND PUT IN MESSAGE.
	LXI	B,BDOSERR;AND PRINT IT.
	CALL	PRTMESG
	POP	B	;PRINT SECOND MESSAGE LINE NOW.
	CALL	PRTMESG
;
;   GET AN INPUT CHARACTER. WE WILL CHECK OUR 1 CHARACTER
; BUFFER FIRST. THIS MAY BE SET BY THE CONSOLE STATUS ROUTINE.
;
GETCHAR	LXI	H,CHARBUF;CHECK CHARACTER BUFFER.
	MOV	A,M	;ANYTHING PRESENT ALREADY?
	MVI	M,0	;...EITHER CASE CLEAR IT.
	ORA	A
	RNZ		;YES, USE IT.
	JMP	CONIN	;NOPE, GO GET A CHARACTER RESPONCE.
;
;   INPUT AND ECHO A CHARACTER.
;
GETECHO	CALL	GETCHAR	;INPUT A CHARACTER.
	CALL	CHKCHAR	;CARRIAGE CONTROL?
	RC		;NO, A REGULAR CONTROL CHAR SO DON'T ECHO.
	PUSH	PSW	;OK, SAVE CHARACTER NOW.
	MOV	C,A
	CALL	OUTCON	;AND ECHO IT.
	POP	PSW	;GET CHARACTER AND RETURN.
	RET
;
;   CHECK CHARACTER IN (A). SET THE ZERO FLAG ON A CARRIAGE
; CONTROL CHARACTER AND THE CARRY FLAG ON ANY OTHER CONTROL
; CHARACTER.
;
CHKCHAR	CPI	CR	;CHECK FOR CARRIAGE RETURN, LINE FEED, BACKSPACE,
	RZ		;OR A TAB.
	CPI	LF
	RZ
	CPI	TAB
	RZ
	CPI	BS
	RZ
	CPI	' '	;OTHER CONTROL CHAR? SET CARRY FLAG.
	RET
;
;   CHECK THE CONSOLE DURING OUTPUT. HALT ON A CONTROL-S, THEN
; REBOOT ON A CONTROL-C. IF ANYTHING ELSE IS READY, CLEAR THE
; ZERO FLAG AND RETURN (THE CALLING ROUTINE MAY WANT TO DO
; SOMETHING).
;
CKCONSOL:LDA	CHARBUF	;CHECK BUFFER.
	ORA	A	;IF ANYTHING, JUST RETURN WITHOUT CHECKING.
	JNZ	CKCON2
	CALL	CONST	;NOTHING IN BUFFER. CHECK CONSOLE.
	ANI	01H	;LOOK AT BIT 0.
	RZ		;RETURN IF NOTHING.
	CALL	CONIN	;OK, GET IT.
	CPI	CNTRLS	;IF NOT CONTROL-S, RETURN WITH ZERO CLEARED.
	JNZ	CKCON1
	CALL	CONIN	;HALT PROCESSING UNTIL ANOTHER CHAR
	CPI	CNTRLC	;IS TYPED. CONTROL-C?
	JZ	0	;YES, REBOOT NOW.
	XRA	A	;NO, JUST PRETEND NOTHING WAS EVER READY.
	RET
CKCON1	STA	CHARBUF	;SAVE CHARACTER IN BUFFER FOR LATER PROCESSING.
CKCON2	MVI	A,1	;SET (A) TO NON ZERO TO MEAN SOMETHING IS READY.
	RET
;
;   OUTPUT (C) TO THE SCREEN. IF THE PRINTER FLIP-FLOP FLAG
; IS SET, WE WILL SEND CHARACTER TO PRINTER ALSO. THE CONSOLE
; WILL BE CHECKED IN THE PROCESS.
;
OUTCHAR	LDA	OUTFLAG	;CHECK OUTPUT FLAG.
	ORA	A	;ANYTHING AND WE WON'T GENERATE OUTPUT.
	JNZ	OUTCHR1
	PUSH	B
	CALL	CKCONSOL;CHECK CONSOLE (WE DON'T CARE WHATS THERE).
	POP	B
	PUSH	B
	CALL	CONOUT	;OUTPUT (C) TO THE SCREEN.
	POP	B
	PUSH	B
	LDA	PRTFLAG	;CHECK PRINTER FLIP-FLOP FLAG.
	ORA	A
	CNZ	LIST	;PRINT IT ALSO IF NON-ZERO.
	POP	B
OUTCHR1	MOV	A,C	;UPDATE CURSORS POSITION.
	LXI	H,CURPOS
	CPI	DEL	;RUBOUTS DON'T DO ANYTHING HERE.
	RZ
	INR	M	;BUMP LINE POINTER.
	CPI	' '	;AND RETURN IF A NORMAL CHARACTER.
	RNC
	DCR	M	;RESTORE AND CHECK FOR THE START OF THE LINE.
	MOV	A,M
	ORA	A
	RZ		;INGNORE CONTROL CHARACTERS AT THE START OF THE LINE.
	MOV	A,C
	CPI	BS	;IS IT A BACKSPACE?
	JNZ	OUTCHR2
	DCR	M	;YES, BACKUP POINTER.
	RET
OUTCHR2	CPI	LF	;IS IT A LINE FEED?
	RNZ		;IGNORE ANYTHING ELSE.
	MVI	M,0	;RESET POINTER TO START OF LINE.
	RET
;
;   OUTPUT (A) TO THE SCREEN. IF IT IS A CONTROL CHARACTER
; (OTHER THAN CARRIAGE CONTROL), USE ^X FORMAT.
;
SHOWIT	MOV	A,C
	CALL	CHKCHAR	;CHECK CHARACTER.
	JNC	OUTCON	;NOT A CONTROL, USE NORMAL OUTPUT.
	PUSH	PSW
	MVI	C,'^'	;FOR A CONTROL CHARACTER, PRECEED IT WITH '^'.
	CALL	OUTCHAR
	POP	PSW
	ORI	'@'	;AND THEN USE THE LETTER EQUIVELANT.
	MOV	C,A
;
;   FUNCTION TO OUTPUT (C) TO THE CONSOLE DEVICE AND EXPAND TABS
; IF NECESSARY.
;
OUTCON	MOV	A,C
	CPI	TAB	;IS IT A TAB?
	JNZ	OUTCHAR	;USE REGULAR OUTPUT.
OUTCON1	MVI	C,' '	;YES IT IS, USE SPACES INSTEAD.
	CALL	OUTCHAR
	LDA	CURPOS	;GO UNTIL THE CURSOR IS AT A MULTIPLE OF 8

	ANI	07H	;POSITION.
	JNZ	OUTCON1
	RET
;
;   ECHO A BACKSPACE CHARACTER. ERASE THE PREVOIUS CHARACTER
; ON THE SCREEN.
;
BACKUP	CALL	BACKUP1	;BACKUP THE SCREEN 1 PLACE.
	MVI	C,' '	;THEN BLANK THAT CHARACTER.
	CALL	CONOUT
BACKUP1	MVI	C,BS	;THEN BACK SPACE ONCE MORE.
	JMP	CONOUT
;
;   SIGNAL A DELETED LINE. PRINT A '#' AT THE END AND START
; OVER.
;
NEWLINE	MVI	C,'#'
	CALL	OUTCHAR	;PRINT THIS.
	CALL	OUTCRLF	;START NEW LINE.
NEWLN1	LDA	CURPOS	;MOVE THE CURSOR TO THE STARTING POSITION.
	LXI	H,STARTING
	CMP	M
	RNC		;THERE YET?
	MVI	C,' '
	CALL	OUTCHAR	;NOPE, KEEP GOING.
	JMP	NEWLN1
;
;   OUTPUT A (CR) (LF) TO THE CONSOLE DEVICE (SCREEN).
;
OUTCRLF	MVI	C,CR
	CALL	OUTCHAR
	MVI	C,LF
	JMP	OUTCHAR
;
;   PRINT MESSAGE POINTED TO BY (BC). IT WILL END WITH A '$'.
;
PRTMESG	LDAX	B	;CHECK FOR TERMINATING CHARACTER.
	CPI	'$'
	RZ
	INX	B
	PUSH	B	;OTHERWISE, BUMP POINTER AND PRINT IT.
	MOV	C,A
	CALL	OUTCON
	POP	B
	JMP	PRTMESG
;
;   FUNCTION TO EXECUTE A BUFFERED READ.
;
RDBUFF	LDA	CURPOS	;USE PRESENT LOCATION AS STARTING ONE.
	STA	STARTING
	LHLD	PARAMS	;GET THE MAXIMUM BUFFER SPACE.
	MOV	C,M
	INX	H	;POINT TO FIRST AVAILABLE SPACE.
	PUSH	H	;AND SAVE.
	MVI	B,0	;KEEP A CHARACTER COUNT.
RDBUF1	PUSH	B
	PUSH	H
RDBUF2	CALL	GETCHAR	;GET THE NEXT INPUT CHARACTER.
	ANI	7FH	;STRIP BIT 7.
	POP	H	;RESET REGISTERS.
	POP	B
	CPI	CR	;EN OF THE LINE?
	JZ	RDBUF17
	CPI	LF
	JZ	RDBUF17
	CPI	BS	;HOW ABOUT A BACKSPACE?
	JNZ	RDBUF3
	MOV	A,B	;YES, BUT IGNORE AT THE BEGINNING OF THE LINE.
	ORA	A
	JZ	RDBUF1
	DCR	B	;OK, UPDATE COUNTER.
	LDA	CURPOS	;IF WE BACKSPACE TO THE START OF THE LINE,
	STA	OUTFLAG	;TREAT AS A CANCEL (CONTROL-X).
	JMP	RDBUF10
RDBUF3	CPI	DEL	;USER TYPED A RUBOUT?
	JNZ	RDBUF4
	MOV	A,B	;IGNORE AT THE START OF THE LINE.
	ORA	A
	JZ	RDBUF1
	MOV	A,M	;OK, ECHO THE PREVOIUS CHARACTER.
	DCR	B	;AND RESET POINTERS (COUNTERS).
	DCX	H
	JMP	RDBUF15
RDBUF4	CPI	CNTRLE	;PHYSICAL END OF LINE?
	JNZ	RDBUF5
	PUSH	B	;YES, DO IT.
	PUSH	H
	CALL	OUTCRLF
	XRA	A	;AND UPDATE STARTING POSITION.
	STA	STARTING
	JMP	RDBUF2
RDBUF5	CPI	CNTRLP	;CONTROL-P?
	JNZ	RDBUF6
	PUSH	H	;YES, FLIP THE PRINT FLAG FILP-FLOP BYTE.
	LXI	H,PRTFLAG
	MVI	A,1	;PRTFLAG=1-PRTFLAG
	SUB	M
	MOV	M,A
	POP	H
	JMP	RDBUF1
RDBUF6	CPI	CNTRLX	;CONTROL-X (CANCEL)?
	JNZ	RDBUF8
	POP	H
RDBUF7	LDA	STARTING;YES, BACKUP THE CURSOR TO HERE.
	LXI	H,CURPOS
	CMP	M
	JNC	RDBUFF	;DONE YET?
	DCR	M	;NO, DECREMENT POINTER AND OUTPUT BACK UP ONE SPACE.
	CALL	BACKUP
	JMP	RDBUF7
RDBUF8	CPI	CNTRLU	;CNTROL-U (CANCEL LINE)?
	JNZ	RDBUF9
	CALL	NEWLINE	;START A NEW LINE.
	POP	H
	JMP	RDBUFF
RDBUF9	CPI	CNTRLR	;CONTROL-R?
	JNZ	RDBUF14
RDBUF10	PUSH	B	;YES, START A NEW LINE AND RETYPE THE OLD ONE.
	CALL	NEWLINE
	POP	B
	POP	H
	PUSH	H
	PUSH	B
RDBUF11	MOV	A,B	;DONE WHOLE LINE YET?
	ORA	A
	JZ	RDBUF12
	INX	H	;NOPE, GET NEXT CHARACTER.
	MOV	C,M
	DCR	B	;COUNT IT.
	PUSH	B
	PUSH	H
	CALL	SHOWIT	;AND DISPLAY IT.
	POP	H
	POP	B
	JMP	RDBUF11
RDBUF12	PUSH	H	;DONE WITH LINE. IF WE WERE DISPLAYING
	LDA	OUTFLAG	;THEN UPDATE CURSOR POSITION.
	ORA	A
	JZ	RDBUF2
	LXI	H,CURPOS;BECAUSE THIS LINE IS SHORTER, WE MUST
	SUB	M	;BACK UP THE CURSOR (NOT THE SCREEN HOWEVER)
	STA	OUTFLAG	;SOME NUMBER OF POSITIONS.
RDBUF13	CALL	BACKUP	;NOTE THAT AS LONG AS (OUTFLAG) IS NON
	LXI	H,OUTFLAG;ZERO, THE SCREEN WILL NOT BE CHANGED.
	DCR	M
	JNZ	RDBUF13
	JMP	RDBUF2	;NOW JUST GET THE NEXT CHARACTER.
;
;   JUST A NORMAL CHARACTER, PUT THIS IN OUR BUFFER AND ECHO.
;
RDBUF14	INX	H
	MOV	M,A	;STORE CHARACTER.
	INR	B	;AND COUNT IT.
RDBUF15	PUSH	B
	PUSH	H
	MOV	C,A	;ECHO IT NOW.
	CALL	SHOWIT
	POP	H
	POP	B
	MOV	A,M	;WAS IT AN ABORT REQUEST?
	CPI	CNTRLC	;CONTROL-C ABORT?
	MOV	A,B
	JNZ	RDBUF16
	CPI	1	;ONLY IF AT START OF LINE.
	JZ	0
RDBUF16	CMP	C	;NOPE, HAVE WE FILLED THE BUFFER?
	JC	RDBUF1
RDBUF17	POP	H	;YES END THE LINE AND RETURN.
	MOV	M,B
	MVI	C,CR
	JMP	OUTCHAR	;OUTPUT (CR) AND RETURN.
;
;   FUNCTION TO GET A CHARACTER FROM THE CONSOLE DEVICE.
;
GETCON	CALL	GETECHO	;GET AND ECHO.
	JMP	SETSTAT	;SAVE STATUS AND RETURN.
;
;   FUNCTION TO GET A CHARACTER FROM THE TAPE READER DEVICE.
;
GETRDR	CALL	READER	;GET A CHARACTER FROM READER, SET STATUS AND RETURN.
	JMP	SETSTAT
;
;  FUNCTION TO PERFORM DIRECT CONSOLE I/O. IF (C) CONTAINS (FF)
; THEN THIS IS AN INPUT REQUEST. IF (C) CONTAINS (FE) THEN
; THIS IS A STATUS REQUEST. OTHERWISE WE ARE TO OUTPUT (C).
;
DIRCIO	MOV	A,C	;TEST FOR (FF).
	INR	A
	JZ	DIRC1
	INR	A	;TEST FOR (FE).
	JZ	CONST
	JMP	CONOUT	;JUST OUTPUT (C).
DIRC1	CALL	CONST	;THIS IS AN INPUT REQUEST.
	ORA	A
	JZ	GOBACK1	;NOT READY? JUST RETURN (DIRECTLY).
	CALL	CONIN	;YES, GET CHARACTER.
	JMP	SETSTAT	;SET STATUS AND RETURN.
;
;   FUNCTION TO RETURN THE I/O BYTE.
;
GETIOB	LDA	IOBYTE
	JMP	SETSTAT
;
;   FUNCTION TO SET THE I/O BYTE.
;
SETIOB	LXI	H,IOBYTE
	MOV	M,C
	RET
;
;   FUNCTION TO PRINT THE CHARACTER STRING POINTED TO BY (DE)
; ON THE CONSOLE DEVICE. THE STRING ENDS WITH A '$'.
;
PRTSTR	XCHG
	MOV	C,L
	MOV	B,H	;NOW (BC) POINTS TO IT.
	JMP	PRTMESG
;
;   FUNCTION TO INTERIGATE THE CONSOLE DEVICE.
;
GETCSTS	CALL	CKCONSOL
;
;   GET HERE TO SET THE STATUS AND RETURN TO THE CLEANUP
; SECTION. THEN BACK TO THE USER.
;
SETSTAT	STA	STATUS
RTN	RET
;
;   SET THE STATUS TO 1 (READ OR WRITE ERROR CODE).
;
IOERR1	MVI	A,1
	JMP	SETSTAT
;
OUTFLAG	.DB	0	;OUTPUT FLAG (NON ZERO MEANS NO OUTPUT).
STARTING:	.DB	2	;STARTING POSITION FOR CURSOR.
CURPOS	.DB	0	;CURSOR POSITION (0=START OF LINE).
PRTFLAG	.DB	0	;PRINTER FLAG (CONTROL-P TOGGLE). LIST IF NON ZERO.
CHARBUF	.DB	0	;SINGLE INPUT CHARACTER BUFFER.
;
;   STACK AREA FOR BDOS CALLS.
;
USRSTACK:	.DW	0	;SAVE USERS STACK POINTER HERE.
;
	.DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
STKAREA	.EQU	$	;END OF STACK AREA.
;
USERNO	.DB	0	;CURRENT USER NUMBER.
ACTIVE	.DB	0	;CURRENTLY ACTIVE DRIVE.
PARAMS	.DW	0	;SAVE (DE) PARAMETERS HERE ON ENTRY.
STATUS	.DW	0	;STATUS RETURNED FROM BDOS FUNCTION.
;
;   SELECT ERROR OCCURED, JUMP TO ERROR ROUTINE.
;
SLCTERR	LXI	H,BADSLCT
;
;   JUMP TO (HL) INDIRECTLY.
;
JUMPHL	MOV	E,M
	INX	H
	MOV	D,M	;NOW (DE) CONTAIN THE DESIRED ADDRESS.
	XCHG
	PCHL
;
;   BLOCK MOVE. (DE) TO (HL), (C) BYTES TOTAL.
;
DE2HL	INR	C	;IS COUNT DOWN TO ZERO?
DE2HL1	DCR	C
	RZ		;YES, WE ARE DONE.
	LDAX	D	;NO, MOVE ONE MORE BYTE.
	MOV	M,A
	INX	D
	INX	H
	JMP	DE2HL1	;AND REPEAT.
;
;   SELECT THE DESIRED DRIVE.
;
SELECT	LDA	ACTIVE	;GET ACTIVE DISK.
	MOV	C,A
	CALL	SELDSK	;SELECT IT.
	MOV	A,H	;VALID DRIVE?
	ORA	L	;VALID DRIVE?
	RZ		;RETURN IF NOT.
;
;   HERE, THE BIOS RETURNED THE ADDRESS OF THE PARAMETER BLOCK
; IN (HL). WE WILL EXTRACT THE NECESSARY POINTERS AND SAVE THEM.
;
	MOV	E,M	;YES, GET ADDRESS OF TRANSLATION TABLE INTO (DE).
	INX	H
	MOV	D,M
	INX	H
	SHLD	SCRATCH1	;SAVE POINTERS TO SCRATCH AREAS.
	INX	H
	INX	H
	SHLD	SCRATCH2	;DITTO.
	INX	H
	INX	H
	SHLD	SCRATCH3	;DITTO.
	INX	H
	INX	H
	XCHG		;NOW SAVE THE TRANSLATION TABLE ADDRESS.
	SHLD	XLATE
	LXI	H,DIRBUF	;PUT THE NEXT 8 BYTES HERE.
	MVI	C,8	;THEY CONSIST OF THE DIRECTORY BUFFER
	CALL	DE2HL	;POINTER, PARAMETER BLOCK POINTER,
	LHLD	DISKPB	;CHECK AND ALLOCATION VECTORS.
	XCHG
	LXI	H,SECTORS	;MOVE PARAMETER BLOCK INTO OUR RAM.
	MVI	C,15	;IT IS 15 BYTES LONG.
	CALL	DE2HL
	LHLD	DSKSIZE	;CHECK DISK SIZE.
	MOV	A,H	;MORE THAN 256 BLOCKS ON THIS?
	LXI	H,BIGDISK
	MVI	M,0FFH	;SET TO SAMLL.
	ORA	A
	JZ	SELECT1
	MVI	M,0	;WRONG, SET TO LARGE.
SELECT1	MVI	A,0FFH	;CLEAR THE ZERO FLAG.
	ORA	A
	RET
;
;   ROUTINE TO HOME THE DISK TRACK HEAD AND CLEAR POINTERS.
;
HOMEDRV	CALL	HOME	;HOME THE HEAD.
	XRA	A
	LHLD	SCRATCH2;SET OUR TRACK POINTER ALSO.
	MOV	M,A
	INX	H
	MOV	M,A
	LHLD	SCRATCH3;AND OUR SECTOR POINTER.
	MOV	M,A
	INX	H
	MOV	M,A
	RET
;
;   DO THE ACTUAL DISK READ AND CHECK THE ERROR RETURN STATUS.
;
DOREAD	CALL	READ
	JMP	IORET
;
;   DO THE ACTUAL DISK WRITE AND HANDLE ANY BIOS ERROR.
;
DOWRITE	CALL	WRITE
IORET	ORA	A
	RZ		;RETURN UNLESS AN ERROR OCCURED.
	LXI	H,BADSCTR;BAD READ/WRITE ON THIS SECTOR.
	JMP	JUMPHL
;
;   ROUTINE TO SELECT THE TRACK AND SECTOR THAT THE DESIRED
; BLOCK NUMBER FALLS IN.
;
TRKSEC	LHLD	FILEPOS	;GET POSITION OF LAST ACCESSED FILE
	MVI	C,2	;IN DIRECTORY AND COMPUTE SECTOR #.
	CALL	SHIFTR	;SECTOR #=FILE-POSITION/4.
	SHLD	BLKNMBR	;SAVE THIS AS THE BLOCK NUMBER OF INTEREST.
	SHLD	CKSUMTBL;WHAT'S IT DOING HERE TOO?
;
;   IF THE SECTOR NUMBER HAS ALREADY BEEN SET (BLKNMBR), ENTER
; AT THIS POINT.
;
TRKSEC1	LXI	H,BLKNMBR
	MOV	C,M	;MOVE SECTOR NUMBER INTO (BC).
	INX	H
	MOV	B,M
	LHLD	SCRATCH3;GET CURRENT SECTOR NUMBER AND
	MOV	E,M	;MOVE THIS INTO (DE).
	INX	H
	MOV	D,M
	LHLD	SCRATCH2;GET CURRENT TRACK NUMBER.
	MOV	A,M	;AND THIS INTO (HL).
	INX	H
	MOV	H,M
	MOV	L,A
TRKSEC2	MOV	A,C	;IS DESIRED SECTOR BEFORE CURRENT ONE?
	SUB	E
	MOV	A,B
	SBB	D
	JNC	TRKSEC3
	PUSH	H	;YES, DECREMENT SECTORS BY ONE TRACK.
	LHLD	SECTORS	;GET SECTORS PER TRACK.
	MOV	A,E
	SUB	L
	MOV	E,A
	MOV	A,D
	SBB	H
	MOV	D,A	;NOW WE HAVE BACKED UP ONE FULL TRACK.
	POP	H
	DCX	H	;ADJUST TRACK COUNTER.
	JMP	TRKSEC2
TRKSEC3	PUSH	H	;DESIRED SECTOR IS AFTER CURRENT ONE.
	LHLD	SECTORS	;GET SECTORS PER TRACK.
	DAD	D	;BUMP SECTOR POINTER TO NEXT TRACK.
	JC	TRKSEC4
	MOV	A,C	;IS DESIRED SECTOR NOW BEFORE CURRENT ONE?
	SUB	L
	MOV	A,B
	SBB	H
	JC	TRKSEC4
	XCHG		;NOT YES, INCREMENT TRACK COUNTER
	POP	H	;AND CONTINUE UNTIL IT IS.
	INX	H
	JMP	TRKSEC3
;
;   HERE WE HAVE DETERMINED THE TRACK NUMBER THAT CONTAINS THE
; DESIRED SECTOR.
;
TRKSEC4	POP	H	;GET TRACK NUMBER (HL).
	PUSH	B
	PUSH	D
	PUSH	H
	XCHG
	LHLD	OFFSET	;ADJUST FOR FIRST TRACK OFFSET.
	DAD	D
	MOV	B,H
	MOV	C,L
	CALL	SETTRK	;SELECT THIS TRACK.
	POP	D	;RESET CURRENT TRACK POINTER.
	LHLD	SCRATCH2
	MOV	M,E
	INX	H
	MOV	M,D
	POP	D
	LHLD	SCRATCH3;RESET THE FIRST SECTOR ON THIS TRACK.
	MOV	M,E
	INX	H
	MOV	M,D
	POP	B
	MOV	A,C	;NOW SUBTRACT THE DESIRED ONE.
	SUB	E	;TO MAKE IT RELATIVE (1-# SECTORS/TRACK).
	MOV	C,A
	MOV	A,B
	SBB	D
	MOV	B,A
	LHLD	XLATE	;TRANSLATE THIS SECTOR ACCORDING TO THIS TABLE.
	XCHG
	CALL	SECTRN	;LET THE BIOS TRANSLATE IT.
	MOV	C,L
	MOV	B,H
	JMP	SETSEC	;AND SELECT IT.
;
;   COMPUTE BLOCK NUMBER FROM RECORD NUMBER (SAVNREC) AND
; EXTENT NUMBER (SAVEXT).
;
GETBLOCK:	LXI	H,BLKSHFT;GET LOGICAL TO PHYSICAL CONVERSION.
	MOV	C,M	;NOTE THAT THIS IS BASE 2 LOG OF RATIO.
	LDA	SAVNREC	;GET RECORD NUMBER.
GETBLK1	ORA	A	;COMPUTE (A)=(A)/2^BLKSHFT.
	RAR
	DCR	C
	JNZ	GETBLK1
	MOV	B,A	;SAVE RESULT IN (B).
	MVI	A,8
	SUB	M
	MOV	C,A	;COMPUTE (C)=8-BLKSHFT.
	LDA	SAVEXT
GETBLK2	DCR	C	;COMPUTE (A)=SAVEXT*2^(8-BLKSHFT).
	JZ	GETBLK3
	ORA	A
	RAL
	JMP	GETBLK2
GETBLK3	ADD	B
	RET
;
;   ROUTINE TO EXTRACT THE (BC) BLOCK BYTE FROM THE FCB POINTED
; TO BY (PARAMS). IF THIS IS A BIG-DISK, THEN THESE ARE 16 BIT
; BLOCK NUMBERS, ELSE THEY ARE 8 BIT NUMBERS.
; NUMBER IS RETURNED IN (HL).
;
EXTBLK	LHLD	PARAMS	;GET FCB ADDRESS.
	LXI	D,16	;BLOCK NUMBERS START 16 BYTES INTO FCB.
	DAD	D
	DAD	B
	LDA	BIGDISK	;ARE WE USING A BIG-DISK?
	ORA	A
	JZ	EXTBLK1
	MOV	L,M	;NO, EXTRACT AN 8 BIT NUMBER FROM THE FCB.
	MVI	H,0
	RET
EXTBLK1	DAD	B	;YES, EXTRACT A 16 BIT NUMBER.
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG		;RETURN IN (HL).
	RET
;
;   COMPUTE BLOCK NUMBER.
;
COMBLK	CALL	GETBLOCK
	MOV	C,A
	MVI	B,0
	CALL	EXTBLK
	SHLD	BLKNMBR
	RET
;
;   CHECK FOR A ZERO BLOCK NUMBER (UNUSED).
;
CHKBLK	LHLD	BLKNMBR
	MOV	A,L	;IS IT ZERO?
	ORA	H
	RET
;
;   ADJUST PHYSICAL BLOCK (BLKNMBR) AND CONVERT TO LOGICAL
; SECTOR (LOGSECT). THIS IS THE STARTING SECTOR OF THIS BLOCK.
; THE ACTUAL SECTOR OF INTEREST IS THEN ADDED TO THIS AND THE
; RESULTING SECTOR NUMBER IS STORED BACK IN (BLKNMBR). THIS
; WILL STILL HAVE TO BE ADJUSTED FOR THE TRACK NUMBER.
;
LOGICAL	LDA	BLKSHFT	;GET LOG2(PHYSICAL/LOGICAL SECTORS).
	LHLD	BLKNMBR	;GET PHYSICAL SECTOR DESIRED.
LOGICL1	DAD	H	;COMPUTE LOGICAL SECTOR NUMBER.
	DCR	A	;NOTE LOGICAL SECTORS ARE 128 BYTES LONG.
	JNZ	LOGICL1
	SHLD	LOGSECT	;SAVE LOGICAL SECTOR.
	LDA	BLKMASK	;GET BLOCK MASK.
	MOV	C,A
	LDA	SAVNREC	;GET NEXT SECTOR TO ACCESS.
	ANA	C	;EXTRACT THE RELATIVE POSITION WITHIN PHYSICAL BLOCK.
	ORA	L	;AND ADD IT TOO LOGICAL SECTOR.
	MOV	L,A
	SHLD	BLKNMBR	;AND STORE.
	RET
;
;   SET (HL) TO POINT TO EXTENT BYTE IN FCB.
;
SETEXT	LHLD	PARAMS
	LXI	D,12	;IT IS THE TWELTH BYTE.
	DAD	D
	RET
;
;   SET (HL) TO POINT TO RECORD COUNT BYTE IN FCB AND (DE) TO
; NEXT RECORD NUMBER BYTE.
;
SETHLDE	LHLD	PARAMS
	LXI	D,15	;RECORD COUNT BYTE (#15).
	DAD	D
	XCHG
	LXI	H,17	;NEXT RECORD NUMBER (#32).
	DAD	D
	RET
;
;   SAVE CURRENT FILE DATA FROM FCB.
;
STRDATA	CALL	SETHLDE
	MOV	A,M	;GET AND STORE RECORD COUNT BYTE.
	STA	SAVNREC
	XCHG
	MOV	A,M	;GET AND STORE NEXT RECORD NUMBER BYTE.
	STA	SAVNXT
	CALL	SETEXT	;POINT TO EXTENT BYTE.
	LDA	EXTMASK	;GET EXTENT MASK.
	ANA	M
	STA	SAVEXT	;AND SAVE EXTENT HERE.
	RET
;
;   SET THE NEXT RECORD TO ACCESS. IF (MODE) IS SET TO 2, THEN
; THE LAST RECORD BYTE (SAVNREC) HAS THE CORRECT NUMBER TO ACCESS.
; FOR SEQUENTIAL ACCESS, (MODE) WILL BE EQUAL TO 1.
;
SETNREC	CALL	SETHLDE
	LDA	MODE	;GET SEQUENTIAL FLAG (=1).
	CPI	2	;A 2 INDICATES THAT NO ADDER IS NEEDED.
	JNZ	STNREC1
	XRA	A	;CLEAR ADDER (RANDOM ACCESS?).
STNREC1	MOV	C,A
	LDA	SAVNREC	;GET LAST RECORD NUMBER.
	ADD	C	;INCREMENT RECORD COUNT.
	MOV	M,A	;AND SET FCB'S NEXT RECORD BYTE.
	XCHG
	LDA	SAVNXT	;GET NEXT RECORD BYTE FROM STORAGE.
	MOV	M,A	;AND PUT THIS INTO FCB AS NUMBER OF RECORDS USED.
	RET
;
;   SHIFT (HL) RIGHT (C) BITS.
;
SHIFTR	INR	C
SHIFTR1	DCR	C
	RZ
	MOV	A,H
	ORA	A
	RAR
	MOV	H,A
	MOV	A,L
	RAR
	MOV	L,A
	JMP	SHIFTR1
;
;   COMPUTE THE CHECK-SUM FOR THE DIRECTORY BUFFER. RETURN
; INTEGER SUM IN (A).
;
CHECKSUM:	MVI	C,128	;LENGTH OF BUFFER.
	LHLD	DIRBUF	;GET ITS LOCATION.
	XRA	A	;CLEAR SUMMATION BYTE.
CHKSUM1	ADD	M	;AND COMPUTE SUM IGNORING CARRIES.
	INX	H
	DCR	C
	JNZ	CHKSUM1
	RET
;
;   SHIFT (HL) LEFT (C) BITS.
;
SHIFTL	INR	C
SHIFTL1	DCR	C
	RZ
	DAD	H	;SHIFT LEFT 1 BIT.
	JMP	SHIFTL1
;
;   ROUTINE TO SET A BIT IN A 16 BIT VALUE CONTAINED IN (BC).
; THE BIT SET DEPENDS ON THE CURRENT DRIVE SELECTION.
;
SETBIT	PUSH	B	;SAVE 16 BIT WORD.
	LDA	ACTIVE	;GET ACTIVE DRIVE.
	MOV	C,A
	LXI	H,1
	CALL	SHIFTL	;SHIFT BIT 0 INTO PLACE.
	POP	B	;NOW 'OR' THIS WITH THE ORIGINAL WORD.
	MOV	A,C
	ORA	L
	MOV	L,A	;LOW BYTE DONE, DO HIGH BYTE.
	MOV	A,B
	ORA	H
	MOV	H,A
	RET
;
;   EXTRACT THE WRITE PROTECT STATUS BIT FOR THE CURRENT DRIVE.
; THE RESULT IS RETURNED IN (A), BIT 0.
;
GETWPRT	LHLD	WRTPRT	;GET STATUS BYTES.
	LDA	ACTIVE	;WHICH DRIVE IS CURRENT?
	MOV	C,A
	CALL	SHIFTR	;SHIFT STATUS SUCH THAT BIT 0 IS THE
	MOV	A,L	;ONE OF INTEREST FOR THIS DRIVE.
	ANI	01H	;AND ISOLATE IT.
	RET
;
;   FUNCTION TO WRITE PROTECT THE CURRENT DISK.
;
WRTPRTD	LXI	H,WRTPRT;POINT TO STATUS WORD.
	MOV	C,M	;SET (BC) EQUAL TO THE STATUS.
	INX	H
	MOV	B,M
	CALL	SETBIT	;AND SET THIS BIT ACCORDING TO CURRENT DRIVE.
	SHLD	WRTPRT	;THEN SAVE.
	LHLD	DIRSIZE	;NOW SAVE DIRECTORY SIZE LIMIT.
	INX	H	;REMEMBER THE LAST ONE.
	XCHG
	LHLD	SCRATCH1;AND STORE IT HERE.
	MOV	M,E	;PUT LOW BYTE.
	INX	H
	MOV	M,D	;THEN HIGH BYTE.
	RET
;
;   CHECK FOR A READ ONLY FILE.
;
CHKROFL	CALL	FCB2HL	;SET (HL) TO FILE ENTRY IN DIRECTORY BUFFER.
CKROF1	LXI	D,9	;LOOK AT BIT 7 OF THE NINTH BYTE.
	DAD	D
	MOV	A,M
	RAL
	RNC		;RETURN IF OK.
	LXI	H,ROFILE;ELSE, PRINT ERROR MESSAGE AND TERMINATE.
	JMP	JUMPHL
;
;   CHECK THE WRITE PROTECT STATUS OF THE ACTIVE DISK.
;
CHKWPRT	CALL	GETWPRT
	RZ		;RETURN IF OK.
	LXI	H,RODISK;ELSE PRINT MESSAGE AND TERMINATE.
	JMP	JUMPHL
;
;   ROUTINE TO SET (HL) POINTING TO THE PROPER ENTRY IN THE
; DIRECTORY BUFFER.
;
FCB2HL	LHLD	DIRBUF	;GET ADDRESS OF BUFFER.
	LDA	FCBPOS	;RELATIVE POSITION OF FILE.
;
;   ROUTINE TO ADD (A) TO (HL).
;
ADDA2HL	ADD	L
	MOV	L,A
	RNC
	INR	H	;TAKE CARE OF ANY CARRY.
	RET
;
;   ROUTINE TO GET THE 'S2' BYTE FROM THE FCB SUPPLIED IN
; THE INITIAL PARAMETER SPECIFICATION.
;
GETS2	LHLD	PARAMS	;GET ADDRESS OF FCB.
	LXI	D,14	;RELATIVE POSITION OF 'S2'.
	DAD	D
	MOV	A,M	;EXTRACT THIS BYTE.
	RET
;
;   CLEAR THE 'S2' BYTE IN THE FCB.
;
CLEARS2	CALL	GETS2	;THIS SETS (HL) POINTING TO IT.
	MVI	M,0	;NOW CLEAR IT.
	RET
;
;   SET BIT 7 IN THE 'S2' BYTE OF THE FCB.
;
SETS2B7	CALL	GETS2	;GET THE BYTE.
	ORI	80H	;AND SET BIT 7.
	MOV	M,A	;THEN STORE.
	RET
;
;   COMPARE (FILEPOS) WITH (SCRATCH1) AND SET FLAGS BASED ON
; THE DIFFERENCE. THIS CHECKS TO SEE IF THERE ARE MORE FILE
; NAMES IN THE DIRECTORY. WE ARE AT (FILEPOS) AND THERE ARE
; (SCRATCH1) OF THEM TO CHECK.
;
MOREFLS	LHLD	FILEPOS	;WE ARE HERE.
	XCHG
	LHLD	SCRATCH1;AND DON'T GO PAST HERE.
	MOV	A,E	;COMPUTE DIFFERENCE BUT DON'T KEEP.
	SUB	M
	INX	H
	MOV	A,D
	SBB	M	;SET CARRY IF NO MORE NAMES.
	RET
;
;   CALL THIS ROUTINE TO PREVENT (SCRATCH1) FROM BEING GREATER
; THAN (FILEPOS).
;
CHKNMBR	CALL	MOREFLS	;SCRATCH1 TOO BIG?
	RC
	INX	D	;YES, RESET IT TO (FILEPOS).
	MOV	M,D
	DCX	H
	MOV	M,E
	RET
;
;   COMPUTE (HL)=(DE)-(HL)
;
SUBHL	MOV	A,E	;COMPUTE DIFFERENCE.
	SUB	L
	MOV	L,A	;STORE LOW BYTE.
	MOV	A,D
	SBB	H
	MOV	H,A	;AND THEN HIGH BYTE.
	RET
;
;   SET THE DIRECTORY CHECKSUM BYTE.
;
SETDIR	MVI	C,0FFH
;
;   ROUTINE TO SET OR COMPARE THE DIRECTORY CHECKSUM BYTE. IF
; (C)=0FFH, THEN THIS WILL SET THE CHECKSUM BYTE. ELSE THE BYTE
; WILL BE CHECKED. IF THE CHECK FAILS (THE DISK HAS BEEN CHANGED),
; THEN THIS DISK WILL BE WRITE PROTECTED.
;
CHECKDIR:	LHLD	CKSUMTBL
	XCHG
	LHLD	ALLOC1
	CALL	SUBHL
	RNC		;OK IF (CKSUMTBL) > (ALLOC1), SO RETURN.
	PUSH	B
	CALL	CHECKSUM;ELSE COMPUTE CHECKSUM.
	LHLD	CHKVECT	;GET ADDRESS OF CHECKSUM TABLE.
	XCHG
	LHLD	CKSUMTBL
	DAD	D	;SET (HL) TO POINT TO BYTE FOR THIS DRIVE.
	POP	B
	INR	C	;SET OR CHECK ?
	JZ	CHKDIR1
	CMP	M	;CHECK THEM.
	RZ		;RETURN IF THEY ARE THE SAME.
	CALL	MOREFLS	;NOT THE SAME, DO WE CARE?
	RNC
	CALL	WRTPRTD	;YES, MARK THIS AS WRITE PROTECTED.
	RET
CHKDIR1	MOV	M,A	;JUST SET THE BYTE.
	RET
;
;   DO A WRITE TO THE DIRECTORY OF THE CURRENT DISK.
;
DIRWRITE:CALL	SETDIR	;SET CHECKSUM BYTE.
	CALL	DIRDMA	;SET DIRECTORY DMA ADDRESS.
	MVI	C,1	;TELL THE BIOS TO ACTUALLY WRITE.
	CALL	DOWRITE	;THEN DO THE WRITE.
	JMP	DEFDMA
;
;   READ FROM THE DIRECTORY.
;
DIRREAD	CALL	DIRDMA	;SET THE DIRECTORY DMA ADDRESS.
	CALL	DOREAD	;AND READ IT.
;
;   ROUTINE TO SET THE DMA ADDRESS TO THE USERS CHOICE.
;
DEFDMA	LXI	H,USERDMA;RESET THE DEFAULT DMA ADDRESS AND RETURN.
	JMP	DIRDMA1
;
;   ROUTINE TO SET THE DMA ADDRESS FOR DIRECTORY WORK.
;
DIRDMA	LXI	H,DIRBUF
;
;   SET THE DMA ADDRESS. ON ENTRY, (HL) POINTS TO
; WORD CONTAINING THE DESIRED DMA ADDRESS.
;
DIRDMA1	MOV	C,M
	INX	H
	MOV	B,M	;SETUP (BC) AND GO TO THE BIOS TO SET IT.
	JMP	SETDMA
;
;   MOVE THE DIRECTORY BUFFER INTO USER'S DMA SPACE.
;
MOVEDIR	LHLD	DIRBUF	;BUFFER IS LOCATED HERE, AND
	XCHG
	LHLD	USERDMA; PUT IT HERE.
	MVI	C,128	;THIS IS ITS LENGTH.
	JMP	DE2HL	;MOVE IT NOW AND RETURN.
;
;   CHECK (FILEPOS) AND SET THE ZERO FLAG IF IT EQUALS 0FFFFH.
;
CKFILPOS:	LXI	H,FILEPOS
	MOV	A,M
	INX	H
	CMP	M	;ARE BOTH BYTES THE SAME?
	RNZ
	INR	A	;YES, BUT ARE THEY EACH 0FFH?
	RET
;
;   SET LOCATION (FILEPOS) TO 0FFFFH.
;
STFILPOS:	LXI	H,0FFFFH
	SHLD	FILEPOS
	RET
;
;   MOVE ON TO THE NEXT FILE POSITION WITHIN THE CURRENT
; DIRECTORY BUFFER. IF NO MORE EXIST, SET POINTER TO 0FFFFH
; AND THE CALLING ROUTINE WILL CHECK FOR THIS. ENTER WITH (C)
; EQUAL TO 0FFH TO CAUSE THE CHECKSUM BYTE TO BE SET, ELSE WE
; WILL CHECK THIS DISK AND SET WRITE PROTECT IF CHECKSUMS ARE
; NOT THE SAME (APPLIES ONLY IF ANOTHER DIRECTORY SECTOR MUST
; BE READ).
;
NXENTRY	LHLD	DIRSIZE	;GET DIRECTORY ENTRY SIZE LIMIT.
	XCHG
	LHLD	FILEPOS	;GET CURRENT COUNT.
	INX	H	;GO ON TO THE NEXT ONE.
	SHLD	FILEPOS
	CALL	SUBHL	;(HL)=(DIRSIZE)-(FILEPOS)
	JNC	NXENT1	;IS THERE MORE ROOM LEFT?
	JMP	STFILPOS;NO. SET THIS FLAG AND RETURN.
NXENT1	LDA	FILEPOS	;GET FILE POSITION WITHIN DIRECTORY.
	ANI	03H	;ONLY LOOK WITHIN THIS SECTOR (ONLY 4 ENTRIES FIT).
	MVI	B,5	;CONVERT TO RELATIVE POSITION (32 BYTES EACH).
NXENT2	ADD	A	;NOTE THAT THIS IS NOT EFFICIENT CODE.
	DCR	B	;5 'ADD A'S WOULD BE BETTER.
	JNZ	NXENT2
	STA	FCBPOS	;SAVE IT AS POSITION OF FCB.
	ORA	A
	RNZ		;RETURN IF WE ARE WITHIN BUFFER.
	PUSH	B
	CALL	TRKSEC	;WE NEED THE NEXT DIRECTORY SECTOR.
	CALL	DIRREAD
	POP	B
	JMP	CHECKDIR
;
;   ROUTINE TO TO GET A BIT FROM THE DISK SPACE ALLOCATION
; MAP. IT IS RETURNED IN (A), BIT POSITION 0. ON ENTRY TO HERE,
; SET (BC) TO THE BLOCK NUMBER ON THE DISK TO CHECK.
; ON RETURN, (D) WILL CONTAIN THE ORIGINAL BIT POSITION FOR
; THIS BLOCK NUMBER AND (HL) WILL POINT TO THE ADDRESS FOR IT.
;
CKBITMAP:	MOV	A,C	;DETERMINE BIT NUMBER OF INTEREST.
	ANI	07H	;COMPUTE (D)=(E)=(C AND 7)+1.
	INR	A
	MOV	E,A	;SAVE PARTICULAR BIT NUMBER.
	MOV	D,A
;
;   COMPUTE (BC)=(BC)/8.
;
	MOV	A,C
	RRC		;NOW SHIFT RIGHT 3 BITS.
	RRC
	RRC
	ANI	1FH	;AND CLEAR BITS 7,6,5.
	MOV	C,A
	MOV	A,B
	ADD	A	;NOW SHIFT (B) INTO BITS 7,6,5.
	ADD	A
	ADD	A
	ADD	A
	ADD	A
	ORA	C	;AND ADD IN (C).
	MOV	C,A	;OK, (C) HA BEEN COMPLETED.
	MOV	A,B	;IS THERE A BETTER WAY OF DOING THIS?
	RRC
	RRC
	RRC
	ANI	1FH
	MOV	B,A	;AND NOW (B) IS COMPLETED.
;
;   USE THIS AS AN OFFSET INTO THE DISK SPACE ALLOCATION
; TABLE.
;
	LHLD	ALOCVECT
	DAD	B
	MOV	A,M	;NOW GET CORRECT BYTE.
CKBMAP1	RLC		;GET CORRECT BIT INTO POSITION 0.
	DCR	E
	JNZ	CKBMAP1
	RET
;
;   SET OR CLEAR THE BIT MAP SUCH THAT BLOCK NUMBER (BC) WILL BE MARKED
; AS USED. ON ENTRY, IF (E)=0 THEN THIS BIT WILL BE CLEARED, IF IT EQUALS
; 1 THEN IT WILL BE SET (DON'T USE ANYOTHER VALUES).
;
STBITMAP:	PUSH	D
	CALL	CKBITMAP;GET THE BYTE OF INTEREST.
	ANI	0FEH	;CLEAR THE AFFECTED BIT.
	POP	B
	ORA	C	;AND NOW SET IT ACORDING TO (C).
;
;  ENTRY TO RESTORE THE ORIGINAL BIT POSITION AND THEN STORE
; IN TABLE. (A) CONTAINS THE VALUE, (D) CONTAINS THE BIT
; POSITION (1-8), AND (HL) POINTS TO THE ADDRESS WITHIN THE
; SPACE ALLOCATION TABLE FOR THIS BYTE.
;
STBMAP1	RRC		;RESTORE ORIGINAL BIT POSITION.
	DCR	D
	JNZ	STBMAP1
	MOV	M,A	;AND STOR BYTE IN TABLE.
	RET
;
;   SET/CLEAR SPACE USED BITS IN ALLOCATION MAP FOR THIS FILE.
; ON ENTRY, (C)=1 TO SET THE MAP AND (C)=0 TO CLEAR IT.
;
SETFILE	CALL	FCB2HL	;GET ADDRESS OF FCB
	LXI	D,16
	DAD	D	;GET TO BLOCK NUMBER BYTES.
	PUSH	B
	MVI	C,17	;CHECK ALL 17 BYTES (MAX) OF TABLE.
SETFL1	POP	D
	DCR	C	;DONE ALL BYTES YET?
	RZ
	PUSH	D
	LDA	BIGDISK	;CHECK DISK SIZE FOR 16 BIT BLOCK NUMBERS.
	ORA	A
	JZ	SETFL2
	PUSH	B	;ONLY 8 BIT NUMBERS. SET (BC) TO THIS ONE.
	PUSH	H
	MOV	C,M	;GET LOW BYTE FROM TABLE, ALWAYS
	MVI	B,0	;SET HIGH BYTE TO ZERO.
	JMP	SETFL3
SETFL2	DCR	C	;FOR 16 BIT BLOCK NUMBERS, ADJUST COUNTER.
	PUSH	B
	MOV	C,M	;NOW GET BOTH THE LOW AND HIGH BYTES.
	INX	H
	MOV	B,M
	PUSH	H
SETFL3	MOV	A,C	;BLOCK USED?
	ORA	B
	JZ	SETFL4
	LHLD	DSKSIZE	;IS THIS BLOCK NUMBER WITHIN THE
	MOV	A,L	;SPACE ON THE DISK?
	SUB	C
	MOV	A,H
	SBB	B
	CNC	STBITMAP;YES, SET THE PROPER BIT.
SETFL4	POP	H	;POINT TO NEXT BLOCK NUMBER IN FCB.
	INX	H
	POP	B
	JMP	SETFL1
;
;   CONSTRUCT THE SPACE USED ALLOCATION BIT MAP FOR THE ACTIVE
; DRIVE. IF A FILE NAME STARTS WITH '$' AND IT IS UNDER THE
; CURRENT USER NUMBER, THEN (STATUS) IS SET TO MINUS 1. OTHERWISE
; IT IS NOT SET AT ALL.
;
BITMAP	LHLD	DSKSIZE	;COMPUTE SIZE OF ALLOCATION TABLE.
	MVI	C,3
	CALL	SHIFTR	;(HL)=(HL)/8.
	INX	H	;AT LEASE 1 BYTE.
	MOV	B,H
	MOV	C,L	;SET (BC) TO THE ALLOCATION TABLE LENGTH.
;
;   INITIALIZE THE BITMAP FOR THIS DRIVE. RIGHT NOW, THE FIRST
; TWO BYTES ARE SPECIFIED BY THE DISK PARAMETER BLOCK. HOWEVER
; A PATCH COULD BE ENTERED HERE IF IT WERE NECESSARY TO SETUP
; THIS TABLE IN A SPECIAL MANNOR. FOR EXAMPLE, THE BIOS COULD
; DETERMINE LOCATIONS OF 'BAD BLOCKS' AND SET THEM AS ALREADY
; 'USED' IN THE MAP.
;
	LHLD	ALOCVECT;NOW ZERO OUT THE TABLE NOW.
BITMAP1	MVI	M,0
	INX	H
	DCX	B
	MOV	A,B
	ORA	C
	JNZ	BITMAP1
	LHLD	ALLOC0	;GET INITIAL SPACE USED BY DIRECTORY.
	XCHG
	LHLD	ALOCVECT;AND PUT THIS INTO MAP.
	MOV	M,E
	INX	H
	MOV	M,D
;
;   END OF INITIALIZATION PORTION.
;
	CALL	HOMEDRV	;NOW HOME THE DRIVE.
	LHLD	SCRATCH1
	MVI	M,3	;FORCE NEXT DIRECTORY REQUEST TO READ
	INX	H	;IN A SECTOR.
	MVI	M,0
	CALL	STFILPOS;CLEAR INITIAL FILE POSITION ALSO.
BITMAP2	MVI	C,0FFH	;READ NEXT FILE NAME IN DIRECTORY
	CALL	NXENTRY	;AND SET CHECKSUM BYTE.
	CALL	CKFILPOS;IS THERE ANOTHER FILE?
	RZ
	CALL	FCB2HL	;YES, GET ITS ADDRESS.
	MVI	A,0E5H
	CMP	M	;EMPTY FILE ENTRY?
	JZ	BITMAP2
	LDA	USERNO	;NO, CORRECT USER NUMBER?
	CMP	M
	JNZ	BITMAP3
	INX	H
	MOV	A,M	;YES, DOES NAME START WITH A '$'?
	SUI	'$'
	JNZ	BITMAP3
	DCR	A	;YES, SET ATATUS TO MINUS ONE.
	STA	STATUS
BITMAP3	MVI	C,1	;NOW SET THIS FILE'S SPACE AS USED IN BIT MAP.
	CALL	SETFILE
	CALL	CHKNMBR	;KEEP (SCRATCH1) IN BOUNDS.
	JMP	BITMAP2
;
;   SET THE STATUS (STATUS) AND RETURN.
;
STSTATUS:	LDA	FNDSTAT
	JMP	SETSTAT
;
;   CHECK EXTENTS IN (A) AND (C). SET THE ZERO FLAG IF THEY
; ARE THE SAME. THE NUMBER OF 16K CHUNKS OF DISK SPACE THAT
; THE DIRECTORY EXTENT COVERS IS EXPRESSAD IS (EXTMASK+1).
; NO REGISTERS ARE MODIFIED.
;
SAMEXT	PUSH	B
	PUSH	PSW
	LDA	EXTMASK	;GET EXTENT MASK AND USE IT TO
	CMA		;TO COMPARE BOTH EXTENT NUMBERS.
	MOV	B,A	;SAVE RESULTING MASK HERE.
	MOV	A,C	;MASK FIRST EXTENT AND SAVE IN (C).
	ANA	B
	MOV	C,A
	POP	PSW	;NOW MASK SECOND EXTENT AND COMPARE
	ANA	B	;WITH THE FIRST ONE.
	SUB	C
	ANI	1FH	;(* ONLY CHECK BUTS 0-4 *)
	POP	B	;THE ZERO FLAG IS SET IF THEY ARE THE SAME.
	RET		;RESTORE (BC) AND RETURN.
;
;   SEARCH FOR THE FIRST OCCURENCE OF A FILE NAME. ON ENTRY,
; REGISTER (C) SHOULD CONTAIN THE NUMBER OF BYTES OF THE FCB
; THAT MUST MATCH.
;
FINDFST	MVI	A,0FFH
	STA	FNDSTAT
	LXI	H,COUNTER;SAVE CHARACTER COUNT.
	MOV	M,C
	LHLD	PARAMS	;GET FILENAME TO MATCH.
	SHLD	SAVEFCB	;AND SAVE.
	CALL	STFILPOS;CLEAR INITIAL FILE POSITION (SET TO 0FFFFH).
	CALL	HOMEDRV	;HOME THE DRIVE.
;
;   ENTRY TO LOCATE THE NEXT OCCURENCE OF A FILENAME WITHIN THE
; DIRECTORY. THE DISK IS NOT EXPECTED TO HAVE BEEN CHANGED. IF
; IT WAS, THEN IT WILL BE WRITE PROTECTED.
;
FINDNXT	MVI	C,0	;WRITE PROTECT THE DISK IF CHANGED.
	CALL	NXENTRY	;GET NEXT FILENAME ENTRY IN DIRECTORY.
	CALL	CKFILPOS;IS FILE POSITION = 0FFFFH?
	JZ	FNDNXT6	;YES, EXIT NOW THEN.
	LHLD	SAVEFCB	;SET (DE) POINTING TO FILENAME TO MATCH.
	XCHG
	LDAX	D
	CPI	0E5H	;EMPTY DIRECTORY ENTRY?
	JZ	FNDNXT1	;(* ARE WE TRYING TO RESERECT ERASED ENTRIES? *)
	PUSH	D
	CALL	MOREFLS	;MORE FILES IN DIRECTORY?
	POP	D
	JNC	FNDNXT6	;NO MORE. EXIT NOW.
FNDNXT1	CALL	FCB2HL	;GET ADDRESS OF THIS FCB IN DIRECTORY.
	LDA	COUNTER	;GET NUMBER OF BYTES (CHARACTERS) TO CHECK.
	MOV	C,A
	MVI	B,0	;INITIALIZE BYTE POSITION COUNTER.
FNDNXT2	MOV	A,C	;ARE WE DONE WITH THE COMPARE?
	ORA	A
	JZ	FNDNXT5
	LDAX	D	;NO, CHECK NEXT BYTE.
	CPI	'?'	;DON'T CARE ABOUT THIS CHARACTER?
	JZ	FNDNXT4
	MOV	A,B	;GET BYTES POSITION IN FCB.
	CPI	13	;DON'T CARE ABOUT THE THIRTEENTH BYTE EITHER.
	JZ	FNDNXT4
	CPI	12	;EXTENT BYTE?
	LDAX	D
	JZ	FNDNXT3
	SUB	M	;OTHERWISE COMPARE CHARACTERS.
	ANI	7FH
	JNZ	FINDNXT	;NOT THE SAME, CHECK NEXT ENTRY.
	JMP	FNDNXT4	;SO FAR SO GOOD, KEEP CHECKING.
FNDNXT3	PUSH	B	;CHECK THE EXTENT BYTE HERE.
	MOV	C,M
	CALL	SAMEXT
	POP	B
	JNZ	FINDNXT	;NOT THE SAME, LOOK SOME MORE.
;
;   SO FAR THE NAMES COMPARE. BUMP POINTERS TO THE NEXT BYTE
; AND CONTINUE UNTIL ALL (C) CHARACTERS HAVE BEEN CHECKED.
;
FNDNXT4	INX	D	;BUMP POINTERS.
	INX	H
	INR	B
	DCR	C	;ADJUST CHARACTER COUNTER.
	JMP	FNDNXT2
FNDNXT5	LDA	FILEPOS	;RETURN THE POSITION OF THIS ENTRY.
	ANI	03H
	STA	STATUS
	LXI	H,FNDSTAT
	MOV	A,M
	RAL
	RNC
	XRA	A
	MOV	M,A
	RET
;
;   FILENAME WAS NOT FOUND. SET APPROPRIATE STATUS.
;
FNDNXT6	CALL	STFILPOS;SET (FILEPOS) TO 0FFFFH.
	MVI	A,0FFH	;SAY NOT LOCATED.
	JMP	SETSTAT
;
;   ERASE FILES FROM THE DIRECTORY. ONLY THE FIRST BYTE OF THE
; FCB WILL BE AFFECTED. IT IS SET TO (E5).
;
ERAFILE	CALL	CHKWPRT	;IS DISK WRITE PROTECTED?
	MVI	C,12	;ONLY COMPARE FILE NAMES.
	CALL	FINDFST	;GET FIRST FILE NAME.
ERAFIL1	CALL	CKFILPOS;ANY FOUND?
	RZ		;NOPE, WE MUST BE DONE.
	CALL	CHKROFL	;IS FILE READ ONLY?
	CALL	FCB2HL	;NOPE, GET ADDRESS OF FCB AND
	MVI	M,0E5H	;SET FIRST BYTE TO 'EMPTY'.
	MVI	C,0	;CLEAR THE SPACE FROM THE BIT MAP.
	CALL	SETFILE
	CALL	DIRWRITE;NOW WRITE THE DIRECTORY SECTOR BACK OUT.
	CALL	FINDNXT	;FIND THE NEXT FILE NAME.
	JMP	ERAFIL1	;AND REPEAT PROCESS.
;
;   LOOK THROUGH THE SPACE ALLOCATION MAP (BIT MAP) FOR THE
; NEXT AVAILABLE BLOCK. START SEARCHING AT BLOCK NUMBER (BC-1).
; THE SEARCH PROCEDURE IS TO LOOK FOR AN EMPTY BLOCK THAT IS
; BEFORE THE STARTING BLOCK. IF NOT EMPTY, LOOK AT A LATER
; BLOCK NUMBER. IN THIS WAY, WE RETURN THE CLOSEST EMPTY BLOCK
; ON EITHER SIDE OF THE 'TARGET' BLOCK NUMBER. THIS WILL SPEED
; ACCESS ON RANDOM DEVICES. FOR SERIAL DEVICES, THIS SHOULD BE
; CHANGED TO LOOK IN THE FORWARD DIRECTION FIRST AND THEN START
; AT THE FRONT AND SEARCH SOME MORE.
;
;   ON RETURN, (DE)= BLOCK NUMBER THAT IS EMPTY AND (HL) =0
; IF NO EMPRY BLOCK WAS FOUND.
;
FNDSPACE:	MOV	D,B	;SET (DE) AS THE BLOCK THAT IS CHECKED.
	MOV	E,C
;
;   LOOK BEFORE TARGET BLOCK. REGISTERS (BC) ARE USED AS THE LOWER
; POINTER AND (DE) AS THE UPPER POINTER.
;
FNDSPA1	MOV	A,C	;IS BLOCK 0 SPECIFIED?
	ORA	B
	JZ	FNDSPA2
	DCX	B	;NOPE, CHECK PREVIOUS BLOCK.
	PUSH	D
	PUSH	B
	CALL	CKBITMAP
	RAR		;IS THIS BLOCK EMPTY?
	JNC	FNDSPA3	;YES. USE THIS.
;
;   NOTE THAT THE ABOVE LOGIC GETS THE FIRST BLOCK THAT IT FINDS
; THAT IS EMPTY. THUS A FILE COULD BE WRITTEN 'BACKWARD' MAKING
; IT VERY SLOW TO ACCESS. THIS COULD BE CHANGED TO LOOK FOR THE
; FIRST EMPTY BLOCK AND THEN CONTINUE UNTIL THE START OF THIS
; EMPTY SPACE IS LOCATED AND THEN USED THAT STARTING BLOCK.
; THIS SHOULD HELP SPEED UP ACCESS TO SOME FILES ESPECIALLY ON
; A WELL USED DISK WITH LOTS OF FAIRLY SMALL 'HOLES'.
;
	POP	B	;NOPE, CHECK SOME MORE.
	POP	D
;
;   NOW LOOK AFTER TARGET BLOCK.
;
FNDSPA2	LHLD	DSKSIZE	;IS BLOCK (DE) WITHIN DISK LIMITS?
	MOV	A,E
	SUB	L
	MOV	A,D
	SBB	H
	JNC	FNDSPA4
	INX	D	;YES, MOVE ON TO NEXT ONE.
	PUSH	B
	PUSH	D
	MOV	B,D
	MOV	C,E
	CALL	CKBITMAP;CHECK IT.
	RAR		;EMPTY?
	JNC	FNDSPA3
	POP	D	;NOPE, CONTINUE SEARCHING.
	POP	B
	JMP	FNDSPA1
;
;   EMPTY BLOCK FOUND. SET IT AS USED AND RETURN WITH (HL)
; POINTING TO IT (TRUE?).
;
FNDSPA3	RAL		;RESET BYTE.
	INR	A	;AND SET BIT 0.
	CALL	STBMAP1	;UPDATE BIT MAP.
	POP	H	;SET RETURN REGISTERS.
	POP	D
	RET
;
;   FREE BLOCK WAS NOT FOUND. IF (BC) IS NOT ZERO, THEN WE HAVE
; NOT CHECKED ALL OF THE DISK SPACE.
;
FNDSPA4	MOV	A,C
	ORA	B
	JNZ	FNDSPA1
	LXI	H,0	;SET 'NOT FOUND' STATUS.
	RET
;
;   MOVE A COMPLETE FCB ENTRY INTO THE DIRECTORY AND WRITE IT.
;
FCBSET	MVI	C,0
	MVI	E,32	;LENGTH OF EACH ENTRY.
;
;   MOVE (E) BYTES FROM THE FCB POINTED TO BY (PARAMS) INTO
; FCB IN DIRECTORY STARTING AT RELATIVE BYTE (C). THIS UPDATED
; DIRECTORY BUFFER IS THEN WRITTEN TO THE DISK.
;
UPDATE	PUSH	D
	MVI	B,0	;SET (BC) TO RELATIVE BYTE POSITION.
	LHLD	PARAMS	;GET ADDRESS OF FCB.
	DAD	B	;COMPUTE STARTING BYTE.
	XCHG
	CALL	FCB2HL	;GET ADDRESS OF FCB TO UPDATE IN DIRECTORY.
	POP	B	;SET (C) TO NUMBER OF BYTES TO CHANGE.
	CALL	DE2HL
UPDATE1	CALL	TRKSEC	;DETERMINE THE TRACK AND SECTOR AFFECTED.
	JMP	DIRWRITE	;THEN WRITE THIS SECTOR OUT.
;
;   ROUTINE TO CHANGE THE NAME OF ALL FILES ON THE DISK WITH A
; SPECIFIED NAME. THE FCB CONTAINS THE CURRENT NAME AS THE
; FIRST 12 CHARACTERS AND THE NEW NAME 16 BYTES INTO THE FCB.
;
CHGNAMES:	CALL	CHKWPRT	;CHECK FOR A WRITE PROTECTED DISK.
	MVI	C,12	;MATCH FIRST 12 BYTES OF FCB ONLY.
	CALL	FINDFST	;GET FIRST NAME.
	LHLD	PARAMS	;GET ADDRESS OF FCB.
	MOV	A,M	;GET USER NUMBER.
	LXI	D,16	;MOVE OVER TO DESIRED NAME.
	DAD	D
	MOV	M,A	;KEEP SAME USER NUMBER.
CHGNAM1	CALL	CKFILPOS;ANY MATCHING FILE FOUND?
	RZ		;NO, WE MUST BE DONE.
	CALL	CHKROFL	;CHECK FOR READ ONLY FILE.
	MVI	C,16	;START 16 BYTES INTO FCB.
	MVI	E,12	;AND UPDATE THE FIRST 12 BYTES OF DIRECTORY.
	CALL	UPDATE
	CALL	FINDNXT	;GET TE NEXT FILE NAME.
	JMP	CHGNAM1	;AND CONTINUE.
;
;   UPDATE A FILES ATTRIBUTES. THE PROCEDURE IS TO SEARCH FOR
; EVERY FILE WITH THE SAME NAME AS SHOWN IN FCB (IGNORING BIT 7)
; AND THEN TO UPDATE IT (WHICH INCLUDES BIT 7). NO OTHER CHANGES
; ARE MADE.
;
SAVEATTR:	MVI	C,12	;MATCH FIRST 12 BYTES.
	CALL	FINDFST	;LOOK FOR FIRST FILENAME.
SAVATR1	CALL	CKFILPOS;WAS ONE FOUND?
	RZ		;NOPE, WE MUST BE DONE.
	MVI	C,0	;YES, UPDATE THE FIRST 12 BYTES NOW.
	MVI	E,12
	CALL	UPDATE	;UPDATE FILENAME AND WRITE DIRECTORY.
	CALL	FINDNXT	;AND GET THE NEXT FILE.
	JMP	SAVATR1	;THEN CONTINUE UNTIL DONE.
;
;  OPEN A FILE (NAME SPECIFIED IN FCB).
;
OPENIT	MVI	C,15	;COMPARE THE FIRST 15 BYTES.
	CALL	FINDFST	;GET THE FIRST ONE IN DIRECTORY.
	CALL	CKFILPOS;ANY AT ALL?
	RZ
OPENIT1	CALL	SETEXT	;POINT TO EXTENT BYTE WITHIN USERS FCB.
	MOV	A,M	;AND GET IT.
	PUSH	PSW	;SAVE IT AND ADDRESS.
	PUSH	H
	CALL	FCB2HL	;POINT TO FCB IN DIRECTORY.
	XCHG
	LHLD	PARAMS	;THIS IS THE USERS COPY.
	MVI	C,32	;MOVE IT INTO USERS SPACE.
	PUSH	D
	CALL	DE2HL
	CALL	SETS2B7	;SET BIT 7 IN 'S2' BYTE (UNMODIFIED).
	POP	D	;NOW GET THE EXTENT BYTE FROM THIS FCB.
	LXI	H,12
	DAD	D
	MOV	C,M	;INTO (C).
	LXI	H,15	;NOW GET THE RECORD COUNT BYTE INTO (B).
	DAD	D
	MOV	B,M
	POP	H	;KEEP THE SAME EXTENT AS THE USER HAD ORIGINALLY.
	POP	PSW
	MOV	M,A
	MOV	A,C	;IS IT THE SAME AS IN THE DIRECTORY FCB?
	CMP	M
	MOV	A,B	;IF YES, THEN USE THE SAME RECORD COUNT.
	JZ	OPENIT2
	MVI	A,0	;IF THE USER SPECIFIED AN EXTENT GREATER THAN
	JC	OPENIT2	;THE ONE IN THE DIRECTORY, THEN SET RECORD COUNT TO 0.
	MVI	A,128	;OTHERWISE SET TO MAXIMUM.
OPENIT2	LHLD	PARAMS	;SET RECORD COUNT IN USERS FCB TO (A).
	LXI	D,15
	DAD	D	;COMPUTE RELATIVE POSITION.
	MOV	M,A	;AND SET THE RECORD COUNT.
	RET
;
;   MOVE TWO BYTES FROM (DE) TO (HL) IF (AND ONLY IF) (HL)
; POINT TO A ZERO VALUE (16 BIT).
;   RETURN WITH ZERO FLAG SET IT (DE) WAS MOVED. REGISTERS (DE)
; AND (HL) ARE NOT CHANGED. HOWEVER (A) IS.
;
MOVEWORD:	MOV	A,M	;CHECK FOR A ZERO WORD.
	INX	H
	ORA	M	;BOTH BYTES ZERO?
	DCX	H
	RNZ		;NOPE, JUST RETURN.
	LDAX	D	;YES, MOVE TWO BYTES FROM (DE) INTO
	MOV	M,A	;THIS ZERO SPACE.
	INX	D
	INX	H
	LDAX	D
	MOV	M,A
	DCX	D	;DON'T DISTURB THESE REGISTERS.
	DCX	H
	RET
;
;   GET HERE TO CLOSE A FILE SPECIFIED BY (FCB).
;
CLOSEIT	XRA	A	;CLEAR STATUS AND FILE POSITION BYTES.
	STA	STATUS
	STA	FILEPOS
	STA	FILEPOS+1
	CALL	GETWPRT	;GET WRITE PROTECT BIT FOR THIS DRIVE.
	RNZ		;JUST RETURN IF IT IS SET.
	CALL	GETS2	;ELSE GET THE 'S2' BYTE.
	ANI	80H	;AND LOOK AT BIT 7 (FILE UNMODIFIED?).
	RNZ		;JUST RETURN IF SET.
	MVI	C,15	;ELSE LOOK UP THIS FILE IN DIRECTORY.
	CALL	FINDFST
	CALL	CKFILPOS;WAS IT FOUND?
	RZ		;JUST RETURN IF NOT.
	LXI	B,16	;SET (HL) POINTING TO RECORDS USED SECTION.
	CALL	FCB2HL
	DAD	B
	XCHG
	LHLD	PARAMS	;DO THE SAME FOR USERS SPECIFIED FCB.
	DAD	B
	MVI	C,16	;THIS MANY BYTES ARE PRESENT IN THIS EXTENT.
CLOSEIT1:	LDA	BIGDISK	;8 OR 16 BIT RECORD NUMBERS?
	ORA	A
	JZ	CLOSEIT4
	MOV	A,M	;JUST 8 BIT. GET ONE FROM USERS FCB.
	ORA	A
	LDAX	D	;NOW GET ONE FROM DIRECTORY FCB.
	JNZ	CLOSEIT2
	MOV	M,A	;USERS BYTE WAS ZERO. UPDATE FROM DIRECTORY.
CLOSEIT2:	ORA	A
	JNZ	CLOSEIT3
	MOV	A,M	;DIRECTORIES BYTE WAS ZERO, UPDATE FROM USERS FCB.
	STAX	D
CLOSEIT3:	CMP	M	;IF NEITHER ONE OF THESE BYTES WERE ZERO,
	JNZ	CLOSEIT7	;THEN CLOSE ERROR IF THEY ARE NOT THE SAME.
	JMP	CLOSEIT5	;OK SO FAR, GET TO NEXT BYTE IN FCBS.
CLOSEIT4:	CALL	MOVEWORD;UPDATE USERS FCB IF IT IS ZERO.
	XCHG
	CALL	MOVEWORD;UPDATE DIRECTORIES FCB IF IT IS ZERO.
	XCHG
	LDAX	D	;IF THESE TWO VALUES ARE NO DIFFERENT,
	CMP	M	;THEN A CLOSE ERROR OCCURED.
	JNZ	CLOSEIT7
	INX	D	;CHECK SECOND BYTE.
	INX	H
	LDAX	D
	CMP	M
	JNZ	CLOSEIT7
	DCR	C	;REMEMBER 16 BIT VALUES.
CLOSEIT5:	INX	D	;BUMP TO NEXT ITEM IN TABLE.
	INX	H
	DCR	C	;THERE ARE 16 ENTRIES ONLY.
	JNZ	CLOSEIT1;CONTINUE IF MORE TO DO.
	LXI	B,0FFECH;BACKUP 20 PLACES (EXTENT BYTE).
	DAD	B
	XCHG
	DAD	B
	LDAX	D
	CMP	M	;DIRECTORY'S EXTENT ALREADY GREATER THAN THE
	JC	CLOSEIT6	;USERS EXTENT?
	MOV	M,A	;NO, UPDATE DIRECTORY EXTENT.
	LXI	B,3	;AND UPDATE THE RECORD COUNT BYTE IN
	DAD	B	;DIRECTORIES FCB.
	XCHG
	DAD	B
	MOV	A,M	;GET FROM USER.
	STAX	D	;AND PUT IN DIRECTORY.
CLOSEIT6:	MVI	A,0FFH	;SET 'WAS OPEN AND IS NOW CLOSED' BYTE.
	STA	CLOSEFLG
	JMP	UPDATE1	;UPDATE THE DIRECTORY NOW.
CLOSEIT7:	LXI	H,STATUS;SET RETURN STATUS AND THEN RETURN.
	DCR	M
	RET
;
;   ROUTINE TO GET THE NEXT EMPTY SPACE IN THE DIRECTORY. IT
; WILL THEN BE CLEARED FOR USE.
;
GETEMPTY:	CALL	CHKWPRT	;MAKE SURE DISK IS NOT WRITE PROTECTED.
	LHLD	PARAMS	;SAVE CURRENT PARAMETERS (FCB).
	PUSH	H
	LXI	H,EMPTYFCB;USE SPECIAL ONE FOR EMPTY SPACE.
	SHLD	PARAMS
	MVI	C,1	;SEARCH FOR FIRST EMPTY SPOT IN DIRECTORY.
	CALL	FINDFST	;(* ONLY CHECK FIRST BYTE *)
	CALL	CKFILPOS;NONE?
	POP	H
	SHLD	PARAMS	;RESTORE ORIGINAL FCB ADDRESS.
	RZ		;RETURN IF NO MORE SPACE.
	XCHG
	LXI	H,15	;POINT TO NUMBER OF RECORDS FOR THIS FILE.
	DAD	D
	MVI	C,17	;AND CLEAR ALL OF THIS SPACE.
	XRA	A
GETMT1	MOV	M,A
	INX	H
	DCR	C
	JNZ	GETMT1
	LXI	H,13	;CLEAR THE 'S1' BYTE ALSO.
	DAD	D
	MOV	M,A
	CALL	CHKNMBR	;KEEP (SCRATCH1) WITHIN BOUNDS.
	CALL	FCBSET	;WRITE OUT THIS FCB ENTRY TO DIRECTORY.
	JMP	SETS2B7	;SET 'S2' BYTE BIT 7 (UNMODIFIED AT PRESENT).
;
;   ROUTINE TO CLOSE THE CURRENT EXTENT AND OPEN THE NEXT ONE
; FOR READING.
;
GETNEXT	XRA	A
	STA	CLOSEFLG;CLEAR CLOSE FLAG.
	CALL	CLOSEIT	;CLOSE THIS EXTENT.
	CALL	CKFILPOS
	RZ		;NOT THERE???
	LHLD	PARAMS	;GET EXTENT BYTE.
	LXI	B,12
	DAD	B
	MOV	A,M	;AND INCREMENT IT.
	INR	A
	ANI	1FH	;KEEP WITHIN RANGE 0-31.
	MOV	M,A
	JZ	GTNEXT1	;OVERFLOW?
	MOV	B,A	;MASK EXTENT BYTE.
	LDA	EXTMASK
	ANA	B
	LXI	H,CLOSEFLG;CHECK CLOSE FLAG (0FFH IS OK).
	ANA	M
	JZ	GTNEXT2	;IF ZERO, WE MUST READ IN NEXT EXTENT.
	JMP	GTNEXT3	;ELSE, IT IS ALREADY IN MEMORY.
GTNEXT1	LXI	B,2	;POINT TO THE 'S2' BYTE.
	DAD	B
	INR	M	;AND BUMP IT.
	MOV	A,M	;TOO MANY EXTENTS?
	ANI	0FH
	JZ	GTNEXT5	;YES, SET ERROR CODE.
;
;   GET HERE TO OPEN THE NEXT EXTENT.
;
GTNEXT2	MVI	C,15	;SET TO CHECK FIRST 15 BYTES OF FCB.
	CALL	FINDFST	;FIND THE FIRST ONE.
	CALL	CKFILPOS;NONE AVAILABLE?
	JNZ	GTNEXT3
	LDA	RDWRTFLG;NO EXTENT PRESENT. CAN WE OPEN AN EMPTY ONE?
	INR	A	;0FFH MEANS READING (SO NOT POSSIBLE).
	JZ	GTNEXT5	;OR AN ERROR.
	CALL	GETEMPTY;WE ARE WRITING, GET AN EMPTY ENTRY.
	CALL	CKFILPOS;NONE?
	JZ	GTNEXT5	;ERROR IF TRUE.
	JMP	GTNEXT4	;ELSE WE ARE ALMOST DONE.
GTNEXT3	CALL	OPENIT1	;OPEN THIS EXTENT.
GTNEXT4	CALL	STRDATA	;MOVE IN UPDATED DATA (REC #, EXTENT #, ETC.)
	XRA	A	;CLEAR STATUS AND RETURN.
	JMP	SETSTAT
;
;   ERROR IN EXTENDING THE FILE. TOO MANY EXTENTS WERE NEEDED
; OR NOT ENOUGH SPACE ON THE DISK.
;
GTNEXT5	CALL	IOERR1	;SET ERROR CODE, CLEAR BIT 7 OF 'S2'
	JMP	SETS2B7	;SO THIS IS NOT WRITTEN ON A CLOSE.
;
;   READ A SEQUENTIAL FILE.
;
RDSEQ	MVI	A,1	;SET SEQUENTIAL ACCESS MODE.
	STA	MODE
RDSEQ1	MVI	A,0FFH	;DON'T ALLOW READING UNWRITTEN SPACE.
	STA	RDWRTFLG
	CALL	STRDATA	;PUT REC# AND EXT# INTO FCB.
	LDA	SAVNREC	;GET NEXT RECORD TO READ.
	LXI	H,SAVNXT;GET NUMBER OF RECORDS IN EXTENT.
	CMP	M	;WITHIN THIS EXTENT?
	JC	RDSEQ2
	CPI	128	;NO. IS THIS EXTENT FULLY USED?
	JNZ	RDSEQ3	;NO. END-OF-FILE.
	CALL	GETNEXT	;YES, OPEN THE NEXT ONE.
	XRA	A	;RESET NEXT RECORD TO READ.
	STA	SAVNREC
	LDA	STATUS	;CHECK ON OPEN, SUCCESSFUL?
	ORA	A
	JNZ	RDSEQ3	;NO, ERROR.
RDSEQ2	CALL	COMBLK	;OK. COMPUTE BLOCK NUMBER TO READ.
	CALL	CHKBLK	;CHECK IT. WITHIN BOUNDS?
	JZ	RDSEQ3	;NO, ERROR.
	CALL	LOGICAL	;CONVERT (BLKNMBR) TO LOGICAL SECTOR (128 BYTE).
	CALL	TRKSEC1	;SET THE TRACK AND SECTOR FOR THIS BLOCK #.
	CALL	DOREAD	;AND READ IT.
	JMP	SETNREC	;AND SET THE NEXT RECORD TO BE ACCESSED.
;
;   READ ERROR OCCURED. SET STATUS AND RETURN.
;
RDSEQ3	JMP	IOERR1
;
;   WRITE THE NEXT SEQUENTIAL RECORD.
;
WTSEQ	MVI	A,1	;SET SEQUENTIAL ACCESS MODE.
	STA	MODE
WTSEQ1	MVI	A,0	;ALLOW AN ADDITION EMPTY EXTENT TO BE OPENED.
	STA	RDWRTFLG
	CALL	CHKWPRT	;CHECK WRITE PROTECT STATUS.
	LHLD	PARAMS
	CALL	CKROF1	;CHECK FOR READ ONLY FILE, (HL) ALREADY SET TO FCB.
	CALL	STRDATA	;PUT UPDATED DATA INTO FCB.
	LDA	SAVNREC	;GET RECORD NUMBER TO WRITE.
	CPI	128	;WITHIN RANGE?
	JNC	IOERR1	;NO, ERROR(?).
	CALL	COMBLK	;COMPUTE BLOCK NUMBER.
	CALL	CHKBLK	;CHECK NUMBER.
	MVI	C,0	;IS THERE ONE TO WRITE TO?
	JNZ	WTSEQ6	;YES, GO DO IT.
	CALL	GETBLOCK;GET NEXT BLOCK NUMBER WITHIN FCB TO USE.
	STA	RELBLOCK;AND SAVE.
	LXI	B,0	;START LOOKING FOR SPACE FROM THE START
	ORA	A	;IF NONE ALLOCATED AS YET.
	JZ	WTSEQ2
	MOV	C,A	;EXTRACT PREVIOUS BLOCK NUMBER FROM FCB
	DCX	B	;SO WE CAN BE CLOSEST TO IT.
	CALL	EXTBLK
	MOV	B,H
	MOV	C,L
WTSEQ2	CALL	FNDSPACE;FIND THE NEXT EMPTY BLOCK NEAREST NUMBER (BC).
	MOV	A,L	;CHECK FOR A ZERO NUMBER.
	ORA	H
	JNZ	WTSEQ3
	MVI	A,2	;NO MORE SPACE?
	JMP	SETSTAT
WTSEQ3	SHLD	BLKNMBR	;SAVE BLOCK NUMBER TO ACCESS.
	XCHG		;PUT BLOCK NUMBER INTO (DE).
	LHLD	PARAMS	;NOW WE MUST UPDATE THE FCB FOR THIS
	LXI	B,16	;NEWLY ALLOCATED BLOCK.
	DAD	B
	LDA	BIGDISK	;8 OR 16 BIT BLOCK NUMBERS?
	ORA	A
	LDA	RELBLOCK	;(* UPDATE THIS ENTRY *)
	JZ	WTSEQ4	;ZERO MEANS 16 BIT ONES.
	CALL	ADDA2HL	;(HL)=(HL)+(A)
	MOV	M,E	;STORE NEW BLOCK NUMBER.
	JMP	WTSEQ5
WTSEQ4	MOV	C,A	;COMPUTE SPOT IN THIS 16 BIT TABLE.
	MVI	B,0
	DAD	B
	DAD	B
	MOV	M,E	;STUFF BLOCK NUMBER (DE) THERE.
	INX	H
	MOV	M,D
WTSEQ5	MVI	C,2	;SET (C) TO INDICATE WRITING TO UN-USED DISK SPACE.
WTSEQ6	LDA	STATUS	;ARE WE OK SO FAR?
	ORA	A
	RNZ
	PUSH	B	;YES, SAVE WRITE FLAG FOR BIOS (REGISTER C).
	CALL	LOGICAL	;CONVERT (BLKNMBR) OVER TO LOICAL SECTORS.
	LDA	MODE	;GET ACCESS MODE FLAG (1=SEQUENTIAL,
	DCR	A	;0=RANDOM, 2=SPECIAL?).
	DCR	A
	JNZ	WTSEQ9
;
;   SPECIAL RANDOM I/O FROM FUNCTION #40. MAYBE FOR M/PM, BUT THE
; CURRENT BLOCK, IF IT HAS NOT BEEN WRITTEN TO, WILL BE ZEROED
; OUT AND THEN WRITTEN (REASON?).
;
	POP	B
	PUSH	B
	MOV	A,C	;GET WRITE STATUS FLAG (2=WRITING UNUSED SPACE).
	DCR	A
	DCR	A
	JNZ	WTSEQ9
	PUSH	H
	LHLD	DIRBUF	;ZERO OUT THE DIRECTORY BUFFER.
	MOV	D,A	;NOTE THAT (A) IS ZERO HERE.
WTSEQ7	MOV	M,A
	INX	H
	INR	D	;DO 128 BYTES.
	JP	WTSEQ7
	CALL	DIRDMA	;TELL THE BIOS THE DMA ADDRESS FOR DIRECTORY ACCESS.
	LHLD	LOGSECT	;GET SECTOR THAT STARTS CURRENT BLOCK.
	MVI	C,2	;SET 'WRITING TO UNUSED SPACE' FLAG.
WTSEQ8	SHLD	BLKNMBR	;SAVE SECTOR TO WRITE.
	PUSH	B
	CALL	TRKSEC1	;DETERMINE ITS TRACK AND SECTOR NUMBERS.
	POP	B
	CALL	DOWRITE	;NOW WRITE OUT 128 BYTES OF ZEROS.
	LHLD	BLKNMBR	;GET SECTOR NUMBER.
	MVI	C,0	;SET NORMAL WRITE FLAG.
	LDA	BLKMASK	;DETERMINE IF WE HAVE WRITTEN THE ENTIRE
	MOV	B,A	;PHYSICAL BLOCK.
	ANA	L
	CMP	B
	INX	H	;PREPARE FOR THE NEXT ONE.
	JNZ	WTSEQ8	;CONTINUE UNTIL (BLKMASK+1) SECTORS WRITTEN.
	POP	H	;RESET NEXT SECTOR NUMBER.
	SHLD	BLKNMBR
	CALL	DEFDMA	;AND RESET DMA ADDRESS.
;
;   NORMAL DISK WRITE. SET THE DESIRED TRACK AND SECTOR THEN
; DO THE ACTUAL WRITE.
;
WTSEQ9	CALL	TRKSEC1	;DETERMINE TRACK AND SECTOR FOR THIS WRITE.
	POP	B	;GET WRITE STATUS FLAG.
	PUSH	B
	CALL	DOWRITE	;AND WRITE THIS OUT.
	POP	B
	LDA	SAVNREC	;GET NUMBER OF RECORDS IN FILE.
	LXI	H,SAVNXT;GET LAST RECORD WRITTEN.
	CMP	M
	JC	WTSEQ10
	MOV	M,A	;WE HAVE TO UPDATE RECORD COUNT.
	INR	M
	MVI	C,2
;
;*   THIS AREA HAS BEEN PATCHED TO CORRECT DISK UPDATE PROBLEM
;* WHEN USING BLOCKING AND DE-BLOCKING IN THE BIOS.
;
WTSEQ10	NOP		;WAS 'DCR C'
	NOP		;WAS 'DCR C'
	LXI	H,0	;WAS 'JNZ WTSEQ99'
;
; *   END OF PATCH.
;
	PUSH	PSW
	CALL	GETS2	;SET 'EXTENT WRITTEN TO' FLAG.
	ANI	7FH	;(* CLEAR BIT 7 *)
	MOV	M,A
	POP	PSW	;GET RECORD COUNT FOR THIS EXTENT.
WTSEQ99	CPI	127	;IS IT FULL?
	JNZ	WTSEQ12
	LDA	MODE	;YES, ARE WE IN SEQUENTIAL MODE?
	CPI	1
	JNZ	WTSEQ12
	CALL	SETNREC	;YES, SET NEXT RECORD NUMBER.
	CALL	GETNEXT	;AND GET NEXT EMPTY SPACE IN DIRECTORY.
	LXI	H,STATUS;OK?
	MOV	A,M
	ORA	A
	JNZ	WTSEQ11
	DCR	A	;YES, SET RECORD COUNT TO -1.
	STA	SAVNREC
WTSEQ11	MVI	M,0	;CLEAR STATUS.
WTSEQ12	JMP	SETNREC	;SET NEXT RECORD TO ACCESS.
;
;   FOR RANDOM I/O, SET THE FCB FOR THE DESIRED RECORD NUMBER
; BASED ON THE 'R0,R1,R2' BYTES. THESE BYTES IN THE FCB ARE
; USED AS FOLLOWS:
;
;       FCB+35            FCB+34            FCB+33
;  |     'R-2'      |      'R-1'      |      'R-0'     |
;  |7             0 | 7             0 | 7             0|
;  |0 0 0 0 0 0 0 0 | 0 0 0 0 0 0 0 0 | 0 0 0 0 0 0 0 0|
;  |    OVERFLOW   | | EXTRA |  EXTENT   |   RECORD #  |
;  | ______________| |_EXTENT|__NUMBER___|_____________|
;                     ALSO 'S2'
;
;   ON ENTRY, REGISTER (C) CONTAINS 0FFH IF THIS IS A READ
; AND THUS WE CAN NOT ACCESS UNWRITTEN DISK SPACE. OTHERWISE,
; ANOTHER EXTENT WILL BE OPENED (FOR WRITING) IF REQUIRED.
;
POSITION:	XRA	A	;SET RANDOM I/O FLAG.
	STA	MODE
;
;   SPECIAL ENTRY (FUNCTION #40). M/PM ?
;
POSITN1	PUSH	B	;SAVE READ/WRITE FLAG.
	LHLD	PARAMS	;GET ADDRESS OF FCB.
	XCHG
	LXI	H,33	;NOW GET BYTE 'R0'.
	DAD	D
	MOV	A,M
	ANI	7FH	;KEEP BITS 0-6 FOR THE RECORD NUMBER TO ACCESS.
	PUSH	PSW
	MOV	A,M	;NOW GET BIT 7 OF 'R0' AND BITS 0-3 OF 'R1'.
	RAL
	INX	H
	MOV	A,M
	RAL
	ANI	1FH	;AND SAVE THIS IN BITS 0-4 OF (C).
	MOV	C,A	;THIS IS THE EXTENT BYTE.
	MOV	A,M	;NOW GET THE EXTRA EXTENT BYTE.
	RAR
	RAR
	RAR
	RAR
	ANI	0FH
	MOV	B,A	;AND SAVE IT IN (B).
	POP	PSW	;GET RECORD NUMBER BACK TO (A).
	INX	H	;CHECK OVERFLOW BYTE 'R2'.
	MOV	L,M
	INR	L
	DCR	L
	MVI	L,6	;PREPARE FOR ERROR.
	JNZ	POSITN5	;OUT OF DISK SPACE ERROR.
	LXI	H,32	;STORE RECORD NUMBER INTO FCB.
	DAD	D
	MOV	M,A
	LXI	H,12	;AND NOW CHECK THE EXTENT BYTE.
	DAD	D
	MOV	A,C
	SUB	M	;SAME EXTENT AS BEFORE?
	JNZ	POSITN2
	LXI	H,14	;YES, CHECK EXTRA EXTENT BYTE 'S2' ALSO.
	DAD	D
	MOV	A,B
	SUB	M
	ANI	7FH
	JZ	POSITN3;SAME, WE ARE ALMOST DONE THEN.
;
;  GET HERE WHEN ANOTHER EXTENT IS REQUIRED.
;
POSITN2	PUSH	B
	PUSH	D
	CALL	CLOSEIT	;CLOSE CURRENT EXTENT.
	POP	D
	POP	B
	MVI	L,3	;PREPARE FOR ERROR.
	LDA	STATUS
	INR	A
	JZ	POSITN4	;CLOSE ERROR.
	LXI	H,12	;PUT DESIRED EXTENT INTO FCB NOW.
	DAD	D
	MOV	M,C
	LXI	H,14	;AND STORE EXTRA EXTENT BYTE 'S2'.
	DAD	D
	MOV	M,B
	CALL	OPENIT	;TRY AND GET THIS EXTENT.
	LDA	STATUS	;WAS IT THERE?
	INR	A
	JNZ	POSITN3
	POP	B	;NO. CAN WE CREATE A NEW ONE (WRITING?).
	PUSH	B
	MVI	L,4	;PREPARE FOR ERROR.
	INR	C
	JZ	POSITN4	;NOPE, READING UNWRITTEN SPACE ERROR.
	CALL	GETEMPTY;YES WE CAN, TRY TO FIND SPACE.
	MVI	L,5	;PREPARE FOR ERROR.
	LDA	STATUS
	INR	A
	JZ	POSITN4	;OUT OF SPACE?
;
;   NORMAL RETURN LOCATION. CLEAR ERROR CODE AND RETURN.
;
POSITN3	POP	B	;RESTORE STACK.
	XRA	A	;AND CLEAR ERROR CODE BYTE.
	JMP	SETSTAT
;
;   ERROR. SET THE 'S2' BYTE TO INDICATE THIS (WHY?).
;
POSITN4	PUSH	H
	CALL	GETS2
	MVI	M,0C0H
	POP	H
;
;   RETURN WITH ERROR CODE (PRESENTLY IN L).
;
POSITN5	POP	B
	MOV	A,L	;GET ERROR CODE.
	STA	STATUS
	JMP	SETS2B7
;
;   READ A RANDOM RECORD.
;
READRAN	MVI	C,0FFH	;SET 'READ' STATUS.
	CALL	POSITION;POSITION THE FILE TO PROPER RECORD.
	CZ	RDSEQ1	;AND READ IT AS USUAL (IF NO ERRORS).
	RET
;
;   WRITE TO A RANDOM RECORD.
;
WRITERAN:	MVI	C,0	;SET 'WRITING' FLAG.
	CALL	POSITION;POSITION THE FILE TO PROPER RECORD.
	CZ	WTSEQ1	;AND WRITE AS USUAL (IF NO ERRORS).
	RET
;
;   COMPUTE THE RANDOM RECORD NUMBER. ENTER WITH (HL) POINTING
; TO A FCB AN (DE) CONTAINS A RELATIVE LOCATION OF A RECORD
; NUMBER. ON EXIT, (C) CONTAINS THE 'R0' BYTE, (B) THE 'R1'
; BYTE, AND (A) THE 'R2' BYTE.
;
;   ON RETURN, THE ZERO FLAG IS SET IF THE RECORD IS WITHIN
; BOUNDS. OTHERWISE, AN OVERFLOW OCCURED.
;
COMPRAND:	XCHG		;SAVE FCB POINTER IN (DE).
	DAD	D	;COMPUTE RELATIVE POSITION OF RECORD #.
	MOV	C,M	;GET RECORD NUMBER INTO (BC).
	MVI	B,0
	LXI	H,12	;NOW GET EXTENT.
	DAD	D
	MOV	A,M	;COMPUTE (BC)=(RECORD #)+(EXTENT)*128.
	RRC		;MOVE LOWER BIT INTO BIT 7.
	ANI	80H	;AND IGNORE ALL OTHER BITS.
	ADD	C	;ADD TO OUR RECORD NUMBER.
	MOV	C,A
	MVI	A,0	;TAKE CARE OF ANY CARRY.
	ADC	B
	MOV	B,A
	MOV	A,M	;NOW GET THE UPPER BITS OF EXTENT INTO
	RRC		;BIT POSITIONS 0-3.
	ANI	0FH	;AND IGNORE ALL OTHERS.
	ADD	B	;ADD THIS IN TO 'R1' BYTE.
	MOV	B,A
	LXI	H,14	;GET THE 'S2' BYTE (EXTRA EXTENT).
	DAD	D
	MOV	A,M
	ADD	A	;AND SHIFT IT LEFT 4 BITS (BITS 4-7).
	ADD	A
	ADD	A
	ADD	A
	PUSH	PSW	;SAVE CARRY FLAG (BIT 0 OF FLAG BYTE).
	ADD	B	;NOW ADD EXTRA EXTENT INTO 'R1'.
	MOV	B,A
	PUSH	PSW	;AND SAVE CARRY (OVERFLOW BYTE 'R2').
	POP	H	;BIT 0 OF (L) IS THE OVERFLOW INDICATOR.
	MOV	A,L
	POP	H	;AND SAME FOR FIRST CARRY FLAG.
	ORA	L	;EITHER ONE OF THESE SET?
	ANI	01H	;ONLY CHECK THE CARRY FLAGS.
	RET
;
;   ROUTINE TO SETUP THE FCB (BYTES 'R0', 'R1', 'R2') TO
; REFLECT THE LAST RECORD USED FOR A RANDOM (OR OTHER) FILE.
; THIS READS THE DIRECTORY AND LOOKS AT ALL EXTENTS COMPUTING
; THE LARGERST RECORD NUMBER FOR EACH AND KEEPING THE MAXIMUM
; VALUE ONLY. THEN 'R0', 'R1', AND 'R2' WILL REFLECT THIS
; MAXIMUM RECORD NUMBER. THIS IS USED TO COMPUTE THE SPACE USED
; BY A RANDOM FILE.
;
RANSIZE	MVI	C,12	;LOOK THRU DIRECTORY FOR FIRST ENTRY WITH
	CALL	FINDFST	;THIS NAME.
	LHLD	PARAMS	;ZERO OUT THE 'R0, R1, R2' BYTES.
	LXI	D,33
	DAD	D
	PUSH	H
	MOV	M,D	;NOTE THAT (D)=0.
	INX	H
	MOV	M,D
	INX	H
	MOV	M,D
RANSIZ1	CALL	CKFILPOS;IS THERE AN EXTENT TO PROCESS?
	JZ	RANSIZ3	;NO, WE ARE DONE.
	CALL	FCB2HL	;SET (HL) POINTING TO PROPER FCB IN DIR.
	LXI	D,15	;POINT TO LAST RECORD IN EXTENT.
	CALL	COMPRAND;AND COMPUTE RANDOM PARAMETERS.
	POP	H
	PUSH	H	;NOW CHECK THESE VALUES AGAINST THOSE
	MOV	E,A	;ALREADY IN FCB.
	MOV	A,C	;THE CARRY FLAG WILL BE SET IF THOSE
	SUB	M	;IN THE FCB REPRESENT A LARGER SIZE THAN
	INX	H	;THIS EXTENT DOES.
	MOV	A,B
	SBB	M
	INX	H
	MOV	A,E
	SBB	M
	JC	RANSIZ2
	MOV	M,E	;WE FOUND A LARGER (IN SIZE) EXTENT.
	DCX	H	;STUFF THESE VALUES INTO FCB.
	MOV	M,B
	DCX	H
	MOV	M,C
RANSIZ2	CALL	FINDNXT	;NOW GET THE NEXT EXTENT.
	JMP	RANSIZ1	;CONTINUE TIL ALL DONE.
RANSIZ3	POP	H	;WE ARE DONE, RESTORE THE STACK AND
	RET		;RETURN.
;
;   FUNCTION TO RETURN THE RANDOM RECORD POSITION OF A GIVEN
; FILE WHICH HAS BEEN READ IN SEQUENTIAL MODE UP TO NOW.
;
SETRAN	LHLD	PARAMS	;POINT TO FCB.
	LXI	D,32	;AND TO LAST USED RECORD.
	CALL	COMPRAND;COMPUTE RANDOM POSITION.
	LXI	H,33	;NOW STUFF THESE VALUES INTO FCB.
	DAD	D
	MOV	M,C	;MOVE 'R0'.
	INX	H
	MOV	M,B	;AND 'R1'.
	INX	H
	MOV	M,A	;AND LASTLY 'R2'.
	RET
;
;   THIS ROUTINE SELECT THE DRIVE SPECIFIED IN (ACTIVE) AND
; UPDATE THE LOGIN VECTOR AND BITMAP TABLE IF THIS DRIVE WAS
; NOT ALREADY ACTIVE.
;
LOGINDRV:	LHLD	LOGIN	;GET THE LOGIN VECTOR.
	LDA	ACTIVE	;GET THE DEFAULT DRIVE.
	MOV	C,A
	CALL	SHIFTR	;POSITION ACTIVE BIT FOR THIS DRIVE
	PUSH	H	;INTO BIT 0.
	XCHG
	CALL	SELECT	;SELECT THIS DRIVE.
	POP	H
	CZ	SLCTERR	;VALID DRIVE?
	MOV	A,L	;IS THIS A NEWLY ACTIVATED DRIVE?
	RAR
	RC
	LHLD	LOGIN	;YES, UPDATE THE LOGIN VECTOR.
	MOV	C,L
	MOV	B,H
	CALL	SETBIT
	SHLD	LOGIN	;AND SAVE.
	JMP	BITMAP	;NOW UPDATE THE BITMAP.
;
;   FUNCTION TO SET THE ACTIVE DISK NUMBER.
;
SETDSK	LDA	EPARAM	;GET PARAMETER PASSED AND SEE IF THIS
	LXI	H,ACTIVE;REPRESENTS A CHANGE IN DRIVES.
	CMP	M
	RZ
	MOV	M,A	;YES IT DOES, LOG IT IN.
	JMP	LOGINDRV
;
;   THIS IS THE 'AUTO DISK SELECT' ROUTINE. THE FIRSST BYTE
; OF THE FCB IS EXAMINED FOR A DRIVE SPECIFICATION. IF NON
; ZERO THEN THE DRIVE WILL BE SELECTED AND LOGED IN.
;
AUTOSEL	MVI	A,0FFH	;SAY 'AUTO-SELECT ACTIVATED'.
	STA	AUTO
	LHLD	PARAMS	;GET DRIVE SPECIFIED.
	MOV	A,M
	ANI	1FH	;LOOK AT LOWER 5 BITS.
	DCR	A	;ADJUST FOR (1=A, 2=B) ETC.
	STA	EPARAM	;AND SAVE FOR THE SELECT ROUTINE.
	CPI	1EH	;CHECK FOR 'NO CHANGE' CONDITION.
	JNC	AUTOSL1	;YES, DON'T CHANGE.
	LDA	ACTIVE	;WE MUST CHANGE, SAVE CURRENTLY ACTIVE
	STA	OLDDRV	;DRIVE.
	MOV	A,M	;AND SAVE FIRST BYTE OF FCB ALSO.
	STA	AUTOFLAG;THIS MUST BE NON-ZERO.
	ANI	0E0H	;WHATS THIS FOR (BITS 6,7 ARE USED FOR
	MOV	M,A	;SOMETHING)?
	CALL	SETDSK	;SELECT AND LOG IN THIS DRIVE.
AUTOSL1	LDA	USERNO	;MOVE USER NUMBER INTO FCB.
	LHLD	PARAMS	;(* UPPER HALF OF FIRST BYTE *)
	ORA	M
	MOV	M,A
	RET		;AND RETURN (ALL DONE).
;
;   FUNCTION TO RETURN THE CURRENT CP/M VERSION NUMBER.
;
GETVER	MVI	A,022H	;VERSION 2.2
	JMP	SETSTAT
;
;   FUNCTION TO RESET THE DISK SYSTEM.
;
RSTDSK	LXI	H,0	;CLEAR WRITE PROTECT STATUS AND LOG
	SHLD	WRTPRT	;IN VECTOR.
	SHLD	LOGIN
	XRA	A	;SELECT DRIVE 'A'.
	STA	ACTIVE
	LXI	H,TBUFF	;SETUP DEFAULT DMA ADDRESS.
	SHLD	USERDMA
	CALL	DEFDMA
	JMP	LOGINDRV;NOW LOG IN DRIVE 'A'.
;
;   FUNCTION TO OPEN A SPECIFIED FILE.
;
OPENFIL	CALL	CLEARS2	;CLEAR 'S2' BYTE.
	CALL	AUTOSEL	;SELECT PROPER DISK.
	JMP	OPENIT	;AND OPEN THE FILE.
;
;   FUNCTION TO CLOSE A SPECIFIED FILE.
;
CLOSEFIL:	CALL	AUTOSEL	;SELECT PROPER DISK.
	JMP	CLOSEIT	;AND CLOSE THE FILE.
;
;   FUNCTION TO RETURN THE FIRST OCCURENCE OF A SPECIFIED FILE
; NAME. IF THE FIRST BYTE OF THE FCB IS '?' THEN THE NAME WILL
; NOT BE CHECKED (GET THE FIRST ENTRY NO MATTER WHAT).
;
GETFST	MVI	C,0	;PREPARE FOR SPECIAL SEARCH.
	XCHG
	MOV	A,M	;IS FIRST BYTE A '?'?
	CPI	'?'
	JZ	GETFST1	;YES, JUST GET VERY FIRST ENTRY (ZERO LENGTH MATCH).
	CALL	SETEXT	;GET THE EXTENSION BYTE FROM FCB.
	MOV	A,M	;IS IT '?'? IF YES, THEN WE WANT
	CPI	'?'	;AN ENTRY WITH A SPECIFIC 'S2' BYTE.
	CNZ	CLEARS2	;OTHERWISE, LOOK FOR A ZERO 'S2' BYTE.
	CALL	AUTOSEL	;SELECT PROPER DRIVE.
	MVI	C,15	;COMPARE BYTES 0-14 IN FCB (12&13 EXCLUDED).
GETFST1	CALL	FINDFST	;FIND AN ENTRY AND THEN MOVE IT INTO
	JMP	MOVEDIR	;THE USERS DMA SPACE.
;
;   FUNCTION TO RETURN THE NEXT OCCURENCE OF A FILE NAME.
;
GETNXT	LHLD	SAVEFCB	;RESTORE POINTERS. NOTE THAT NO
	SHLD	PARAMS	;OTHER DBOS CALLS ARE ALLOWED.
	CALL	AUTOSEL	;NO ERROR WILL BE RETURNED, BUT THE
	CALL	FINDNXT	;RESULTS WILL BE WRONG.
	JMP	MOVEDIR
;
;   FUNCTION TO DELETE A FILE BY NAME.
;
DELFILE	CALL	AUTOSEL	;SELECT PROPER DRIVE.
	CALL	ERAFILE	;ERASE THE FILE.
	JMP	STSTATUS;SET STATUS AND RETURN.
;
;   FUNCTION TO EXECUTE A SEQUENTIAL READ OF THE SPECIFIED
; RECORD NUMBER.
;
READSEQ	CALL	AUTOSEL	;SELECT PROPER DRIVE THEN READ.
	JMP	RDSEQ
;
;   FUNCTION TO WRITE THE NET SEQUENTIAL RECORD.
;
WRTSEQ	CALL	AUTOSEL	;SELECT PROPER DRIVE THEN WRITE.
	JMP	WTSEQ
;
;   CREATE A FILE FUNCTION.
;
FCREATE	CALL	CLEARS2	;CLEAR THE 'S2' BYTE ON ALL CREATES.
	CALL	AUTOSEL	;SELECT PROPER DRIVE AND GET THE NEXT
	JMP	GETEMPTY;EMPTY DIRECTORY SPACE.
;
;   FUNCTION TO RENAME A FILE.
;
RENFILE	CALL	AUTOSEL	;SELECT PROPER DRIVE AND THEN SWITCH
	CALL	CHGNAMES;FILE NAMES.
	JMP	STSTATUS
;
;   FUNCTION TO RETURN THE LOGIN VECTOR.
;
GETLOG	LHLD	LOGIN
	JMP	GETPRM1
;
;   FUNCTION TO RETURN THE CURRENT DISK ASSIGNMENT.
;
GETCRNT	LDA	ACTIVE
	JMP	SETSTAT
;
;   FUNCTION TO SET THE DMA ADDRESS.
;
PUTDMA	XCHG
	SHLD	USERDMA	;SAVE IN OUR SPACE AND THEN GET TO
	JMP	DEFDMA	;THE BIOS WITH THIS ALSO.
;
;   FUNCTION TO RETURN THE ALLOCATION VECTOR.
;
GETALOC	LHLD	ALOCVECT
	JMP	GETPRM1
;
;   FUNCTION TO RETURN THE READ-ONLY STATUS VECTOR.
;
GETROV	LHLD	WRTPRT
	JMP	GETPRM1
;
;   FUNCTION TO SET THE FILE ATTRIBUTES (READ-ONLY, SYSTEM).
;
SETATTR	CALL	AUTOSEL	;SELECT PROPER DRIVE THEN SAVE ATTRIBUTES.
	CALL	SAVEATTR
	JMP	STSTATUS
;
;   FUNCTION TO RETURN THE ADDRESS OF THE DISK PARAMETER BLOCK
; FOR THE CURRENT DRIVE.
;
GETPARM	LHLD	DISKPB
GETPRM1	SHLD	STATUS
	RET
;
;   FUNCTION TO GET OR SET THE USER NUMBER. IF (E) WAS (FF)
; THEN THIS IS A REQUEST TO RETURN THE CURRENT USER NUMBER.
; ELSE SET THE USER NUMBER FROM (E).
;
GETUSER	LDA	EPARAM	;GET PARAMETER.
	CPI	0FFH	;GET USER NUMBER?
	JNZ	SETUSER
	LDA	USERNO	;YES, JUST DO IT.
	JMP	SETSTAT
SETUSER	ANI	1FH	;NO, WE SHOULD SET IT INSTEAD. KEEP LOW
	STA	USERNO	;BITS (0-4) ONLY.
	RET
;
;   FUNCTION TO READ A RANDOM RECORD FROM A FILE.
;
RDRANDOM:	CALL	AUTOSEL	;SELECT PROPER DRIVE AND READ.
	JMP	READRAN
;
;   FUNCTION TO COMPUTE THE FILE SIZE FOR RANDOM FILES.
;
WTRANDOM:	CALL	AUTOSEL	;SELECT PROPER DRIVE AND WRITE.
	JMP	WRITERAN
;
;   FUNCTION TO COMPUTE THE SIZE OF A RANDOM FILE.
;
FILESIZE:	CALL	AUTOSEL	;SELECT PROPER DRIVE AND CHECK FILE LENGTH
	JMP	RANSIZE
;
;   FUNCTION #37. THIS ALLOWS A PROGRAM TO LOG OFF ANY DRIVES.
; ON ENTRY, SET (DE) TO CONTAIN A WORD WITH BITS SET FOR THOSE
; DRIVES THAT ARE TO BE LOGGED OFF. THE LOG-IN VECTOR AND THE
; WRITE PROTECT VECTOR WILL BE UPDATED. THIS MUST BE A M/PM
; SPECIAL FUNCTION.
;
LOGOFF	LHLD	PARAMS	;GET DRIVES TO LOG OFF.
	MOV	A,L	;FOR EACH BIT THAT IS SET, WE WANT
	CMA		;TO CLEAR THAT BIT IN (LOGIN)
	MOV	E,A	;AND (WRTPRT).
	MOV	A,H
	CMA
	LHLD	LOGIN	;RESET THE LOGIN VECTOR.
	ANA	H
	MOV	D,A
	MOV	A,L
	ANA	E
	MOV	E,A
	LHLD	WRTPRT
	XCHG
	SHLD	LOGIN	;AND SAVE.
	MOV	A,L	;NOW DO THE WRITE PROTECT VECTOR.
	ANA	E
	MOV	L,A
	MOV	A,H
	ANA	D
	MOV	H,A
	SHLD	WRTPRT	;AND SAVE. ALL DONE.
	RET
;
;   GET HERE TO RETURN TO THE USER.
;
GOBACK	LDA	AUTO	;WAS AUTO SELECT ACTIVATED?
	ORA	A
	JZ	GOBACK1
	LHLD	PARAMS	;YES, BUT WAS A CHANGE MADE?
	MVI	M,0	;(* RESET FIRST BYTE OF FCB *)
	LDA	AUTOFLAG
	ORA	A
	JZ	GOBACK1
	MOV	M,A	;YES, RESET FIRST BYTE PROPERLY.
	LDA	OLDDRV	;AND GET THE OLD DRIVE AND SELECT IT.
	STA	EPARAM
	CALL	SETDSK
GOBACK1	LHLD	USRSTACK;RESET THE USERS STACK POINTER.
	SPHL
	LHLD	STATUS	;GET RETURN STATUS.
	MOV	A,L	;FORCE VERSION 1.4 COMPATABILITY.
	MOV	B,H
	RET		;AND GO BACK TO USER.
;
;   FUNCTION #40. THIS IS A SPECIAL ENTRY TO DO RANDOM I/O.
; FOR THE CASE WHERE WE ARE WRITING TO UNUSED DISK SPACE, THIS
; SPACE WILL BE ZEROED OUT FIRST. THIS MUST BE A M/PM SPECIAL
; PURPOSE FUNCTION, BECAUSE WHY WOULD ANY NORMAL PROGRAM EVEN
; CARE ABOUT THE PREVIOUS CONTENTS OF A SECTOR ABOUT TO BE
; WRITTEN OVER.
;
WTSPECL	CALL	AUTOSEL	;SELECT PROPER DRIVE.
	MVI	A,2	;USE SPECIAL WRITE MODE.
	STA	MODE
	MVI	C,0	;SET WRITE INDICATOR.
	CALL	POSITN1	;POSITION THE FILE.
	CZ	WTSEQ1	;AND WRITE (IF NO ERRORS).
	RET
;
;**************************************************************
;*
;*     BDOS DATA STORAGE POOL.
;*
;**************************************************************
;
EMPTYFCB:	.DB	0E5H	;EMPTY DIRECTORY SEGMENT INDICATOR.
WRTPRT	.DW	0	;WRITE PROTECT STATUS FOR ALL 16 DRIVES.
LOGIN	.DW	0	;DRIVE ACTIVE WORD (1 BIT PER DRIVE).
USERDMA	.DW	080H	;USER'S DMA ADDRESS (DEFAULTS TO 80H).
;
;   SCRATCH AREAS FROM PARAMETER BLOCK.
;
SCRATCH1:	.DW	0	;RELATIVE POSITION WITHIN DIR SEGMENT FOR FILE (0-3).
SCRATCH2:	.DW	0	;LAST SELECTED TRACK NUMBER.
SCRATCH3:	.DW	0	;LAST SELECTED SECTOR NUMBER.
;
;   DISK STORAGE AREAS FROM PARAMETER BLOCK.
;
DIRBUF	.DW	0	;ADDRESS OF DIRECTORY BUFFER TO USE.
DISKPB	.DW	0	;CONTAINS ADDRESS OF DISK PARAMETER BLOCK.
CHKVECT	.DW	0	;ADDRESS OF CHECK VECTOR.
ALOCVECT:	.DW	0	;ADDRESS OF ALLOCATION VECTOR (BIT MAP).
;
;   PARAMETER BLOCK RETURNED FROM THE BIOS.
;
SECTORS	.DW	0	;SECTORS PER TRACK FROM BIOS.
BLKSHFT	.DB	0	;BLOCK SHIFT.
BLKMASK	.DB	0	;BLOCK MASK.
EXTMASK	.DB	0	;EXTENT MASK.
DSKSIZE	.DW	0	;DISK SIZE FROM BIOS (NUMBER OF BLOCKS-1).
DIRSIZE	.DW	0	;DIRECTORY SIZE.
ALLOC0	.DW	0	;STORAGE FOR FIRST BYTES OF BIT MAP (DIR SPACE USED).
ALLOC1	.DW	0
OFFSET	.DW	0	;FIRST USABLE TRACK NUMBER.
XLATE	.DW	0	;SECTOR TRANSLATION TABLE ADDRESS.
;
;
CLOSEFLG:	.DB	0	;CLOSE FLAG (=0FFH IS EXTENT WRITTEN OK).
RDWRTFLG:	.DB	0	;READ/WRITE FLAG (0FFH=READ, 0=WRITE).
FNDSTAT	.DB	0	;FILENAME FOUND STATUS (0=FOUND FIRST ENTRY).
MODE	.DB	0	;I/O MODE SELECT (0=RANDOM, 1=SEQUENTIAL, 2=SPECIAL RANDOM).
EPARAM	.DB	0	;STORAGE FOR REGISTER (E) ON ENTRY TO BDOS.
RELBLOCK:	.DB	0	;RELATIVE POSITION WITHIN FCB OF BLOCK NUMBER WRITTEN.
COUNTER	.DB	0	;BYTE COUNTER FOR DIRECTORY NAME SEARCHES.
SAVEFCB	.DW	0,0	;SAVE SPACE FOR ADDRESS OF FCB (FOR DIRECTORY SEARCHES).
BIGDISK	.DB	0	;IF =0 THEN DISK IS > 256 BLOCKS LONG.
AUTO	.DB	0	;IF NON-ZERO, THEN AUTO SELECT ACTIVATED.
OLDDRV	.DB	0	;ON AUTO SELECT, STORAGE FOR PREVIOUS DRIVE.
AUTOFLAG:	.DB	0	;IF NON-ZERO, THEN AUTO SELECT CHANGED DRIVES.
SAVNXT	.DB	0	;STORAGE FOR NEXT RECORD NUMBER TO ACCESS.
SAVEXT	.DB	0	;STORAGE FOR EXTENT NUMBER OF FILE.
SAVNREC	.DW	0	;STORAGE FOR NUMBER OF RECORDS IN FILE.
BLKNMBR	.DW	0	;BLOCK NUMBER (PHYSICAL SECTOR) USED WITHIN A FILE OR LOGICAL SECTOR.
LOGSECT	.DW	0	;STARTING LOGICAL (128 BYTE) SECTOR OF BLOCK (PHYSICAL SECTOR).
FCBPOS	.DB	0	;RELATIVE POSITION WITHIN BUFFER FOR FCB OF FILE OF INTEREST.
FILEPOS	.DW	0	;FILES POSITION WITHIN DIRECTORY (0 TO MAX ENTRIES -1).
;
;   DISK DIRECTORY BUFFER CHECKSUM BYTES. ONE FOR EACH OF THE
; 16 POSSIBLE DRIVES.
;
CKSUMTBL:	.DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
;
;   EXTRA SPACE ?
;
	.DB	0,0,0,0
;
;**************************************************************
;*
;*        B I O S   J U M P   T A B L E
;*
;**************************************************************
;
;BOOT	JMP	0	;NOTE WE USE FAKE DESTINATIONS
;WBOOT	JMP	0
;CONST	JMP	0
;CONIN	JMP	0
;CONOUT	JMP	0
;LIST	JMP	0
;PUNCH	JMP	0
;READER	JMP	0
;HOME	JMP	0
;SELDSK	JMP	0
;SETTRK	JMP	0
;SETSEC	JMP	0
;SETDMA	JMP	0
;READ	JMP	0
;WRITE	JMP	0
;PRSTAT	JMP	0
;SECTRN	JMP	0
;
;*
;******************   E N D   O F   C P / M   *****************
;*

;	.END


;
;**************************************************************
;*
;*        C B I O S  f o r
;*
;*  T e s t   P r o t o t y p e
;*
;*  by Andrew Lynch, with input from many sources
;*
;**************************************************************
;
;	SKELETAL CBIOS FOR FIRST LEVEL OF CP/M 2.0 ALTERATION
;             WITH MODS FOR CP/M  ROMDISK AND RAMDISK.
;
;             ENTIRELY IN 8080 MNEUMONICS (SO ASM CAN BE USED)
;             BUT ASSUMES A Z80! (remove)
;
;MSIZE	.EQU	20			;CP/M VERSION MEMORY SIZE IN KILOBYTES
;MSIZE	.EQU	62			;CP/M VERSION MEMORY SIZE IN KILOBYTES
; MEM defined in CPM22 above, line 0015
MSIZE	.EQU	MEM			;CP/M VERSION MEMORY SIZE IN KILOBYTES

;
;	"BIAS" IS ADDRESS OFFSET FROM 3400H FOR MEMORY SYSTEMS
;	THAN 16K (REFERRED TO AS "B" THROUGHOUT THE TEXT).
;
BIAS	.EQU	(MSIZE-20)*1024
CCP	.EQU	3400H+BIAS		;BASE OF CCP
BDOS	.EQU	CCP+806H		;BASE OF BDOS
BIOS	.EQU	CCP+1600H		;BASE OF BIOS
CDISK	.EQU	0004H			;CURRENT DISK NUMBER 0=A,...,15=P
; IOBYTE already defined in CPM22 above, line 0017
;IOBYTE	.EQU	0003H			;INTEL I/O BYTE
;
;	CONSTANTS

END		.EQU	$FF
;CR		.EQU	$0D
;LF		.EQU	$0A

; TEST PROTOTYPE SPECIFIC HARDWARE IO PORT ADDRESSES AND MEMORY LOCATIONS

UART		.EQU	$68		; BASE IO ADDRESS OF UART
MPCL_RAM	.EQU	$78		; BASE IO ADDRESS OF RAM MEMORY PAGER CONFIGURATION LATCH
MPCL_ROM	.EQU	$7C		; BASE IO ADDRESS OF ROM MEMORY PAGER CONFIGURATION LATCH

ROMSTART_MON:	.EQU	$0100		; WHERE THE MONITOR IS STORED IN ROM
RAMTARG_MON:	.EQU	$F800		; WHERE THE MONITOR STARTS IN RAM (ENTRY POINT)
MOVSIZ_MON:	.EQU	$0800		; MONITOR IS 2KB IN LENGTH

ROMSTART_CPM:	.EQU	$0900		; WHERE THE CCP+BDOS+BIOS IS STORED IN ROM
RAMTARG_CPM:	.EQU	$D400		; WHERE THE CCP+BDOS+BIOS STARTS IN RAM (ENTRY POINT)
MOVSIZ_CPM:	.EQU	$1EFF		; CCP, BDOS, + BIOS IS 6-7KB IN LENGTH

; IDE REGISTER		IO PORT		; FUNCTION
IDELO		.EQU	$20		; DATA PORT (LOW BYTE)
IDEERR		.EQU	$21		; READ: ERROR REGISTER; WRITE: PRECOMP
IDESECTC	.EQU	$22		; SECTOR COUNT
IDESECTN	.EQU	$23		; SECTOR NUMBER
IDECYLLO	.EQU	$24		; CYLINDER LOW
IDECYLHI	.EQU	$25		; CYLINDER HIGH
IDEHEAD		.EQU	$26		; DRIVE/HEAD
IDESTTS		.EQU	$27		; READ: STATUS; WRITE: COMMAND
IDEHI		.EQU	$28		; DATA PORT (HIGH BYTE)
IDECTRL		.EQU	$2E		; READ: ALTERNATIVE STATUS; WRITE; DEVICE CONTROL
IDEADDR		.EQU	$2F		; DRIVE ADDRESS (READ ONLY)

;	.ORG	BIOS			;ORIGIN OF THIS PROGRAM
NSECTS	.EQU	($-CCP)/128		;WARM START SECTOR COUNT

;
;	JUMP VECTOR FOR INDIVIDUAL SUBROUTINES
	JMP	BOOT			;COLD START
WBOOTE:	JMP	WBOOT			;WARM START
	JMP	CONST			;CONSOLE STATUS
	JMP	CONIN			;CONSOLE CHARACTER IN
	JMP	CONOUT			;CONSOLE CHARACTER OUT
;	JMP	LIST			;LIST CHARACTER OUT (NULL ROUTINE)
LIST:	RET
	NOP
	NOP
;	JMP	PUNCH			;PUNCH CHARACTER OUT (NULL ROUTINE)
PUNCH:	RET
	NOP
	NOP
;	JMP	READER			;READER CHARACTER OUT (NULL ROUTINE)
READER:	RET
	NOP
	NOP
	JMP	HOME			;MOVE HEAD TO HOME POSITION
	JMP	SELDSK			;SELECT DISK
	JMP	SETTRK			;SET TRACK NUMBER
	JMP	SETSEC			;SET SECTOR NUMBER
	JMP	SETDMA			;SET DMA ADDRESS
	JMP	READ			;READ DISK
	JMP	WRITE			;WRITE DISK
;	JMP	LISTST			;RETURN LIST STATUS (NULL ROUTINE)
LISTST:	RET
	NOP
	NOP
	JMP	SECTRN			;SECTOR TRANSLATE
;
;   FIXED DATA TABLES FOR ALL DRIVES
;   0= ROMDISK, 1=RAMDISK, 2=HDPART2, 3=HDPART3, AND 4=HDPART4
;   DISK PARAMETER HEADER FOR DISK 00
DPBASE:	.DW	00000,0000H
	.DW	0000H,0000H
	.DW	DIRBF,DPBLK0
	.DW	CHK00,ALL00
;   DISK PARAMETER HEADER FOR DISK 01
	.DW	0000,0000H
	.DW	0000H,0000H
	.DW	DIRBF,DPBLK1
	.DW	CHK01,ALL01
;   DISK PARAMETER HEADER FOR DISK 02
	.DW	0000,0000H
	.DW	0000H,0000H
	.DW	DIRBF,DPBLK2
	.DW	CHK02,ALL02
;   DISK PARAMETER HEADER FOR DISK 03
	.DW	0000,0000H
	.DW	0000H,0000H
	.DW	DIRBF,DPBLK3
	.DW	CHK03,ALL03
;   DISK PARAMETER HEADER FOR DISK 04
	.DW	0000,0000H
	.DW	0000H,0000H
	.DW	DIRBF,DPBLK4
	.DW	CHK04,ALL04
;
;DPBLK0:	;DISK PARAMETER BLOCK (ROMDISK 1MB) ** RESERVED FOR FUTURE EXPANSION **
;	SPT	.DW 	256		; 256 SECTORS OF 128 BYTES PER 32K TRACK
;	BSH	.DB 	2 		; BLOCK SHIFT FACTOR (SIZE OF ALLOCATION BLOCK)
;	BLM 	.DB 	15 		; PART OF THE ALLOCATION BLOCK SIZE MATH
;	EXM 	.DB 	1 		; DEFINES SIZE OF EXTENT (DIRECTORY INFO)
;	DSM 	.DW 	495 		; BLOCKSIZE [2048] * NUMBER OF BLOCKS +1 =DRIVE SIZE
;	DRM 	.DW 	255 		; NUMBER OF DIRECTORY ENTRIES
;	AL0 	.DB 	11110000  	; BIT MAP OF SPACE ALLOCATED TO DIRECTORY
;	AL1 	.DB 	00000000  	; DIRECTORY CAN HAVE UP TO 16 BLOCKS ALLOCATED
;	CKS 	.DW 	0 	  	; SIZE OF DIRECTORY CHECK [0 IF NON REMOVEABLE]
;	OFF 	.DW 	1 	  	; 1 TRACK RESERVED [FIRST 32K OF ROM]


DPBLK0:			;DISK PARAMETER BLOCK (ROMDISK 32KB WITH 16 2K TRACKS, 22K usable)
SPT_0:	.DW 	16	 		; 16 SECTORS OF 128 BYTES PER 2K TRACK
BSH_0:	.DB 	3 			; BLOCK SHIFT FACTOR (SIZE OF ALLOCATION BLOCK)
BLM_0:	.DB 	7 			; PART OF THE ALLOCATION BLOCK SIZE MATH
EXM_0:	.DB 	0 			; DEFINES SIZE OF EXTENT (DIRECTORY INFO)
DSM_0:	.DW 	31 			; BLOCKSIZE [1024] * NUMBER OF BLOCKS + 1 = DRIVE SIZE
DRM_0:	.DW 	31 			; NUMBER OF DIRECTORY ENTRIES
AL0_0:	.DB 	10000000  		; BIT MAP OF SPACE ALLOCATED TO DIRECTORY
AL1_0:	.DB 	00000000  		; DIRECTORY CAN HAVE UP TO 16 BLOCKS ALLOCATED
CKS_0:	.DW 	0 	  		; SIZE OF DIRECTORY CHECK [0 IF NON REMOVEABLE]
OFF_0:	.DW 	5 	  		; FIRST 5 TRACKS TRACKS RESERVED (10K FOR SYSTEM)
					; SYSTEM IS ROM LOADER, CCP, BDOS, CBIOS, AND MONITOR
					;
					; IMPORTANT NOTE: TRACKS $00 - $04 OF 2K BYTES
					; EACH ARE MARKED WITH THE OFF_0 SET TO 5 AS 
					; SYSTEM TRACKS. USABLE ROM DRIVE SPACE
					; STARTING AFTER THE FIFTH TRACK (IE, TRACK $05)
					; MOST LIKELY FIX TO THIS IS PLACING A DUMMY
					; FIRST 10K ROM CONTAINS THE ROM LOADER, MONITOR,
 					; CCP, BDOS, BIOS, ETC (5 TRACKS * 2K EACH)

DPBLK1:			;DISK PARAMETER BLOCK (RAMDISK 512K, 448K usable)
SPT_1:	.DW 	256	 		; 256 SECTORS OF 128 BYTES PER 32K TRACK
BSH_1:	.DB 	4 			; BLOCK SHIFT FACTOR (SIZE OF ALLOCATION BLOCK)
BLM_1: 	.DB 	15 			; PART OF THE ALLOCATION BLOCK SIZE MATH
EXM_1: 	.DB 	1 			; DEFINES SIZE OF EXTENT (DIRECTORY INFO)
DSM_1: 	.DW 	225 			; BLOCKSIZE [2048] * NUMBER OF BLOCKS + 1 = DRIVE SIZE
DRM_1: 	.DW 	255 			; NUMBER OF DIRECTORY ENTRIES
AL0_1: 	.DB 	11110000  		; BIT MAP OF SPACE ALLOCATED TO DIRECTORY
AL1_1: 	.DB 	00000000  		; DIRECTORY CAN HAVE UP TO 16 BLOCKS ALLOCATED
CKS_1: 	.DW 	0 	  		; SIZE OF DIRECTORY CHECK [0 IF NON REMOVEABLE]
OFF_1: 	.DW 	1 	  		; 1 TRACK RESERVED [FIRST 32K OF RAM]

DPBLK2:			;DISK PARAMETER BLOCK (IDE HARD DISK 8MB)
SPT_2:	.DW 	256	 		; 256 SECTORS OF 128 BYTES PER 32K TRACK
BSH_2:	.DB 	5 			; BLOCK SHIFT FACTOR (SIZE OF ALLOCATION BLOCK)
BLM_2: 	.DB 	31 			; PART OF THE ALLOCATION BLOCK SIZE MATH
EXM_2: 	.DB 	1 			; DEFINES SIZE OF EXTENT (DIRECTORY INFO)
DSM_2: 	.DW 	2017 			; BLOCKSIZE [4096] * NUMBER OF BLOCKS + 1 = DRIVE SIZE
					; HD PARTITION 2 IS 16128 SECTORS LONG
					; AT 512 BYTES EACH WHICH IS 
					; 2016 BLOCKS AT 4096 BYTES A PIECE.
DRM_2: 	.DW 	511 			; NUMBER OF DIRECTORY ENTRIES
AL0_2: 	.DB 	11110000  		; BIT MAP OF SPACE ALLOCATED TO DIRECTORY
AL1_2: 	.DB 	00000000  		; DIRECTORY CAN HAVE UP TO 16 BLOCKS ALLOCATED
CKS_2: 	.DW 	0 	  		; SIZE OF DIRECTORY CHECK [0 IF NON REMOVEABLE]
OFF_2: 	.DW 	1 	  		; 1 TRACK (32K) RESERVED FOR SYSTEM

DPBLK3:			;DISK PARAMETER BLOCK (IDE HARD DISK 8MB)
SPT_3:	.DW 	256	 		; 256 SECTORS OF 128 BYTES PER 32K TRACK
BSH_3:	.DB 	5 			; BLOCK SHIFT FACTOR (SIZE OF ALLOCATION BLOCK)
BLM_3: 	.DB 	31 			; PART OF THE ALLOCATION BLOCK SIZE MATH
EXM_3: 	.DB 	1 			; DEFINES SIZE OF EXTENT (DIRECTORY INFO)
DSM_3: 	.DW 	2017 			; BLOCKSIZE [4096] * NUMBER OF BLOCKS + 1 = DRIVE SIZE
					; HD PARTITION 3 IS 16128 SECTORS LONG
					; AT 512 BYTES EACH WHICH IS 
					; 2016 BLOCKS AT 4096 BYTES A PIECE.
DRM_3: 	.DW 	511 			; NUMBER OF DIRECTORY ENTRIES
AL0_3: 	.DB 	11110000  		; BIT MAP OF SPACE ALLOCATED TO DIRECTORY
AL1_3: 	.DB 	00000000  		; DIRECTORY CAN HAVE UP TO 16 BLOCKS ALLOCATED
CKS_3: 	.DW 	0 	  		; SIZE OF DIRECTORY CHECK [0 IF NON REMOVEABLE]
OFF_3: 	.DW 	1 	  		; 1 TRACK (32K) RESERVED FOR SYSTEM

DPBLK4:			;DISK PARAMETER BLOCK (IDE HARD DISK 1024K)
SPT_4:	.DW 	256	 		; 256 SECTORS OF 128 BYTES PER 32K TRACK
BSH_4:	.DB 	4 			; BLOCK SHIFT FACTOR (SIZE OF ALLOCATION BLOCK)
BLM_4: 	.DB 	15 			; PART OF THE ALLOCATION BLOCK SIZE MATH
EXM_4: 	.DB 	0 			; DEFINES SIZE OF EXTENT (DIRECTORY INFO)
DSM_4: 	.DW 	497 			; BLOCKSIZE [2048] * NUMBER OF BLOCKS + 1 = DRIVE SIZE
					; HD PARTITION 4 IS 4032 SECTORS LONG
					; AT 512 BYTES EACH WHICH IS 
					; 1008 BLOCKS AT 2048 BYTES A PIECE.
					; NOT USING ALL OF THE AVAILABLE SECTORS SINCE THIS
					; DRIVE IS INTENDED TO EMULATE A ROM DRIVE AND COPIED
					; INTO A ROM IN THE FUTURE.
DRM_4: 	.DW 	255 			; NUMBER OF DIRECTORY ENTRIES
AL0_4: 	.DB 	11110000  		; BIT MAP OF SPACE ALLOCATED TO DIRECTORY
AL1_4: 	.DB 	00000000  		; DIRECTORY CAN HAVE UP TO 16 BLOCKS ALLOCATED
CKS_4: 	.DW 	0 	  		; SIZE OF DIRECTORY CHECK [0 IF NON REMOVEABLE]
OFF_4: 	.DW 	1 	  		; 1 TRACK RESERVED [FIRST 32K OF PARTITION]

;
;	END OF FIXED TABLES
;
;	INDIVIDUAL SUBROUTINES TO PERFORM EACH FUNCTION

BOOT:	;SIMPLEST CASE IS TO JUST PERFORM PARAMETER INITIALIZATION
	MVI	A,$80			; LOAD VALUE TO SWITCH OUT ROM
	OUT	MPCL_ROM		; SWITCH OUT ROM, BRING IN LOWER 32K RAM PAGE

	MVI	A,$00			; ENSURE LOWEST RAM PAGE SELECTED
	OUT	MPCL_RAM		; BRING IN LOWEST 32K RAM PAGE

	XRA	A			;ZERO IN THE ACCUM
	STA	IOBYTE			;CLEAR THE IOBYTE
	STA	CDISK			;SELECT DISK ZERO
	
	CALL	IDE_SOFT_RESET		; RESET THE IDE HARD DISK

	LXI	H,TXT_STARTUP_MSG	; PRINT STARTUP MESSAGE
	CALL	PRTMSG

	JMP	GOCPM			;INITIALIZE AND GO TO CP/M

;
WBOOT:	;SIMPLEST CASE IS TO READ THE DISK UNTIL ALL SECTORS LOADED
        ; WITH A ROMDISK WE SELECT THE ROM AND THE CORRECT PAGE [0]
        ; THEN COPY THE CP/M IMAGE (CCP, BDOS, BIOS, MONITOR) TO HIGH RAM
        ; LOAD ADDRESS.
	; FOR Z80 IT LOOKS LIKE THIS... USING 8080 NEMONICS

	DI				; DISABLE INTERRUPT
	LXI	SP,80H			;USE SPACE BELOW BUFFER FOR STACK
;	IM	1			; SET INTERRUPT MODE 1
IM_1:	.DB	$ED,$56			; Z80 "IM 1" INSTRUCTION

        XRA	A			; CHEAP ZERO IN ACC
	OUT	MPCL_ROM		; SEND 0 TO ROM MAP PORT (SWITCH IN LOWER 32K ROM PAGE)

        XRA	A			; CHEAP ZERO IN ACC
	OUT	MPCL_RAM		; SEND 0 TO RAM MAP PORT (SELECT LOWEST RAM PAGE)

	LXI	H,ROMSTART_MON		; WHERE IN ROM MONITOR IS STORED (FIRST BYTE)
	LXI	D,RAMTARG_MON		; WHERE IN RAM TO MOVE MONITOR TO (FIRST BYTE)
	LXI	B,MOVSIZ_MON		; NUMBER OF BYTES TO MOVE FROM ROM TO RAM
LDIR1:	.DB	$ED,$B0			; Z80 "LDIR" INSTRUCTION (REMOVE)
;	CALL	LDIR			; LDIR REPLACEMENT SUBROUTINE

	LXI	H,ROMSTART_CPM		; WHERE IN ROM CP/M IS STORED (FIRST BYTE)
	LXI	D,RAMTARG_CPM		; WHERE IN RAM TO MOVE MONITOR TO (FIRST BYTE)
	LXI	B,MOVSIZ_CPM		; NUMBER OF BYTES TO MOVE FROM ROM TO RAM
LDIR2:	.DB	$ED,$B0			; Z80 "LDIR" INSTRUCTION (REMOVE)
;	CALL	LDIR			; LDIR REPLACEMENT SUBROUTINE

	EI				; ENABLE INTERRUPTS (ACCESS TO MONITOR WHILE
					; CP/M RUNNING)
	MVI	A,$80			; LOAD VALUE TO SWITCH OUT ROM
	OUT	MPCL_ROM		; SWITCH OUT ROM, BRING IN LOWER 32K RAM PAGE

        XRA	A			; CHEAP ZERO IN ACC
	OUT	MPCL_RAM		; SEND 0 TO RAM MAP PORT (SELECT LOWEST RAM PAGE)

	CALL	IDE_SOFT_RESET		; RESET THE IDE HARD DISK

	LXI	H,TXT_STARTUP_MSG	; PRINT STARTUP MESSAGE
	CALL	PRTMSG
					; FALL THROUGH TO GOCPM ROUTINE

;	END OF LOAD OPERATION, SET PARAMETERS AND GO TO CP/M
GOCPM:
					; CPU RESET HANDLER
	MVI	A,0C3H			;C3 IS A JMP INSTRUCTION
	STA	$0000			;FOR JMP TO WBOOT
	LXI	H,WBOOTE		;WBOOT ENTRY POINT
	SHLD	1			;SET ADDRESS FIELD FOR JMP AT 0
;
					; CPU INTERRUPT HANDLER
	MVI	A,0C3H			;C3 IS A JMP INSTRUCTION
	STA	$0038			;FOR JMP TO WBOOT
	LXI	H,WBOOTE		;WBOOT ENTRY POINT
	SHLD	1			;SET ADDRESS FIELD FOR JMP AT 0
;
	STA	5			;FOR JMP TO BDOS
	LXI	H,BDOS			;BDOS ENTRY POINT
	SHLD	6			;ADDRESS FIELD OF JUMP AT 5 TO BDOS
;
	LXI	B,80H			;DEFAULT DMA ADDRESS IS 80H
	CALL	SETDMA
;
	LDA	CDISK			;GET CURRENT DISK NUMBER
	MOV	C,A			;SEND TO THE CCP
	JMP	CCP			;GO TO CP/M FOR FURTHER PROCESSING
;
;
;	SIMPLE I/O HANDLERS (MUST BE FILLED IN BY USER)
;	IN EACH CASE, THE ENTRY POINT IS PROVIDED, WITH SPACE RESERVED
;	TO INSERT YOUR OWN CODE
;
CONST:	;CONSOLE STATUS, RETURN 0FFH IF CHARACTER READY, 00H IF NOT
	IN	UART + $05		; READ LINE STATUS REGISTER (UART5 = $68 + $05)
	ANI	$01			; TEST IF DATA IN RECEIVE BUFFER
					; IS THERE A CHAR READY? 0=NO, 1=YES
	JZ	NOT_READY
	MVI	A,$FF			; YES, PUT $FF IN A AND RETURN
NOT_READY:				; NO, LEAVE $00 IN A AND RETURN
	RET
;
CONIN:	;CONSOLE CHARACTER INTO REGISTER A

	CALL	CONST			; IS A CHAR READY TO BE READ FROM UART?
	CPI	$00			;
	JZ	CONIN			; NO?  TRY AGAIN   
	IN	UART			; YES? READ THE CHAR FROM THE UART (UART0 = $68 + $00)
					; REGISTER AND PASS BACK TO USER
;	ANI	7FH			;STRIP PARITY BIT
	RET
;
CONOUT: ;CONSOLE CHARACTER OUTPUT FROM REGISTER C

CONOUT1:
	IN	UART + $05		; READ LINE STATUS REGISTER
	ANI	$20			; TEST IF UART IS READY TO SEND
	JZ	CONOUT1			; IF NOT REPEAT

	MOV	A,C			;GET TO ACCUMULATOR
	OUT	UART			; THEN WRITE THE CHAR TO UART (UART0 = $68 + $00)
	RET
;
;LIST:	;LIST CHARACTER FROM REGISTER C
;	MOV	A,C			;CHARACTER TO REGISTER A
;	RET				;NULL SUBROUTINE
;
;LISTST:	;RETURN LIST STATUS (0 IF NOT READY, 1 IF READY)
;	XRA	A			;0 IS ALWAYS OK TO RETURN
;	RET
;
;PUNCH:	;PUNCH CHARACTER FROM REGISTER C
            				; I NEVER USE THESE SO THEY ARE NUL DEVICES.
;	MOV	A,C			;CHARACTER TO REGISTER A
;	RET				;NULL SUBROUTINE
;
;
;READER:	;READ CHARACTER INTO REGISTER A FROM READER DEVICE
          				; I NEVER USE THESE SO THEY ARE NUL DEVICES.
;	MVI	A,1AH			;ENTER END OF FILE FOR NOW (REPLACE LATER)
;	ANI	7FH			;REMEMBER TO STRIP PARITY BIT
;	RET
;
;	I/O DRIVERS FOR THE DISK FOLLOW
;	FOR NOW, WE WILL SIMPLY STORE THE PARAMETERS AWAY FOR USE
;	IN THE READ AND WRITE SUBROUTINES
;

;
;   SELECT DISK GIVEN BY REGISTER C
;
SELDSK:	LXI	H,0000H			;ERROR RETURN CODE
	MOV	A,C
	STA	DISKNO
	CPI	5			;MUST BE BETWEEN 0 AND 4
	RNC				;NO CARRY IF 5,6...
;   DISK NUMBER IS IN THE PROPER RANGE
;   COMPUTE PROPER DISK PARAMETER HEADER ADDRESS
	LDA	DISKNO
	MOV	L,A			;L=DISK NUMBER 0,1,2,3,4
	MVI	H,0			;HIGH ORDER ZERO
	DAD	H			;*2
	DAD	H			;*4
	DAD	H			;*8
	DAD	H			;*16 (SIZE OF EACH HEADER)
	LXI	D,DPBASE
	DAD	D			;HL=.DPBASE(DISKNO*16)
	RET
;
HOME:	;MOVE TO THE TRACK 00 POSITION OF CURRENT DRIVE
					; TRANSLATE THIS CALL INTO A SETTRK CALL WITH PARAMETER 00
	LXI	B,0			;SELECT TRACK 0000
;	CALL	SETTRK
;	RET				;WE WILL MOVE TO 00 ON FIRST READ/WRITE
					; FALL THROUGH TO SETTRK TO STORE VALUE
					

SETTRK:	;SET TRACK GIVEN BY REGISTER BC
	MOV	H,B
	MOV	L,C
	SHLD 	TRACK
	RET
;
SETSEC:	;SET SECTOR GIVEN BY REGISTER BC
	MOV	H,B
	MOV	L,C
	SHLD	SECTOR
	RET
;
;   TRANSLATE THE SECTOR GIVEN BY BC USING THE
;   TRANSLATE TABLE GIVEN BY DE
; ONLY USED FOR FLOPPIES! FOR ROMDISK/RAMDISK IT'S 1:1
; DO THE NEXT ROUTINE IS A NULL (RETURNS THE SAME)
SECTRN:  
	MOV	H,B
	MOV	L,C
	RET
;
SETDMA:	;SET DMA ADDRESS GIVEN BY REGISTERS B AND C
	MOV	L,C			;LOW ORDER ADDRESS
	MOV	H,B			;HIGH ORDER ADDRESS
	SHLD	DMAAD			;SAVE THE ADDRESS
	RET
;
;  DISK DRIVERS...
;
; DRIVER NEED TO DO SEVERAL THINGS FOR ROM AND RAM DISKS.
;   - INTERRUPTS ARE NOT ALLOWED DURING LOW RAM/ROM ACCESS (DISABLE!)
;   -TRANSLATE TRACK AND SECTOR INTO A POINTER TO WHERE THE 128 BYTE 
;     SECTOR BEGINS IN THE RAM/ROM
;   -TRANSLATE THE DRIVE INTO A RAM/ROM SELECT, COMBINE WITH TRACK ADDRESS
;     AND SEND TO THE MAP PORT.
;   -COPY 128 BYTE FROM OR TO THE ROM/RAMDISK AND MEMORY POINTED TO BY THE DMA 
;     ADDRESS PREVIOUSLY STORED.
;   -RESTORE MAP PORT TO PRIOR CONDITION BEFOR READ/WRITE
;
;   - FIRST TRICK IS THAT WE MADE SECTORS 256 AS 256*128=32768.  SO WE COPY 
;     THE LOW SECTOR ADDRESS TO THE LOW BYTE OF THE HL REGISTER AND THEN 
;     MULTIPLY BY 128. THIS RESULTS IN THE STARTING ADDRESS IN THE RAM OR ROM
;     (0000 -> 7F80H) 32K PAGE.
;
;    - TRICK TWO IS THE TRACK ADDRESS EQUALS THE 32K PAGE ADDRESS AND IS A 
;      DIRECT SELECT THAT CAN BE COPIED TO THE MAP PORT D0 THROUGH D5.  D7
;      SELECTS THE DRIVE (ROM OR RAM).
;      THAT MEANS THE LOW BYTE OF TRACK CONTAINS THE D0-D5 VALUE AND 
;      DISKNO HAS THE DRIVE SELECTED.  WE FIRST COPY DISKNO TO ACC
;      AND RIGHTSHIFT IT TO PLACE THAT IN BIT 7, WE THEN ADD THE LOW BYTE OF 
;      TRACK TO ACC AND THEN SEND THAT TO THE MAP PORT.
;
;      NOTE 1: A WRITE TO ROM SHOULD BE FLAGGED AS AN ERROR.
;      NOTE 2: RAM MUST START AS A "FORMATTED DISK"  IF BATTERY BACKED UP
;                   IT'S A DO ONCE AT COLD COLD START.  IF NOT BATTERY BACKED UP
;                   IT WILL HAVE TO BE DONE EVERY TIME THE SYSTEM IS POWERED.
;                   FORMATTING THE RAM IS SIMPLE AS CLEARING THE DIRECTORY AREA 
;                   TO A VALUE OF E5H (THE FIRST 8K OF TRACK 1 OR THE RAMDISK).
;                   IT COULD BE DONE AS A SIMPLE UTILITY PROGRAM STORED IN ROMDISK
;                   OR ANYTIME COLBOOT IS CALLED(LESS DESIREABLE).
;
;     -WE NOW CAN COPY TO OR FROM AS CORRECT FOR THE DEVICE 128 BYTES (SECTOR)
;      TO OR FROM THE DMA ADDRESS. ALMOST!  SINCE ROM OR RAM IS BEING PAGED
;      WE HAVE TO COPY ANYTHING DETINED FOR BELOW 8000H TO A TEMP BUFFER THEN
;      HANDLE THE PAGING.
;        
;
;     - LAST STEP IS TO RESTORE THE MAP PORT TO POINT TO THE RAM (TRACK 0) SO THE CP/M
;       MEMORY MAP IS ALL RAM AGAIN AND NOT POINTING INTO THE DATA AREAS OR THE "DISK".
;       SINCE THE RAM 0TH PAGE IS NOMINALLY THE LOW 32K OF RAM IN THE SYSTEM WE CAN
;       SEND A SIMPLE MVI A,80H ; OUT MPCL_ROM; MVI A,00H ; OUT MPCL_RAM.
;
;      - THE READ OR WRITE OPERATION IS DONE.
;
;   READ DISK
;    USES DE,DL, BC,  ACC FLAGS
;      Z80 COULD USE BLOCK MOVE [LDIR] BUT WRITTEN IN 8080 
;
;


READ:
	DI				; DISABLE INTERRUPTS
	LDA	DISKNO			; GET DRIVE

	CPI	$00			; FIND OUT WHICH DRIVE IS BEING REQUESTED
	JZ	READ_EEPROM_DISK	; ARE WE READING RAM OR ROM?
					; READ FROM 22K EEPROM DISK
	CPI	$01			;
	JZ	READ_RAM_DISK		; READ FROM 448K RAM DISK

	CPI	$02
	JZ	READ_HDPART2		; READ FROM 8 MB IDE HARD DISK, PARTITION 2

	CPI	$03
	JZ	READ_HDPART3		; READ FROM 8 MB IDE HARD DISK, PARTITION 3

	CPI	$04
	JZ	READ_HDPART4		; READ FROM 1 MB IDE HARD DISK, PARTITION 4

					; IF NONE OF THE OTHER DISKS, IT MUST BE
					; THE EEPROM DISK, SO FALL THROUGH


READ_EEPROM_DISK:			; 
					; IF ROM, MAP TRACK/SECTOR TO VIRTUAL TRACK/SECTOR
					; HANDLE READING FROM ROM HERE
					; 
					; PURPOSE OF THIS ROUTINE IS TO MAP 32K ROM PART
					; TRACK/SECTOR MAP (2K TRACK SIZE MADE OF 16 128
					; BYTE SECTORS EACH) ONTO WHAT THE RAM/ROM SECTOR
					; READ ROUTINES ARE EXPECTING (32K TRACK SIZE MADE
					; OF 256 128 BYTE SECTORS EACH).  THE ROUTINE 
					; CONVERTS 4 BIT TRACK # AND 4 BIT SECTOR #
					; INTO A VIRTUAL 1 TRACK, 256 SECTOR ACCESS
	LHLD	TRACK			; TRACK # IS UPPER 4 BITS OF SECTOR ADDRESS
	DAD	H			; SHIFT BITS LEFT 1 (*2)
	DAD	H			; SHIFT BITS LEFT 1 (*4)
	DAD	H			; SHIFT BITS LEFT 1 (*8)
	DAD	H			; SHIFT BITS LEFT 1 (*16)
	MOV	B,H			; PUT UPPER 4 BITS OF SECTOR ADDRESS IN BC
	MOV	C,L			; (B IS UPPER BYTE AND C IS LOWER BYTE)
					; BC NOW CONTAINS THE UPDATED TRACK #
	LHLD	SECTOR			; SECTOR # IS LOWER 4 BITS OF SECTOR ADDRESS
	DAD	B			; VIRTUAL SECTOR = (UPDATED TRACK #) + SECTOR #
	SHLD	V_SECTOR		; STORE VIRTUAL SECTOR #
					; NOW CONTINUE READING ROM WITH REGULAR RAM
					; SETUP FOR READ OF RAM OR ROM DISK
	LHLD	V_SECTOR
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	DAD	H			; *128
	SHLD	SECST			; SAVE SECTOR STARTING ADDRESS

					; SET PAGER WITH DRIVE (0) AND TRACK (0)
	MVI	A,$00			; SWITCH IN ROM PAGE 
	OUT	MPCL_ROM 		; SEND TO PORT MAPPER
	STA 	PAGER			; SAVE COPY (JUST BECAUSE)
	
	LHLD	SECST			; GET ROM/RAM ADDRESS
	MOV	E,L
	MOV	D,H			; GET IT INTO DE
	LXI	H,TMPBUF		; LOAD HL WITH TEMP BUF ADDRESS

;	MVI	C,128			; C IS COUNTER FOR TRANSFER
;RLOOPROM:
;	LDAX	D			; GET DATA FROM RAM/ROM VIA DE
;	MOV	M,A			; MOVE TO TEMP ADDRESS
;	DCR	C			; COUNTER -1
;	INX	D			; GET NEXT BYTE OF DATA FROM SECST+DE
;	INX	H			; PUT NEXT BYTE OF DATA AT TMPBUF+HL
;	JNZ	RLOOPROM		; LOOP TILL DONE

	CALL	COPY_CPM_SECTOR

;
; NO WITH THE ROM/RAM DATA IN THE BUFFER WE CAN NOW MOVE IT TO THE 
;  DMA ADDRESS (IN RAM)
;
	CALL	RPAGE			; SET PAGE TO CP/M RAM
	LXI	H,TMPBUF		; GET ROM/RAM ADDRESS
	MOV	E,L
	MOV	D,H			; GET IT INTO DE
	LHLD	DMAAD			; LOAD HL WITH DMA ADDRESS

;	MVI	C,128			; C IS COUNTER FOR TRANSFER
;R2LOOPROM:	
;	LDAX	D			; GET DATA FROM RAM/ROM VIA DE
;	MOV	M,A			; MOVE TO DMA ADDRESS
;	DCR	C			; COUNTER -1
;	INX	D			; GET NEXT BYTE OF DATA AT TMPBUF + DE
;	INX	H			; PUT NEXT BYTE OF DATA FROM DMAAD + HL
;	JNZ	R2LOOPROM		; LOOP TILL DONE

	CALL	COPY_CPM_SECTOR

	MVI	A,$00
	EI				; RE-ENABLE INTERRUPTS
	RET
					; ACCESS ALGORITHM (ONLY APPLICABLE TO 32K ROM PART!)

READ_RAM_DISK:
					; IF RAM, PROCEED WITH NORMAL TRACK/SECTOR READ
	CALL	SECPAGE			; SETUP FOR READ OF RAM OR ROM DISK
	CALL 	PAGERB			; SET PAGER WITH DRIVE AND TRACK
	LHLD	SECST			; GET ROM/RAM ADDRESS
	MOV	E,L
	MOV	D,H			; GET IT INTO DE
	LXI	H,TMPBUF		; LOAD HL WITH TEMP BUF ADDRESS

;	MVI	C,128			; C IS COUNTER FOR TRANSFER
;RLOOP:
;	LDAX	D			; GET DATA FROM RAM/ROM VIA DE
;	MOV	M,A			; MOVE TO TEMP ADDRESS
;	DCR	C			; COUNTER -1
;	INX	D			; GET NEXT BYTE OF DATA FROM SECST+DE
;	INX	H			; PUT NEXT BYTE OF DATA AT TMPBUF+HL
;	JNZ	RLOOP			; LOOP TILL DONE

	CALL	COPY_CPM_SECTOR

;
; NO WITH THE ROM/RAM DATA IN THE BUFFER WE CAN NOW MOVE IT TO THE 
;  DMA ADDRESS (IN RAM)
;
	CALL	RPAGE			; SET PAGE TO CP/M RAM
	LXI	H,TMPBUF		; GET ROM/RAM ADDRESS
	MOV	E,L
	MOV	D,H			; GET IT INTO DE
	LHLD	DMAAD			; LOAD HL WITH DMA ADDRESS

;	MVI	C,128			; C IS COUNTER FOR TRANSFER
;R2LOOP:	
;	LDAX	D			; GET DATA FROM RAM/ROM VIA DE
;	MOV	M,A			; MOVE TO DMA ADDRESS
;	DCR	C			; COUNTER -1
;	INX	D			; GET NEXT BYTE OF DATA FROM TMPBUF + DE
;	INX	H			; PUT NEXT BYTE OF DATA AT DMAAD + HL
;	JNZ	R2LOOP			; LOOP TILL DONE

	CALL	COPY_CPM_SECTOR

	MVI	A,$00
	EI				; RE-ENABLE INTERRUPTS
	RET

READ_HDPART2:

	DI				; DISABLE INTERRUPTS

	LXI	H,$FC00			; INITIALIZE LBA OFFSET SECTOR LO WORD
	SHLD	LBA_OFFSET_LO

	LXI	H,$0000			; INITIALIZE LBA OFFSET SECTOR HI WORD
	SHLD	LBA_OFFSET_HI

	; BDOS TRACK PARAMETER (16 BITS)
	; BDOS SECTOR PARAMETER (16 BITS)

	LHLD	TRACK			; LOAD TRACK # (WORD)
	MOV	B,L			; SAVE LOWER 8 BITS (TRACK # 0-255)
	LHLD	SECTOR			; LOAD SECTOR # (WORD)
	MOV	H,B			; HL IS 8 BIT TRACK IN H, 8 BIT SECTOR IN L

	CALL	CONVERT_IDE_SECTOR_CPM	; COMPUTE WHERE THE CP/M SECTOR IS ON THE
					; IDE PARTITION

	; MAP COMPUTED IDE HD SECTOR TO LBA REGISTERS

	; LBA REGISTERS STORE 28 BIT VALUE OF IDE HD SECTOR ADDRESS

	LDA	LBA_TARGET_LO		; LOAD LBA REGISTER 0 WITH SECTOR ADDRESS TO READ
	STA	IDE_LBA0 
	LDA	LBA_TARGET_LO+1		; LOAD LBA REGISTER 1 WITH SECTOR ADDRESS TO READ
	STA	IDE_LBA1
	LDA	LBA_TARGET_HI		; LOAD LBA REGISTER 2 WITH SECTOR ADDRESS TO READ
	STA	IDE_LBA2
	LDA	LBA_TARGET_HI+1		; LOAD LBA REGISTER 3 WITH SECTOR ADDRESS TO READ
	ANI	%00001111		; ONLY LOWER FOUR BITS ARE VALID
	ADI	%11100000		; ENABLE LBA BITS 5:7=111 IN IDE_LBA3
	STA	IDE_LBA3

	; READ IDE HD SECTOR

	CALL	IDE_READ_SECTOR		; READ THE IDE HARD DISK SECTOR

; NEED TO ADD ERROR CHECKING HERE, CARRY FLAG IS SET IF IDE_READ_SECTOR SUCCESSFUL!

	; COMPUTE STARTING ADDRESS OF CP/M SECTOR IN READ IDE HD SECTOR BUFFER

	LXI	H,SECTOR_BUFFER		; LOAD HL WITH SECTOR BUFFER ADDRESS
	LDA	SECTOR_INDEX		; GET THE SECTOR INDEX (CP/M SECTOR OFFSET IN BUFFER)
	RRC				; MOVE BIT 0 TO BIT 7
	RRC				; DO AGAIN - IN EFFECT MULTIPLY BY 64
	MVI	D,$00			; PUT RESULT AS 16 VALUE IN DE, UPPER BYTE IN D IS $00
	MOV	E,A			; PUT ADDRESS OFFSET IN E
	DAD	D			; MULTIPLY BY 2, TOTAL MULTIPLICATION IS X 128
	DAD	D			; CP/M SECTOR STARTING ADDRESS IN IDE HD SECTOR BUFFER

	; COPY CP/M SECTOR TO BDOS DMA ADDRESS BUFFER

	MOV	D,H			; TRANSFER HL REGISTERS TO DE
	MOV	E,L
	LHLD	DMAAD			; LOAD HL WITH DMA ADDRESS

;	MVI	C,128			; C IS COUNTER FOR TRANSFER (128 BYTES)
;P2LOOP:	
;	LDAX	D			; GET DATA FROM RAM/ROM VIA DE
;	MOV	M,A			; MOVE TO DMA ADDRESS
;	DCR	C			; COUNTER -1
;	INX	D			; GET NEXT BYTE OF DATA FROM 
;					; IDE BUFFER + OFFSET ADDRESS + DE
;	INX	H			; PUT NEXT BYTE OF DATA AT DMAAD + HL
;	JNZ	P2LOOP			; LOOP TILL DONE

	CALL	COPY_CPM_SECTOR

	EI				; RE-ENABLE INTERRUPTS

	MVI	A,$00			; RETURN ERROR CODE READ SUCCESSFUL A=0

	RET

READ_HDPART3:				; STUB
	RET
READ_HDPART4:				; STUB
	RET


;
;   WRITE DISK
;
WRITE:
	DI				; DISABLE INTERRUPTS

	LDA	DISKNO			; GET DRIVE
;	ORA	A			; SET FLAGS
	CPI	$00			; FIND OUT WHICH DRIVE IS BEING REQUESTED
	JZ	RDONLY			; JUMP TO READ ONLY ROUTINE (CANT WRITE TO ROM)
					; READ ONLY, FROM 22K EEPROM DISK, ERROR ON WRITE
	CPI	$01			;
	JZ	WRITE_RAM_DISK		; WRITE TO 448K RAM DISK

	CPI	$02
	JZ	WRITE_HDPART2		; WRITE TO 8 MB IDE HARD DISK, PARTITION 2

	CPI	$03
	JZ	WRITE_HDPART3		; WRITE TO 8 MB IDE HARD DISK, PARTITION 3

	CPI	$04
	JZ	WRITE_HDPART4		; WRITE TO 1 MB IDE HARD DISK, PARTITION 4

					; IF NONE OF THE OTHER DISKS, IT MUST BE
					; THE RAM DISK, SO FALL THROUGH

RDONLY:

;
;   HANDLE WRITE TO READ ONLY
;
;   SENDS A MESSAGE TO TERMINAL THAT ROM DRIVE IS NOT WRITEABLE
;   DOES A PAUSE THEN RETURNS TO CPM WITH ERROR FLAGGED. THIS IS
;   DONE TO ALLOW A POSSIBLE GRACEFUL EXIT (SOME APPS MAY PUKE).
;

	; CODE TBD, PRINT A HEY WRONG DISK AND PAUSE 5SEC AND
	; CONTINUE.

	LXI	H,TXT_RO_ERROR		; SET HL TO START OF ERROR MESSAGE

	CALL	PRTMSG			; PRINT ERROR MESSAGE

	MVI	A,$01			; SEND BAD SECTOR ERROR BACK
					; BDOS WILL ALSO PRINT ITS OWN ERROR MESSAGE
; ADD 5 SECOND PAUSE ROUTINE HERE
	RET


WRITE_RAM_DISK:

	LHLD	DMAAD			; GET DMA ADDRESS
	MOV	E,L
	MOV	D,H			; GET IT INTO DE
	LXI	H,TMPBUF		; LOAD HL WITH TEMP BUF ADDRESS

;	MVI	C,128			; C IS COUNTER FOR TRANSFER
;WLOOP:
;	LDAX	D			; GET DATA FROM RAM/ROM VIA DE
;	MOV	M,A			; MOVE TO TEMP ADDRESS
;	DCR	C			; COUNTER -1
;	INX	D			; GET NEXT BYTE OF DATA FROM DMAAD + DE
;	INX	H			; PUT NEXT BYTE OF DATA AT TMPBUF + HL
;	JNZ	WLOOP			; LOOP TILL DONE

	CALL	COPY_CPM_SECTOR

;
;  NOW THAT DATA IS IN THE TEMP BUF WE SET TO RAM PAGE
;   FOR WRITE.
;
	CALL	SECPAGE 		; GET RAM PAGE WRITE ADDRESS
	CALL 	PAGERB			; SET PAGER WITH DRIVE AND TRACK
	LXI	H,TMPBUF		; GET TEMP BUFFER ADDRESS
	MOV	E,L
	MOV	D,H			; GET IT INTO DE
	LHLD	SECST			; LOAD HL WITH DMA ADDRESS (WHERE TO WRITE TO)

;	MVI	C,128			; C IS COUNTER FOR TRANSFER
;W2LOOP:
;	LDAX	D			; GET DATA FROM RAM/ROM VIA DE
;	MOV	M,A			; MOVE TO RAMDRIVE ADDRESS
;	DCR	C			; COUNTER -1
;	INX	D			; PUT NEXT BYTE OF DATA AT TMPBUF+DE
;	INX	H			; GET NEXT BYTE OF DATA FROM SECST+HL
;	JNZ	W2LOOP			; LOOP TILL DONE

	CALL	COPY_CPM_SECTOR

	CALL	RPAGE			; SET BACK TO RAM
	MVI	A,$00
	EI				; RE-ENABLE INTERRUPTS
	RET

WRITE_HDPART2:

	DI				; DISABLE INTERRUPTS

	LXI	H,$FC00			; INITIALIZE LBA OFFSET SECTOR LO WORD
	SHLD	LBA_OFFSET_LO

	LXI	H,$0000			; INITIALIZE LBA OFFSET SECTOR HI WORD
	SHLD	LBA_OFFSET_HI

	; BDOS TRACK PARAMETER (16 BITS)
	; BDOS SECTOR PARAMETER (16 BITS)

	LHLD	TRACK			; LOAD TRACK # (WORD)
	MOV	B,L			; SAVE LOWER 8 BITS (TRACK # 0-255)
	LHLD	SECTOR			; LOAD SECTOR # (WORD)
	MOV	H,B			; HL IS 8 BIT TRACK IN H, 8 BIT SECTOR IN L

	CALL	CONVERT_IDE_SECTOR_CPM	; COMPUTE WHERE THE CP/M SECTOR IS ON THE
					; IDE PARTITION

	; MAP COMPUTED IDE HD SECTOR TO LBA REGISTERS

	; LBA REGISTERS STORE 28 BIT VALUE OF IDE HD SECTOR ADDRESS

	LDA	LBA_TARGET_LO		; LOAD LBA REGISTER 0 WITH SECTOR ADDRESS TO READ
	STA	IDE_LBA0 
	LDA	LBA_TARGET_LO+1		; LOAD LBA REGISTER 1 WITH SECTOR ADDRESS TO READ
	STA	IDE_LBA1
	LDA	LBA_TARGET_HI		; LOAD LBA REGISTER 2 WITH SECTOR ADDRESS TO READ
	STA	IDE_LBA2
	LDA	LBA_TARGET_HI+1		; LOAD LBA REGISTER 3 WITH SECTOR ADDRESS TO READ
	ANI	%00001111		; ONLY LOWER FOUR BITS ARE VALID
	ADI	%11100000		; ENABLE LBA BITS 5:7=111 IN IDE_LBA3
	STA	IDE_LBA3

	; READ IDE HD SECTOR

	CALL	IDE_READ_SECTOR		; READ THE IDE HARD DISK SECTOR

; NEED TO ADD ERROR CHECKING HERE, CARRY FLAG IS SET IF IDE_READ_SECTOR SUCCESSFUL!

	; COMPUTE STARTING ADDRESS OF CP/M SECTOR IN READ IDE HD SECTOR BUFFER

	LXI	H,SECTOR_BUFFER		; LOAD HL WITH SECTOR BUFFER ADDRESS
	LDA	SECTOR_INDEX		; GET THE SECTOR INDEX (CP/M SECTOR OFFSET IN BUFFER)
	RRC				; MOVE BIT 0 TO BIT 7
	RRC				; DO AGAIN - IN EFFECT MULTIPLY BY 64
	MVI	D,$00			; PUT RESULT AS 16 VALUE IN DE, UPPER BYTE IN D IS $00
	MOV	E,A			; PUT ADDRESS OFFSET IN E
	DAD	D			; CP/M SECTOR STARTING ADDRESS IN IDE HD SECTOR BUFFER
	DAD	D			; MULTIPLY BY 2, TOTAL MULTIPLICATION IS X 128

	SHLD	SECST			; KEEP CP/M SECTOR ADDRESS FOR LATER USE

	; COPY CP/M SECTOR FROM BDOS DMA ADDRESS BUFFER

	LHLD	DMAAD			; LOAD HL WITH DMA ADDRESS (WHERE THE DATA TO BE WRITTEN IS)
	MOV	D,H			; TRANSFER HL REGISTERS TO DE
	MOV	E,L
	LHLD	SECST			; LOAD CP/M SECTOR ADDRESS (WHERE THE DATA IS TO BE WRITTEN)

;	MVI	C,128			; C IS COUNTER FOR TRANSFER (128 BYTES)
;WP2LOOP:	
;	LDAX	D			; GET DATA FROM RAM/ROM VIA DE
;	MOV	M,A			; MOVE TO DMA ADDRESS
;	DCR	C			; COUNTER -1
;	INX	D			; GET NEXT BYTE OF DATA FROM 
;					; IDE BUFFER + OFFSET ADDRESS + DE
;	INX	H			; PUT NEXT BYTE OF DATA AT DMAAD + HL
;	JNZ	WP2LOOP			; LOOP TILL DONE

	CALL	COPY_CPM_SECTOR

	; IDE HD SECTOR IS NOW UPDATED WITH CURRENT CP/M SECTOR DATA SO WRITE TO DISK

	CALL	IDE_WRITE_SECTOR	; WRITE THE UPDATED IDE HARD DISK SECTOR

; NEED TO ADD ERROR CHECKING HERE, CARRY FLAG IS SET IF IDE_WRITE_SECTOR SUCCESSFUL!

	EI				; RE-ENABLE INTERRUPTS

	MVI	A,$00			; RETURN ERROR CODE WRITE SUCCESSFUL A=0

	RET

WRITE_HDPART3:				; STUB
	RET
WRITE_HDPART4:				; STUB
	RET

LDIR:					; 8080 SIMULATED Z80 LDIR ROUTINE
; INPUTS
;  - HL OF SOURCE DATA ADDRESS
;  - DE OF TARGET DATE ADDRESS
;  - BC NUMBER OF BYTES TO MOVE
	
;	MOV A,M
;	STAX D
;	INX D
;	INX H
;	DCX B
;	MOV A,B
;	ORA C
;	JNZ LDIR
;	RET

; ABOVE CODE MAKES TEST PROTOTYPE COLD START DURING CP/M WARM BOOT (WBOOT)

	PUSH PSW 
LDIR_LOOP: 
	MOV  A,M 
	STAX D 
	INX  D 
	INX  H 
	DCR  C 
	JNZ  LDIR_LOOP
	DCR  B 
	JNZ  LDIR_LOOP 
	POP  PSW 

	RET


PRTMSG:
	MOV	A,M			; GET CHARACTER TO A
	CPI	END			; TEST FOR END BYTE
	JZ	PRTMSG1			; JUMP IF END BYTE IS FOUND
	MOV	C,A			; PUT CHAR TO PRINT VALUE IN REG C FOR CONOUT
	CALL	CONOUT			; SEND CHARACTER TO CONSOLE FROM REG C
	INX	H			; INC POINTER, TO NEXT CHAR
	JMP	PRTMSG			; TRANSMIT LOOP

PRTMSG1:
	RET				


;
; UTILITY ROUTINE FOR SECTOR TO PAGE ADDRESS
;   USES HL AND CARRY
;SECPAG:	LHLD	SECTOR
SECPAGE:
	LHLD	SECTOR
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	DAD	H			; *128
	SHLD	SECST			; SAVE SECTOR STARTING ADDRESS
	RET
;
;  PAGER BYTE CREATION
;    ASSEMBLES DRIVE AND TRACK AND SENDS IT TO PAGER PORT
;
PAGERB:	LHLD	TRACK
	LDA	DISKNO
	ANI	1			; MASK FOR 1 BIT OF DRIVE SELECT 
	RRC				; MOVE BIT 0 TO BIT 7
	ORA	L			; OR L WITH ACC TO COMBINE TRACK AND DRIVE
	OUT	MPCL_RAM 		; SEND TO PORT MAPPER
	STA 	PAGER			; SAVE COPY (JUST BECAUSE)
	RET
;
;   RESET PAGER BACK TO RAM.  
;
RPAGE:
	MVI	A,$80			; DESELECT ROM PAGE
	OUT	MPCL_ROM		; SELECT RAM
	MVI	A,$00			; SET TO RAM, TRACK 0
	OUT	MPCL_RAM		; SELECT RAM
	STA 	PAGER			; SAVE COPY OF PAGER BYTE
	RET


COPY_CPM_SECTOR:			; COPIES ONE CPM SECTOR FROM ONE MEMORY ADDRESS TO ANOTHER

	; INPUT
	;  - DE SOURCE ADDRESS
	;  - HL TARGET ADDRESS
	; USES C REGISTER

	MVI	C,128			; C IS COUNTER FOR FIXED SIZE TRANSFER (128 BYTES)
COPYLOOP:	
	LDAX	D			; GET DATA FROM RAM/ROM VIA DE (SOURCE)
	MOV	M,A			; MOVE TO HL ADDRESS (TARGET)
	DCR	C			; COUNTER -1
	INX	D			; GET NEXT BYTE OF DATA FROM SOURCE
	INX	H			; PUT NEXT BYTE OF DATA AT TARGET
	JNZ	COPYLOOP		; LOOP TILL DONE

	RET


CONVERT_IDE_SECTOR_CPM:

	; COMPUTES WHERE THE CP/M SECTOR IS IN THE IDE PARTITION
	; IDE HD SECTORS ARE 512 BYTES EACH, CP/M SECTORS ARE 128 BYTES EACH
	; MAXIMUM SIZE OF CP/M DISK IS 8 MB = 65536 (16 BITS) X 128 BYTES PER SECTOR
	; IDE HD PARTITION CAN HAVE AT MOST 16384 IDE SECTORS -> 65536 CP/M SECTORS
	; EACH IDE HD SECTOR CONTAINS 4 ADJACENT CP/M SECTORS
	; 
	;
	; INPUT:
	; IDE HD PARTITION STARTING SECTOR NUMBER (FROM PARTITION TABLE)
	;  - LOWER 16 BITS STORED IN LBA_OFFSET_LO
	;  - UPPER 16 BITS STORED IN LBA_OFFSET_HI
	; PARTITION OFFSET IN HL (16 BITS)
	;  - A UNIQUELY COMPUTED FUNCTION BASED ON GEOMETRY OF DISKS NUMBER OF
	;    CP/M TRACKS AND SECTORS SPECIFIED IN DPB
	; 
	;
	; OUTPUT:
	; IDE TARGET SECTOR (SENT TO IDE HD CONTROLLER FOR READ OPERATION)
	;  - LOWER 16 BITS STORED IN LBA_TARGET_LO
	;  - UPPER 16 BITS STORED IN LBA_TARGET_HI
	; CP/M TO IDE HD SECTOR MAPPING PARAMETER STORED IN SECTOR_INDEX
	;  - 8 BIT VALUE WITH 4 LEGAL STATES (00, 01, 02, 04) WHICH IS
	;    TO BE USED TO COMPUTE STARTING ADDRESS OF 128 BYTE CP/M SECTOR ONCE
	;    512 BYTE IDE HD SECTOR READ INTO MEMORY BUFFER
	; 

	; ROTATE WITH CARRY 16 BIT TRACK,SECTOR VALUE IN HL TO GET 14 BIT IDE HD
	; TARGET SECTOR IN PARTITION
	; KEEP LAST TWO BITS IN B FOR IDE HD SECTOR TO CP/M SECTOR TRANSLATION

	; COMPUTE SECTOR_INDEX 

	XRA	A			; ZERO ACCUMULATOR
	MOV	A,L			; STORE LAST 2 BITS OF L IN B
	ANI	%00000011		; 
	MOV	B,A
	STA	SECTOR_INDEX		; LOCATES WHERE THE 128 BYTE CP/M SECTOR
					; IS WITHIN THE 512 BYTE IDE HD SECTOR

	; COMPUTE WHICH IDE HD SECTOR TO READ TO WITHIN 4 CP/M SECTORS 
	; SHIFTS 16 BIT PARTITION OFFSET TO THE RIGHT 2 BITS AND ADDS RESULT TO
	; IDE HD PARTITION STARTING SECTOR

	; SHIFT PARTITION OFFSET RIGHT 1 BIT

	STC
	CMC				; CLEAR CARRY FLAG
	MOV	A,H			; 16 BIT ROTATE HL WITH CARRY
	RAR
	MOV	H,A			; ROTATE HL RIGHT 1 BIT (DIVIDE BY 2)
	MOV	A,L
	RAR
	MOV	L,A

	; SHIFT PARTITION OFFSET RIGHT 1 BIT

	STC
	CMC				; CLEAR CARRY FLAG
	MOV	A,H			; 16 BIT ROTATE HL WITH CARRY
	RAR
	MOV	H,A			; ROTATE HL RIGHT 1 BIT (DIVIDE BY 2)
	MOV	A,L
	RAR
	MOV	L,A

	; ADD RESULTING 14 BIT VALUE TO IDE HD PARTITION STARTING SECTOR
	; STORE RESULT IN IDE HD TARGET SECTOR PARAMETER

	LDA	LBA_OFFSET_LO		; 16 BIT ADD OF LBA_OFFSET_LO WITH HL
	ADD	L
	STA	LBA_TARGET_LO
	LDA	LBA_OFFSET_LO+1
	ADC	H
	STA	LBA_TARGET_LO+1		; STORE OVERFLOW BIT IN CARRY

	LXI	H,$0000
	LDA	LBA_OFFSET_HI		; 16 BIT ADD WITH CARRY OF LBA_OFFSET_HI WITH $0000
	ADC	L
	STA	LBA_TARGET_HI
	LDA	LBA_OFFSET_HI+1
	ADC	H
	STA	LBA_TARGET_HI+1

	RET

IDE_READ_SECTOR:

	CALL	IDE_WAIT_BUSY_READY	;MAKE SURE DRIVE IS READY TO PROCEED
	RNC
	CALL	IDE_SETUP_LBA		;TELL DRIVE WHAT SECTOR IS REQUIRED
	MVI	A,$20			
	OUT	IDESTTS			;$20 = IDE 'READ SECTOR' COMMAND 

IDE_SREX:
	CALL	IDE_WAIT_BUSY_READY	;MAKE SURE DRIVE IS READY TO PROCEED
	RNC
	CALL	IDE_TEST_ERROR		;ENSURE NO ERROR WAS REPORTED
	RNC
	CALL	IDE_WAIT_BUFFER		;WAIT FOR FULL BUFFER SIGNAL FROM DRIVE
	RNC

	CALL	IDE_READ_BUFFER		;GRAB THE 256 WORDS FROM THE BUFFER
	STC				;CARRY = 1 ON RETURN = OPERATION OK
	RET
		
;-----------------------------------------------------------------------------

IDE_WRITE_SECTOR:

	CALL	IDE_WAIT_BUSY_READY	;MAKE SURE DRIVE IS READY TO PROCEED
	RNC
	CALL	IDE_SETUP_LBA		;TELL DRIVE WHAT SECTOR IS REQUIRED
	MVI	A,$30			
	OUT	IDESTTS			;$30 = IDE 'WRITE SECTOR' COMMAND 
	CALL	IDE_WAIT_BUSY_READY
	RNC
	CALL	IDE_TEST_ERROR		;ENSURE NO ERROR WAS REPORTED
	RNC
	CALL	IDE_WAIT_BUFFER		;WAIT FOR BUFFER READY SIGNAL FROM DRIVE
	RNC
	CALL	IDE_WRITE_BUFFER	;SEND 256 WORDS TO DRIVE'S BUFFER
	CALL	IDE_WAIT_BUSY_READY	;MAKE SURE DRIVE IS READY TO PROCEED
	RNC
	CALL	IDE_TEST_ERROR		;ENSURE NO ERROR WAS REPORTED
	RNC
	STC				;CARRY = 1 ON RETURN = OPERATION OK
	RET

;-----------------------------------------------------------------------------

IDE_SOFT_RESET:

	MVI	A,%00000110		;NO INTERRUPTS, RESET DRIVE = 1
	OUT	IDECTRL
	MVI	A,%00000010		;NO INTERRUPTS, RESET DRIVE = 0
	OUT	IDECTRL
	CALL	IDE_WAIT_BUSY_READY
	RET

;--------------------------------------------------------------------------------
; IDE INTERNAL SUBROUTINES 
;--------------------------------------------------------------------------------

IDE_WAIT_BUSY_READY:
	
	LXI	D,0

IDE_WBSY:

	MVI	B,5

IDE_DLP:

	DCR	B
	JNZ	IDE_DLP

	INX	D
	MOV	A,D
	ORA	E

	JZ	IDE_TO

	IN	IDESTTS			;READ ERROR REG
	ANI	%11000000		;MASK OFF BUSY AND RDY BITS
	XRI	%01000000		;WE WANT BUSY(7) TO BE 0 AND RDY(6) TO BE 1

	JNZ	IDE_WBSY

	STC				;CARRY 1 = OK
	RET

IDE_TO:
	XRA	A			;CARRY 0 = TIMED OUT
	RET
	
;----------------------------------------------------------------------------

IDE_TEST_ERROR:
	
	STC
	IN	IDESTTS
	MOV	B,A			;NEW
	ANI	%00000001		;TEST ERROR BIT
	STC				;NEW
	RZ

	MOV	A,B			;NEW
	ANI	%00100000
	STC
	JNZ	IDE_ERR			;TEST WRITE ERROR BIT
	
	IN	IDEERR			;READ ERROR FLAGS

IDE_ERR:
	ORA	A			;CARRY 0 = ERROR
	RET				;IF A = 0, IDE BUSY TIMED OUT

;-----------------------------------------------------------------------------
	
IDE_WAIT_BUFFER:
	
	LXI	D,0

IDE_WDRQ:
	MVI	B,5

IDE_BLP:
	DCR	B
	JNZ	IDE_BLP

	INX	D
	MOV	A,D
	ORA	E
	JZ	IDE_TO2

	IN	IDESTTS			;WAIT FOR DRIVE'S 512 BYTE READ BUFFER 
	ANI	%00001000		;TO FILL (OR READY TO FILL)
	JZ	IDE_WDRQ

	STC				;CARRY 1 = OK
	RET

IDE_TO2:
	XRA	A			;CARRY 0 = TIMED OUT
	RET

;------------------------------------------------------------------------------

IDE_READ_BUFFER:

	PUSH	H
	LXI	H,SECTOR_BUFFER
	MVI	B,0			;256 WORDS (512 BYTES PER SECTOR)

IDEBUFRD:
	IN	IDELO			;LOW BYTE OF WORD FIRST	
	MOV	M,A
	IN	IDEHI			;THEN HIGH BYTE OF WORD
	INX	H
	MOV	M,A
	INX	H
	DCR	B
	JNZ	IDEBUFRD

	POP	H
	RET

;-----------------------------------------------------------------------------

IDE_WRITE_BUFFER:

	PUSH	H
	LXI	H,SECTOR_BUFFER
	MVI	B,0			;256 WORDS (512 BYTES PER SECTOR)

IDEBUFWT:

	INX	H
	MOV	A,M
	DCX	H
	OUT	IDEHI			;SET UP HIGH LATCHED BYTE BEFORE
	MOV	A,M
	OUT	IDELO			;WRITING WORD WITH WRITE TO LOW BYTE
	INX	H
	INX	H
	DCR	B
	JNZ	IDEBUFWT

	POP	H
	RET
	
;-----------------------------------------------------------------------------

IDE_SETUP_LBA:
	
	MVI	A,1			
	OUT	IDESECTC		;SET SECTOR COUNT = 1	

	LDA	IDE_LBA0
	OUT	IDESECTN		;SET LBA 0:7

	LDA	IDE_LBA1
	OUT	IDECYLLO		;SET LBA 8:15

	LDA	IDE_LBA2
	OUT	IDECYLHI		;SET LBA 16:23

	LDA	IDE_LBA3
	ANI	%00001111		;LOWEST 4 BITS USED ONLY
	ORI	%11100000		;TO ENABLE LBA MODE
	OUT	IDEHEAD			;SET LBA 24:27 + BITS 5:7=111
	RET


;
;	THE REMAINDER OF THE CBIOS IS RESERVED UNINITIALIZED
;	DATA AREA, AND DOES NOT NEED TO BE A PART OF THE
;	SYSTEM MEMORY IMAGE (THE SPACE MUST BE AVAILABLE,
;	HOWEVER, BETWEEN "BEGDAT" AND "ENDDAT").
;
TRACK:		.DS	2		;TWO BYTES FOR TRACK #
PAGER:		.DB	1		; COPY OF PAGER BYTE
SECTOR:		.DS	2		;TWO BYTES FOR SECTOR #
V_SECTOR:	.DS	2		;TWO BYTES FOR VIRTUAL SECTOR #
SECST:		.DS	2		; SECTOR IN ROM/RAM START ADDRESS
DMAAD:		.DS	2		;DIRECT MEMORY ADDRESS
DISKNO:		.DS	1		;DISK NUMBER 0-15
LBA_OFFSET_LO	.DW			; IDE HD PARTITION STARTING SECTOR (LOW 16 BITS)
LBA_OFFSET_HI	.DW			; IDE HD PARTITION STARTING SECTOR (HI 16 BITS, 12 USED)
LBA_TARGET_LO	.DW			; IDE HD PARTITION TARGET SECTOR (LOW 16 BITS)
LBA_TARGET_HI	.DW			; IDE HD PARTITION TARGET SECTOR (HI 16 BITS, 12 USED)
IDE_LBA0:	.DS	$01		;SET LBA 0:7
IDE_LBA1:	.DS	$01		;SET LBA 8:15
IDE_LBA2:	.DS	$01		;SET LBA 16:23
IDE_LBA3:	.DS	$01		;LOWEST 4 BITS USED ONLY TO ENABLE LBA MODE 
SECTOR_INDEX	.DB			; WHERE 128 BYTE CP/M SECTOR IS IN 512 BYTE IDE HD SECTOR
SECTOR_BUFFER	.DS	512		; STORAGE FOR 512 BYTE IDE HD SECTOR
;TMPBUF: 	.DS	128		; TEMPORARY BUFFER FOR DISK TRANSFERS

TMPBUF		.EQU	SECTOR_BUFFER

;
;	SCRATCH RAM AREA FOR BDOS USE
BEGDAT	.EQU	$			;BEGINNING OF DATA AREA
DIRBF:	.DS	128			;SCRATCH DIRECTORY AREA
ALL00:	.DS	4			;ALLOCATION VECTOR 0  (DSM/8 = 1 BIT PER BLOCK)
ALL01:	.DS	32			;ALLOCATION VECTOR 1 (225/8)
ALL02:	.DS	64			;ALLOCATION VECTOR 2 (511/8)
ALL03:	.DS	64			;ALLOCATION VECTOR 3 (511/8)
ALL04:	.DS	64			;ALLOCATION VECTOR 4 (497/8)
CHK00:	.DS	0			; NOT USED FOR FIXED MEDIA
CHK01:	.DS	0			; NOT USED FOR FIXED MEDIA
CHK02:	.DS	0			; NOT USED FOR FIXED MEDIA
CHK03:	.DS	0			; NOT USED FOR FIXED MEDIA
CHK04:	.DS	0			; NOT USED FOR FIXED MEDIA
;
ENDDAT	.EQU	$			;END OF DATA AREA
DATSIZ	.EQU	$-BEGDAT		;SIZE OF DATA AREA


;	TEXT STRINGS

TXT_RO_ERROR:
	.BYTE CR,LF
	.BYTE "ERROR: WRITE TO READ ONLY DISK"
	.BYTE END

TXT_STARTUP_MSG:
	.BYTE CR,LF
	.BYTE "CP/M-80 VERSION 2.2C FOR THE "
	.BYTE "TEST PROTOTYPE COMPUTER"
	.BYTE CR,LF
	.BYTE END

	.ORG	$F2FF
LASTBYTE:	.DB	$00

	.END
