;***********************************
;*	Z80 Test Prototype
;*	SIMPLE KEYBOARD REPEATER TO TEST CONST, CONIN, CONOUT functions
;*	Andrew Lynch
;*	lynchaj@yahoo.com
;*	15 Feb 2007
;***********************************


;********************* CONSTANTS ****************************************


const:		.EQU	$F206
conin:		.EQU	$F209
conout:		.EQU	$F20C

home:		.EQU	$F218		;move head to home position
seldsk:		.EQU	$F21B		;select disk
settrk:		.EQU	$F21E		;set track number
setsec:		.EQU	$F221		;set sector number
setdma:		.EQU	$F224		;set dma address
read:		.EQU	$F227		;read disk
write:		.EQU	$F22A 		;write disk

track:		.EQU	$F435           ; 2 bytes for Track #
pager:		.EQU	$F437		; copy of pager byte
sector:		.EQU	$F438		;two bytes for Sector #
V_sector:	.EQU	$F43A		;two bytes for Virtual Sector #
secst:		.EQU	$F43C		; sector in rom/ram start address
dmaad:		.EQU	$F43E		;direct memory address
diskno:		.EQU	$F440		;disk number 0-15



CHEK:		.EQU	$F803
END		.EQU	$FF


;*******************************************************************
;*	START AFTER RESET
;*	Function	: ready system, load monitor into RAM and start
;*******************************************************************

	.ORG	$8000

	LD	HL,TXT_HELLO
	
TX_SERLP:
	LD	A,(HL)			; GET CHARACTER TO A
	CP	END			; TEST FOR END BYTE
	JP	Z,TX_END		; JUMP IF END BYTE IS FOUND
	LD	C,A			; put character into C reg
	CALL	conout			; call CONOUT

	INC	HL			; INC POINTER, TO NEXT CHAR
	JP	TX_SERLP		; TRANSMIT LOOP
TX_END:


	LD	A,$00
	LD	(diskno),A
	LD	HL,$0005
	LD	(track),HL
	LD	HL,$0008
	LD	(sector),HL
	call	read

	jp	CHEK


TXT_HELLO:
	.BYTE " HELLO WORLD ",$0d,$0a,END

.END
