	.Z80
;
; ADD CONDITIONAL ASSEMBLY INSTRUCTIONS HERE EITHER  EQU TRUE OR .EQU FALSE
; ALL CONDITIONAL ASSEMBLY GROUPS START WITH CONDXXXX:
; DEFAULT IS TRUE IE THE ORIGINAL INSTRUCTIONS EG IF TSR IS THE ORIGINAL CODE
; SO TO ADD A NEW GROUP SET THE NAME TO FALSE ELSE SET IT TO TRUE FOR THE OLD CODE
FALSE:		 EQU 0
TRUE:		 EQU 1

; LIST OF CONDITIONAL ASSEMBLY INSTRUCTIONS

CONDSWAPAB:	 EQU	TRUE   ; TRUE FOR ORIGINAL, FALSE FOR NEW CODE=A=RAM
CONDIDESOFT:	 EQU	TRUE	; IF NO IDE DRIVE, HAS A SIGNIFICANT DELAY ON SOFT BOOT (TRUE) OR QUICK (FALSE)
CONDWBOOT:	 EQU	FALSE	; WARM BOOT COMPLETELY RELOADS CP/M (TRUE) OR DOESN'T (FALSE)
CONDTSR		 EQU	TRUE	; TRUE FOR ORIGINAL, FALSE TO ADD TSR ROUTINES
CONDSHORTMSG	 EQU	TRUE	; TRUE FOR ORIGINAL WARM BOOT SIGNON, FALSE FOR SHORTER ONE WITH LESS <CR>
CONDSUPERSUB	 EQU	TRUE	; TRUE FOR NO SUPERSUB AUTOEXEC, FALSE TO RUN SUPERSUB AUTOEXEC
CONDKEYBOARD	 EQU	TRUE	; TRUE FOR ORIGINAL, FALSE TO SCAN PS2 KEYBOARD IN CONIN AS WELL AS SERIAL
CONDCONOUT	 EQU	TRUE	; TRUE FOR ORIGINAL, FALSE TO RUN ECHOOFF.COM TSR TO MAINTAIN RADIO SILENCE AND LCD
CONDUSRPATCH	 EQU	TRUE	; TRUE FOR ORIGINAL, FALSE TO ADD A1> FOR USER NUMBER AS WELL AS DRIVE
CONDMASKCONIN 	 EQU    TRUE   ; TRUE FOR ORIGINAL, FALSE TO ADD A >127 MASK FOR CONIN
CONDABONLY    	 EQU    TRUE   ; TRUE FOR ORIGINAL, FALSE TO ONLY HAVE DRIVE A AND B
CONDINVALIDDRV	 EQU    FALSE   ; TRUE FOR ORIGINAL, FALSE TO GO TO A IF AN INVALID DRIVE SELECTED



;
;**************************************************************
;*
;*        C B I O S  F O R
;*
;*  T E S T   P R O T O T Y P E
;*
;*  BY ANDREW LYNCH, WITH INPUT FROM MANY SOURCES
;*
;**************************************************************
;
;	SKELETAL CBIOS FOR FIRST LEVEL OF CP/M 2 0 ALTERATION
;             WITH MODS FOR CP/M  ROMDISK AND RAMDISK 
;
;             ENTIRELY IN 8080 MNEUMONICS (SO ASM CAN BE USED)
;             BUT ASSUMES A Z80! (REMOVE)
;
MSIZE	 EQU	59			;CP/M VERSION MEMORY SIZE IN KILOBYTES
;
;	"BIAS" IS ADDRESS OFFSET FROM 3400H FOR MEMORY SYSTEMS
;	THAN 16K (REFERRED TO AS "B" THROUGHOUT THE TEXT) 
;
BIAS:	 EQU (MSIZE-20)*1024
CCP:	 EQU 3400H+BIAS		; BASE OF CCP
BDOS:	 EQU CCP+806H		; BASE OF BDOS
BIOS:	 EQU CCP+1600H		; BASE OF BIOS
CDISK:	 EQU 0004H		; CURRENT DISK NUMBER 0=A,...,15=P
IOBYTE:	 EQU 3			; I/O DEFINITION BYTE.

     		 ORG   BIOS

; IOBYTE ALREADY DEFINED IN CPM22 ABOVE, LINE 0017
;IOBYTE	 EQU	0003H			;INTEL I/O BYTE
;
;	CONSTANTS

END:		 EQU 0FFH
CR		 EQU	0DH
LF		 EQU	0AH

; TEST PROTOTYPE SPECIFIC HARDWARE IO PORT ADDRESSES AND MEMORY LOCATIONS

UART:		 EQU 68H		; BASE IO ADDRESS OF UART
MPCL_RAM:	 EQU 78H		; BASE IO ADDRESS OF RAM MEMORY PAGER CONFIGURATION LATCH
MPCL_ROM:	 EQU 7CH		; BASE IO ADDRESS OF ROM MEMORY PAGER CONFIGURATION LATCH

ROMSTART_CPM:	 EQU 0900H		; WHERE THE CCP+BDOS+BIOS IS STORED IN ROM
RAMTARG_CPM:	 EQU 0D000H		; WHERE THE CCP+BDOS+BIOS STARTS IN RAM (ENTRY POINT)
MOVSIZ_CPM:	 EQU 2BFFH		; CCP, BDOS
CCPSIZ_CPM:	 EQU 0800H		; CCP 0800h BYTES IN LENGTH

; IDE REGISTER		IO PORT		; FUNCTION
IDELO:		 EQU 20H		; DATA PORT (LOW BYTE)
IDEERR:		 EQU 21H		; READ: ERROR REGISTER; WRITE: PRECOMP
IDESECTC:	 EQU 22H		; SECTOR COUNT
IDESECTN:	 EQU 23H		; SECTOR NUMBER
IDECYLLO:	 EQU 24H		; CYLINDER LOW
IDECYLHI:	 EQU 25H		; CYLINDER HIGH
IDEHEAD:	 EQU 26H		; DRIVE/HEAD
IDESTTS:	 EQU 27H		; READ: STATUS; WRITE: COMMAND
IDEHI:		 EQU 28H		; DATA PORT (HIGH BYTE)
IDECTRL:	 EQU 2EH		; READ: ALTERNATIVE STATUS; WRITE; DEVICE CONTROL
IDEADDR:	 EQU 2FH		; DRIVE ADDRESS (READ ONLY)
FMSR:		 EQU	036H		; ADDRESS OF MAIN STATUS REGISTER
FDATA:		 EQU	037H		; FLOPPY DATA REGISTER
FLATCH:		 EQU	03AH		; FLOPPY CONFIGURATION LATCH
FDMA:		 EQU	03CH		; PSEUDO DMA ADDRESS
;
; FDC CONFIGURATION LATCH OUTPUT BIT PATTERNS
MOTOR:		 EQU	00000000b	; BIT PATTERN IN LATCH FOR MOTOR CONTROL (ON)
TERMCN:		 EQU	00000001b	; BIT PATTERN IN LATCH TO WRITE A TC STROBE
RESETL:		 EQU	00000010b	; BIT PATTERN IN LATCH TO RESET ALL BITS
MINI:		 EQU	00000100b	; BIT PATTERN IN LATCH TO SET MINI MODE FDC9229 LOW DENS=1, HIGH DENS=0
PRECOMP:	 EQU	00100000b	; BIT PATTERN IN LATCH TO SET WRITE PRECOMP 125 NS:
FDDENSITY:	 EQU	01000000b	; BIT PATTERN IN LATCH TO FLOPPY LOW DENSITY (HIGH IS 0)
FDREADY:	 EQU	10000000b	; BIT PATTERN IN LATCH TO FLOPPY READY (P-34):



;	 ORG	BIOS			;ORIGIN OF THIS PROGRAM
NSECTS:	 EQU ($-CCP)/128	; WARM START SECTOR COUNT

;
;	JUMP VECTOR FOR INDIVIDUAL SUBROUTINES
	JP	BOOT		; COLD START
WBOOTE:	JP	WBOOT		; WARM START
	JP	CONST		; CONSOLE STATUS
	JP	CONIN		; CONSOLE CHARACTER IN
	JP	CONOUT		; CONSOLE CHARACTER OUT
	JP	LIST		; LIST CHARACTER OUT (NULL ROUTINE)
	JP	PUNCH		; PUNCH CHARACTER OUT (NULL ROUTINE)
	JP	READER		; READER CHARACTER OUT (NULL ROUTINE)
	JP	HOME		; MOVE HEAD TO HOME POSITION
	JP	SELDSK		; SELECT DISK
	JP	SETTRK		; SET TRACK NUMBER
	JP	SETSEC		; SET SECTOR NUMBER
	JP	SETDMA		; SET DMA ADDRESS
	JP	READ		; READ DISK
	JP	WRITE		; WRITE DISK
	JP	LISTST		; RETURN LIST STATUS (NULL ROUTINE)
	JP	SECTRN		; SECTOR TRANSLATE
;
;   FIXED DATA TABLES FOR ALL DRIVES
;   0= FLOPPY DISK, 1=RAMDISK, 2=IDE, 3=ATAPI, AND 4=HDPART4
;   5= 1MBDISK

	 IF CONDSWAPAB

		;   DISK PARAMETER HEADER FOR DISK 00
DPBASE:		 DW 0000,0000
		 DW 0000,0000
		 DW DIRBF,DPBLK0
		 DW CHK00,ALL00
		;   DISK PARAMETER HEADER FOR DISK 01
		 DW 0000,0000
		 DW 0000,0000
		 DW DIRBF,DPBLK1
		 DW CHK01,ALL01

	 ELSE

		;   DISK PARAMETER HEADER FOR DISK 01
DPBASE:		 DW 0000,0000
		 DW 0000,0000
		 DW DIRBF,DPBLK1
		 DW CHK01,ALL01

		;   DISK PARAMETER HEADER FOR DISK 00
		 DW 0000,0000
		 DW 0000,0000
		 DW DIRBF,DPBLK0
		 DW CHK00,ALL00

	 ENDIF

;   DISK PARAMETER HEADER FOR DISK 02
	 DW 0000,0000
	 DW 0000,0000
	 DW DIRBF,DPBLK2
	 DW CHK02,ALL02
;   DISK PARAMETER HEADER FOR DISK 03
	 DW 0000,0000
	 DW 0000,0000
	 DW DIRBF,DPBLK3
	 DW CHK03,ALL03
;   DISK PARAMETER HEADER FOR DISK 04
	 DW 0000,0000
	 DW 0000,0000
	 DW DIRBF,DPBLK4
	 DW CHK04,ALL04
;   DISK PARAMETER HEADER FOR DISK 05
	 DW 0000,0000
	 DW 0000,0000
	 DW DIRBF,DPBLK5
	 DW CHK05,ALL05
;   DISK PARAMETER HEADER FOR DISK 06
	 DW 0000,0000
	 DW 0000,0000
	 DW DIRBF,DPBLK6
	 DW CHK06,ALL06

;

DPBLK0:				; DISK PARAMETER BLOCK (FLOPPY DISK 720KB)
SPT_0:	 DW  36			; 36 SECTORS OF 128 BYTES PER 4.5K TRACK
BSH_0:	 DB  4			; BLOCK SHIFT FACTOR (SIZE OF ALLOCATION BLOCK)
BLM_0:	 DB  15			; PART OF THE ALLOCATION BLOCK SIZE MATH
EXM_0:	 DB  0			; DEFINES SIZE OF EXTENT (DIRECTORY INFO)
DSM_0:	 DW  350		; BLOCKSIZE [2048] * NUMBER OF BLOCKS + 1 = DRIVE SIZE
DRM_0:	 DW  127		; NUMBER OF DIRECTORY ENTRIES
AL0_0:	 DB  11000000b		; BIT MAP OF SPACE ALLOCATED TO DIRECTORY
AL1_0:	 DB  00000000b		; DIRECTORY CAN HAVE UP TO 16 BLOCKS ALLOCATED
CKS_0:	 DW  32			; SIZE OF DIRECTORY CHECK [0 IF NON REMOVEABLE]
OFF_0:	 DW  4			; FIRST 4 TRACKS TRACKS RESERVED (18K FOR SYSTEM)
				; 
DPBLK1:				; DISK PARAMETER BLOCK (RAMDISK 512K, 448K USABLE)
SPT_1:	 DW  256		; 256 SECTORS OF 128 BYTES PER 32K TRACK
BSH_1:	 DB  4			; BLOCK SHIFT FACTOR (SIZE OF ALLOCATION BLOCK)
BLM_1:	 DB  15			; PART OF THE ALLOCATION BLOCK SIZE MATH
EXM_1:	 DB  1			; DEFINES SIZE OF EXTENT (DIRECTORY INFO)
DSM_1:	 DW  225		; BLOCKSIZE [2048] * NUMBER OF BLOCKS + 1 = DRIVE SIZE
DRM_1:	 DW  255		; NUMBER OF DIRECTORY ENTRIES
AL0_1:	 DB  11110000b		; BIT MAP OF SPACE ALLOCATED TO DIRECTORY
AL1_1:	 DB  00000000b		; DIRECTORY CAN HAVE UP TO 16 BLOCKS ALLOCATED
CKS_1:	 DW  0			; SIZE OF DIRECTORY CHECK [0 IF NON REMOVEABLE]
OFF_1:	 DW  1			; 1 TRACK RESERVED [FIRST 32K OF RAM]
				;
DPBLK2:				; DISK PARAMETER BLOCK (IDE HARD DISK 8MB)
SPT_2:	 DW  256		; 256 SECTORS OF 128 BYTES PER 32K TRACK
BSH_2:	 DB  5			; BLOCK SHIFT FACTOR (SIZE OF ALLOCATION BLOCK)
BLM_2:	 DB  31			; PART OF THE ALLOCATION BLOCK SIZE MATH
EXM_2:	 DB  1			; DEFINES SIZE OF EXTENT (DIRECTORY INFO)
DSM_2:	 DW  2017		; BLOCKSIZE [4096] * NUMBER OF BLOCKS + 1 = DRIVE SIZE
DRM_2:	 DW  511		; NUMBER OF DIRECTORY ENTRIES
AL0_2:	 DB  11110000b		; BIT MAP OF SPACE ALLOCATED TO DIRECTORY
AL1_2:	 DB  00000000b		; DIRECTORY CAN HAVE UP TO 16 BLOCKS ALLOCATED
CKS_2:	 DW  0			; SIZE OF DIRECTORY CHECK [0 IF NON REMOVEABLE]
OFF_2:	 DW  03F1H		; TRACKS (32K) RESERVED FOR SYSTEM AND OTHER PARTITIONS
				;
DPBLK3:				; DISK PARAMETER BLOCK (ATAPI DRIVE 8MB)
SPT_3:	 DW  256		; 256 SECTORS OF 128 BYTES PER 32K TRACK
BSH_3:	 DB  5			; BLOCK SHIFT FACTOR (SIZE OF ALLOCATION BLOCK)
BLM_3:	 DB  31			; PART OF THE ALLOCATION BLOCK SIZE MATH
EXM_3:	 DB  1			; DEFINES SIZE OF EXTENT (DIRECTORY INFO)
DSM_3:	 DW  2017		; BLOCKSIZE [4096] * NUMBER OF BLOCKS + 1 = DRIVE SIZE
DRM_3:	 DW  511		; NUMBER OF DIRECTORY ENTRIES
AL0_3:	 DB  11110000b		; BIT MAP OF SPACE ALLOCATED TO DIRECTORY
AL1_3:	 DB  00000000b		; DIRECTORY CAN HAVE UP TO 16 BLOCKS ALLOCATED
CKS_3:	 DW  0			; SIZE OF DIRECTORY CHECK [0 IF NON REMOVEABLE]
OFF_3:	 DW  1			; 1 TRACK (32K) RESERVED FOR SYSTEM
				;
DPBLK4:				; DISK PARAMETER BLOCK (IDE HARD DISK 1024K)
SPT_4:	 DW  256		; 256 SECTORS OF 128 BYTES PER 32K TRACK
BSH_4:	 DB  4			; BLOCK SHIFT FACTOR (SIZE OF ALLOCATION BLOCK)
BLM_4:	 DB  15			; PART OF THE ALLOCATION BLOCK SIZE MATH
EXM_4:	 DB  1			; DEFINES SIZE OF EXTENT (DIRECTORY INFO)
DSM_4:	 DW  497		; BLOCKSIZE [2048] * NUMBER OF BLOCKS + 1 = DRIVE SIZE
DRM_4:	 DW  255		; NUMBER OF DIRECTORY ENTRIES
AL0_4:	 DB  11110000b		; BIT MAP OF SPACE ALLOCATED TO DIRECTORY
AL1_4:	 DB  00000000b		; DIRECTORY CAN HAVE UP TO 16 BLOCKS ALLOCATED
CKS_4:	 DW  0			; SIZE OF DIRECTORY CHECK [0 IF NON REMOVEABLE]
OFF_4:	 DW  1			; 1 TRACK RESERVED [FIRST 32K OF PARTITION]
				;
DPBLK5:				; DISK PARAMETER BLOCK (ROMDISK 1MB) ** RESERVED FOR FUTURE EXPANSION 
SPT_5:	 DW  256		; 256 SECTORS OF 128 BYTES PER 32K TRACK
BSH_5:	 DB  4			; BLOCK SHIFT FACTOR (SIZE OF ALLOCATION BLOCK)
BLM_5:	 DB  15			; PART OF THE ALLOCATION BLOCK SIZE MATH
EXM_5:	 DB  1			; DEFINES SIZE OF EXTENT (DIRECTORY INFO)
DSM_5:	 DW  511		; BLOCKSIZE [2048] * NUMBER OF BLOCKS +1 =DRIVE SIZE
DRM_5:	 DW  255		; NUMBER OF DIRECTORY ENTRIES
AL0_5:	 DB  11110000b		; BIT MAP OF SPACE ALLOCATED TO DIRECTORY
AL1_5:	 DB  00000000b		; DIRECTORY CAN HAVE UP TO 16 BLOCKS ALLOCATED
CKS_5:	 DW  0			; SIZE OF DIRECTORY CHECK [0 IF NON REMOVEABLE]
OFF_5:	 DW  1			; 1 TRACK RESERVED [FIRST 32K OF ROM]
				;
DPBLK6:				;DISK PARAMETER BLOCK (ROMDISK 1MB) ** RESERVED FOR FUTURE EXPANSION *
SPT_6:	 DW 	16	 	; 16 SECTORS OF 128 BYTES PER 2K TRACK
BSH_6:	 DB 	3 		; BLOCK SHIFT FACTOR (SIZE OF ALLOCATION BLOCK)
BLM_6:	 DB 	7 		; PART OF THE ALLOCATION BLOCK SIZE MATH
EXM_6:	 DB 	1 		; DEFINES SIZE OF EXTENT (DIRECTORY INFO)
DSM_6:	 DW 	31 		; BLOCKSIZE [1024] * NUMBER OF BLOCKS + 1 = DRIVE SIZE
DRM_6:	 DW 	31 		; NUMBER OF DIRECTORY ENTRIES
AL0_6:	 DB 	10000000b  	; BIT MAP OF SPACE ALLOCATED TO DIRECTORY
AL1_6:	 DB 	00000000b  	; DIRECTORY CAN HAVE UP TO 16 BLOCKS ALLOCATED
CKS_6:	 DW 	0 	  	; SIZE OF DIRECTORY CHECK [0 IF NON REMOVEABLE]
OFF_6:	 DW 	10 	  	; FIRST 5 TRACKS TRACKS RESERVED (16K FOR SYSTEM)
				; SYSTEM IS ROM LOADER, CCP, BDOS, CBIOS, AND MONITOR
				;
				; IMPORTANT NOTE: TRACKS 000h - $04 OF 2K BYTES
				; EACH ARE MARKED WITH THE OFF_0 SET TO 5 AS 
				; SYSTEM TRACKS  USABLE ROM DRIVE SPACE
				; STARTING AFTER THE FIFTH TRACK (IE, TRACK 005h)
				; MOST LIKELY FIX TO THIS IS PLACING A DUMMY
				; FIRST 10K ROM CONTAINS THE ROM LOADER, MONITOR,
 				; CCP, BDOS, BIOS, ETC (5 TRACKS * 2K EACH)



;
;	END OF FIXED TABLES
;
;	INDIVIDUAL SUBROUTINES TO PERFORM EACH FUNCTION

BOOT:				; SIMPLEST CASE IS TO JUST PERFORM PARAMETER INITIALIZATION
				;
	LD	A,80H		; LOAD VALUE TO SWITCH OUT ROM
	OUT	(MPCL_ROM),A	; SWITCH OUT ROM, BRING IN LOWER 32K RAM PAGE
				;
				;
	LD	A,10000001b	; SWITCH IN FIRST 32K LOWER PAGE (FIRST TRACK)
	OUT	(MPCL_RAM),A	;
				; FORMATTING THE RAM IS SIMPLE AS CLEARING THE DIRECTORY AREA 
				; TO A VALUE OF E5H (THE FIRST 8K OF TRACK 1 OR THE RAMDISK) 
	LD	HL,0000H	; STARTING MEMORY ADDRESS OF TRACK 1, SECTOR 0 IN HL
	LD	BC,1FFFH	; 8K OF DIRECTORY SECTORS RESERVED (LENGTH IN BC)
	LD	A,0E5H		; INITIALIZING VALUE IN A 
	LD	E,L		;
	LD	D,H		;
	INC	DE		;
	LD	(HL),A		;
	LDIR			;
				;
	LD	A,80H		; LOAD VALUE TO SWITCH OUT ROM
	OUT	(MPCL_ROM),A	; SWITCH OUT ROM, BRING IN LOWER 32K RAM PAGE

	LD	A,00H		; ENSURE LOWEST RAM PAGE SELECTED
	OUT	(MPCL_RAM),A	; BRING IN LOWEST 32K RAM PAGE

	XOR	A		; ZERO IN THE ACCUM
	LD	(IOBYTE),A	; CLEAR THE IOBYTE
	LD	(CDISK),A	; SELECT DISK ZERO
	
	CALL	IDE_SOFT_RESET	; RESET THE IDE HARD DISK

	LD	HL,TXT_STARTUP_MSG ; PRINT STARTUP MESSAGE
	CALL	PRTMSG

	JP	GOCPM		; INITIALIZE AND GO TO CP/M

;
WBOOT:				; SIMPLEST CASE IS TO READ THE DISK UNTIL ALL SECTORS LOADED
				; WITH A ROMDISK WE SELECT THE ROM AND THE CORRECT PAGE [0]
				; THEN COPY THE CP/M IMAGE (CCP, BDOS, BIOS, MONITOR) TO HIGH RAM
				; LOAD ADDRESS 
				; FOR Z80 IT LOOKS LIKE THIS .. USING 8080 NEMONICS

	DI			; DISABLE INTERRUPT
	LD	SP,80H		; USE SPACE BELOW BUFFER FOR STACK
	IM	1		; SET INTERRUPT MODE 1

	XOR	A		; CHEAP ZERO IN ACC
	OUT	(MPCL_ROM),A	; SEND 0 TO ROM MAP PORT (SWITCH IN LOWER 32K ROM PAGE)

	XOR	A		; CHEAP ZERO IN ACC
	OUT	(MPCL_RAM),A	; SEND 0 TO RAM MAP PORT (SELECT LOWEST RAM PAGE)


; REMOVED FOR DISK BOOT
;
;	IF 	CONDWBOOT
;		LD	HL,ROMSTART_MON	; WHERE IN ROM MONITOR IS STORED (FIRST BYTE)
;		LD	DE,RAMTARG_MON	; WHERE IN RAM TO MOVE MONITOR TO (FIRST BYTE)
;		LD	BC,MOVSIZ_MON	; NUMBER OF BYTES TO MOVE FROM ROM TO RAM
;		LDIR
;
;		LD	HL,ROMSTART_CPM	; WHERE IN ROM CP/M IS STORED (FIRST BYTE)
;		LD	DE,RAMTARG_CPM	; WHERE IN RAM TO MOVE MONITOR TO (FIRST BYTE)
;		LD	BC,MOVSIZ_CPM	; NUMBER OF BYTES TO MOVE FROM ROM TO RAM
;		LDIR
;	ELSE
;		LD 	HL,0F2F0H	;MOVE FROM F2F0 THE 5 TSR JUMPS
;		LD 	DE,0FFF0H	;MOVE TO FFF0
;		LD	BC,16		; 16 BYTES
;		LDIR
;
;		LD	HL,ROMSTART_CPM	; WHERE IN ROM CP/M IS STORED (FIRST BYTE)
;		LD	DE,RAMTARG_CPM	; WHERE IN RAM TO MOVE MONITOR TO (FIRST BYTE)
;		LD	BC,MOVSIZ_CPM	; NUMBER OF BYTES TO MOVE FROM ROM TO RAM
;		LDIR
;
;		LD	HL,0FFF0H	; MOVE FROM FFF0
;		LD	DE,0F2F0H	; MOVE BACK TO F2F0
;		LD 	BC,16		; 16 BYTES
;		LDIR
;	ENDIF

		LD	HL,ROMSTART_CPM	; WHERE IN ROM CP/M IS STORED (FIRST BYTE)
		LD	DE,RAMTARG_CPM	; WHERE IN RAM TO MOVE MONITOR TO (FIRST BYTE)
		LD	BC,CCPSIZ_CPM	; NUMBER OF BYTES TO MOVE FROM ROM TO RAM
		LDIR


	EI			; ENABLE INTERRUPTS (ACCESS TO MONITOR WHILE
				; CP/M RUNNING)
	LD	A,80H		; LOAD VALUE TO SWITCH OUT ROM
	OUT	(MPCL_ROM),A	; SWITCH OUT ROM, BRING IN LOWER 32K RAM PAGE

	XOR	A		; CHEAP ZERO IN ACC
	OUT	(MPCL_RAM),A	; SEND 0 TO RAM MAP PORT (SELECT LOWEST RAM PAGE)

	CALL	IDE_SOFT_RESET	; RESET THE IDE HARD DISK

	 IF CONDSUPERSUB
		; DO NOTHING FOR ORIGINAL CODE
	 ELSE
		; CLEAR THE AUTOSUB BUFFER, DO ON A WARM BOOT
		XOR	A
		LD	(INBUFF+1),A	; SECOND BYTE IS ACTUAL LENGTH 

	 ENDIF

	LD	HL,TXT_STARTUP_MSG ; PRINT STARTUP MESSAGE
	CALL	PRTMSG
				; FALL THROUGH TO GOCPM ROUTINE

;	END OF LOAD OPERATION, SET PARAMETERS AND GO TO CP/M
GOCPM:
				; CPU RESET HANDLER
	LD	A,0C3H		; C3 IS A JMP INSTRUCTION
	LD	(0000H),A	; FOR JMP TO WBOOT
	LD	HL,WBOOTE	; WBOOT ENTRY POINT
	LD	(1),HL		; SET ADDRESS FIELD FOR JMP AT 0
;
				; CPU INTERRUPT HANDLER
	LD	A,0C3H		; C3 IS A JMP INSTRUCTION
	LD	(0038H),A	; FOR JMP TO WBOOT
	LD	HL,WBOOTE	; WBOOT ENTRY POINT
	LD	(1),HL		; SET ADDRESS FIELD FOR JMP AT 0
;
	LD	(5),A		; FOR JMP TO BDOS
	LD	HL,BDOS		; BDOS ENTRY POINT
	LD	(6),HL		; ADDRESS FIELD OF JUMP AT 5 TO BDOS
;
	LD	BC,80H		; DEFAULT DMA ADDRESS IS 80H
	CALL	SETDMA
;
	CALL	SETUPDRIVE	; SETUP FLOPPY PARAMETERS
;
	LD	A,(CDISK)	; GET CURRENT DISK NUMBER
	LD	C,A		; SEND TO THE CCP
	JP	CCP		; GO TO CP/M FOR FURTHER PROCESSING
;
;
;	SIMPLE I/O HANDLERS (MUST BE FILLED IN BY USER)
;	IN EACH CASE, THE ENTRY POINT IS PROVIDED, WITH SPACE RESERVED
;	TO INSERT YOUR OWN CODE
;

;	IF CONDKEYBOARD

CONST:					; CONSOLE STATUS, RETURN 0FFH IF CHARACTER READY, 00H IF NOT
		IN	A,(UART + 05H)	; READ LINE STATUS REGISTER (UART5 = 068h + $05)
		AND	01H		; TEST IF DATA IN RECEIVE BUFFER
					; IS THERE A CHAR READY? 0=NO, 1=YES
		JP	Z,NOT_READY
		LD	A,0FFH		; YES, PUT 0FFh IN A AND RETURN
NOT_READY:
					; NO, LEAVE 000h IN A AND RETURN
		RET
CONIN:					; CONSOLE CHARACTER INTO REGISTER A

		CALL	CONST		; IS A CHAR READY TO BE READ FROM UART?
		CP	00H		; 
		JP	Z,CONIN		; NO?  TRY AGAIN   
		IN	A,(UART)	; YES? READ THE CHAR FROM THE UART (UART0 = 068h + $00)
					; REGISTER AND PASS BACK TO USER
		 IF CONDMASKCONIN
					; NO CHANGE IF TRUE LEAVE ORIGINAL CODE
		 ELSE
		AND	127		; MASK OUT ASCII 128 TO 255 = RUBBISH THAT MIGHT COME FROM AN XMODEM FAIL
		 ENDIF
		RET
	
;	ELSE
;		; SCAN KEYBOARD AS WELL (NEED TO RUN TSR KEYBOARD)
;CONST:		CALL	0F2F3h		; COUNTER, USED FOR A CLOCK AND FOR RANDOM NUMBER GEN
;					; CONSOLE STATUS, RETURN 0FFH IF CHARACTER READY, 00H IF NOT
;		IN	A,(UART + 005h)	; READ LINE STATUS REGISTER (UART5 = $68 + $05)
;		AND	001h		; TEST IF DATA IN RECEIVE BUFFER
;					; IS THERE A CHAR READY? 0=NO, 1=YES
;		CALL 	Z,0F2F6h		; NO CHARACTER, SO TRY PS/2 KEYBOARD TSR
;		CP	0FFh		; ANYTHING FROM THE KEYBOARD? FF=YES (NEED TO CALL AGAIN WITH A=1 TO GET)
;		RET	Z		; RETURN IF YES
;		RET

;CONIN:		LD	A,0		; START WITH NOTHING
;		CALL	CONST		; RETURNS A=0 OR A=NOT 0
;		CP	0		; KEEP LOOPING WHILE IT IS A ZERO
;		JR	Z,CONIN		; IF NOTHING, KEEP TRYING
;					; IF SOMETHING, RETEST BECAUSE IS IT KEYBOARD OR UART?
;		IN	A,(UART + 005h)	; READ LINE STATUS REGISTER (UART5 = $68 + $05)
;		AND	001h		; TEST IF DATA IN RECEIVE BUFFER
;		JR	NZ,CONUART	; IF NOT A ZERO THEN GET THE DATA FROM THE UART
;					; IF GOT HERE IT MUST BE THE KEYBOARD 
;		LD	A,1		; TELLS THE KEYBOARD TSR TO RETURN THE ASCII CHARACTER
;		CALL	0F2F6h		; CALL THE TSR, RETURNS THE CHARACTER IN A, THE TSR RESETS THE FLAG
;		RET
;
;CONUART:				; READ THE CHARACTER FROM THE UART
;		IN	A,(UART)	
;		IF CONDMASKCONIN	
;					; LEAVE AS IS
;		ELSE
;		AND	127		; MASK OUT ASCII 128 TO 255 = RUBBISH THAT MIGHT COME FROM AN XMODEM FAIL
;		ENDIF
;		RET			; RETURN
;
;	ENDIF



	
	 IF	CONDCONOUT

CONOUT:				; CONSOLE CHARACTER OUTPUT FROM REGISTER C

CONOUT1:
		IN	A,(UART + 05H)	; READ LINE STATUS REGISTER
		AND	20H		; TEST IF UART IS READY TO SEND
		JP	Z,CONOUT1	; IF NOT REPEAT

		LD	A,C		; GET TO ACCUMULATOR
		OUT	(UART),A	; THEN WRITE THE CHAR TO UART (UART0 = 068h + $00)
		RET
	
	 ELSE

CONOUT:				; CONSOLE CHARACTER OUTPUT FROM REGISTER C
CONOUT1:
		IN	A,(UART + 05H)	; READ LINE STATUS REGISTER
		AND	20H		; TEST IF UART IS READY TO SEND
		JP	Z,CONOUT1	; IF NOT REPEAT
		LD	A,C		; GET TO ACCUMULATOR
		LD	B,A		;  N8VEM 
		CALL	0F2F9H		;  CHANGES B SO B<>A IF ECHO OFF SO CAN DO A CP AND SKIP THE OUT
		CP	B		;  STILL  EQUAL AFTER THE CALL
		JR	NZ,ECHOOFF	;  SOMETHING CHANDGED B SO SKIP THE UART OUT  TRY THE LCD
		OUT	(UART),A	; THEN WRITE THE CHAR TO UART (UART0 = 068h + $00)
	
ECHOOFF:	CALL	0F2F0H		; TSR1	LCD DISPLAY
		RET

	 ENDIF



;
LIST:					;LIST CHARACTER FROM REGISTER C
	LD	A,C			;CHARACTER TO REGISTER A
	RET				;NULL SUBROUTINE
;
LISTST:					;RETURN LIST STATUS (0 IF NOT READY, 1 IF READY)
	XOR	A			;0 IS ALWAYS OK TO RETURN
	RET
;
PUNCH:					;PUNCH CHARACTER FROM REGISTER C
	LD	A,C			;CHARACTER TO REGISTER A
	RET				;NULL SUBROUTINE
;
READER:					;READ CHARACTER INTO REGISTER A FROM READER DEVICE
	LD	A,C			;CHARACTER TO REGISTER A
	RET
;
;	I/O DRIVERS FOR THE DISK FOLLOW
;	FOR NOW, WE WILL SIMPLY STORE THE PARAMETERS AWAY FOR USE
;	IN THE READ AND WRITE SUBROUTINES
;

;
;   SELECT DISK GIVEN BY REGISTER C
;
SELDSK:	LD	HL,0000H	; ERROR RETURN CODE
	LD	A,C
	 IF CONDABONLY
		CP	07H		; MUST BE BETWEEN 0 AND 6
	 ELSE
		CP	02H		; IF NO IDE THEN ONLY DRIVE A AND B FOR THE MINI N8VEM SO 0 OR 1 ONLY
	 ENDIF
	RET	NC		; ORIGINAL CODE - RETURNS BUT GETS STUCK IN A LOOP
	LD	(DISKNO),A

;   DISK NUMBER IS IN THE PROPER RANGE
;   COMPUTE PROPER DISK PARAMETER HEADER ADDRESS
	LD	L,A		; L=DISK NUMBER 0,1,2,3,4
	LD	H,0		; HIGH ORDER ZERO
	ADD	HL,HL		; *2
	ADD	HL,HL		; *4
	ADD	HL,HL		; *8
	ADD	HL,HL		; *16 (SIZE OF EACH HEADER)
	LD	DE,DPBASE
	ADD	HL,DE		; HL= DPBASE(DISKNO*16)
	RET


;
HOME:				; MOVE TO THE TRACK 00 POSITION OF CURRENT DRIVE
				; TRANSLATE THIS CALL INTO A SETTRK CALL WITH PARAMETER 00
	LD	BC,0		; SELECT TRACK 0000
	

SETTRK:				; SET TRACK GIVEN BY REGISTER BC
	LD	H,B
	LD	L,C
	LD	(TRACK),HL
	RET
;
SETSEC:				; SET SECTOR GIVEN BY REGISTER BC
	LD	H,B
	LD	L,C
	LD	(SECTOR),HL
	RET
;
;   TRANSLATE THE SECTOR GIVEN BY BC USING THE
;   TRANSLATE TABLE GIVEN BY DE
; ONLY USED FOR FLOPPIES! FOR ROMDISK/RAMDISK IT'S 1:1
; DO THE NEXT ROUTINE IS A NULL (RETURNS THE SAME)
SECTRN:	
	LD	H,B
	LD	L,C
	RET
;
SETDMA:				; SET DMA ADDRESS GIVEN BY REGISTERS B AND C
	LD	L,C		; LOW ORDER ADDRESS
	LD	H,B		; HIGH ORDER ADDRESS
	LD	(DMAAD),HL	; SAVE THE ADDRESS
	RET
;________________________________________________________________________________________________________
;  DISK DRIVERS ..
;
; DRIVER NEED TO DO SEVERAL THINGS FOR ROM AND RAM DISKS 
;   - INTERRUPTS ARE NOT ALLOWED DURING LOW RAM/ROM ACCESS (DISABLE!)
;   -TRANSLATE TRACK AND SECTOR INTO A POINTER TO WHERE THE 128 BYTE 
;     SECTOR BEGINS IN THE RAM/ROM
;   -TRANSLATE THE DRIVE INTO A RAM/ROM SELECT, COMBINE WITH TRACK ADDRESS
;     AND SEND TO THE MAP PORT 
;   -COPY 128 BYTE FROM OR TO THE ROM/RAMDISK AND MEMORY POINTED TO BY THE DMA 
;     ADDRESS PREVIOUSLY STORED 
;   -RESTORE MAP PORT TO PRIOR CONDITION BEFOR READ/WRITE
;
;   - FIRST TRICK IS THAT WE MADE SECTORS 256 AS 256*128=32768   SO WE COPY 
;     THE LOW SECTOR ADDRESS TO THE LOW BYTE OF THE HL REGISTER AND THEN 
;     MULTIPLY BY 128  THIS RESULTS IN THE STARTING ADDRESS IN THE RAM OR ROM
;     (0000 -> 7F80H) 32K PAGE 
;
;    - TRICK TWO IS THE TRACK ADDRESS  EQUALS THE 32K PAGE ADDRESS AND IS A 
;      DIRECT SELECT THAT CAN BE COPIED TO THE MAP PORT D0 THROUGH D5   D7
;      SELECTS THE DRIVE (ROM OR RAM) 
;      THAT MEANS THE LOW BYTE OF TRACK CONTAINS THE D0-D5 VALUE AND 
;      DISKNO HAS THE DRIVE SELECTED   WE FIRST COPY DISKNO TO ACC
;      AND RIGHTSHIFT IT TO PLACE THAT IN BIT 7, WE THEN ADD THE LOW BYTE OF 
;      TRACK TO ACC AND THEN SEND THAT TO THE MAP PORT 
;
;      NOTE 1: A WRITE TO ROM SHOULD BE FLAGGED AS AN ERROR 
;      NOTE 2: RAM MUST START AS A "FORMATTED DISK"  IF BATTERY BACKED UP
;                   IT'S A DO ONCE AT COLD COLD START   IF NOT BATTERY BACKED U
;                   IT WILL HAVE TO BE DONE EVERY TIME THE SYSTEM IS POWERED 
;                   FORMATTING THE RAM IS SIMPLE AS CLEARING THE DIRECTORY AREA
;                   TO A VALUE OF E5H (THE FIRST 8K OF TRACK 1 OR THE RAMDISK) 
;                   IT COULD BE DONE AS A SIMPLE UTILITY PROGRAM STORED IN ROMD
;                   OR ANYTIME COLBOOT IS CALLED(LESS DESIREABLE) 
;
;     -WE NOW CAN COPY TO OR FROM AS CORRECT FOR THE DEVICE 128 BYTES (SECTOR)
;      TO OR FROM THE DMA ADDRESS  ALMOST!  SINCE ROM OR RAM IS BEING PAGED
;      WE HAVE TO COPY ANYTHING DETINED FOR BELOW 8000H TO A TEMP BUFFER THEN
;      HANDLE THE PAGING 
;        
;
;     - LAST STEP IS TO RESTORE THE MAP PORT TO POINT TO THE RAM (TRACK 0) SO T
;       MEMORY MAP IS ALL RAM AGAIN AND NOT POINTING INTO THE DATA AREAS OR THE
;       SINCE THE RAM 0TH PAGE IS NOMINALLY THE LOW 32K OF RAM IN THE SYSTEM WE
;       SEND A SIMPLE MVI A,80H ; OUT MPCL_ROM; MVI A,00H ; OUT MPCL_RAM 
;
;      - THE READ OR WRITE OPERATION IS DONE 
;
;   READ DISK
;    USES DE,DL, BC,  ACC FLAGS
;      Z80 COULD USE BLOCK MOVE [LDIR] BUT WRITTEN IN 8080 
;________________________________________________________________________________________________________

;__READ__________________________________________________________________________________________________
;
; 	PERFORM CP/M SECTOR READ
;________________________________________________________________________________________________________
READ:
	DI				; DISABLE INTERRUPTS
	LD	A,(DISKNO)		; GET DRIVE
	 IF CONDSWAPAB			;
	CP	00H			; "A"
	JP	Z,READ_FLOPPY_DISK 	; READ FLOPPY
					; 
	CP	01H			; "B"
	JP	Z,READ_RAM_DISK		; READ FROM 448K RAM DISK
	 ELSE				;
	CP	01H			; "B"
	JP	Z,READ_FLOPPY_DISK 	; READ FLOPPY
					; 
	CP	00H			; "A"
	JP	Z,READ_RAM_DISK		; READ FROM 448K RAM DISK
	 ENDIF				;
	CP	02H			; "C"
	JP	Z,READ_IDE		; READ FROM 8 MB IDE HARD DISK
	CP	03H			; "D"
	JP	Z,READ_ATAPI		; READ FROM 8 MB ATAPI
	CP	04H			; "E"
	JP	Z,READ_HDPART4		; READ FROM 1 MB IDE HARD DISK, PARTITION 4
	CP	05H			; "F"
	JP	Z,READ_RAM_DISK		; READ FROM 1M ROM DISK (UTILIZES SAME
					; ROUTINES AS RAM_DISK
					; "G"
					; READ FROM 22K EEPROM DISK , SO FALL THROUGH

;___READ_EEPROM_DISK_____________________________________________________________________________________
;
;	READ EEPROM DISK
;________________________________________________________________________________________________________
READ_EEPROM_DISK:
					; 
					; IF ROM, MAP TRACK/SECTOR TO VIRTUAL TRACK/SECTOR
					; HANDLE READING FROM ROM HERE
					; 
					; PURPOSE OF THIS ROUTINE IS TO MAP 32K ROM PART
					; TRACK/SECTOR MAP (2K TRACK SIZE MADE OF 16 128
					; BYTE SECTORS EACH) ONTO WHAT THE RAM/ROM SECTOR
					; READ ROUTINES ARE EXPECTING (32K TRACK SIZE MADE
					; OF 256 128 BYTE SECTORS EACH)   THE ROUTINE 
					; CONVERTS 4 BIT TRACK # AND 4 BIT SECTOR #
					; INTO A VIRTUAL 1 TRACK, 256 SECTOR ACCESS
	LD	HL,(TRACK)		; TRACK # IS UPPER 4 BITS OF SECTOR ADDRESS
	ADD	HL,HL			; SHIFT BITS LEFT 1 (*2)
	ADD	HL,HL			; SHIFT BITS LEFT 1 (*4)
	ADD	HL,HL			; SHIFT BITS LEFT 1 (*8)
	ADD	HL,HL			; SHIFT BITS LEFT 1 (*16)
	LD	B,H			; PUT UPPER 4 BITS OF SECTOR ADDRESS IN BC
	LD	C,L			; (B IS UPPER BYTE AND C IS LOWER BYTE)
					; BC NOW CONTAINS THE UPDATED TRACK #
	LD	HL,(SECTOR)		; SECTOR # IS LOWER 4 BITS OF SECTOR ADDRESS
	ADD	HL,BC			; VIRTUAL SECTOR = (UPDATED TRACK #) + SECTOR #
	LD	(V_SECTOR),HL		; STORE VIRTUAL SECTOR #
					; NOW CONTINUE READING ROM WITH REGULAR RAM
					; SETUP FOR READ OF RAM OR ROM DISK
	LD	HL,(V_SECTOR)		;
	ADD	HL,HL			; SHIFT BITS LEFT 1 (*2)
	ADD	HL,HL			; SHIFT BITS LEFT 1 (*4)
	ADD	HL,HL			; SHIFT BITS LEFT 1 (*8)
	ADD	HL,HL			; SHIFT BITS LEFT 1 (*16)
	ADD	HL,HL			; SHIFT BITS LEFT 1 (*32)
	ADD	HL,HL			; SHIFT BITS LEFT 1 (*64)
	ADD	HL,HL			; SHIFT BITS LEFT 1 (*128)
	LD	(SECST),HL		; SAVE SECTOR STARTING ADDRESS
					; SET PAGER WITH DRIVE (0) AND TRACK (0)
	LD	A,00H			; SWITCH IN ROM PAGE 
	OUT	(MPCL_ROM),A		; SEND TO PORT MAPPER
	LD	(PAGER),A		; SAVE COPY (JUST BECAUSE)	
	LD	HL,TMPBUF		; LOAD HL WITH TEMP BUF ADDRESS
	LD	E,L			;
	LD	D,H			; GET IT INTO DE
	LD	HL,(SECST)		; GET ROM/RAM ADDRESS
	CALL	COPY_CPM_SECTOR		;
	CALL	RPAGE			; SET PAGE TO CP/M RAM
	LD	HL,(DMAAD)		; LOAD HL WITH DMA ADDRESS
	LD	E,L			;
	LD	D,H			; GET IT INTO DE
	LD	HL,TMPBUF		; GET ROM/RAM ADDRESS
	CALL	COPY_CPM_SECTOR		;
	LD	A,(DISKNO)		; STORE CURRENT DRIVE IN BUFFER
	LD	(CUDISK),A		;
	LD	A,00H			;
	EI				; RE-ENABLE INTERRUPTS
	RET			

;___READ_RAM_DISK_________________________________________________________________________________________
;
;	READ RAM DISK
;________________________________________________________________________________________________________
READ_RAM_DISK:				;
					; IF RAM, PROCEED WITH NORMAL TRACK/SECTOR READ
	CALL	SECPAGE			; SETUP FOR READ OF RAM OR ROM DISK
	CALL	PAGERB			; SET PAGER WITH DRIVE AND TRACK
	LD	HL,TMPBUF		; LOAD HL WITH TEMP BUF ADDRESS
	LD	E,L			;
	LD	D,H			; GET IT INTO DE
	LD	HL,(SECST)		; GET ROM/RAM ADDRESS
	CALL	COPY_CPM_SECTOR		; MOVE SECTOR TO TMPBUF
	CALL	RPAGE			; SET PAGE TO CP/M RAM
	LD	HL,(DMAAD)		; LOAD HL WITH DMA ADDRESS					;
	LD	E,L			;
	LD	D,H			; GET IT INTO DE
	LD	HL,TMPBUF		; GET ROM/RAM ADDRESS
	CALL	COPY_CPM_SECTOR		; MOVE SECTOR FROM TMPBUF TO DMA AREA
	LD	A,(DISKNO)		; STORE CURRENT DRIVE IN BUFFER
	LD	(CUDISK),A		;
	LD	A,00H			;
	EI				; RE-ENABLE INTERRUPTS
	RET
	
;___TRFLSEC______________________________________________________________________________________________
;
;	TRANSLATE LOGICAL FLOPPY DISK SECTOR TO PHYSICAL SECTOR
;	IN:  TRACK,SECTOR
;	OUT: PTRACK,PSECTOR,SECTOR_INDEX
;________________________________________________________________________________________________________
TRFLSEC:	
	LD	A,(TRACK)		; LOAD TRACK # (LOW BYTE)
	AND	01H			; FILTER OUT HEAD
	LD	(HEAD),A		; STORE HEAD
	LD	A,(TRACK)		; SAVE TRACK IN A
	SRL	A			; REMOVE HEAD BIT	
	LD	(PTRACK),A		; STORE IN TRACK
	LD	A,(SECTOR)		; LOAD SECTOR # (LOW BYTE)
	LD	(SECTOR_INDEX),A	; STORE SECTOR IN SECTOR INDEX
	SRL	A			; 
	SRL	A			; DIVIDE BY 4 (FOR BLOCKING)
	LD	(PSECTOR),A		; STORE IN SECTOR
	LD	A,(SECTOR_INDEX)	; FILTER OUT UNWANTED BITS
	AND	03H			;
	LD	(SECTOR_INDEX),A	;
	RET	

;___DEBSEC_______________________________________________________________________________________________
;
;	DEBLOCK 512 BYTE SECTOR FOR CP/M
;
;________________________________________________________________________________________________________
DEBSEC:		
	LD	HL,(DMAAD)		; LOAD HL WITH DMA ADDRESS
	LD	D,H			; TRANSFER HL REGISTERS TO DE
	LD	E,L			;
	PUSH	DE			; STORE DE
					; COMPUTE STARTING ADDRESS OF CP/M SECTOR IN READ SECTOR BUFFER
	LD	HL,SECTOR_BUFFER 	; LOAD HL WITH SECTOR BUFFER ADDRESS
	LD	A,(SECTOR_INDEX) 	; GET THE SECTOR INDEX (CP/M SECTOR OFFSET IN BUFFER)
	RRCA				; MOVE BIT 0 TO BIT 7
	RRCA				; DO AGAIN - IN EFFECT MULTIPLY BY 4
	LD	D,00H			; PUT RESULT AS 16 VALUE IN DE, UPPER BYTE IN D IS 000h
	LD	E,A			; PUT ADDRESS OFFSET IN E
	ADD	HL,DE			; MULTIPLY BY 2, TOTAL MULTIPLICATION IS X 128
	ADD	HL,DE			; CP/M SECTOR STARTING ADDRESS IN IDE HD SECTOR BUFFER
					; COPY CP/M SECTOR TO BDOS DMA ADDRESS BUFFER					
	POP	DE			; RESTORE DE					
	CALL	COPY_CPM_SECTOR		;
	RET

;___BLKSEC_______________________________________________________________________________________________
;
;	BLOCK 512 BYTE SECTOR FOR CP/M
;
;________________________________________________________________________________________________________
BLKSEC:	
					; COMPUTE STARTING ADDRESS OF CP/M SECTOR IN READ SECTOR BUFFER	
	LD	HL,SECTOR_BUFFER 	; LOAD HL WITH SECTOR BUFFER ADDRESS
	LD	A,(SECTOR_INDEX) 	; GET THE SECTOR INDEX (CP/M SECTOR OFFSET IN BUFFER)
	RRCA				; MOVE BIT 0 TO BIT 7
	RRCA				; DO AGAIN - IN EFFECT MULTIPLY BY 64
	LD	D,00			; PUT RESULT AS 16 VALUE IN DE, UPPER BYTE IN D IS 000h
	LD	E,A			; PUT ADDRESS OFFSET IN E
	ADD	HL,DE			; CP/M SECTOR STARTING ADDRESS IN IDE HD SECTOR BUFFER
	ADD	HL,DE			; MULTIPLY BY 2, TOTAL MULTIPLICATION IS X 128
	LD	(SECST),HL		; KEEP CP/M SECTOR ADDRESS FOR LATER USE
					; COPY CP/M SECTOR FROM BDOS DMA ADDRESS BUFFER
	LD	HL,(SECST)		; LOAD CP/M SECTOR ADDRESS (WHERE THE DATA IS TO BE WRITTEN)
	LD	D,H			; TRANSFER HL REGISTERS TO DE
	LD	E,L			;
	LD	HL,(DMAAD)		; LOAD HL WITH DMA ADDRESS (WHERE THE DATA TO BE WRITTEN IS)
	CALL	COPY_CPM_SECTOR		;
	RET
	
;___ISCUR_______________________________________________________________________________________________
;
;	IS CURRENT SECTOR IN BUFFER?
;
;________________________________________________________________________________________________________
ISCUR:				
	LD	HL,(PSECTOR)		; COMPARE REQUESTED SECTOR WITH SECTOR IN BUFFER
	LD	A,(CUSECTOR)		; 
	CP	L			;
	RET	NZ			; LOW BYTE NOT  EQUAL
	LD	A,(CUSECTOR+1)		; 
	CP	H			;
	RET	NZ			; HIGH BYTE NOT  EQUAL
	LD	HL,(PTRACK)		; COMPARE REQUESTED TRACK WITH TRACK IN BUFFER
	LD	A,(CUTRACK)		; 
	CP	L			; LOW BYTE NOT  EQUAL
	RET	NZ			;
	LD	A,(CUTRACK+1)		; 
	CP	H			;
	RET	NZ			; HIGH BYTE NOT  EQUAL
	LD	HL,(DISKNO)		; COMPARE REQUESTED DRIVE WITH DRIVE IN BUFFER
	LD	A,(CUDISK)		;
	CP	L			;
	RET				; EXIT WITH RESULT

;___READ_FLOPPY_DISK_____________________________________________________________________________________
;
;	READ FLOPPY DISK
;
;________________________________________________________________________________________________________

READ_FLOPPY_DISK:
	DI				; DISABLE INTERRUPTS
	LD	HL,0			;
	ADD	HL,SP			; GET STACK POINTER INTO HL
	LD	(PARKSTACK),HL		; SAVE STACK POINTER 
	LD	SP,FLOPPYSTACK		; 
	CALL	TRFLSEC			; TRANSLATE SECTOR INFORMATION
	CALL 	READ_FLOPPY_SECTOR	;
	CALL	DEBSEC			; DEBLOCK SECTOR
	LD	A,(ST1)			; LOAD RESULT CODE INTO A
READ_FLOPPY_DISK_EXIT:			;
	LD	SP,(PARKSTACK)		; RETURN STACK
	EI				; RE-ENABLE INTERRUPTS
	RET
	
	
;___READ_FLOPPY_SECTOR_____________________________________________________________________________________
;
;	READ A SECTOR FROM A FLOPPY DISK
;
;________________________________________________________________________________________________________
READ_FLOPPY_SECTOR:
	LD	A,0			; RESET STATUS FLAG 1
	LD	(ST1),A			;
	CALL	ISCUR			; IS CURRENT SECTOR ALREADY IN BUFFER
	JP	Z,READ_FLOPPY_SECTOR_OK	;
	LD	A,20			; 20 RETRIES
	LD	(RETRY),A		;
	LD	A,2			; 2 ITERATIONS OF RETRIES 
	LD	(RETRY1),A		;	
READ_FLOPPY_SECTOR_RETRY:		;
	CALL	FLOPPYREAD		; READ THE FLOPPY DISK SECTOR
	LD	A,(ST0)			; GET STATUS FLAG 0
	AND	0F8H			; MASK OF DRIVE AND HEAD SELECTION
	LD	B,A			; MOVE STATUS FLAG 0 TO B
	LD	A,(ST1)			; GET STATUS FLAG 1
	OR	B			; IF ZERO READ WAS OK
	JP	Z,READ_FLOPPY_SECTOR_OK
	LD	A,(RETRY)		; READ NOT OK, DEC RETRY COUNTER
	DEC	A			; 
	LD	(RETRY),A		; STORE NEW RETRY COUNTER
	JP	NZ,READ_FLOPPY_SECTOR_RETRY
	CALL	CYCLEFLOPPY		; CYCLE FLOPPY HEAD
	LD	A,20			; RESET TO 20 RETRIES
	LD	(RETRY),A		; STORE RETRY COUNTER
	LD	A,(RETRY1)		; DEC RETRY ITERATION COUNTER
	DEC	A			;
	LD	(RETRY1),A		;
	JP	NZ,READ_FLOPPY_SECTOR_RETRY
	LD	HL,0FFFFH		; SET INVALID CONDITION, BUFFER IS INVALID
	LD	(CUSECTOR),HL		; CURRENT PHYSICAL DISK SECTOR IN BUFFER
	LD	(CUTRACK),HL		; CURRENT PHYSICAL DISK TRACK IN BUFFER
	RET				;
READ_FLOPPY_SECTOR_OK:			;
	LD	HL,(PSECTOR)		; STORE PHYSICAL SECTOR IN BUFFER
	LD	(CUSECTOR),HL		; 
	LD	HL,(PTRACK)		; STORE PHYSICAL DISK TRACK IN BUFFER
	LD	(CUTRACK),HL		; 
	LD	A,(DISKNO)		; STORE CURRENT DRIVE IN BUFFER
	LD	(CUDISK),A		;
	RET
	
;___READ_IDE_____________________________________________________________________________________________
;
;	READ  FROM IDE HARD DISK  
;________________________________________________________________________________________________________

READ_IDE:
	DI				; DISABLE INTERRUPTS
	LD	HL,0			;
	ADD	HL,SP			; GET STACK POINTER INTO HL
	LD	(PARKSTACK),HL		; SAVE STACK POINTER 
	LD	SP,FLOPPYSTACK		; 
					; DISABLE INTERRUPTS
	CALL	CONVERT_IDE_SECTOR_CPM 	; COMPUTE WHERE THE CP/M SECTOR IS ON THE
	CALL	IDE_READ_SECTOR		; READ THE IDE HARD DISK SECTOR
	JP	NC,READ_IDE_ERROR	;
	CALL	DEBSEC			;
	LD	SP,(PARKSTACK)		; RETURN STACK
	EI				; RE-ENABLE INTERRUPTS
	LD	A,00H			; RETURN ERROR CODE READ SUCCESSFUL A=0
	RET				;
READ_IDE_ERROR:				;
	LD	SP,(PARKSTACK)		; RETURN STACK
	EI				; RE-ENABLE INTERRUPTS
	LD	A,0FFH			; RETURN ERROR CODE READ ERROR A=FF
	RET	

;___READ_ATAPI_________________________________________________________________________________________
;
;	READ  FROM ATAPI DEVICE
;________________________________________________________________________________________________________	
READ_ATAPI:
	LD	A,0FFH			; 255 RETRIES
	LD	(RETRY),A		;
READ_ATAPI_RETRY:		
	LD	A,10H			; SET TO SECONDARY DEVICE
	LD	(IDEDEVICE),A		;
	DI				; DISABLE INTERRUPTS
	LD	HL,0			;
	ADD	HL,SP			; GET STACK POINTER INTO HL
	LD	(PARKSTACK),HL		; SAVE STACK POINTER 
	LD	SP,FLOPPYSTACK		; 
	CALL	CONVERT_IDE_SECTOR_CPM	; COMPUTE WHERE THE CP/M SECTOR IS ON THE
	CALL	ATAPI_READ_SECTOR	; READ THE IDE HARD DISK SECTOR
	JP	NC,READ_ATAPI_ERROR	;
	CALL	DEBSEC			;									;
	LD	SP,(PARKSTACK)		; RETURN STACK
	EI				; RE-ENABLE INTERRUPTS
	LD	A,00H			; RETURN ERROR CODE READ SUCCESSFUL A=0
	RET				;
READ_ATAPI_ERROR:		
	LD	A,(RETRY)		; READ NOT OK, DEC RETRY COUNTER
	DEC	A			; 
	LD	(RETRY),A		; STORE NEW RETRY COUNTER
	JP	NZ,READ_ATAPI_RETRY	;
	LD	SP,(PARKSTACK)		; RETURN STACK
	EI				; RE-ENABLE INTERRUPTS
	LD	A,0FFH			; RETURN ERROR CODE READ ERROR A=FF
	RET				;
		
READ_HDPART4:
					; STUB
	RET

;___WRITE______________________________________________________________________________________________
;
;   HANDLE CP/M WRITE CALL
;
;________________________________________________________________________________________________________
WRITE:
	DI				; DISABLE INTERRUPTS
	LD	A,(DISKNO)		; GET DRIVE
	 IF CONDSWAPAB			;
	CP	00H			; FIND OUT WHICH DRIVE IS BEING REQUESTED
	JP	Z,WRITE_FLOPPY_DISK	;
	CP	01H			; 
	JP	Z,WRITE_RAM_DISK 	; WRITE TO 448K RAM DISK
	 ELSE				;
	CP	01H			; FIND OUT WHICH DRIVE IS BEING REQUESTED
	JP	Z,WRITE_FLOPPY_DISK	;				
	CP	00H			; 
	JP	Z,WRITE_RAM_DISK 	; WRITE TO 448K RAM DISK
	 ENDIF				;
	CP	02H			;
	JP	Z,WRITE_IDE		; WRITE TO 8 MB IDE HARD DISK, PARTITION 2
	CP	03H			;
	JP	Z,WRITE_ATAPI		; WRITE TO 8 MB IDE HARD DISK, PARTITION 3
	CP	04H			;
	JP	Z,WRITE_HDPART4		; WRITE TO 1 MB IDE HARD DISK, PARTITION 4


;___RDONLY______________________________________________________________________________________________
;
;   HANDLE WRITE TO READ ONLY
;
;   SENDS A MESSAGE TO TERMINAL THAT ROM DRIVE IS NOT WRITEABLE
;   DOES A PAUSE THEN RETURNS TO CPM WITH ERROR FLAGGED  THIS IS
;   DONE TO ALLOW A POSSIBLE GRACEFUL EXIT (SOME APPS MAY PUKE) 
;________________________________________________________________________________________________________
RDONLY:
	LD	HL,TXT_RO_ERROR		; SET HL TO START OF ERROR MESSAGE
	CALL	PRTMSG			; PRINT ERROR MESSAGE
	LD	A,01H			; SEND BAD SECTOR ERROR BACK
					; BDOS WILL ALSO PRINT ITS OWN ERROR MESSAGE
	RET

;___WRITE_RAM_DISK_____________________________________________________________________________________
;
;	WRITE RAM DISK
;________________________________________________________________________________________________________
WRITE_RAM_DISK:
	LD	HL,TMPBUF		; LOAD HL WITH TEMP BUF ADDRESS
	LD	E,L			;
	LD	D,H			; GET IT INTO DE
	LD	HL,(DMAAD)		; GET DMA ADDRESS
	CALL	COPY_CPM_SECTOR		;
	CALL	SECPAGE			; GET RAM PAGE WRITE ADDRESS
	CALL	PAGERB			; SET PAGER WITH DRIVE AND TRACK
	LD	HL,(SECST)		; LOAD HL WITH DMA ADDRESS (WHERE TO WRITE TO)
	LD	E,L			;
	LD	D,H			; GET IT INTO DE
	LD	HL,TMPBUF		; GET TEMP BUFFER ADDRESS
	CALL	COPY_CPM_SECTOR		;
	CALL	RPAGE			; SET BACK TO RAM
	LD	A,(DISKNO)		; STORE CURRENT DRIVE IN BUFFER
	LD	(CUDISK),A		;
	LD	A,00H			;
	EI				; RE-ENABLE INTERRUPTS
	RET
	
;___WRITE_FLOPPY_DISK_____________________________________________________________________________________
;
;	WRITE FLOPPY DISK
;________________________________________________________________________________________________________
WRITE_FLOPPY_DISK:
	DI				; DISABLE INTERRUPTS
	LD	HL,0			;
	ADD	HL,SP			; MOVE STACK POINTER TO HL
	LD	(PARKSTACK),HL		; SAVE STACK POINTER 
	LD	SP,FLOPPYSTACK		;
	CALL	TRFLSEC			; TRANSLATE SECTOR INFORMATION
	CALL 	READ_FLOPPY_SECTOR	;
	LD	A,(ST1)			; GET STATUS CODE
	JP	NZ,WRITE_FLOPPY_DISK_OK	;
WRITE_READ_FLOPPY_DISK_OK:		;
	CALL	BLKSEC			; BLOCK SECTOR 
					; IDE HD SECTOR IS NOW UPDATED WITH CURRENT CP/M SECTOR DATA SO WRITE TO DISK
	LD	A,20			; 20 RETRIES
	LD	(RETRY),A		;
WRITE_FLOPPY_DISK_RETRY:		;
	CALL	FLOPPYWRITE		; WRITE THE FLOPPY DISK SECTOR
	LD	A,(ST0)			; GET STATUS CODE 0
	AND	0F8H			; MASK OF DRIVE AND HEAD SELECTION
	LD	B,A			; MOVE STATUS CODE 0 TO B
	LD	A,(ST1)			; GET STATUS CODE 1
	OR	B			; IF ZERO WRITE WAS OK
	JP	Z,WRITE_FLOPPY_DISK_OK
	LD	A,(RETRY)		; BAD WRITE, DEC RETRY COUNTER
	DEC	A			;
	LD	(RETRY),A		; STORE NEW RETRY COUNTER
	JP	NZ,WRITE_FLOPPY_DISK_RETRY
WRITE_FLOPPY_DISK_OK:			;
	LD	SP,(PARKSTACK)		; RESTORE STACK
	LD	A,(ST1)			; GET STATUS CODE 1
	EI				; RE-ENABLE INTERRUPTS
	RET

	

;___WRITE_IDE____________________________________________________________________________________________
;
;	WRITE TO IDE DEVICE
;________________________________________________________________________________________________________		
WRITE_IDE:
	DI				; DISABLE INTERRUPTS
	LD	HL,0			;
	ADD	HL,SP			; GET STACK POINTER INTO HL
	LD	(PARKSTACK),HL		; SAVE STACK POINTER 
	LD	SP,FLOPPYSTACK		; 
	CALL	CONVERT_IDE_SECTOR_CPM 	; COMPUTE WHERE THE CP/M SECTOR IS ON THE
	CALL	IDE_READ_SECTOR		; READ THE IDE HARD DISK SECTOR
	JP	NC,WRITE_IDE_ERROR	; ON ERROR, ABORT
	CALL	BLKSEC			; DEBLOCK SECTOR
	CALL	IDE_WRITE_SECTOR 	; WRITE THE UPDATED IDE HARD DISK SECTOR
	LD	SP,(PARKSTACK)		; RESTORE STACK
	EI				; RE-ENABLE INTERRUPTS
	LD	A,00H			; RETURN ERROR CODE WRITE SUCCESSFUL A=0
	RET				;
WRITE_IDE_ERROR:			;
	LD	SP,(PARKSTACK)		; RESTORE STACK
	EI				; RE-ENABLE INTERRUPTS
	LD	A,0FFH			; RETURN ERROR CODE WRITE ERROR A=FF
	RET

;___WRITE_ATAPI__________________________________________________________________________________________
;
;	WRITE TO ATAPI DEVICE
;________________________________________________________________________________________________________		
WRITE_ATAPI:
	LD	A,10H			; SET TO SECONDARY DEVICE
	LD	(IDEDEVICE),A		;
	DI				; DISABLE INTERRUPTS
	LD	HL,0			;
	ADD	HL,SP			; GET STACK POINTER INTO HL
	LD	(PARKSTACK),HL		; SAVE STACK POINTER 
	LD	SP,FLOPPYSTACK		; 
					;
	CALL	CONVERT_IDE_SECTOR_CPM	; COMPUTE WHERE THE CP/M SECTOR IS ON THE DISK
					;
	CALL	ATAPI_READ_SECTOR	; READ SECTOR
	JP	NC,WRITE_ATAPI_ERROR	; ON ERROR, ABORT
	CALL	BLKSEC			; DEBLOCK SECTOR
	CALL	ATAPI_WRITE_SECTOR	;
					;
	LD	SP,(PARKSTACK)		; RESTORE STACK					
	EI				; RE-ENABLE INTERRUPTS
	LD	A,00H			; RETURN ERROR CODE WRITE SUCCESSFUL A=0
	RET				;
WRITE_ATAPI_ERROR:			
	LD	SP,(PARKSTACK)		; RESTORE STACK
	EI				; RE-ENABLE INTERRUPTS
	LD	A,0FFH			; RETURN ERROR CODE WRITE ERROR A=FF
	RET
	
WRITE_HDPART4:
					; STUB
	RET


;___PRTMSG_______________________________________________________________________________________________
;
;	PRINT MESSAGE POINTED TO BY HL ON CONSOLE DEVICE
;________________________________________________________________________________________________________		
PRTMSG:
	LD	A,(HL)			; GET CHARACTER TO A
	CP	END			; TEST FOR END BYTE
	JP	Z,PRTMSG1		; JUMP IF END BYTE IS FOUND
	LD	C,A			; PUT CHAR TO PRINT VALUE IN REG C FOR CONOUT
	CALL	CONOUT			; SEND CHARACTER TO CONSOLE FROM REG C
	INC	HL			; INC POINTER, TO NEXT CHAR
	JP	PRTMSG			; TRANSMIT LOOP
PRTMSG1:
	RET


;___SECPAGE_______________________________________________________________________________________________
;
;	UTILITY ROUTINE FOR SECTOR TO PAGE ADDRESS
;________________________________________________________________________________________________________		
SECPAGE:
	LD	HL,(SECTOR)		; GET SECTOR INTO HL
	ADD	HL,HL			; SHIFT BITS 1 TO LEFT (*2)
	ADD	HL,HL			; SHIFT BITS 1 TO LEFT (*4)
	ADD	HL,HL			; SHIFT BITS 1 TO LEFT (*8)
	ADD	HL,HL			; SHIFT BITS 1 TO LEFT (*16)
	ADD	HL,HL			; SHIFT BITS 1 TO LEFT (*32)
	ADD	HL,HL			; SHIFT BITS 1 TO LEFT (*64)
	ADD	HL,HL			; SHIFT BITS 1 TO LEFT (*128)
	LD	(SECST),HL		; SAVE SECTOR STARTING ADDRESS
	RET
	
;___PAGERB_______________________________________________________________________________________________
;
;	PAGER BYTE CREATION
;    	ASSEMBLES DRIVE AND TRACK AND SENDS IT TO PAGER PORT
;________________________________________________________________________________________________________		
PAGERB:	
	LD	HL,(TRACK)		; LOAD TRACK INTO HL
	LD	A,(DISKNO)		; LOAD DISK INTO A
	CP	05H			; IS ROM?
	JP	Z,ROMD			; READ FROM 1M ROM DISK
	CP	06H			; IS ROM?
	JP	Z,ROMD			; READ FROM 22K ROM DISK
	AND	1			; MASK FOR 1 BIT OF DRIVE SELECT 
	RRCA				; MOVE BIT 0 TO BIT 7
	OR	L			; OR L WITH ACC TO COMBINE TRACK AND DRIVE
	OUT	(MPCL_RAM),A		; SEND TO RAM PORT MAPPER
	LD	(PAGER),A		; SAVE COPY (JUST BECAUSE)
	RET				;
ROMD:					;
	LD	A,05H			;
	AND	1			; MASK FOR 1 BIT OF DRIVE SELECT 
	RRCA				; MOVE BIT 0 TO BIT 7
	OR	L			; OR L WITH ACC TO COMBINE TRACK AND DRIVE
	AND	7FH			; STRIP OFF BIT 7 (ROM_ENABLE BIT)
	OUT	(MPCL_ROM),A		; SEND TO ROM PORT MAPPER
	LD	(PAGER),A		; SAVE COPY (JUST BECAUSE)
	LD	(DB_PAGER),A		; SAVE COPY (JUST BECAUSE) (DEBUG)
	RET

;___RPAGE_______________________________________________________________________________________________
;
;	RESET PAGER BACK TO RAM   
;________________________________________________________________________________________________________		
RPAGE:
	LD	A,80H			; DESELECT ROM PAGE
	OUT	(MPCL_ROM),A		; SELECT RAM
	LD	A,00H			; SET TO RAM, TRACK 0
	OUT	(MPCL_RAM),A		; SELECT RAM
	LD	(PAGER),A		; SAVE COPY OF PAGER BYTE
	RET

;___COPY_CPM_SECTOR______________________________________________________________________________________
;
; 	COPIES ONE CPM SECTOR FROM ONE MEMORY ADDRESS TO ANOTHER
;	INPUT
;  		 DE SOURCE ADDRESS
;		 HL TARGET ADDRESS
; 	USES C REGISTER
;________________________________________________________________________________________________________		
COPY_CPM_SECTOR:
	LD	BC,128			; BC IS COUNTER FOR FIXED SIZE TRANSFER (128 BYTES)
	LDIR				; TRANSFER
	RET

;___CONVERT_IDE_SECTOR_CPM________________________________________________________________________________
;
; COMPUTES WHERE THE CP/M SECTOR IS IN THE LBA PARTITION
; LBA HD SECTORS ARE 512 BYTES EACH, CP/M SECTORS ARE 128 BYTES EACH
; MAXIMUM SIZE OF CP/M DISK IS 8 MB = 65536 (16 BITS) X 128 BYTES PER SECTOR
; LBA HD PARTITION CAN HAVE AT MOST 16777215 IDE SECTORS -> 67108860 CP/M SECTORS
; EACH IDE HD SECTOR CONTAINS 4 ADJACENT CP/M SECTORS
; 
; 
; INPUT:
;  - CP/M TRACK AND SECTOR 16 BIT WORDS
; 
; OUTPUT:
; IDE TARGET SECTOR (SENT TO IDE HD CONTROLLER FOR READ OPERATION)
;  - LOWER 16 BITS STORED IN LBA_TARGET_LO
;  - UPPER 16 BITS STORED IN LBA_TARGET_HI
; CP/M TO IDE HD SECTOR MAPPING PARAMETER STORED IN SECTOR_INDEX
;  - 8 BIT VALUE WITH 4 LEGAL STATES (00, 01, 02, 04) WHICH IS
;    TO BE USED TO COMPUTE STARTING ADDRESS OF 128 BYTE CP/M SECTOR ONCE
;    512 BYTE IDE HD SECTOR READ INTO MEMORY BUFFER
; LBA ADDRESS FORMAT = 00TTTTSS
;
; ROTATE WITH CARRY 16 BIT TRACK,SECTOR VALUE IN HL TO GET 14 BIT IDE HD
; TARGET SECTOR IN PARTITION
; KEEP LAST TWO BITS IN B FOR IDE HD SECTOR TO CP/M SECTOR TRANSLATION
; COMPUTE SECTOR_INDEX 
;________________________________________________________________________________________________________		
CONVERT_IDE_SECTOR_CPM:

	LD	A,(TRACK)		; LOAD TRACK # (LOW BYTE)
	LD	H,A			; 
	LD	A,(SECTOR)		; LOAD SECTOR# (LOW BYTE)
	LD	L,A			;		
	CALL	RRA16			; ROTATE 'HL' RIGHT (DIVIDE BY 2)
	CALL	RRA16			; ROTATE 'HL' RIGHT (DIVIDE BY 2)
	LD	A,(TRACK+1)		; GET HIGH BYTE OF TRACK INTO A
	SLA	A			;
	SLA	A			;
	SLA	A			;
	SLA	A			;
	SLA	A			;
	SLA	A			;
	OR	H			;
	LD	H,A			;
	LD	A,(TRACK+1)		; GET HIGH BYTE OF TRACK INTO A
	SRL	A			;
	SRL	A			;
	LD	(LBA_TARGET_HI),A	;
	LD	A,L
	LD	(LBA_TARGET_LO),A	; LBA REGISTER IS 00TTTTSS / 4
	LD	A,H			;
	LD	(LBA_TARGET_LO+1),A 	; 
	LD	A,00H			;
	LD	(LBA_TARGET_HI+1),A	;
					;
	LD	HL,(LBA_TARGET_LO)	; STORE PHYSICAL SECTOR 
	LD	(PSECTOR),HL		;					
	LD	HL,(LBA_TARGET_HI)	; STORE PHYSICAL TRACK 
	LD	(PTRACK),HL		;					
	
	LD	A,(SECTOR)		; LOAD SECTOR # 
	AND	000000011b		; 
	LD	(SECTOR_INDEX),A 	; LOCATES WHERE THE 128 BYTE CP/M SECTOR
					; IS WITHIN THE 512 BYTE IDE HD SECTOR
					; COMPUTE WHICH IDE HD SECTOR TO READ TO WITHIN 4 CP/M SECTORS 
					; SHIFTS 16 BIT PARTITION OFFSET TO THE RIGHT 2 BITS AND ADDS RESULT TO
					; IDE HD PARTITION STARTING SECTOR		
					; SHIFT PARTITION OFFSET RIGHT 1 BIT
	RET
RRA16:
	SCF				;
	CCF				; CLEAR CARRY FLAG
	LD	A,H			; 16 BIT ROTATE HL WITH CARRY
	RRA				;
	LD	H,A			; ROTATE HL RIGHT 1 BIT (DIVIDE BY 2)
	LD	A,L			;
	RRA				;
	LD	L,A			;		
	RET


;___IDE_READ_SECTOR______________________________________________________________________________________
;
;	READ IDE SECTOR
;________________________________________________________________________________________________________			
IDE_READ_SECTOR:
	CALL	ISCUR			; IS CURRENT SECTOR IN BUFFER?	
	JP	Z,IDE_READ_SECTOR_OK	;
	CALL	IDE_WAIT_BUSY_READY 	; MAKE SURE DRIVE IS READY TO PROCEED
	RET	NC			; ERROR, RETURN
	CALL	IDE_SETUP_LBA		; TELL DRIVE WHAT SECTOR IS REQUIRED
	LD	A,20H			;
	OUT	(IDESTTS),A		; 020h = IDE 'READ SECTOR' COMMAND 
IDE_SREX:				;
	CALL	IDE_WAIT_BUSY_READY	; MAKE SURE DRIVE IS READY TO PROCEED
	RET	NC			; ERROR, RETURN
	CALL	IDE_TEST_ERROR		; ENSURE NO ERROR WAS REPORTED
	RET	NC			; ERROR, RETURN
	CALL	IDE_WAIT_BUFFER		; WAIT FOR FULL BUFFER SIGNAL FROM DRIVE
	RET	NC			; ERROR, RETURN
	CALL	IDE_READ_BUFFER		; GRAB THE 256 WORDS FROM THE BUFFER
	SCF				; CARRY = 1 ON RETURN = OPERATION OK
IDE_READ_SECTOR_OK:			;
	LD	HL,(PSECTOR)		; STORE PHYSICAL SECTOR IN BUFFER
	LD	(CUSECTOR),HL		; 
	LD	HL,(PTRACK)		; STORE PHYSICAL DISK TRACK IN BUFFER
	LD	(CUTRACK),HL		; 
	LD	A,(DISKNO)		; STORE CURRENT DRIVE IN BUFFER
	LD	(CUDISK),A		;
	SCF				; CARRY = 1 ON RETURN = OPERATION OK
	RET
	
;___IDE_WRITE_SECTOR_____________________________________________________________________________________
;
;	WRITE IDE SECTOR
;________________________________________________________________________________________________________			
IDE_WRITE_SECTOR:
	CALL	IDE_WAIT_BUSY_READY 	; MAKE SURE DRIVE IS READY TO PROCEED
	RET	NC			; ERROR, RETURN
	CALL	IDE_SETUP_LBA		; TELL DRIVE WHAT SECTOR IS REQUIRED
	LD	A,30H			;
	OUT	(IDESTTS),A		; 030h = IDE 'WRITE SECTOR' COMMAND 
	CALL	IDE_WAIT_BUSY_READY	;
	RET	NC			; ERROR, RETURN
	CALL	IDE_TEST_ERROR		; ENSURE NO ERROR WAS REPORTED
	RET	NC			; ERROR, RETURN
	CALL	IDE_WAIT_BUFFER		; WAIT FOR BUFFER READY SIGNAL FROM DRIVE
	RET	NC			; ERROR, RETURN
	CALL	IDE_WRITE_BUFFER 	; SEND 256 WORDS TO DRIVE'S BUFFER
	CALL	IDE_WAIT_BUSY_READY 	; MAKE SURE DRIVE IS READY TO PROCEED
	RET	NC			; ERROR, RETURN
	CALL	IDE_TEST_ERROR		; ENSURE NO ERROR WAS REPORTED
	RET	NC			; ERROR, RETURN
	SCF				; CARRY = 1 ON RETURN = OPERATION OK
	RET		

;___IDE_SOFT_RESET_______________________________________________________________________________________
;
;	RESET IDE CHANNEL
;________________________________________________________________________________________________________			
IDE_SOFT_RESET:
	 IF 	CONDIDESOFT		;
	LD	A,000000110b		; NO INTERRUPTS, RESET DRIVE = 1
	OUT	(IDECTRL),A		;
	LD	A,000000010b		; NO INTERRUPTS, RESET DRIVE = 0
	OUT	(IDECTRL),A		;
	CALL	IDE_WAIT_BUSY_READY	;THIS TAKES A COUPLE OF SECONDS
	RET	
	 ELSE
	; SKIP THIS IF NO IDE DRIVE WHICH SPEEDS UP REBOOTS AND STARTUPS
	RET
	 ENDIF

;___ATAPI_WAIT_BUSY_READY________________________________________________________________________________
;
;	WAIT FOR ATAPI CHANNEL TO BE READY
;________________________________________________________________________________________________________			
ATAPI_WAIT_BUSY_READY:
	LD	DE,0			; CLEAR OUT DE
ATAPI_WBSY:				;
	LD	B,0F0H			; SETUP TIMEOUT
ATAPI_DLP:				;
	DJNZ	ATAPI_DLP		; 
	INC	DE			;
	LD	A,D			;
	OR	E			;
	JR	Z,ATAPI_TO		;
	IN	A,(IDESTTS)		; READ ERROR REG
	AND	010000000b		; MASK OFF BUSY BIT
	JR	NZ,ATAPI_WBSY		; WE WANT BUSY(7) TO BE 0 
	SCF				; CARRY 1 = OK
	RET				;
ATAPI_TO:				;
	XOR	A			; CARRY 0 = TIMED OUT
	RET				;
	
;___IDE_WAIT_DRQ_READY___________________________________________________________________________________
;
;	WAIT FOR IDE CHANNEL TO BE READY
;________________________________________________________________________________________________________			
IDE_WAIT_DRQ_READY:
	IN	A,(IDESTTS)		; READ ERROR REG
	AND	000001000b		; MASK OFF RDY BIT
	JR	Z,IDE_WAIT_DRQ_READY	; WE WANT DRQ(3) TO BE 1
	RET

;___IDE_WAIT_DRQ_ZERO____________________________________________________________________________________
;
;	WAIT FOR IDE DRQ TO BE ZERO
;________________________________________________________________________________________________________			
IDE_WAIT_DRQ_ZERO:
	IN	A,(IDESTTS)		; READ ERROR REG
	AND	000001000b		; MASK OFF RDY BIT
	JR	NZ,IDE_WAIT_DRQ_ZERO	; WE WANT DRQ(3) TO BE 0
	RET

;___IDE_WAIT_BUSY_READY___________________________________________________________________________________
;
;	WAIT FOR IDE CHANNEL TO BE READY
;________________________________________________________________________________________________________			
IDE_WAIT_BUSY_READY:
	LD	DE,0			; CLEAR DE
IDE_WBSY:				;
	LD	B,5			; SETUP TIMEOUT
IDE_DLP:				;
	DEC	B			;
	JP	NZ,IDE_DLP		;
	INC	DE			;
	LD	A,D			;
	OR	E			;
	JP	Z,IDE_TO		;
	IN	A,(IDESTTS)		; READ ERROR REG
	AND	011000000b		; MASK OFF BUSY AND RDY BITS
	XOR	001000000b		; WE WANT BUSY(7) TO BE 0 AND RDY(6) TO BE 1
	JP	NZ,IDE_WBSY		;
	SCF				; CARRY 1 = OK
	RET
IDE_TO:
	XOR	A			; CARRY 0 = TIMED OUT
	RET
	
;___IDE_TEST_ERROR_______________________________________________________________________________________
;
;	CHECK FOR IDE ERROR CONDITION
;________________________________________________________________________________________________________			
IDE_TEST_ERROR:
	SCF				;
	IN	A,(IDESTTS)		;
	LD	B,A			; 
	AND	000000001b		; TEST ERROR BIT
	SCF				; 
	RET	Z			;
	LD	A,B			; 
	AND	000100000b		;
	SCF				;
	JP	NZ,IDE_ERR		; TEST WRITE ERROR BIT
	IN	A,(IDEERR)		; READ ERROR FLAGS
IDE_ERR:
	OR	A			; CARRY 0 = ERROR
	RET				; IF A = 0, IDE BUSY TIMED OUT

;___IDE_WAIT_BUFFER_______________________________________________________________________________________
;
;	WAIT FOR DATA BUFFER READY
;________________________________________________________________________________________________________			
IDE_WAIT_BUFFER:
	LD	DE,0			;
IDE_WDRQ:				;
	LD	B,5			;
IDE_BLP:				;
	DEC	B			;
	JP	NZ,IDE_BLP		;	
	INC	DE			;
	LD	A,D			;
	OR	E			;
	JP	Z,IDE_TO2		;
	IN	A,(IDESTTS)		; WAIT FOR DRIVE'S 512 BYTE READ BUFFER 
	AND	000001000b		; TO FILL (OR READY TO FILL)
	JP	Z,IDE_WDRQ		;
	SCF				; CARRY 1 = OK
	RET				;
IDE_TO2:				;
	XOR	A			; CARRY 0 = TIMED OUT
	RET				;

;___IDE_READ_BUFFER_______________________________________________________________________________________
;
;	READ IDE BUFFER
;________________________________________________________________________________________________________			
IDE_READ_BUFFER:
	PUSH	HL			;
	LD	HL,SECTOR_BUFFER	;
	LD	B,0			; 256 WORDS (512 BYTES PER SECTOR)
IDEBUFRD:				;
	IN	A,(IDELO)		; LOW BYTE OF WORD FIRST	
	LD	(HL),A			;
	IN	A,(IDEHI)		; THEN HIGH BYTE OF WORD
	INC	HL			;
	LD	(HL),A			;
	INC	HL			;
	DEC	B			;
	JP	NZ,IDEBUFRD		;
	POP	HL			;
	RET

;___IDE_WRITE_BUFFER_______________________________________________________________________________________
;
;	WRITE TO IDE BUFFER
;________________________________________________________________________________________________________			
IDE_WRITE_BUFFER:
	PUSH	HL			;
	LD	HL,SECTOR_BUFFER	;
	LD	B,0			; 256 WORDS (512 BYTES PER SECTOR)
IDEBUFWT:				;
	INC	HL			;
	LD	A,(HL)			;
	DEC	HL			;
	OUT	(IDEHI),A		; SET UP HIGH LATCHED BYTE BEFORE
	LD	A,(HL)			;
	OUT	(IDELO),A		; WRITING WORD WITH WRITE TO LOW BYTE
	INC	HL			;
	INC	HL			;
	DEC	B			;
	JP	NZ,IDEBUFWT		;
	POP	HL			;
	RET		
	
;___IDE_SETUP_LDA________________________________________________________________________________________
;
;	SETUP IDE DRIVE FOR LDA OPERATION
;________________________________________________________________________________________________________			
IDE_SETUP_LBA:
	LD	A,(LBA_TARGET_LO) 	; LOAD LBA REGISTER 0 WITH SECTOR ADDRESS TO READ
	LD	(IDE_LBA0),A		;
	LD	A,(LBA_TARGET_LO+1)	; LOAD LBA REGISTER 1 WITH SECTOR ADDRESS TO READ
	LD	(IDE_LBA1),A		;
	LD	A,(LBA_TARGET_HI) 	; LOAD LBA REGISTER 2 WITH SECTOR ADDRESS TO READ
	LD	(IDE_LBA2),A		;
	LD	A,(LBA_TARGET_HI+1)	; LOAD LBA REGISTER 3 WITH SECTOR ADDRESS TO READ
	AND	000001111b		; ONLY LOWER FOUR BITS ARE VALID
	ADD	A,011100000b		; ENABLE LBA BITS 5:7=111 IN IDE_LBA3
	LD	(IDE_LBA3),A		;
					; READ IDE HD SECTOR
	LD	A,1			;
	OUT	(IDESECTC),A		; SET SECTOR COUNT = 1	
					;	
	LD	A,(IDE_LBA0)		;
	OUT	(IDESECTN),A		; SET LBA 0:7
					;
	LD	A,(IDE_LBA1)		;
	OUT	(IDECYLLO),A		; SET LBA 8:15
					;
	LD	A,(IDE_LBA2)		;
	OUT	(IDECYLHI),A		; SET LBA 16:23
					;
	LD	A,(IDE_LBA3)		;
	AND	000001111b		; LOWEST 4 BITS USED ONLY
	OR	011100000b		; TO ENABLE LBA MODE
	OUT	(IDEHEAD),A		; SET LBA 24:27 + BITS 5:7=111
	CALL	IDESEGDISPLAY		;
	RET	

;___ATAPI_SOFT_RESET_____________________________________________________________________________________
;
;	RESET ATAPI BUS
;________________________________________________________________________________________________________			
ATAPI_SOFT_RESET:
	LD	A,000001110b		;NO INTERRUPTS, RESET DRIVE = 1
	OUT	(IDECTRL),A		;
	CALL	DELAY24			;
	LD	A,000001010b		;NO INTERRUPTS, RESET DRIVE = 0
	OUT	(IDECTRL),A		;
	CALL	ATAPI_WAIT_BUSY_READY	;
	RET	NC			; ERROR, RETURN
	CALL	ATAPI_DEVICE_SELECTION	;
	CALL	DELAY24			;
	CALL 	REQUEST_SENSE_LOOP	;
	RET

;___REQUEST_SENSE_LOOP____________________________________________________________________________________
;
;	ATAPI_REQUEST SENSE DATA
;_________________________________________________________________________________________________________			
REQUEST_SENSE_LOOP:
	LD	HL,ATAPI_REQUEST_SENSE	;
	CALL	ATAPI_SEND_PACKET	;
	CALL	ATAPI_WAIT_BUSY_READY	; MAKE SURE DRIVE IS READY TO PROCEED
	RET	NC			; ERROR, RETURN
	LD	B,0			; 256 WORDS (512 BYTES PER SECTOR)
REQUEST_SENSE_LOOP1:			;
	IN	A,(IDELO)		;
	INC	IX			;
	IN	A,(IDEHI)		;
	INC	IX			;
	DJNZ	REQUEST_SENSE_LOOP1	;
	RRD				; DELAY ONLY
	IN	A,(IDESTTS)		;READ ERROR REG
	AND	000000001b		;MASK OFF BIT
	JR	NZ,REQUEST_SENSE_LOOP	;
	RET

;___ATAPI_DEVICE_SELECTION________________________________________________________________________________
;
;	ATAPI DEVICE SELECTION
;_________________________________________________________________________________________________________			
ATAPI_DEVICE_SELECTION:

	LD	A,(IDEDEVICE)		; SELECTS DEVICE
	OR	0A0H			;
	OUT	(IDEHEAD),A		;	
	RET				;



;__ATAPI_READ_SECTOR_____________________________________________________________________________________________________________ 
;  READ ATAPI SECTOR   
;
;   D E H L = SECTOR (DOUBLE WORD) TO READ 
;________________________________________________________________________________________________________________________________ 
ATAPI_READ_SECTOR:
	CALL	ISCUR			;
	JP	Z,ATAPI_READ_DATA_EXIT	;
	LD	A,(LBA_TARGET_LO)	; LOAD LBA REGISTER 0 WITH SECTOR ADDRESS TO READ
	LD	(READ_DISK_PACKET+5),A	;
	LD	A,(LBA_TARGET_LO+1)	; LOAD LBA REGISTER 1 WITH SECTOR ADDRESS TO READ
	LD	(READ_DISK_PACKET+4),A	;
	LD	A,(LBA_TARGET_HI)	; LOAD LBA REGISTER 2 WITH SECTOR ADDRESS TO READ
	LD	(READ_DISK_PACKET+3),A	;
	LD	A,(LBA_TARGET_HI+1)	; LOAD LBA REGISTER 3 WITH SECTOR ADDRESS TO READ
	LD	(READ_DISK_PACKET+2),A	;
	CALL	ATAPISEGDISPLAY		;
	CALL	REQUEST_SENSE_LOOP	; GET ATAPI SENSE CODES TO CLEAR ERRORS
	LD	HL,READ_DISK_PACKET	; SET POINTER TO READ SECTOR PACKET
	CALL	ATAPI_SEND_PACKET	; SEND PACKET COMMAND
	CALL	ATAPI_WAIT_BUSY_READY	; MAKE SURE DRIVE IS READY TO PROCEED
	RET	NC			; ERROR, RETURN
	LD	B,0			; 256 WORDS (512 BYTES PER SECTOR)
	LD	IX,SECTOR_BUFFER	;
	IN	A,(IDESTTS)		; READ  REG
	AND	000001000b		; MASK OFF BIT
	CP	08H			; IS DATA WAITING?
	JR	NZ,ATAPI_READ_DATA_EXIT	; NO, EXIT
ATAPI_READ_DATA_LOOP:
	IN	A,(IDELO)		;
	LD	(IX+0),A		;
	INC	IX			;
	IN	A,(IDEHI)		;
	LD	(IX+0),A		;
	INC	IX			;
	DJNZ	ATAPI_READ_DATA_LOOP	;
ATAPI_READ_DATA_EXIT:
	LD	HL,(PSECTOR)		; STORE PHYSICAL SECTOR IN BUFFER
	LD	(CUSECTOR),HL		; 
	LD	HL,(PTRACK)		; STORE PHYSICAL DISK TRACK IN BUFFER
	LD	(CUTRACK),HL		; 
	LD	A,(DISKNO)		; STORE CURRENT DRIVE IN BUFFER
	LD	(CUDISK),A		;
	SCF				; CARRY = 1 ON RETURN = OPERATION OK
	RET				;



;__ATAPI_WRITE_SECTOR_____________________________________________________________________________________________________________ 
;  WRITE ATAPI SECTOR   
;
;   D E H L = SECTOR (DOUBLE WORD) TO WRITE 
;________________________________________________________________________________________________________________________________ 
ATAPI_WRITE_SECTOR:

	LD	A,(LBA_TARGET_LO)	; LOAD LBA REGISTER 0 WITH SECTOR ADDRESS TO READ
	LD	(WRITE_DISK_PACKET+5),A	;
	LD	A,(LBA_TARGET_LO+1)	; LOAD LBA REGISTER 1 WITH SECTOR ADDRESS TO READ
	LD	(WRITE_DISK_PACKET+4),A	;
	LD	A,(LBA_TARGET_HI)	; LOAD LBA REGISTER 2 WITH SECTOR ADDRESS TO READ
	LD	(WRITE_DISK_PACKET+3),A	;
	LD	A,(LBA_TARGET_HI+1)	; LOAD LBA REGISTER 3 WITH SECTOR ADDRESS TO READ
	LD	(WRITE_DISK_PACKET+2),A	;
	CALL	ATAPISEGDISPLAY
	CALL 	REQUEST_SENSE_LOOP	;
	LD	HL,WRITE_DISK_PACKET	; SET POINTER TO WRITE PACKET COMMAND
	CALL	ATAPI_SEND_PACKET	; SEND THE PACKET COMMAND						
	CALL	ATAPI_WAIT_BUSY_READY	; MAKE SURE DRIVE IS READY TO PROCEED
	RET	NC			; ERROR, RETURN
	LD	B,0			; 256 WORDS (512 BYTES PER SECTOR)
	LD	IX,SECTOR_BUFFER	;
ATAPI_WRITE_DATA_LOOP:
	IN	A,(IDESTTS)		; READ  REG
	LD	A,(IX+0)		;
	PUSH    AF			;
	INC	IX			;
	LD	A,(IX+0)		;
	OUT	(IDEHI),A		;
	POP	AF			;
	OUT	(IDELO),A		;
	INC	IX			;
	DJNZ	ATAPI_WRITE_DATA_LOOP	;
	SCF				; CARRY = 1 ON RETURN = OPERATION OK
	RET				;




;__ATAPI_SEND_PACKET_____________________________________________________________________________________________________________ 
;  SEND PACKET POINTED TO BY HL TO ATAPI DRIVE   
;
;________________________________________________________________________________________________________________________________ 
ATAPI_SEND_PACKET:

	CALL	ATAPI_WAIT_BUSY_READY	; MAKE SURE DRIVE IS READY TO PROCEED
	RET	NC			; ERROR, RETURN
	CALL	IDE_WAIT_DRQ_ZERO	;
					;
	LD	A,0AH			;
	OUT	(IDECTRL),A		; DISABLE INT
	LD	A,00H			;
	OUT	(IDEERR),A		;
	LD	A,00H			;
	OUT	(IDESECTC),A		; 
	LD	A,00H			;
	OUT	(IDESECTN),A		;
	LD	A,00H			;
	OUT	(IDECYLLO),A		; 
	LD	A,60H			;
	OUT	(IDECYLHI),A		; 
	LD	A,(IDEDEVICE)		;
	OUT	(IDEHEAD),A		; BIT 4 SELECTS DEVICE
	LD	A,0A0H			;
	OUT	(IDESTTS),A		;
					;
	CALL	IDE_WAIT_DRQ_READY	; MAKE SURE DRIVE IS READY TO PROCEED
					;
	LD	B,6			; SEND 12 BYTES (6 WORDS)
					;
ATAPI_SEND_PACKET_LOOP:
	LD	A,(HL)			; GET BYTE
	LD	D,A			; STORE LOW BYTE IN D
	INC	HL			; INC POINTER
	LD	A,(HL)			; GET HIGH BYTE
	OUT	(IDEHI),A		; STORE HIGH BYTE
	LD	A,D			; MOVE LOW BYTE INTO A
	OUT	(IDELO),A		; STORE LOW BYTE
	INC	HL			; INC POINTER
	IN	A,(IDECTRL)		; GET STATUS
	DJNZ	ATAPI_SEND_PACKET_LOOP	; LOOP
					;
	CALL	ATAPI_WAIT_BUSY_READY	; MAKE SURE DRIVE IS READY TO PROCEED
	RET	NC			; ERROR, RETURN
	IN	A,(IDECTRL)		; READ STATUS (FOR DELAY)
					;
	RET				;
	
;__SETUPDRIVE__________________________________________________________________________________________________________________________ 
;
;	SETUP FLOPPY DRIVE SETTINGS 
;________________________________________________________________________________________________________________________________
;
;
;
SETUPDRIVE:
	LD	A,RESETL		; RESET SETTINGS
	OR	MINI			; SELECT MINI FLOPPY (LOW DENS=1, HIGH DENS=0)
	OR	PRECOMP			; SELECT PRECOMP 
	OR	FDDENSITY		; SELECT DENSITY
	OR	FDREADY			; SELECT READY SIGNAL
	LD	(FLATCH_STORE),A	; SAVE SETTINGS
	LD	A,01H			;
	LD	(UNIT),A		; SET UNIT 1
	LD	A,2			; DENSITY
	LD	(DENS),A		;
	LD	A,09			;
	LD	(EOTSEC),A		; LAST SECTOR OF TRACK			
	LD	A,7FH			;
	LD	(SRTHUT),A		; STEP RATE AND HEAD UNLOAD TIME
	LD	A,05H			;
	LD	(HLT),A			; HEAD LOAD TIME
	LD	A,0DH			;
	LD	(GAP),A			; GAP 
	LD	A,80H			;
	LD	(SECSIZ),A		; SECTOR SIZE /4
					;
	CALL	CHECKINT		; CHECK INTERRUPT STATUS, MAKE SURE IT IS CLEAR
	CALL	CHECKINT		; CHECK INTERRUPT STATUS, MAKE SURE IT IS CLEAR
	CALL	CHECKINT		; CHECK INTERRUPT STATUS, MAKE SURE IT IS CLEAR
	CALL	CHECKINT		; CHECK INTERRUPT STATUS, MAKE SURE IT IS CLEAR
	CALL	CHECKINT		; CHECK INTERRUPT STATUS, MAKE SURE IT IS CLEAR
	CALL	CHECKINT		; CHECK INTERRUPT STATUS, MAKE SURE IT IS CLEAR
					;					
	LD	HL,FLATCH_STORE		; POINT TO FLATCH
	RES	1,(HL)			; SET MOTOR ON
	CALL	OUTFLATCH		; OUTPUT TO CONTROLLER
	NOP				;
	NOP				;
	LD	A,00H			; ZERO TRACK
	LD	(PTRACK),A		; STORE TRACK
	CALL	SETTRACK		; DO IT	
	NOP				;
	NOP				;
	LD	HL,FLATCH_STORE		; POINT TO FLATCH
	SET	1,(HL)			; SET MOTOR OFF
	CALL	OUTFLATCH		; OUTPUT TO CONTROLLER
	RET
;
;__OUTFLATCH__________________________________________________________________________________________________________________________ 
;
;	SEND SETTINGS TO FLOPPY CONTROLLER
;________________________________________________________________________________________________________________________________
;
OUTFLATCH:
	LD	A,(FLATCH_STORE)	; SET A TO SETTINGS
	OUT	(FLATCH),A		; OUTPUT TO CONTROLLER
	RET

		
;__FLOPPYREAD__________________________________________________________________________________________________________________________ 
;
; 	READ A FLOPPY DISK SECTOR 	
;________________________________________________________________________________________________________________________________
;	
FLOPPYREAD:
	CALL	SEGDISPLAY		;
	LD	A,46H			; BIT 6 SETS MFM, 06H IS READ COMMAND
	LD	(CMD),A			;
	JP	DSKOP			;
;
;__FLOPPYWRITE__________________________________________________________________________________________________________________________ 
;
; 	WRITE A FLOPPY DISK SECTOR 	
;________________________________________________________________________________________________________________________________
;	
FLOPPYWRITE:
	CALL	SEGDISPLAY		;
	LD	A,45H			; BIT 6 SETS MFM, 05H IS WRITE COMMAND
	LD	(CMD),A			;
	JP	DSKOP			;
;
;__DSKOP__________________________________________________________________________________________________________________________ 
;
; 	PERFORM A DISK OPERATION 	
;________________________________________________________________________________________________________________________________
;		
DSKOP:
	LD	HL,FLATCH_STORE		; POINT TO FLATCH
	SET	1,(HL)			; SET MOTOR OFF
	CALL	OUTFLATCH		; OUTPUT TO CONTROLLER
					;
	CALL	CHECKINT		; CHECK INTERRUPT STATUS, MAKE SURE IT IS CLEAR
	CP	0FFH			; DID IT RETURN WITH ERROR CODE?
	JP	Z,DSKEXIT		; IF YES, EXIT WITH ERROR CODE
					;	
	LD	A,(UNIT)		; GET DISK UNIT NUMBER
	AND	03H			; MASK FOR FOUR DRIVES 
	LD	B,A			; PARK IT IN B
	LD	A,(HEAD)		; GET HEAD SELECTION
	AND	01H			; INSURE SINGLE BIT
	RLA				;
	RLA				; MOVE HEAD TO BIT 2 POSITION
	OR	B			; OR HEAD TO UNIT BYTE IN COMMAND BLOCK
	LD	(UNIT),A		; STORE IN UNIT
					;
	LD	HL,FLATCH_STORE		; POINT TO FLATCH
	RES	1,(HL)			; SET MOTOR ON
	CALL	OUTFLATCH		; OUTPUT TO CONTROLLER	
					;
	LD	A,03H			; SPECIFY COMMAND
	CALL	PFDATA			; PUSH IT
	LD	A,(SRTHUT)		; STEP RATE AND HEAD UNLOAD TIME
	CALL	PFDATA			; PUSH THAT
	LD	A,(HLT)			;
	CALL	PFDATA			; PUSH THAT
					;
	CALL	SETTRACK		; PERFORM SEEK TO TRACK
					;
	JP	NZ,DSKEXIT		; IF ERROR, EXIT
					;
	LD	A,(CMD)			; WHAT COMMAND IS PENDING?
	OR	A			; SET FLAGS
	JP	DOSO4			; NO, MUST BE READ OR WRITE COMMAND
DSKEXIT:	
	LD	HL,FLATCH_STORE		; POINT TO FLATCH
	SET	1,(HL)			; SET MOTOR OFF
	CALL	OUTFLATCH		; OUTPUT TO CONTROLLER
					;
	OR	0FFH			; SET -1 IF ERROR
	RET

RESULT:
	LD	C,07H			; LOAD C WITH NUMBER OF STATUS BYTES
	LD	HL,ST0			; POINT TO STATS STORAGE
RS3:
	CALL	GFDATA			; GET FIRST BYTE
	LD	(HL),A			; SAVE IT
	INC	HL			; POINTER++
	DEC	C			; CC-1
	JP	NZ,RS3			; LOOP TIL C0
	LD	A,(ST0)			; LOAD STS0
	AND	0F8H			; MASK OFF DRIVE #
	LD	B,A			; PARK IT
	LD	A,(ST1)			; LOAD STS1
	OR	B			; ACC OR B ->ACC IF 0 THEN SUCCESS
					;
RSTEXIT:
	CALL	CHECKINT		; CHECK INTERRUPT STATUS, MAKE SURE IT IS CLEAR
	LD	HL,FLATCH_STORE		; POINT TO FLATCH
	SET	1,(HL)			; SET MOTOR OFF
	CALL	OUTFLATCH		; OUTPUT TO CONTROLLER
					;
	CALL	SEGDISPLAY		;
	RET				; DONE RETURN TO CALLER 
	
	
DOSO4:
					;
	LD	HL,SECTOR_BUFFER	; GET BUFFER ADDRESS TO HL
	LD	A,(SECSIZ)		; XFERLEN
	LD	C,A			; C WILL BE THE NUMBER OF TRANSACTIONS
					; DIVIDED BY 4
					;
	LD	A,(CMD)			;
	CALL	PFDATA			; PUSH COMMAND TO I8272
	LD	A,(UNIT)		;
	CALL	PFDATA			; 
	LD	A,(PTRACK)		;
	CALL	PFDATA			; 
	LD	A,(HEAD)		;
	CALL	PFDATA			; 
	LD	A,(PSECTOR)		;
	INC	A			;
	CALL	PFDATA			; 
	LD	A,(DENS)		;
	CALL	PFDATA			; WHAT DENSITY
	LD	A,(EOTSEC)		;
	CALL	PFDATA			; ASSUME SC (SECTOR COUNT)  EOT
	LD	A,(GAP)			;
	CALL	PFDATA			; WHAT GAP IS NEEDED
	LD	A,(DTL)			; DTL, IS THE LAST COMMAND BYTE TO I8272
	CALL	PFDATAS
	LD	A,(CMD)			; READ IS 0 IS THIS A READ OR WRITE?
	AND	000000001b		; WRITE IS 1
	JP	NZ,WRR			; JMP WRITE IF 1
;

	;
; PERFORM READ
; LOOP EXECUTES 4X, THIS ALLOWS C RATHER THAN BC AS COUNTER
; SAVING A FEW TSTATES  MAKES UP TO 1024 BYTE SECTORS POSSIBLE.
; FROM READ TO READ MUST NOT EXCEED 25US WORST CASE MIN 
; (76T STATES FOR 3MHZ 8085) OR (100 T STATES FOR 4MHZ Z80)
;

RDD_POLL:
FDC_READP0:
	IN	A,(FMSR)		;
	OR	A			; TEST IF BYTE READY RQM1
	JP	P,FDC_READP0		;	
					;
	AND	20H			;
	JP	Z,DSKOPEND		;JUMP IF IN RESULTS MODE
					;
	IN	A,(FDATA)		;
	LD	(HL),A			;
	INC	HL			;

FDC_READP1:
	IN	A,(FMSR)		;
	OR	A			;
	JP	P,FDC_READP1		;
					;
	AND	20H			;
	JP	Z,DSKOPEND		;
					;
	IN	A,(FDATA)		;
	LD	(HL),A			;
	INC	HL			;
					;
FDC_READP2:
	IN	A,(FMSR)		;
	OR	A			;
	JP	P,FDC_READP2		;
					;
	AND	20H			;
	JP	Z,DSKOPEND		;
					;
	IN	A,(FDATA)		;
	LD	(HL),A			;
	INC	HL			;
					;
FDC_READP3:
	IN	A,(FMSR)		; 11
	OR	A			; 4
	JP	P,FDC_READP3		; 10
					;
	AND	20H			; 7
	JP	Z,DSKOPEND		; 10
					;
	IN	A,(FDATA)		; 11
	LD	(HL),A			; 10
	INC	HL			; 11
					;
	DEC	C			; 4
	JP	NZ,FDC_READP0		; 11

DSKOPEND:
	LD	HL,FLATCH_STORE		; POINT TO FLATCH
	SET	0,(HL)			; SET TC
	CALL	OUTFLATCH		; OUTPUT TO CONTROLLER
	NOP				;
	NOP				; 2 MICROSECOND DELAY
	RES	0,(HL)			; RESET TC
	CALL	OUTFLATCH		; OUTPUT TO CONTROLLER
	NOP				;
	NOP				; 2 MICROSECOND DELAY
	NOP				;
	NOP				; 2 MICROSECOND DELAY
	SET	1,(HL)			; TURN OFF MOTOR
	CALL	OUTFLATCH		; OUTPUT TO CONTROLLER
	JP	RESULT			; GET STATUS BYTES <RESULT PHASE>
WRR:
FDC_WRITEP0:
	IN	A,(FMSR)		;
	OR	A			; TEST IF BYTE READY RQM1
	JP	P,FDC_WRITEP0		;	
					;
	AND	20H			;
	JP	Z,DSKOPEND		;JUMP IF IN RESULTS MODE
					;
	LD	A,(HL)			;
	OUT	(FDATA),A		;	
	INC	HL			;

FDC_WRITEP1:
	IN	A,(FMSR)		;
	OR	A			;
	JP	P,FDC_WRITEP1		;
					;
	AND	20H			;
	JP	Z,DSKOPEND		;
					;
	LD	A,(HL)			;
	OUT	(FDATA),A		;	
	INC	HL			;
					;
FDC_WRITEP2:
	IN	A,(FMSR)		;
	OR	A			;
	JP	P,FDC_WRITEP2		;
					;
	AND	20H			;
	JP	Z,DSKOPEND		;
					;
	LD	A,(HL)			;
	OUT	(FDATA),A		;	
	INC	HL			;
					;
FDC_WRITEP3:
	IN	A,(FMSR)		; 11
	OR	A			; 4
	JP	P,FDC_WRITEP3		; 10
					;
	AND	20H			; 7
	JP	Z,DSKOPEND		; 10
					;
	LD	A,(HL)			;
	OUT	(FDATA),A		;	
	INC	HL			; 11
					;
	DEC	C			; 4
	JP	NZ,FDC_WRITEP0		; 11
	JP	DSKOPEND		; 10
	
		
;__SETTRACK__________________________________________________________________________________________________________________________ 
;
; 	SEEK TO A TRACK ON GIVEN UNIT
; 	A: TRACK #
;________________________________________________________________________________________________________________________________
;
SETTRACK:
	LD	A,(FTRACK)		; GET CURRENT HEAD TRACK
	LD	C,A
	LD	A,(PTRACK)		; GET TRACK
	OR	A			; SET FLAGS
	JP	Z,RECAL			; IF 0 PERFORM RECAL INSTEAD OF SEEK
	CP	C			;
	JP	Z,WAINT			; ALREADY THERE, ABORT
	LD	(FTRACK),A		; STORE TRACK
	LD	A,0FH			; SEEK COMMAND
	CALL	PFDATA			; PUSH COMMAND
	LD	A,(UNIT)		; SAY WHICH UNIT
	CALL	PFDATA			; SEND THAT
	LD	A,(PTRACK)		; TO WHAT TRACK
	CALL	PFDATA			; SEND THAT TOO
	JP	WAINT			; WAIT FOR INTERRUPT SAYING DONE
RECAL:
	LD	A,00H			;
	LD	(FTRACK),A		; STORE TRACK
	LD	A,07H			; RECAL TO TRACK 0
	CALL	PFDATA			; SEND IT
	LD	A,(UNIT)		; WHICH UNIT
	CALL	PFDATA			; SEND THAT TOO
;
WAINT:
;
	CALL	DELAYHSEC		; DELAY TO LET HEADS SETTLE BEFORE READ
					;
					; WAIT HERE FOR INTERRPT SAYING DONE
					; LOOP TIL INTERRUPT
	CALL	CHECKINT		; CHECK INTERRUPT STATUS
;
	RET
	
	
;__CYCLEFLOPPY__________________________________________________________________________________________________________________________ 
;
; 	SEEK TO TRACK 0, THEN BACK TO THE SELECTED TRACK    
;	THIS CAN BE USED ON AN ERROR CONDITION TO VERIFY THAT HEAD IS ON SELECTED TRACK
; 	
;________________________________________________________________________________________________________________________________
;
CYCLEFLOPPY:
	PUSH	AF			; STORE	AF
	PUSH	HL			; STORE	HL
	CALL	CHECKINT		; CHECK INTERRUPT STATUS, MAKE SURE IT IS CLEAR
	CALL	CHECKINT		; CHECK INTERRUPT STATUS, MAKE SURE IT IS CLEAR
	CALL	CHECKINT		; CHECK INTERRUPT STATUS, MAKE SURE IT IS CLEAR
	CALL	CHECKINT		; CHECK INTERRUPT STATUS, MAKE SURE IT IS CLEAR
	CALL	CHECKINT		; CHECK INTERRUPT STATUS, MAKE SURE IT IS CLEAR
	CALL	CHECKINT		; CHECK INTERRUPT STATUS, MAKE SURE IT IS CLEAR
	LD	HL,FLATCH_STORE		; POINT TO FLATCH
	RES	1,(HL)			; SET MOTOR ON
	CALL	OUTFLATCH		; OUTPUT TO CONTROLLER
	NOP				;
	NOP				;
	CALL	RECAL			;
	CALL	DELAYHSEC		;
	CALL	DELAYHSEC		;
	CALL	DELAYHSEC		;
	CALL	DELAYHSEC		;
	CALL	RECAL			;
	CALL	DELAYHSEC		;
	CALL	DELAYHSEC		;
	CALL	DELAYHSEC		;
	CALL	DELAYHSEC		;
	CALL	SETTRACK		;
	CALL	DELAYHSEC		;
	CALL	DELAYHSEC		;
	CALL	DELAYHSEC		;
	CALL	DELAYHSEC		;
	POP	HL			;
	POP	AF			; RESTORE AF
	RET	

;__PFDATAS__________________________________________________________________________________________________________________________ 
;
; WRITE A COMMAND OR PARAMETER S EQUENCE
;
; TRANSFERS ARE SYNCHONIZED BYT MSR D7 <RQM> AND D6 <DIO>
;	RQM  DIO
;	0	0	BUSY
;	1	0	WRITE TO DATA REGISTER PERMITTED
;	1	1	BYTE FOR READ BY HOST PENDING
;	0	1	BUSY
;
;________________________________________________________________________________________________________________________________
;
PFDATAS:
	PUSH	AF			; STORE AF
PFDS1:
	IN	A,(FMSR)		; READING OR WRITING IS KEYS TO D7 RQM
	AND	80H			; MASK OFF RQM BIT 
	JP	Z,PFDS1			; WAIT FOR RQM TO BE TRUE 
	IN	A,(FMSR)		; READ STATUS
	AND	40H			; WAITING FOR INPUT?
	CALL	NZ,ERRORT		; NO, SIGNAL ERROR
	POP	AF			; RESTORE AF
	OUT	(FDATA),A		; OUTPUT A TO CONTROLLER
	RET		
	
;__PFDATA__________________________________________________________________________________________________________________________ 
;
; WRITE A COMMAND OR PARAMETER S EQUENCE
;
; TRANSFERS ARE SYNCHONIZED BYT MSR D7 <RQM> AND D6 <DIO>
;	RQM  DIO
;	0	0	BUSY
;	1	0	WRITE TO DATA REGISTER PERMITTED
;	1	1	BYTE FOR READ BY HOST PENDING
;	0	1	BUSY
;
;________________________________________________________________________________________________________________________________
;
PFDATA:
	PUSH	AF			; STORE AF
PFD1:
	IN	A,(FMSR)		; READING OR WRITING IS KEYS TO D7 RQM
	AND	80H			; MASK OFF RQM BIT 
	JP	Z,PFD1			; WAIT FOR RQM TO BE TRUE 
	IN	A,(FMSR)		; READ STATUS
	AND	40H			; WAITING FOR INPUT?
	CALL	NZ,ERRORT		; NO, SIGNAL ERROR
	POP	AF			; RESTORE AF
	OUT	(FDATA),A		; OUTPUT A TO CONTROLLER
	JP	DELAY24			; DELAY 24US
	
	
	
;__DELAY24__________________________________________________________________________________________________________________________ 
;
; 	DELAY 24US
;________________________________________________________________________________________________________________________________
;
	
DELAY24:	
					; JP= 10T	
	PUSH	IX			; 15T
	POP	IX			; 14T
	PUSH	IX			; 15T
	POP	IX			; 14T
DELAY12:
	PUSH	IX			; 15T
	POP	IX			; 14T
	RET				; 10T


;__CHECKINT__________________________________________________________________________________________________________________________ 
;
; CHECK FOR ACTIVE FDC INTERRUPTS BEFORE GIVING I8272 COMMANDS
; POLL RQM FOR WHEN NOT BUSY AND THEN SEND FDC
; SENSE INTERRUPT COMMAND   IF IT RETURNS WITH NON ZERO
; ERROR CODE, PASS BACK TO CALLING ROUTINE FOR HANDLING
;________________________________________________________________________________________________________________________________
;
CHECKINT:
	IN	A,(FMSR)		; READING OR WRITING IS KEYS TO D7 RQM
	AND	80H			; MASK OFF RQM BIT
	JP	Z,CHECKINT		; WAIT FOR RQM TO BE TRUE  WAIT UNTIL DONE
	IN	A,(FMSR)		; READ STATUS
	AND	40H			; WAITING FOR INPUT?
	JP	NZ,CHECKINTDONE		; NO, SIGNAL ERROR
	CALL	SENDINT			; SENSE INTERRUPT COMMAND
CHECKINTDONE:
	RET				;
	

;__DELAYHSEC__________________________________________________________________________________________________________________________ 
;
; DELAY FOR 1/2 SECOND
;________________________________________________________________________________________________________________________________
;		
DELAYHSEC:
	LD	HL,00000H		; 65536
DELDM:
	NOP				; (4 T) 
	NOP				; (4 T)
	NOP				; (4 T)
	NOP				; (4 T)
	DEC	L			; (6 T)
	JP	NZ,DELDM		; (10 T) 24 T  8 MICROSECONDS AT 4 MHZ
	DEC	H			; (6 T)
	JP	NZ,DELDM		; (10 T) (8 US * 256) * 256  524288 US   5 SECONDS
	RET

;__ERRORT__________________________________________________________________________________________________________________________ 
;
; ERROR HANDLING
;________________________________________________________________________________________________________________________________
;			
ERRORT:
	IN	A,(FDATA)		; CLEAR THE JUNK OUT OF DATA REGISTER
	IN	A,(FMSR)		; CHECK WITH RQM
	AND	80H			; IF STILL NOT READY, READ OUT MORE JUNK
	JP	Z,ERRORT		;
	LD	A,0FFH			; RETURN ERROR CODE -1
					;
	RET
;__SENDINT__________________________________________________________________________________________________________________________ 
;
; SENSE INTERRUPT COMMAND
;________________________________________________________________________________________________________________________________
;			
SENDINT:
	LD	A,08H			; SENSE INTERRUPT COMMAND
	CALL	PFDATA			; SEND IT
	CALL	GFDATA			; GET RESULTS
	LD	(ST0A),A		; STORE THAT
	AND	0C0H			; MASK OFF INTERRUPT STATUS BITS
	CP	80H			; CHECK IF INVALID COMMAND
	JP	Z,ENDSENDINT		; YES, EXIT
	CALL	GFDATA			; GET ANOTHER (STATUS CODE 1)
	LD	(ST1A),A		; SAVE THAT
	LD	A,(ST0A)		; GET FIRST ONE
	AND	0C0H			; MASK OFF ALL BUT INTERRUPT CODE 00 IS NORMAL
ENDSENDINT:
	RET				;ANYTHING ELSE IS AN ERROR


;__GFDATA__________________________________________________________________________________________________________________________ 
;
; GET DATA FROM FLOPPY CONTROLLER
;
; TRANSFERS ARE SYNCHONIZED BYT MSR D7 <RQM> AND D6 <DIO>
;	RQM  DIO
;	0	0	BUSY
;	1	0	WRITE TO DATA REGISTER PERMITTED
;	1	1	BYTE FOR READ BY HOST PENDING
;	0	1	BUSY
;
;________________________________________________________________________________________________________________________________
;		
GFDATA:
	IN	A,(FMSR)		; READ STATUS BYTE
	AND	80H			; MASK OFF RQM
	JP	Z,GFDATA		; LOOP WHILE BUSY
	IN	A,(FMSR)		; READ STSTUS BUTE
	AND	40H			; MASK OFF DIO
	CALL	Z,ERRORT		; IF WRITE EXPECTED RUN ERRORRT
	IN	A,(FDATA)		; READ DATA
	JP	DELAY24			; DELAY 24US
	

; PIO 82C55 I/O IS DECODED TO PORT 60-67
;
PORTA		 EQU 	60H
PORTB		 EQU 	61H
PORTC		 EQU 	62H
PIOCONT 	 EQU 	63H	

;__IDESEGDISPLAY________________________________________________________________________________________
;
;  DISPLAY CONTENTS OF IDE LOGICAL BLOCK ADDRESS ON DSKY    
;____________________________________________________________________________________________________
IDESEGDISPLAY:
	LD	A, 82H			;
	OUT (PIOCONT),A			;
					;
	LD	A,(IDE_LBA3)		;
	AND	0FH			;
	LD	(DISPLAYBUF+6),A	;
	LD	A,(IDE_LBA3)		;
	AND	0F0H			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	LD	(DISPLAYBUF+7),A	;
					;
	LD	A,(IDE_LBA2)		;
	AND	0FH			;
	LD	(DISPLAYBUF+4),A	;
	LD	A,(IDE_LBA2)		;
	AND	0F0H			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	LD	(DISPLAYBUF+5),A	;
					;
	LD	A,(IDE_LBA1)		;
	AND	0FH			;
	LD	(DISPLAYBUF+2),A	;
	LD	A,(IDE_LBA1)		;
	AND	0F0H			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	LD	(DISPLAYBUF+3),A	;
	
	LD	A,(IDE_LBA0)		;
	AND	0FH			;
	LD	(DISPLAYBUF),A		;
	LD	A,(IDE_LBA0)		;
	AND	0F0H			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	LD	(DISPLAYBUF+1),A	;
	JP	SEGDISPLAY1		;
;__ATAPISEGDISPLAY________________________________________________________________________________________
;
;  DISPLAY CONTENTS OF ATAPI LOGICAL BLOCK ADDRESS ON DSKY    
;____________________________________________________________________________________________________
ATAPISEGDISPLAY:
	LD	A, 82H			;
	OUT (PIOCONT),A			;
					;
	LD	A,(LBA_TARGET_HI+1)	;
	AND	0FH			;
	LD	(DISPLAYBUF+6),A	;
	LD	A,(LBA_TARGET_HI+1)	;
	AND	0F0H			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	LD	(DISPLAYBUF+7),A	;
					;
	LD	A,(LBA_TARGET_HI)	;
	AND	0FH			;
	LD	(DISPLAYBUF+4),A	;
	LD	A,(LBA_TARGET_HI)	;
	AND	0F0H			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	LD	(DISPLAYBUF+5),A	;
					;
	LD	A,(LBA_TARGET_LO+1)	;
	AND	0FH			;
	LD	(DISPLAYBUF+2),A	;
	LD	A,(LBA_TARGET_LO+1)	;
	AND	0F0H			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	LD	(DISPLAYBUF+3),A	;
	
	LD	A,(LBA_TARGET_LO)	;
	AND	0FH			;
	LD	(DISPLAYBUF),A		;
	LD	A,(LBA_TARGET_LO)	;
	AND	0F0H			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	LD	(DISPLAYBUF+1),A	;
	JP	SEGDISPLAY1		;

;__SEGDISPLAY________________________________________________________________________________________
;
;  DISPLAY CONTENTS OF TRACK, SECTOR, ST0, ST1 ON DSKY
;     
;____________________________________________________________________________________________________
SEGDISPLAY:
	LD	A, 82H			;
	OUT (PIOCONT),A			;
	LD	A,(TRACK)		;
	AND	0FH			;
	LD	(DISPLAYBUF+6),A	;
	LD	A,(TRACK)		;
	AND	0F0H			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	LD	(DISPLAYBUF+7),A	;			
	LD	A,(SECTOR)		;
	AND	0FH			;
	LD	(DISPLAYBUF+4),A	;
	LD	A,(SECTOR)		;
	AND	0F0H			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	LD	(DISPLAYBUF+5),A	;
	LD	A,(ST0)			;
	AND	0FH			;
	LD	(DISPLAYBUF+2),A	;
	LD	A,(ST0)			;
	AND	0F0H			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	LD	(DISPLAYBUF+3),A	;			
	LD	A,(ST1)			;
	AND	0FH			;
	LD	(DISPLAYBUF),A		;
	LD	A,(ST1)			;
	AND	0F0H			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	LD	(DISPLAYBUF+1),A	;
SEGDISPLAY1:				;
	LD	HL,DISPLAYBUF		;
	LD	BC,0007H		;
	ADD	HL,BC			;
	LD	B,08H			; SET DIGIT COUNT
	LD	A,40H			; SET CONTROL PORT 7218 TO OFF
	OUT	(PORTC),A		; OUTPUT
	CALL 	DELAY12			; WAIT
	LD	A,0D0H			; SET CONTROL TO 1111 (DATA COMING, HEX DECODE, DECODE, NORMAL)
	OUT	(PORTA),A		; OUTPUT TO PORT
	LD	A,80H			; STROBE WRITE PULSE WITH CONTROL=1
	OUT	(PORTC),A		; OUTPUT TO PORT
	CALL 	DELAY12			; WAIT
	LD	A,40H			; SET CONTROL PORT 7218 TO OFF
	OUT	(PORTC),A		; OUTPUT
	CALL 	DELAY12			; WAIT
SEGDISPLAY_LP:		
	LD	A,(HL)			; GET DISPLAY DIGIT
	OUT	(PORTA),A		; OUT TO PORTA
	LD	A,00H			; SET WRITE STROBE
	OUT	(PORTC),A		; OUT TO PORTC
	CALL	DELAY12			; DELAY
	LD	A,40H			; SET CONTROL PORT OFF
	OUT	(PORTC),A		; OUT TO PORTC
	CALL	DELAY12			; WAIT
	DEC	HL			; INC POINTER
	DJNZ	SEGDISPLAY_LP		; LOOP FOR NEXT DIGIT
	RET	
	
DISPLAYBUF:	 DB 	01,02,03,04,05,06,07,08
		 DB	00,00,00,00,00,00,00,00	
		 DB	00,00,00,00,00,00,00,00	
		 DB	00,00,00,00,00,00,00,00	
		 DB	00,00,00,00,00,00,00,00	
FLOPPYSTACK:	 DB	00
PARKSTACK:	 DB	00,00,00,00
		
READ_DISK_PACKET
		 DB	0A8H,00,00,00,00,01H,00,00,00,01H,00,00
WRITE_DISK_PACKET
		 DB	2AH,00,00,00,00,11H,00,00,01H,00,00,00
ATAPI_REQUEST_SENSE
		 DB	03H,00,00,00,011H,00,00,00,00,00,00,00

		 ;	******* TEXT STRINGS *******

TXT_RO_ERROR:
	 DB CR,LF
	 DB "ERROR: WRITE TO READ ONLY DISK"
	 DB END


TXT_STARTUP_MSG:

	 IF 	CONDSHORTMSG

		 DB CR,LF
		 DB "CP/M-80 VERSION 2.2C FOR THE "
		 DB "N8VEM - W/ATAPI & FLOPPY"
		 DB CR,LF
		 DB END

	 ELSE

		 DB "CP/M V2.2C"
		 DB END

	 ENDIF


	 IF 	CONDTSR
		; ADD NOTHING
	 ELSE

		; TSR ENTRY POINTS HERE - PUT A CALL XX THEN RET AT 5 LOCATIONS
		; CAN ADD ANY CODE ABOVE 0F800h AS THIS IS NOT USED BY ANYTHING
		; EXTRA CODE ADDED BY SEPERATE PROGRAMS USUALLY RUN AT STARTUP
		; AND THESE PROGRAMS POKE A JUMP AT EACH OF THESE LOCATIONS
		; IF NOT RUN, THESE ROUTINES SIMPLY RETURN

		 ORG 0F2F0H		; ADD LCD OUTPUT ROUTINE HERE F900-FBFF
TSR1:		RET
		 ORG 0F2F3H		; ADD COUNTER HERE USES 64 BYTES F800 TO F83F
TSR2:		RET
		 ORG 0F2F6H		; ADD SCAN IBM KEYBOARD ROUTINE HERE FC00 TO FFFF
TSR3:		RET
		 ORG 0F2F9H		; ECHOOFF 16 BYTES F840 TO F84F
TSR4:		RET			
		 ORG 0F2FCH		; BLANK
TSR5:		RET



	 ENDIF

		 
;
;	THE REMAINDER OF THE CBIOS IS RESERVED UNINITIALIZED
;	DATA AREA, AND DOES NOT NEED TO BE A PART OF THE
;	SYSTEM MEMORY IMAGE (THE SPACE MUST BE AVAILABLE,
;	HOWEVER, BETWEEN "BEGDAT" AND "ENDDAT") 
;

;
; DISK COMMAND BLOCK
;
CMD:		 DB	0			; COMMAND READ OR WRITE,
UNIT:		 DB	0			; PHYSICAL DRIVE 0->3
HEAD:		 DB	0			; HEAD SEL 0 OR 1
DENS:		 DB	2			; DENSITY
EOTSEC:		 DB	09			; LAST SECTOR OF TRACK
GAP:		 DB	1BH			; VALUE FOR IRG <GAP3>
SECSIZ:		 DB	080H			; HOW MANY BYTES TO TRANSFER/4
DTL:		 DB	0FFH			; SIZE OF SECTOR
SRTHUT:		 DB	7FH			; STEP RATE AND HEAD UNLOAD TIME
HLT:		 DB	05H			; HEAD LOAD TIME
MIN:		 DB	MINI			; LATCH BIT PATTERN FOR FDC9229 MINITRUE
PRE:		 DB	PRECOMP			; LATCH BIT PATTERN FOR FDC9229 PRECOMP125NS
;
; FLOPPY STATUS RESULT STORAGE
;
ST0:		 DB	0			; STORE STATUS 0
ST1:		 DB	0			; ST1
ST2:		 DB	0			; ST2
SCYL:		 DB	0			; TRACK
SHEAD:		 DB	0			; HEAD 0 OR 1
SREC:		 DB	0			; SECTOR
SNBIT:		 DB	0			; DENSITY
ST0A:		 DB	0			; STORE STATUS 0
ST1A:		 DB	0			; ST1
RETRY		 DB	0			; RETRIES
RETRY1		 DB	0			; RETRIES

FLATCH_STORE:
		 DB	00


TRACK:		 DW 0				; TWO BYTES FOR TRACK # (LOGICAL)
PTRACK:		 DW 0				; TWO BYTES FOR TRACK # (PHYSICAL)
FTRACK:		 DW 0				; TWO BYTES FOR TRACK # (HEAD LOCATION)

PAGER:		 DB 1				; COPY OF PAGER BYTE
DB_PAGER:
		 DB 0FFH			; COPY OF PAGER BYTE (DEBUG)
SECTOR:		 DW 0				; TWO BYTES FOR SECTOR # (LOGICAL)
PSECTOR: 	 DW 0				; TWO BYTES FOR SECTOR # (PHYSICAL)
V_SECTOR: 	 EQU PSECTOR			; TWO BYTES FOR VIRTUAL SECTOR #
SECST:		 DW 0				; SECTOR IN ROM/RAM START ADDRESS
DMAAD:		 DW 0				; DIRECT MEMORY ADDRESS
DISKNO:		 DB 0				; DISK NUMBER 0-15
LBA_TARGET_LO:
		 DW 0				; IDE HD PARTITION TARGET SECTOR (LOW 16 BITS)
LBA_TARGET_HI:
		 DW 0				; IDE HD PARTITION TARGET SECTOR (HI 16 BITS, 12 USED)
IDEDEVICE:
		 DB 0				; ATAPI DEVICE SELECTION FLAG

IDE_LBA0:
		 DB 0				; SET LBA 0:7
IDE_LBA1:
		 DB 0				; SET LBA 8:15
IDE_LBA2:
		 DB 0				; SET LBA 16:23
IDE_LBA3:
		 DB 0				; LOWEST 4 BITS USED ONLY TO ENABLE LBA MODE 
SECTOR_INDEX:
		 DB 1				; WHERE 128 BYTE CP/M SECTOR IS IN 512 BYTE IDE HD SECTOR
;
;	SCRATCH RAM AREA FOR BDOS USE
BEGDAT:		 EQU $				; BEGINNING OF DATA AREA
DIRBF:		 DS 128				; SCRATCH DIRECTORY AREA
ALL00:		 DS 65				; ALLOCATION VECTOR 0  (DSM/8 = 1 BIT PER BLOCK)  44
ALL01:		 DS 33				; ALLOCATION VECTOR 1 (225/8)
ALL02:		 DS 256				; ALLOCATION VECTOR 2 (511/8)
ALL03:		 DS 256				; ALLOCATION VECTOR 3 (511/8)
ALL04:		 DS 65				; ALLOCATION VECTOR 4 (497/8)
ALL05:		 DS 65				; ALLOCATION VECTOR 4 (495/8)
ALL06:		 DS 65				; ALLOCATION VECTOR 4 (495/8)
CHK00:		 DS 5				; NOT USED FOR FIXED MEDIA
CHK01:		 DS 0				; NOT USED FOR FIXED MEDIA
CHK02:		 DS 0				; NOT USED FOR FIXED MEDIA
CHK03:		 DS 128				; NOT USED FOR FIXED MEDIA
CHK04:		 DS 0				; NOT USED FOR FIXED MEDIA
CHK05:		 DS 0				; NOT USED FOR FIXED MEDIA
CHK06:		 DS 0				; NOT USED FOR FIXED MEDIA
;
CUDISK:		 DS 1				; CURRENT PHYSICAL DISK ID IN BUFFER
CUSECTOR:					; CURRENT PHYSICAL DISK SECTOR IN BUFFER
		 DW 1	
CUTRACK:					; CURRENT PHYSICAL DISK TRACK IN BUFFER
		 DW 2
SECTOR_BUFFER:
		 DS 520				; STORAGE FOR 512 BYTE IDE HD SECTOR
TMPBUF:	 EQU SECTOR_BUFFER
ENDDAT:	 EQU $					; END OF DATA AREA
DATSIZ:	 EQU $-BEGDAT				; SIZE OF DATA AREA








	 ORG 0FDFFH
LASTBYTE:	 DB 00H

	 END
