	TITLE	'CHARACTER I/O HANDLER FOR CP/M 3.0'
	;Modified by Andrew Bingham, 1/12/16
	;Imported Console Status, Console Input, and Console Output routines for
	;S-100 SBC.  Routines by John M., translated from Z80 to 8080 mnemonics

	; DEFINE LOGICAL VALUES:
TRUE		EQU	-1
FALSE		EQU	NOT TRUE

	; DETERMINE IF FOR BANK SELECT OR NOT:
BANKED		EQU	FALSE	;<------------------- BANKED VERSION

	; DEFINE PUBLIC LABELS:
	PUBLIC	?CINIT,?CI,?CO,?CIST,?COST
	PUBLIC	@CTBL

	; DEFINE EXTERNAL LABELS AND ENTRY POINTS:
	IF	BANKED
	EXTRN	@CBNK
	EXTRN	?BNKSL
	ENDIF
	EXTRN	OUT$BLOCKS	;BLOCK OUTPUT ROUTINE TO I/O PORTS
	EXTRN	?PMSG



	; INCLUDE Z-80 MACROS:
	MACLIB	Z80

	; EQUATES FOR MODE BYTE BIT FIELDS

MB$INPUT	EQU 0000$0001B	; DEVICE MAY DO INPUT
MB$OUTPUT	EQU 0000$0010B	; DEVICE MAY DO OUTPUT
MB$IN$OUT	EQU MB$INPUT+MB$OUTPUT

MB$SOFT$BAUD	EQU 0000$0100B	; SOFTWARE SELECTABLE BAUD RATES

MB$SERIAL	EQU 0000$1000B	; DEVICE MAY USE PROTOCOL
MB$XON$XOFF	EQU 0001$0000B	; XON/XOFF PROTOCOL ENABLED

BAUD$NONE	EQU 0		; NO BAUD RATE ASSOCIATED WITH THIS DEVICE
BAUD$50		EQU 1		; 50 BAUD
BAUD$75		EQU 2		; 75 BAUD
BAUD$110	EQU 3		; 110 BAUD
BAUD$134	EQU 4		; 134.5 BAUD
BAUD$150	EQU 5		; 150 BAUD
BAUD$300	EQU 6		; 300 BAUD
BAUD$600	EQU 7		; 600 BAUD
BAUD$1200	EQU 8		; 1200 BAUD
BAUD$1800	EQU 9		; 1800 BAUD
BAUD$2400	EQU 10		; 2400 BAUD
BAUD$3600	EQU 11		; 3600 BAUD
BAUD$4800	EQU 12		; 4800 BAUD
BAUD$7200	EQU 13		; 7200 BAUD
BAUD$9600	EQU 14		; 9600 BAUD
BAUD$19200	EQU 15		; 19.2K BAUD


	; MISCELLANEOUS EQUATES:
; BIT MAP OF IOBYTE BASEPORT + 6H:- X X X X X X X X (if xx111100= CONFIG, will use onboard USB chip for Console I/O)
                                   ; | | | | | | | |.............. 1=CONSOLE IN DATA from Console IO board
                                   ; | | | | | | |................ 1=CONSOLE OUT DATA to Console IO board
                                   ; | | | | | |.................. 0=CONSOLE OUT DATA also to Printer (unused)
                                   ; | | | | |........Unused
                                   ; | | | |...........Unused
                                   ; | | |......................... 1= IOBYTE not active/implemented (output to Console IO Board)
                                   ; | |
                                   ; | |...............USB status, data available to recieve on this Computer
                                   ; |.................USB Status, data CAN be written to PC
                                   ;
                                   ;
								   
BASEPORT 	EQU 30H
IOBYTE 		EQU BASEPORT+6H ;See above
USBDATA 	EQU BASEPORT+4H ;PORT FOR DLP-USB Controller chip (Note different from chip on the S100 Serial I/O Board).
USBSTATUS 	EQU BASEPORT+6H ;Status port for USB port ( bits 6,7 of IOBYTE Port)
USBRXE 		EQU 80H 	;RXF#, If Bit 7 = 0, data available to recieve on this Computer
USBTXE 		EQU 40H 	;TXE# If Bit 6 = 0 data CAN be written to PC

;Will use these later in the console I/O routine
BELL 		EQU 07H
SPACE 		EQU 20H
TAB 		EQU 09H ;TAB ACROSS (8 SPACES FOR SD-BOARD)
CR 		EQU 0DH
LF 		EQU 0AH
BACKS 		EQU 08H

	; WILL START OFF IN COMMON MEMORY FOR BANKED OR NON-BANKED SYSTEMS:
	CSEG


	IF	BANKED
	; WE PROVIDE ALTERNATE DEFINITIONS OF THE ROUTINE ENTRY POINTS IF
	;  WE ARE RUNNING A BANKED SYSTEM VERSUS A NON-BANKED SYSTEM:

	;;;;; ?CINIT
	; ENTER HERE FOR BANKED SYSTEMS FOR DEVICE INITIALIZATIONS:
?CINIT:
	LXI	H,BCINIT	;POINT TO BANKED ROUTINE ADDRESS
	JR	BANKIO		;GO TO DISPATCHER

	;;;;; ?CI
	; ENTER HERE FOR BANKED SYSTEM DEVICE INPUT:
?CI:	LXI	H,BCI		;POINT TO BANKED ROUTINE ADDRESS
	JR	BANKIO		;GO TO DISPATCHER

	;;;;; ?CO
	; ENTER HERE FOR BANKED SYSTEM DEVICE OUTPUT:
?CO:	LXI	H,BCO		;POINT TO BANKED ROUTINE ADDRESS
	JR	BANKIO		;GO TO DISPATCHER

	;;;;; ?CIST
	; ENTER HERE FOR BANKED SYSTEM DEVICE INPUT STATUS:
?CIST:	LXI	H,BCIST		;POINT TO BANKED ROUTINE ADDRESS
	JR	BANKIO		;GO TO DISPATCHER

	;;;;; ?COST
	; ENTER HERE FOR BANKED SYSTEM DEVICE OUTPUT STATUS:
?COST:	LXI	H,BCOST		;POINT TO BANKED ROUTINE ADDRESS


	;;;;; BANKIO
	; ROUTINE DISPATCHES TO BANKED PORTION OF CHARACTER I/O ROUTINES:
BANKIO:
	SSPD	SPSAVE		;SAVE CURRENT STACK POINTER
	LXI	SP,IOSP		; AND USE LOCAL STACK FOR I/O
	LDA	@CBNK		;GET CURRENT BANK
	PUSH	PSW		;SAVE ON LOCAL STACK
	XRA	A		;WE WILL SELECT BANK 0 (OP SYS)
	CALL	?BNKSL
	LXI	D,BIORET	;RETURN ADDRESS IN [DE]
	PUSH	D		;PUT IT ON STACK FOR RETURN
	PCHL			;DISPATCH TO BANKED PART OF ROUTINE

	; ARRIVE HERE AFTER DEVICE HANDLER FINISHED:
BIORET:
	POP	D		;GET PREVIOUS CURRENT BANK TO [D]
	PUSH	PSW		;SAVE HANDLER RETURNED RESULT (IF ANY)
	MOV	A,D		;RESELECT PREVIOUS CURRENT BANK
	CALL	?BNKSL
	POP	PSW		;GET BACK RESULT CODE TO [A]
	LSPD	SPSAVE		;RESTORE PREVIOUS STACK
	RET			;AND RETURN...
	ENDIF


	;;;;;
	;;;;; ACTUAL DEVICE HANDLERS
	;;;;;


	;;;;; ?CINIT (BCINIT FOR BANKED)
	; PHYSICAL CODE FOR DEVICE INITIALIZATION:
	IF	BANKED
	DSEG			;CAN PUT IN BANKED SEGMENT IF BANKED
BCINIT:
	ELSE
?CINIT:
	ENDIF
	MOV	B,C		;ON ENTRY DEVICE # IS IN [C] BUT WE NEED
				; IT IN [B]
	;Breadcrumbs added 1/31/16 ATB
	;MVI	A, 041H		;ASCII 'A'
	;OUT	USBDATA		;Output to USB
	;End breadcrumb
	CALL	DEV$DISPATCH	;GO TO CORRECT INIT ROUTINE
	DW	CINIT0		;INIT FOR DEVICE 0
	DW	NULL$INIT	;INIT FOR DEVICE 1 (Set Device 1 to null ATB 1/22/16)
	DW	NULL$INIT	;INIT FOR DEVICE 2
	DW	NULL$INIT	;INIT FOR DEVICE 3
	DW	NULL$INIT	;INIT FOR DEVICE 4
	DW	NULL$INIT	;INIT FOR DEVICE 5
	DW	NULL$INIT	;INIT FOR DEVICE 6
	DW	NULL$INIT	;INIT FOR DEVICE 7
	DW	NULL$INIT	;INIT FOR DEVICE 8
	DW	NULL$INIT	;INIT FOR DEVICE 9
	DW	NULL$INIT	;INIT FOR DEVICE 10
	DW	NULL$INIT	;INIT FOR DEVICE 11
	DW	NULL$INIT	;INIT FOR DEVICE 12
	DW	NULL$INIT	;INIT FOR DEVICE 13
	DW	NULL$INIT	;INIT FOR DEVICE 14
	DW	NULL$INIT	;INIT FOR DEVICE 15


	;;;;; ?CI (BCI FOR BANKED)
	; PHYSICAL CODE FOR DEVICE INPUT:
	IF	BANKED
BCI:
	ELSE
?CI:
	ENDIF
	;Breadcrumbs added 1/31/16 ATB
	;MVI	A,042H		;ASCII 'B'
	;OUT	USBDATA		;Output to USB
	;End breadcrumb
	CALL	DEV$DISPATCH
	DW	CI0		;DEVICE 0 INPUT
	DW	NULL$CI		;DEVICE 1 INPUT (Set Device 1 to null ATB 1/22/16)
	DW	NULL$CI		;DEVICE 2 INPUT
	DW	NULL$CI		;DEVICE 3 INPUT
	DW	NULL$CI		;DEVICE 4 INPUT
	DW	NULL$CI		;DEVICE 5 INPUT
	DW	NULL$CI		;DEVICE 6 INPUT
	DW	NULL$CI		;DEVICE 7 INPUT
	DW	NULL$CI		;DEVICE 8 INPUT
	DW	NULL$CI		;DEVICE 9 INPUT
	DW	NULL$CI		;DEVICE 10 INPUT
	DW	NULL$CI		;DEVICE 11 INPUT
	DW	NULL$CI		;DEVICE 12 INPUT
	DW	NULL$CI		;DEVICE 13 INPUT
	DW	NULL$CI		;DEVICE 14 INPUT
	DW	NULL$CI		;DEVICE 15 INPUT


	;;;;; ?CO (BCO FOR BANKED)
	; PHYSICAL CODE FOR DEVICE OUTPUT:
	IF	BANKED
BCO:
	ELSE
?CO:
	ENDIF
	;Breadcrumbs added 1/31/16 ATB
	;MVI	A, 043H		;ASCII 'C'
	;OUT	USBDATA		;Output to USB
	;End breadcrumb
	CALL	DEV$DISPATCH	;GO TO CORRECT DEVICE OUTPUT HANDLER
	DW	CO0		;DEVICE 0 OUTPUT
	DW	NULL$CO		;DEVICE 1 OUTPUT (Set Device 1 to null ATB 1/22/16)
	DW	NULL$CO		;DEVICE 2 OUTPUT
	DW	NULL$CO		;DEVICE 3 OUTPUT
	DW	NULL$CO		;DEVICE 4 OUTPUT
	DW	NULL$CO		;DEVICE 5 OUTPUT
	DW	NULL$CO		;DEVICE 6 OUTPUT
	DW	NULL$CO		;DEVICE 7 OUTPUT
	DW	NULL$CO		;DEVICE 8 OUTPUT
	DW	NULL$CO		;DEVICE 9 OUTPUT
	DW	NULL$CO		;DEVICE 10 OUTPUT
	DW	NULL$CO		;DEVICE 11 OUTPUT
	DW	NULL$CO		;DEVICE 12 OUTPUT
	DW	NULL$CO		;DEVICE 13 OUTPUT
	DW	NULL$CO		;DEVICE 14 OUTPUT
	DW	NULL$CO		;DEVICE 15 OUTPUT


	;;;;; ?CIST (BCIST FOR BANKED)
	; PHYSICAL CODE FOR DEVICE INPUT STATUS:
	IF	BANKED
BCIST:
	ELSE
?CIST:
	ENDIF
	;Breadcrumbs added 1/31/16 ATB
	;MVI	A, 044H		;ASCII 'D'
	;OUT	USBDATA		;Output to USB
	;End breadcrumb
	CALL	DEV$DISPATCH
	DW	CIST0		;DEVICE 0 INPUT STATUS
	DW	NULL$CIST	;DEVICE 1 INPUT STATUS (Set Device 1 to null ATB 1/22/16)
	DW	NULL$CIST	;DEVICE 2 INPUT STATUS
	DW	NULL$CIST	;DEVICE 3 INPUT STATUS
	DW	NULL$CIST	;DEVICE 4 INPUT STATUS
	DW	NULL$CIST	;DEVICE 5 INPUT STATUS
	DW	NULL$CIST	;DEVICE 6 INPUT STATUS
	DW	NULL$CIST	;DEVICE 7 INPUT STATUS
	DW	NULL$CIST	;DEVICE 8 INPUT STATUS
	DW	NULL$CIST	;DEVICE 9 INPUT STATUS
	DW	NULL$CIST	;DEVICE 10 INPUT STATUS
	DW	NULL$CIST	;DEVICE 11 INPUT STATUS
	DW	NULL$CIST	;DEVICE 12 INPUT STATUS
	DW	NULL$CIST	;DEVICE 13 INPUT STATUS
	DW	NULL$CIST	;DEVICE 14 INPUT STATUS
	DW	NULL$CIST	;DEVICE 15 INPUT STATUS


	;;;;; ?COST (BCOST FOR BANKED)
	; PHYSICAL CODE FOR DEVICE OUTPUT STATUS:
	IF	BANKED
BCOST:
	ELSE
?COST:
	ENDIF
	;Breadcrumbs added 1/31/16 ATB
	;MVI	A, 045H		;ASCII 'E'
	;OUT	USBDATA		;Output to USB
	;End breadcrumb
	CALL	DEV$DISPATCH	;GO TO CONSOLE OUTPUT STATUS HANDLER
	DW	COST0		;DEVICE 0 OUTPUT STATUS
	DW	NULL$COST	;DEVICE 1 OUTPUT STATUS (Set Device 1 to null ATB 1/22/16)
	DW	NULL$COST	;DEVICE 2 OUTPUT STATUS
	DW	NULL$COST	;DEVICE 3 OUTPUT STATUS
	DW	NULL$COST	;DEVICE 4 OUTPUT STATUS
	DW	NULL$COST	;DEVICE 5 OUTPUT STATUS
	DW	NULL$COST	;DEVICE 6 OUTPUT STATUS
	DW	NULL$COST	;DEVICE 7 OUTPUT STATUS
	DW	NULL$COST	;DEVICE 8 OUTPUT STATUS
	DW	NULL$COST	;DEVICE 9 OUTPUT STATUS
	DW	NULL$COST	;DEVICE 10 OUTPUT STATUS
	DW	NULL$COST	;DEVICE 11 OUTPUT STATUS
	DW	NULL$COST	;DEVICE 12 OUTPUT STATUS
	DW	NULL$COST	;DEVICE 13 OUTPUT STATUS
	DW	NULL$COST	;DEVICE 14 OUTPUT STATUS
	DW	NULL$COST	;DEVICE 15 OUTPUT STATUS


	;;;;; DEV$DISPATCH
	; ROUTINE JUMPS TO CORRECT DEVICE HANDLER:
DEV$DISPATCH:	
	MOV	A,B		;GET DEVICE # TO [A]
	STA	DEV$CODE	;SAVE FOR LATER USE
	;>>>Added code to send Device Codes to USB port ATB 1/30/16
	;ADI	030H		;Add 030H to device # in A to convert to an ASCII # (0 binary -> 0 ASCII, etc)
	;OUT 	USBDATA		;Send device # (ASCII) to USB, assume FIFO on USN chip takes care of any buffering
	;LDA	DEV$CODE	;Load raw device code (binary) back into A, continue with previous code
	;>>>End added code
	ADD	A		;X2 FOR WORD OFFSET
	POP	H		;RETURN ADDRESS IS 1ST PARAMETER ADDRESS
	MOV	E,A		;SET UP OFFSET IN [DE]
	MVI	D,0
	DAD	D		;[HL] = PTR TO HANDLER ADDRESS
	MOV	E,M		;GET HANDLER ADDRESS TO [DE]
	INX	H
	MOV	D,M
	XCHG			;PUT IN [HL]
	PCHL			;AND DISPATCH TO IT...


	;;;;;
	;;;;; PHYSICAL DEVICE HANDLER CODE:
	;;;;;

	;;;;; DEVICE 0 HANDLERS (PARALLEL->USB INTERFACE ON S-100 SBC)
	;<<<<<<<<<<<<<<<<<<< DEVICE 0 INIT ROUTINE >>>>>>>>>>>>>>>>>>>>>>
CINIT0:	; DEVICE 0 INITIALIZATION
	;NO INIT NEEDED ATB 1/22/16
	RET
	
	;<<<<<<<<<<<<<<<<<<<< DEVICE 0 INPUT ROUTINE >>>>>>>>>>>>>>>>>>>>
CI0:
	IN USBSTATUS ;Is there a character to receive from the PC via the USB Port
	ANI USBRXE
	JNZ CI0 ;HIGH No Character yet
	IN USBDATA
	ANI 7FH				
	RET

	;<<<<<<<<<<<<<<<<<<<< DEVICE 0 OUTPUT ROUTINE >>>>>>>>>>>>>>>>>>>>
CO0:
	IN USBSTATUS ;Input must be from USB port on this SBC
	ANI USBTXE
	JNZ CO0 ;HIGH, Output FIFO not ready yet to send character
	MOV A,C ;LOW, OK to send
	CPI BELL ;IS IT A BELL
	RZ;Do not send BELL to to TELNET Window (at least for now)!
	CPI CR ;Send CR
	JZ CO2
	CPI LF ;Send LF
	JZ CO2
	CPI TAB ;Send TAB
	JZ CO2
	CPI BACKS ;Send backspace
	JZ CO2
	CPI SPACE
	RC ;If less than ASCII space then ignore
CO2: 
	OUT USBDATA
	RET
		
	;<<<<<<<<<<<<<<<<<<<< DEVICE 0 INPUT STATUS ROUTINE >>>>>>>>>>>>>>>>>>>>
CIST0:				; DEVICE 0 INPUT STATUS:
	IN USBSTATUS
	ANI USBRXE
	JZ CIST0OK		;BIT 7 0 => bytes waiting to receive 
	XRA A
	RET			;RETURN WITH 00H IN [A] and ZERO FLAT SET IF NO BYTES WAITING
CIST0OK:
	XRA A
	DCR A			;RETURN WITH 0FFH IN [A] and NO ZERO FLAG IF BYTES WAITING
	RET

	;<<<<<<<<<<<<<<<<<<<<<< DEVICE 0 OUTPUT STATUS ROUTINE >>>>>>>>>>>>>>>>>>>>>>>>>
COST0:	; DEVICE 0 OUTPUT STATUS:
	IN USBSTATUS
	ANI USBTXE		
	JZ	COST0OK		;BIT 6 0 => OK to transmit
	XRA	A
	RET			;RETURN WITH 00H in [A] and ZERO FLAG SET IF NOT OK TO TRANSMIT
COST0OK:
	XRA A
	DCR A			;RETURN WITH 0FFH IN [A] and NO ZERO FLAG IF OK TO TRANSMIT
	RET
	
	
	;;;;; NULL ROUTINES:
NULL$CIST:
NULL$COST:
	XRA	A		;RETURN A FALSE STATUS RESULT
	JR	NULL$RET
NULL$CI:
	MVI	A,1AH		;FOR INPUT RETURN A CNTL-Z (EOF)
NULL$INIT:
NULL$CO:
NULL$RET:
	RET			;HARMLESS RETURN


	; STORAGE FOR DEVICE CODE -- CAN RESIDE IN SAME SEGMENT AS THE BULK
	;  OF CHARACTER I/O ROUTINES:
DEV$CODE:	DS	1

	;;;;; CHRTBL
	; CHARACTER DEVICE TABLE
	CSEG			;MUST RESIDE IN COMMON MEMORY
@CTBL:
	DB	'USB   '		;CONSOLE (DEVICE 0)
	DB	MB$IN$OUT
	DB	BAUD$NONE

	MAX$DEVICES	EQU	($-@CTBL)/8	;# DEVICES IN TABLE
	DB	0			;TABLE TERMINATOR


	; OTHER DATA AREAS:
	DS	24		;CHARACTER I/O LOCAL STACK
IOSP	EQU	$
SPSAVE	DS	2

	END
