
	TITLE	'BOOT LOADER MODULE FOR CP/M 3.0'

	; DEFINE LOGICAL VALUES:
TRUE		EQU	-1
FALSE		EQU	NOT TRUE

	; DETERMINE IF FOR BANK SELECT OR NOT:
BANKED		EQU	FALSE	;<--------------- BANKED VERSION

	; DEFINE PUBLIC LABELS:
	PUBLIC	?INIT,?LDCCP,?RLCCP,?TIME
	PUBLIC	OUT$BLOCKS

	; EXTERNALLY DEFINED ENTRY POINTS AND LABELS:
	EXTRN	?PMSG,?CONIN
	EXTRN	@CIVEC,@COVEC,@AIVEC,@AOVEC,@LOVEC
	EXTRN 	@CBNK,?BNKSL

	IF	BANKED
	EXTRN	BANKBUF		;128 BYTE BUFFER IN MOVE MODULE FOR USE
				; DURING COLD AND WARM BOOTS
	ENDIF

	EXTRN	@SEC,@MIN,@HOUR,@DATE	;FIELDS HOLDING CURRENT TIME AND DATE


	; INCLUDE Z-80 MACROS:
	MACLIB	Z80


	; SOME MISCELLANEOUS EQUATES:
BDOS		EQU	5
CR		EQU	13	;ASCII CARRIAGE RETURN
LF		EQU	10	;ASCII LINEFEED
;
;
	; WE CAN DO INITIALIZATION FROM BANKED MEMORY (IF WE HAVE IT):
	IF	BANKED
	DSEG	; INIT DONE FROM BANKED MEMORY
	ELSE
	CSEG	; INIT TO BE DONE FROM COMMON MEMORY
	ENDIF


	;;;;; ?INIT
	; HARDWARE INITIALIZATION OTHER THAN CHARACTER AND DISK I/O:
?INIT:
	; ASSIGN CONSOLE INPUT AND OUTPUT TO CRT:
	LXI	H,8000H		;SIGNIFIES DEVICE 0
	SHLD	@CIVEC		;CONSOLE INPUT VECTOR
	SHLD	@COVEC		;CONSOLE OUTPUT VECTOR

	; ASSIGN PRINTER TO LPT:
	LXI	H,4000H		;SIGNIFIES DEVICE 1
	SHLD	@LOVEC		;LIST OUTPUT VECTOR

	; ASSIGN AUX TO CRT1:
	LXI	H,02000H	;SIGNIFIES DEVICE 2
	SHLD	@AIVEC		;AUXILLIARY INPUT VECTOR
	SHLD	@AOVEC		;AUXILLIARY OUTPUT VECTOR

	; PRINT THE SIGN-ON MESSAGE:
	LXI	H,SIGNON$MSG	;POINT TO IT
	JMP	?PMSG		;AND PRINT IT
;
;
	;;;;; OUT$BLOCKS
	; ROUTINE OUTPUTS SPECIFIED # BYTES TO SPECIFIED OUTPUT PORTS:
	IF	BANKED
	CSEG			;WE WANT THIS ROUTINE IN COMMON MEMORY
	ENDIF
OUT$BLOCKS:
	MOV	A,M		;GET A BYTE FROM THE BLOCK
	ORA	A		;END OF OUTPUT BLOCK ?
	RZ			;THEN DONE!!
	MOV	B,A		;ELSE PUT # BYTES TO SEND OUT IN [B]
	INX	H		;POINT TO PORT TO SEND TO
	MOV	C,M		;GET IT TO [C]
	INX	H		;POINT TO 1ST BYTE OF BLOCK TO SEND OUT
	OUTIR			;Z-80 BLOCK OUTPUT
	JR	OUT$BLOCKS


	;;;;; ?LDCCP
	; THIS ROUTINE IS ENTERED TO LOAD THE CCP.COM FILE INTO THE TPA BANK
	;  AT SYSTEM COLD START:
?LDCCP:
	; SET UP THE FCB FOR THE FILE OPERATION:
	XRA	A		;ZERO EXTENT
	STA	CCP$FCB+15
	LXI	H,0		;START AT BEGINNING OF FILE
	SHLD	FCB$NR

	; TRY TO OPEN THE CCP.COM FILE:
	LXI	D,CCP$FCB	;POINT TO FCB
	CALL	OPEN		;ATTEMPT THE OPEN OPERATION
	INR	A		;WAS IT ON THE DISK ?
	JRNZ	CCP$FOUND	;YES -- GO LOAD IT

	; WE ARRIVE HERE WHEN CCP.COM FILE WASN'T FOUND:
	LXI	H,CCP$MSG	;REPORT THE ERROR
	CALL	?PMSG
	CALL	?CONIN		;GET A RESPONSE
	JR	?LDCCP		;AND TRY AGAIN

	; FILE WAS OPENED OK -- READ IT IN:
CCP$FOUND:
	LXI	D,0100H		;LOAD AT BOTTOM OF TPA
	CALL	SETDMA		;BY SETTING THE NEXT DMA ADDRESS
	LXI	D,128		;SET MULTI SECTOR I/O COUNT
	CALL	SETMULTI	; TO ALLOW UP TO 16K BYTES IN ONE OPERATION
	LXI	D,CCP$FCB	;POINT TO THE FCB
	CALL	READ		;AND READ THE CCP IN

	; FOLLOWING CODE FOR BANKED SYSTEMS -- MOVES CCP IMAGE TO BANK 2
	;  FOR LATER RELOADING AT WARM STARTS:
	IF	BANKED
	LXI	H,0100H		;GET CCP IMAGE FROM START OF TPA
	MVI	B,25		;TRANSFER 25 LOGICAL SECTORS
	LDA	@CBNK		;GET CURRENT BANK
	PUSH	PSW		;AND SAVE IT
LD$1:
	PUSH	B		;SAVE SECTOR COUNT
	MVI	A,1		;SELECT TPA BANK
	CALL	?BNKSL
	LXI	B,128		;TRANSFER 128 BYTES TO TEMPORARY BUFFER
	LXI	D,BANKBUF	;TEMPORARY BUFFER ADDR IN [DE]
	PUSH	H		;SAVE SOURCE ADDRESS
	PUSH	D		;AND DESTINATION
	PUSH	B		;AND COUNT
	LDIR			;BLOCK MOVE SECTOR TO TEMPORARY BUFFER
	MVI	A,2		;SELECT BANK TO SAVE CCP IN
	CALL	?BNKSL
	POP	B		;GET BACK COUNT
	POP	H		;LAST DESTINATION WILL BE NEW SOURCE ADDR
	POP	D		;LAST SOURCE WILL BE NEW DESTINATION
	LDIR			;BLOCK MOVE SECTOR FROM BUFFER TO ALTERNATE
				; BANK
	XCHG			;NEXT ADDR WILL BE NEW SOURCE ADDR
	POP	B		;GET BACK SECTOR COUNT
	DJNZ	LD$1		;DROP SECTOR COUNT AND LOOP TILL DONE...
	POP	PSW		;WHEN DONE -- RESTORE ORIGINAL BANK
	JMP	?BNKSL
	ELSE

	; IF NON-BANKED WE RETURN THROUGH HERE:
	RET
	ENDIF


	;;;;; ?RLCCP
	; ROUTINE RELOADS CCP IMAGE FROM BANK 2 IF BANKED SYSTEM OR FROM THE
	;  DISK IF NON-BANKED VERSION:
?RLCCP:
	IF	BANKED
	; FOLLOWING CODE FOR BANKED VERSION:
	LXI	H,0100H		;GET CCP IMAGE FROM START OF ALTERNATE BUFFER
	MVI	B,25		;TRANSFER 25 LOGICAL SECTORS
	LDA	@CBNK		;GET CURRENT BANK
	PUSH	PSW		;AND SAVE IT
RL$1:
	PUSH	B		;SAVE SECTOR COUNT
	MVI	A,2		;SELECT ALTERNATE BANK
	CALL	?BNKSL
	LXI	B,128		;TRANSFER 128 BYTES TO TEMPORARY BUFFER
	LXI	D,BANKBUF	;TEMPORARY BUFFER ADDR IN [DE]
	PUSH	H		;SAVE SOURCE ADDRESS
	PUSH	D		;AND DESTINATION
	PUSH	B		;AND COUNT
	LDIR			;BLOCK MOVE SECTOR TO TEMPORARY BUFFER
	MVI	A,1		;PUT CCP TO TPA BANK
	CALL	?BNKSL
	POP	B		;GET BACK COUNT
	POP	H		;LAST DESTINATION WILL BE NEW SOURCE ADDR
	POP	D		;LAST SOURCE WILL BE NEW DESTINATION
	LDIR			;BLOCK MOVE SECTOR FROM BUFFER TO TPA BANK
	XCHG			;NEXT ADDR WILL BE NEW SOURCE ADDR
	POP	B		;GET BACK SECTOR COUNT
	DJNZ	RL$1		;DROP SECTOR COUNT AND LOOP TILL DONE...
	POP	PSW		;GET BACK LAST CURRENT BANK #
	JMP	?BNKSL		;SELECT IT AND RETURN
	ELSE

	; FOLLOWING CODE IS FOR NON-BANKED VERSIONS:
	JMP	?LDCCP		;JUST DO LOAD AS THOUGH COLD BOOT
	ENDIF


	;;;;; ?TIME
	; ROUTINE SETS/GETS TIME:
?TIME:	
	RET			;Just return in this simple version
;
;
;
	IF	BANKED
	CSEG
	ENDIF

	;;;;;
	; CP/M BDOS FUNCTION INTERFACES

	; OPEN FILE:
OPEN:
	MVI C,15 ! JMP BDOS		; OPEN FILE CONTROL BLOCK

	; SET DMA ADDRESS:
SETDMA:
	MVI C,26 ! JMP BDOS		; SET DATA TRANSFER ADDRESS

	; SET MULTI SECTOR I/O COUNT:
SETMULTI:
	MVI C,44 ! JMP BDOS		; SET RECORD COUNT

	; READ FILE RECORD:
READ:
	MVI C,20 ! JMP BDOS		; READ RECORDS

	; CCP NOT FOUND ERROR MESSAGE:
CCP$MSG:
	DB	CR,LF,'BIOS ERR ON A: NO CCP.COM FILE',0


	; FCB FOR CCP.COM FILE LOADING:
CCP$FCB:
	DB	1		;AUTO-SELECT DRIVE A
	DB	'CCP     COM'	;FILE NAME AND TYPE
	DB	0,0,0,0
	DS	16
FCB$NR:	DB	0,0,0


	; SYSTEM SIGN-ON MESSAGE:
SIGNON$MSG:
	DB	CR,LF,LF,'ZSOS v0.10 - a distribution of CP/M 3.0 (NON-BANKED)'
	DB	CR,LF,'Image by Andrew Bingham, 02-FEB-2016'
	DB	CR,LF,'Original BIOS code by John Monahan 03/16/2011'
	DB	CR,LF,'No-holes IDE/CF LBA address routines by David Fry'
	DB	CR,LF,'A:=IDE Hard Disk/CF Card. (No Floppy Disks!) '
	DB	CR,LF,0
	END
