*__BOOTGEN__________________________________________________________________________________________
*
*
*  BOOTGEN
*     WRITE THE OS OUT TO THE BOOT TRACKS OF A DRIVE 
*____________________________________________________________________________________________________
; constants

OSRAM	EQU	$0000
OSEND	EQU	$C2FF
OSUTIL	EQU	$B700


DRIVE	EQU	0		DRIVE ID (ADDRESS)
NCYL	EQU	1		NUMBER OF CYLINDERS
NHEAD	EQU	2		NUMBER OF HEADS
NSEC	EQU	3		NUMBER OF SECTORS/TRACK
CYL	EQU	4		CURRENT CYLINDER
HEAD	EQU	5		CURRENT HEAD
SEC	EQU	6		CURRENT SECTOR

	ORG	$0000

TYPE	CMPA	#'?'		QUERY?
	BNE	QUAL		SHOW HOW IT'S DONE
	SWI
	FCB	25		DISPLAY MESSAGE
	FCC	'Use: BOOTGEN <device>'
	FCB	00
	RTS
* PARSE FOR COMMAND QUALIFIERS
QUAL	LDA	,Y		GET CHAR FROM COMMAND LINE
	SUBA	#65
	CMPA	#04		IS IT IN RANGE
	BHS	QERR		IF SO, IT'S INVALID
	BRA	BEGIN
QERR	SWI
	FCB	24		DISPLAY MESSAGE
	FCC	'Invalid Drive'	
	FCB	00
	SWI
	FCB	22
	LDA	,Y+		GET CHARACTER
	JMP	DONE

BEGIN:		
	SWI
	FCB	25			; OUTPUT MESSAGE
	FCC	'STORING CUBIX OS'
	FCB	$00			; Line terminator
	SWI
	FCB	89
	LDAA	NCYL,U	
	DECA
	DECA
	STAA	CYL,U
	CLRA
	STAA	HEAD,U
	STAA	SEC,U
	LDX	#$C700
WRITELOOP:
	PSHS	X
	SWI
	FCB	98
	PULS	D
	ADDD	#$0200
	PSHS	D
	PULS	X
	CPX	#$F000
	BHS	DONE
	LDAA	SEC,U
	INCA
	STAA	SEC,U
	CMPA	NSEC,U
	BNE	WRITELOOP
	CLRA
	STAA	SEC,U
	LDAA	HEAD,U
	INCA
	STAA	HEAD,U
	CMPA	NHEAD,U	
	BNE	WRITELOOP
	CLRA
	STAA	SEC,U
	STAA	HEAD,U
	LDAA	CYL,U
	INCA
	STAA	CYL,U
	CMPA	NCYL,U	
	BNE	WRITELOOP	
	
DONE:
	CLRA
	SWI
	FCB	0

	RTS	

