;__FDCMON09______________________________________________________________________________________________________________________ 
;
;	FLOPPY DISK UTILITY PROGRAM 6809 
;	AUTHOR:  DAN WERNER
;	BASED ON WORKS BY: ANDREW LYNCH	
;________________________________________________________________________________________________________________________________
;

; DATA CONSTANTS
;________________________________________________________________________________________________________________________________ 

OSRAM	EQU	$0000
OSEND	EQU	$C2FF
OSUTIL	EQU	$B700



;REGISTER		IO PORT		; FUNCTION
FMSR		EQU	$F136		; ADDRESS OF MAIN STATUS REGISTER
FDATA		EQU	$F137		; FLOPPY DATA REGISTER
FLATCH		EQU	$F13A		; FLOPPY CONFIGURATION LATCH
FDMA		EQU	$F13C		; PSEUDO DMA ADDRESS
;
; FDC CONFIGURATION LATCH OUTPUT BIT PATTERNS
MOTOR		EQU	%00000000	; BIT PATTERN IN LATCH FOR MOTOR CONTROL (ON)
TERMCN		EQU	%00000001	; BIT PATTERN IN LATCH TO WRITE A TC STROBE
RESETL		EQU	%00000010	; BIT PATTERN IN LATCH TO RESET ALL BITS
MINI		EQU	%00000100	; BIT PATTERN IN LATCH TO SET MINI MODE FDC9229 LOW DENS=1, HIGH DENS=0
PRECOMP		EQU	%00100000	; BIT PATTERN IN LATCH TO SET WRITE PRECOMP 125 NS:
FDDENSITY	EQU	%01000000	; BIT PATTERN IN LATCH TO FLOPPY LOW DENSITY (HIGH IS 0)
FDREADY		EQU	%10000000	; BIT PATTERN IN LATCH TO FLOPPY READY (P-34):
;
;________________________________________________________________________________________________________________________________ 
; MAIN PROGRAM BEGINS HERE
;________________________________________________________________________________________________________________________________ 
		ORG	$0000
;
	JSR	SETUPDRIVE		; SETUP DRIVE PARAMETERS
	JSR	OUTFLATCH		; OUTPUT TO CONTROLLER
	JMP	MAIN_LOOP		;
	
MAIN_LOOP:


	SWI
	FCB	25			; OUTPUT MESSAGE
	FCB	$0A,$0D
	FCC	"FLOPPY TEST PROGRAM   "
	FCB	$0A,$0D
	FCC	"1->START MOTOR"
	FCB	$0A,$0D
	FCC	"2->STOP MOTOR"
	FCB	$0A,$0D
	FCC	"3->SELECT TRACK"
	FCB	$0A,$0D
	FCC	"4->FORMAT TRACK"
	FCB	$0A,$0D
	FCC	"5->READ SECTOR"
	FCB	$0A,$0D
	FCC	"6->WRITE SECTOR"
	FCB	$0A,$0D
	FCC	"7->DUMP BUFFER"
	FCB	$0A,$0D
	FCC	"8->SENSE INT"
	FCB	$0A,$0D
	FCC	"9->CLEAR BUFFER"
	FCB	$0A,$0D
	FCC	"A->FORMAT DISK"
	FCB	$0A,$0D
	FCC	"B->READ DISK"
	FCB	$0A,$0D
	FCC	"Q->Quit"
	FCB	$0A,$0D
	FCB	$00

	SWI
	FCB	34		
			
	CMPA	#'1'			; MOTOR ON
	BNE	NOT1			;
	JMP	MENU_MOTOR_ON		;
NOT1:	
	CMPA	#'2'			; MOTOR OFF
	BNE	NOT2			;
	JMP	MENU_MOTOR_OFF		;
NOT2:		
	CMPA	#'3'			; SET TRACK
	BNE	NOT3			;
	JMP	MENU_SET_TRACK		;
NOT3:		
	CMPA	#'4'			; FORMAT TRACK
	BNE	NOT4			;
	JMP	MENU_FORMAT		;
NOT4:		
	CMPA	#'5'			; READ SECTOR
	BNE	NOT5			;
	JMP	MENU_READ		;
NOT5:		
	CMPA	#'6'			; WRITE SECTOR
	BNE	NOT6			;
	JMP	MENU_WRITE		;
NOT6:	
	CMPA	#'7'			; DUMP BUFFER
	BNE	NOT7			;
	JMP	MENU_DUMP		;
NOT7:		
	CMPA	#'8'			; SENSE INT
	BNE	NOT8			;
	JMP	MENU_SENSE		;
NOT8:		
	CMPA	#'9'			; CLEAR BUFFER
	BNE	NOT9			;
	JMP	MENU_CLEAR		;
NOT9:		
	CMPA	#'A'			; FORMAT DISK
	BNE	NOTA			;
	JMP	MENU_FORMATDISK		;
NOTA:		
	CMPA	#'B'			; READ DISK
	BNE	NOTB			;
	JMP	MENU_READDISK		;
NOTB:		
	CMPA	#'Q'			; IS QUIT
	BNE	NOTQ			;
	JMP	MENU_QUIT		;
NOTQ:		
	JMP	MAIN_LOOP		; LOOP TO MENU 

;________________________________________________________________________________________________________________________________ 
;
; MENU OPERATIONS
;________________________________________________________________________________________________________________________________ 
MENU_MOTOR_ON:
	LDAA	FLATCH_STORE		; POINT TO FLATCH
	ANDA	#%11111101		; SET MOTOR ON
	STAA	FLATCH_STORE		; POINT TO FLATCH
	JSR	OUTFLATCH		; OUTPUT TO CONTROLLER
	JMP	MAIN_LOOP		; LOOP TO MENU 

MENU_MOTOR_OFF:
	LDAA	FLATCH_STORE		; POINT TO FLATCH
	ORAA	#%00000010		; SET MOTOR ON
	STAA	FLATCH_STORE		; POINT TO FLATCH
	JSR	OUTFLATCH		; OUTPUT TO CONTROLLER
	JMP	MAIN_LOOP		; LOOP TO MENU 
	
MENU_SET_TRACK:

	SWI
	FCB	25			; OUTPUT MESSAGE
	FCC	"ENTER TRACK NUMBER (00):"
	FCB	$00			; OUTPUT MESSAGE
	JSR	HEXIN			; GET TRACK
	STAA	TRACK			; STORE TRACK
	JSR	SETTRACK		; DO IT	
	JMP	MAIN_LOOP		; LOOP TO MENU 

	
MENU_FORMAT:
	SWI
	FCB	25			; OUTPUT MESSAGE
	FCC	"ENTER TRACK NUMBER (00):"
	FCB	$0A,$0D,$00		; OUTPUT MESSAGE
	JSR	HEXIN			; GET TRACK
	STAA	TRACK			; STORE TRACK
	JSR	FORMAT			; FORMAT A FLOPPY DISK TRACK
	JMP	MAIN_LOOP		; LOOP TO MENU 

MENU_READ:
	SWI
	FCB	25			; OUTPUT MESSAGE
	FCC	"ENTER TRACK NUMBER (00):"
	FCB	$0A,$0D,$00		; OUTPUT MESSAGE
	JSR	HEXIN			; GET TRACK
	STAA	TRACK			; STORE TRACK
	SWI
	FCB	25			; OUTPUT MESSAGE
	FCC	"ENTER SECTOR NUMBER (00):"
	FCB	$0A,$0D,$00		; OUTPUT MESSAGE
	JSR	HEXIN			; GET SECTOR
	STAA	SECTOR			; STORE SECTOR
					;	
	JSR	READ			; READ A FLOPPY DISK SECTOR
	CMPA	#$FF
	BNE	DOREADEXIT		; NO ERROR IF READ RTSURNS OTHER THAN -1
					; ELSE, PRINT ERROR MESSAGE
					;	
	SWI
	FCB	25			; OUTPUT MESSAGE
	FCC	"READ ERROR"
	FCB	$0A,$0D,$00		; OUTPUT MESSAGE
DOREADEXIT:
	JMP	MAIN_LOOP		;

MENU_WRITE:
	SWI
	FCB	25			; OUTPUT MESSAGE
	FCC	"ENTER TRACK NUMBER (00):"
	FCB	$0A,$0D,$00		; OUTPUT MESSAGE
	JSR	HEXIN			; GET TRACK
	STAA	TRACK			; STORE TRACK
	SWI
	FCB	25			; OUTPUT MESSAGE
	FCC	"ENTER SECTOR NUMBER (00):"
	FCB	$0A,$0D,$00		; OUTPUT MESSAGE
	JSR	HEXIN			; GET SECTOR
	STAA	SECTOR			; STORE SECTOR
					;	
	JSR	WRITE			; WRITE A FLOPPY DISK SECTOR
	CMPA	#$FF
	BNE	DOWRITEEXIT		; NO ERROR IF WRITE RTSURNS OTHER THAN -1
					; ELSE, PRINT ERROR MESSAGE
					;	
	SWI
	FCB	25			; OUTPUT MESSAGE
	FCC	"WRITE ERROR"
	FCB	$0A,$0D,$00		; OUTPUT MESSAGE
DOWRITEEXIT:
	JMP	MAIN_LOOP		;
	
MENU_SENSE:
	JSR	CHECKINT		;
	JMP	MAIN_LOOP		;

	
	
	
MENU_DUMP:
	LDX	#SECTOR_BUFFER     	; INITIALIZE X TO SECTOR BUFFER 
	LDD	#SECTOR_BUFFER     	; INITIALIZE D TO SECTOR BUFFER 
	ADDD	#$0200			; ADD BUFFER SIZE
	PSHS	D			; STORE D
	PULS	Y			; RESTORE Y
	JSR	DUMP_BUFFER		; DUMP THE BUFFER
	JMP	MAIN_LOOP		;

MENU_CLEAR:
	LDX	#SECTOR_BUFFER     	; INITIALIZE SECTOR BUFFER TO KNOWN VALUE $00
	LDY	#$0200
	LDAA    #$00
	JSR	FILL_MEM
	JMP	MAIN_LOOP		;
	
	
	
MENU_FORMATDISK:
	SWI
	FCB	25			; OUTPUT MESSAGE
	FCC	"FORMAT DISK"
	FCB	$0A,$0D,$00		; OUTPUT MESSAGE
					;
	LDAA	#$00
	STAA	TRACK			; STORE TRACK
	JSR	SETTRACK		; DO IT
	JSR	DELAYHSEC		; DELAY TO LET HEADS SETTLE BEFORE READ

FORMATDISK1:
	LDAA	#$00
	STAA	HEAD
	JSR	FORMAT			; FORMAT A FLOPPY DISK TRACK SIDE 0
	LDAA	#$01
	STAA	HEAD
	JSR	FORMAT			; FORMAT A FLOPPY DISK TRACK SIDE 1
	LDAA	TRACK
	INCA				; INCREMENT TO NEXT TRACK
	STAA	TRACK
	CMPA	#80			; IS THIS TRACK 80?
	BNE	FORMATDISK1		; NO, FORMAT NEXT TRACK
	JMP	MAIN_LOOP		; LOOP TO MENU 

MENU_READDISK:
	SWI
	FCB	25			; OUTPUT MESSAGE
	FCC	"READ DISK"
	FCB	$0A,$0D,$00		; OUTPUT MESSAGE
					;					
	LDAA	#$00
	STAA	TRACK			; STORE TRACK
	STAA	HEAD			; STORE HEAD
	LDAA	#$01
	STAA	SECTOR			; STORE SECTOR
	JSR	SETTRACK		; DO IT	
	JSR	DELAYHSEC		; DELAY TO LET HEADS SETTLE BEFORE READ

READDISK1:
	LDAA	#$00
	STAA	HEAD
	JSR	READ			; READ A FLOPPY DISK SECTOR & TRACK SIDE 0
	LDAA	#$01
	STAA	HEAD
	JSR	READ			; READ A FLOPPY DISK SECTOR & TRACK SIDE 1
	LDAA	SECTOR
	INCA				; INCREMENT TO NEXT SECTOR
	STAA	SECTOR
	CMPA	#10			; IS THIS SECTOR 10?
	BNE	READDISK1		; NO, READ NEXT SECTOR
	LDAA	#$01			; START AT SECTOR 01 FOR NEXT TRACK
	STAA	SECTOR			; STORE SECTOR
	LDAA	TRACK
	INCA				; INCREMENT TO NEXT TRACK
	STAA	TRACK
	CMPA	#80			; IS THIS TRACK 80?
	BNE	READDISK1		; NO, READ NEXT SECTOR & TRACK
	JMP	MAIN_LOOP		; LOOP TO MENU 

MENU_QUIT:
	SWI
	FCB	25			; OUTPUT MESSAGE
	FCC	'END FDC TEST PROGRAM'
	FCB	$00			; Line terminator
	SWI
	FCB	$00			; EXIT PROGRAM
	RTS

;________________________________________________________________________________________________________________________________ 
;
; MAIN PROGRAM ENDS HERE
;________________________________________________________________________________________________________________________________ 

;__SETUPDRIVE__________________________________________________________________________________________________________________________ 
;
;	SETUP DRIVE SETTINGS 
;________________________________________________________________________________________________________________________________
;
;
;
SETUPDRIVE:
	LDAA	#RESETL			; RESET SETTINGS
	ORAA	#MINI			; SELECT MINI FLOPPY (low dens=1, high dens=0)
	ORAA	#PRECOMP		; SELECT PRECOMP 
	ORAA	#FDDENSITY		; SELECT DENSITY
	ORAA	#FDREADY		; SELECT READY SIGNAL
	STAA	FLATCH_STORE		; SAVE SETTINGS
	LDAA	#$01			;
	STAA	UNIT			; SET UNIT 1
	LDAA	#$02			; DENSITY
	STAA	DENS			;
	LDAA	#$09			;
	STAA	EOTSEC			; LAST SECTOR OF TRACK			
	LDAA	#$E5			;
	STAA	D			; FILLER BYTE FOR FORMAT
	LDAA	#$2A			;
	STAA	FMTGAP			; GAP FOR FORMAT
	LDAA	#$0D			;
	STAA	GAP			; GAP 
	LDAA	#$80			;
	STAA	SECSIZ			; SECTOR SIZE /4
	LDA	#$03			; SPECIFY COMMAND
	JSR	PFDATA			; OUTPUT TO FDC
	LDA	#$7F			; 6 MS STEP, 480 MS HEAD UNLOAD
	JSR	PFDATA			; OUTPUT TO FDC
	LDA	#$05			; 508 MS HEAD LOAD, NON-DMA MODE
	JSR	PFDATA			; OUTPUT TO FDC
	RTS




;__OUTFLATCH__________________________________________________________________________________________________________________________ 
;
;	SEND SETTINGS TO FLOPPY CONTROLLER
;________________________________________________________________________________________________________________________________
;
OUTFLATCH:
	LDAA	FLATCH_STORE		; SET A TO SETTINGS
	STAA	FLATCH			; OUTPUT TO CONTROLLER
	RTS

		
;__READ__________________________________________________________________________________________________________________________ 
;
; 	READ A SECTOR 	
;________________________________________________________________________________________________________________________________
;	
READ:
	LDAA	#$46			; BIT 6 SETS MFM, 06H IS READ COMMAND
	STAA	CMD
	JMP	DSKOP

;__WRITE__________________________________________________________________________________________________________________________ 
;
; 	WRITE A SECTOR 	
;________________________________________________________________________________________________________________________________
;	
WRITE:
	LDAA	#$45			; BIT 6 SETS MFM, 05H IS WRITE COMMAND
	STAA	CMD
	JMP	DSKOP

;__FORMAT__________________________________________________________________________________________________________________________ 
;
; 	FORMAT A TRACK 	
;________________________________________________________________________________________________________________________________
;	
FORMAT:
	LDAA	#$4D			; BIT 6 SETS MFM, 0DH IS FORMAT COMMAND
	STAA	CMD
	JMP	DSKOP

;__DSKOP__________________________________________________________________________________________________________________________ 
;
; 	PERFORM A DISK OPERATION 	
;________________________________________________________________________________________________________________________________
;		
DSKOP:
	JSR	CHECKINT		; CHECK INTERRUPT STATUS, MAKE SURE IT IS CLEAR
	CMPA	#$FF			; DID IT RTSURN WITH ERROR CODE?
	BEQ	DSKEXIT			; IF YES, EXIT WITH ERROR CODE
					;	
	LDAA	UNIT			; GET DISK UNIT NUMBER
	ANDA	#$03			; MASK FOR FOUR DRIVES.
	STAA	UNIT			; PARK IT IN TEMP
	LDAA	HEAD			; GET HEAD SELECTION
	ANDA	#$01			; INSURE SINGLE BIT
	ASLA				;
	ASLA				; MOVE HEAD TO BIT 2 POSITION
	ORAA	UNIT			; OR HEAD TO UNIT BYTE IN COMMAND BLOCK
	STAA	UNIT			; STORE IN UNIT
					;
	LDAA	FLATCH_STORE		; POINT TO FLATCH
	ANDA	#%11111101		; SET MOTOR ON
	STAA	FLATCH_STORE		; POINT TO FLATCH	
	JSR	OUTFLATCH		; OUTPUT TO CONTROLLER
					;
	JSR	SETTRACK		; PERFORM SEEK TO TRACK
					;
	LDX	#SECTOR_BUFFER		; GET BUFFER ADDRESS TO HL
	LDAB	SECSIZ			; C WILL BE THE NUMBER OF TRANSACTIONS
					; DIVIDED BY 4
					;					
	LDAA	CMD			; WHAT COMMAND IS PENDING?
	CMPA	#$4D			; IS IT A FORMAT COMMAND?
	BEQ	FMT			; YES, DO FORMAT
	CMPA	#$46			; IS IT A READ COMMAND?
	BEQ	RDCMD			;
	JMP	WRR_POLL		; NO, MUST BE READ OR WRITE COMMAND
RDCMD:	
	JMP	RDD_POLL		;
DSKEXIT:	
	LDAA	FLATCH_STORE		; POINT TO FLATCH
	ORAA	#%00000010		; SET MOTOR OFF
	STAA	FLATCH_STORE		; POINT TO FLATCH	
	JSR	OUTFLATCH		; OUTPUT TO CONTROLLER
	LDAA	#$FF			; SET -1 IF ERROR
	RTS
FMT:	
	SWI
	FCB	25			; OUTPUT MESSAGE
	FCC	 "FORMAT BEGINNING. . ."				; FORMAT TRACK COMMAND
	FCB	$00			; Line terminator
					;
	LDAB	#$00			;
					;
	LDAA	CMD			;
	JSR	PFDATA			; PUSH FORMAT COMMAND TO I8272
	LDAA	UNIT			;
	JSR	PFDATA			; WHICH DRIVE UNIT TO FORMAT
	LDAA	DENS			;
	JSR	PFDATA			; WHAT DENSITY
	LDAA	EOTSEC			;
	JSR	PFDATA			; ASSUME SC (SECTOR COUNT)  EOT
	LDAA	FMTGAP			;
	JSR	PFDATA			; WHAT GAP IS NEEDED
	LDAA	D			;
	JSR	PFDATA			; FILLER BYTE FOR SECTORS
					;
FMT1:
	LDAA	>FMSR			;
	BPL	FMT1			;	
					;
	BITA	#%00100000		; 
	BEQ	DSKFMTEND		;
					;
	LDAA	TRACK			; UPDATE I8272 DURING FORMAT				
	STAA	>FDATA			; SEND CYLINDER NUMBER
					;
FMT1A:
	LDAA	>FMSR			;
	BPL	FMT1A			;	
					;
	BITA	#%00100000		; 
	BEQ	DSKFMTEND		;
					;
	LDAA	HEAD			;
	STAA	>FDATA			; WHICH DRIVE HEAD TO FORMAT
FMT1B:
	LDAA	>FMSR			;
	BPL	FMT1B			;	
					;
	BITA	#%00100000		; 
	BEQ	DSKFMTEND		;
					;
	INCB				; physical sector is 1-9
	STAB	>FDATA			; WHAT SECTOR NUMBER
FMT1C:
	LDAA	>FMSR			;
	BPL	FMT1C			;	
					;
	BITA	#%00100000		; 
	BEQ	DSKFMTEND		;
					;
	LDAA	DENS			;
	STAA	>FDATA			; NUMBER OF BYTES PER SECTOR (N2)
					;
	CMPB	EOTSEC			;
	BNE	FMT1			; IF NO, SEND ANOTHER SECTOR
	JMP	DSKOPEND		;
RESULT:
	SWI
	FCB	25			; OUTPUT MESSAGE
	FCC	 "END OPERATION . . ."	;
	FCB	$00			; Line terminator
					;
	LDAB	#$07			; LOAD C WITH NUMBER OF STATUS BYTES
	LDX	#ST0			; POINT TO STATS STORAGE
RS3:
	JSR	GFDATA			; GET FIRST BYTE
	STAA	,X			; SAVE IT
	INX				; POINTER++
	DECB				; CC-1
	CMPB	#$00			;
	BNE	RS3			; LOOP TIL C0
					;
RSTEXIT:
	JSR	PRINTRESULTS		; PRINT RESULTS OF COMMAND
	JSR	CHECKINT		; CHECK INTERRUPT STATUS, MAKE SURE IT IS CLEAR
	LDAA	FLATCH_STORE		; POINT TO FLATCH
	ORAA    #%00000010		;
	STAA	FLATCH_STORE		; POINT TO FLATCH
	JSR	OUTFLATCH		; OUTPUT TO CONTROLLER					;
	RTS				; DONE RTSURN TO JSRER.
DSKFMTEND:	
	JMP	DSKOPEND
	
PRINTRESULTS:
	PSHS	A
	SWI
	FCB	22
	LDAA 	ST0			; GET BYTE
	SWI
	FCB	28
	SWI
	FCB	21
	LDAA 	ST1			; GET BYTE
	SWI
	FCB	28
	SWI
	FCB	21
	LDAA 	ST2			; GET BYTE
	SWI
	FCB	28
	SWI
	FCB	21
	LDAA 	SCYL			; GET BYTE
	SWI
	FCB	28
	SWI
	FCB	21
	LDAA 	SHEAD			; GET BYTE
	SWI
	FCB	28
	SWI
	FCB	21
	LDAA 	SREC			; GET BYTE
	SWI
	FCB	28
	SWI
	FCB	21
	LDAA 	SNBIT			; GET BYTE
	SWI
	FCB	28
	SWI
	FCB	21
	SWI
	FCB	22
	PULS	A
	RTS

	
SNDFDWR:
	LDAA	CMD			;
	JSR	PFDATA			; PUSH COMMAND TO I8272
	LDAA	UNIT			;
	JSR	PFDATA			; 
	LDAA	TRACK			;
	JSR	PFDATA			; 
	LDAA	HEAD			;
	JSR	PFDATA			; 
	LDAA	SECTOR			;
	JSR	PFDATA			; 
	LDAA	DENS			;
	JSR	PFDATA			; WHAT DENSITY
	LDAA	EOTSEC			;
	JSR	PFDATA			; ASSUME SC (SECTOR COUNT)  EOT
	LDAA	GAP			;
	JSR	PFDATA			; WHAT GAP IS NEEDED
	LDAA	DTL			; DTL, IS THE LAST COMMAND BYTE TO I8272
	JSR	PFDATA
	RTS
					;
; PERFORM READ
; LOOP EXECUTES 4X, THIS ALLOWS C RATHER THAN BC AS COUNTER
; SAVING A FEW CYCLESS. MAKES UP TO 1024 BYTE SECTORS POSSIBLE.
; FROM READ TO READ MUST NOT EXCEED 25US WORST CASE MIN.
; 1 Mhz 6809 = 1 CYC PER US OR 25 CYCLES WORST CASE (50 FOR 2 Mhz)
;	
RDD_POLL:
	LDY	#$0200
	LDX	#SECTOR_BUFFER
	JSR	SNDFDWR
RDS1	LDA	>FMSR		GET STATUS
	BPL	RDS1		NOT READY
	BITA	#%00100000	EXECUTION MODE?
	BEQ	DSKOPEND	NO, ERROR
	LDA	>FDATA		GET DATA
	STA	,X+		WRITE IT
	LEAY	-1,Y		REDUCE COUNT
	BNE	RDS1		KEEP GOING
DSKOPEND:
	LDAA	FLATCH_STORE		; POINT TO FLATCH
	ORAA	#%00000001		;
	STAA	FLATCH_STORE		; SET TC
	JSR	OUTFLATCH		; OUTPUT TO CONTROLLER
	NOP				;
	NOP				; 2 MICROSECOND DELAY
	NOP				;
	NOP				; 
	LDAA	FLATCH_STORE		; POINT TO FLATCH
	ANDA	#%11111110		;
	STAA	FLATCH_STORE		; SET TC
	JSR	OUTFLATCH		; OUTPUT TO CONTROLLER
	NOP				;
	NOP				; 2 MICROSECOND DELAY
	NOP				;
	NOP				; 2 MICROSECOND DELAY
	LDAA	FLATCH_STORE		; POINT TO FLATCH
	ORAA    #%00000010		;
	STAA	FLATCH_STORE		; POINT TO FLATCH
	JSR	OUTFLATCH		; OUTPUT TO CONTROLLER
	JMP	RESULT			; GET STATUS BYTES <RESULT PHASE>

WRR_POLL:
	LDY	#$0200
	LDX	#SECTOR_BUFFER
	JSR	SNDFDWR
WRS1	LDB	,X+		GET DATA
WRS2	LDA	>FMSR		GET STATUS
	BPL	WRS2		NOT READY
	BITA	#%00100000	EXECUTION MODE?
	BEQ	WRS3		NO, ERROR
	STB	>FDATA		WRITE TO FDC
	LEAY	-1,Y		BACKUP COUNT
	BNE	WRS1		DO NEXT
WRS3	JMP	DSKOPEND		; 

	
		
;__SETTRACK__________________________________________________________________________________________________________________________ 
;
; 	SEEK TO A TRACK ON GIVEN UNIT
; 	A: TRACK #
;________________________________________________________________________________________________________________________________
;
SETTRACK:
					; ANY INTERUPT PENDING
					; IF YES FIND OUT WHY/CLEAR
	JSR	CHECKINT		; CHECK INTERRUPT STATUS, MAKE SURE IT IS CLEAR
	CMPA	#$FF			; DID IT RTSURN WITH ERROR CODE?
	BNE	SETTRK1
	JMP	SETTRKEXIT		;
					;
SETTRK1:					
	LDAA	TRACK			; GET TRACK
	CMPA	#$00			;
	BEQ	RECAL			; IF 0 PERFORM RECAL INSTEAD OF SEEK
	LDAA	#$0F			; SEEK COMMAND
	JSR	PFDATA			; PUSH COMMAND
	LDAA	UNIT			; SAY WHICH UNIT
	JSR	PFDATA			; SEND THAT
	LDAA	TRACK			; TO WHAT TRACK
	JSR	PFDATA			; SEND THAT TOO
	JMP	WAINT			; WAIT FOR INTERRUPT SAYING DONE
RECAL:
	LDAA	#$07			; RECAL TO TRACK 0
	JSR	PFDATA			; SEND IT
	LDAA	UNIT			; WHICH UNIT
	JSR	PFDATA			; SEND THAT TOO
;
WAINT:
;
SETTRK2:		
	JSR	CHECKINT			
	LDAA	>FMSR			; READ SEEK STATUS
	BITA	#%00001111		; ANY DRIVES SEEKING?
	BNE	SETTRK2			; YES, WAIT FOR THEM
;
SETTRKEXIT:
	RTS

;__PFDATA__________________________________________________________________________________________________________________________ 
;
; WRITE A COMMAND OR PARAMETER SEQUENCE
;
; TRANSFERS ARE SYNCHONIZED BY MSR D7 <RQM> AND D6 <DIO>
;	RQM  DIO
;	0	0	BUSY
;	1	0	WRITE TO DATA REGISTER PERMITTED
;	1	1	BYTE FOR READ BY HOST PENDING
;	0	1	BUSY
;
;________________________________________________________________________________________________________________________________
;
PFDATA:
	PSHS	A			; SAVE DATA BYTE
WRF1:
	LDAA	>FMSR			; READ FDC STATUS
	BPL	WRF1			; FDC IS NOT READY, WAIT FOR IT
	BITA	#%01000000		; TEST DIO BIT
	BNE	WRF2			; FDC IS OUT OF SYNC
	PULS	A			; RESTORE DATA
	STAA	>FDATA			; WRITE TO FDC
	RTS
*; FDC IS OUT OF SYNC CLEAR IT OUT AND RE-TRY
WRF2:
	LDAA	>FDATA			; READ DATA REGISTER
	BRA	WRF1			; AND CONTINUE
	
	
;__CHECKINT__________________________________________________________________________________________________________________________ 
;
; CHECK FOR ACTIVE FDC INTERRUPTS BEFORE GIVING I8272 COMMANDS
; POLL RQM FOR WHEN NOT BUSY AND THEN SEND FDC
; SENSE INTERRUPT COMMAND.  IF IT RTSURNS WITH NON ZERO
; ERROR CODE, PASS BACK TO JSRING ROUTINE FOR HANDLING
;________________________________________________________________________________________________________________________________
;
CHECKINT:
	PSHS	A			; STORE A
WTDONE:
	LDAA	>FMSR			; READING OR WRITING IS KEYS TO D7 RQM
	BPL	WTDONE			; WAIT FOR RQM TO BE TRUE. WAIT UNTIL DONE
	BITA	#%01000000		; WAITING FOR INPUT?
	BEQ	WTDONE1
	JMP	ERRORT			; NO, SIGNAL ERROR
WTDONE1:	
	PULS	A			; RESTORE AF
	JSR	SENDINT			; SENSE INTERRUPT COMMAND
	PSHS	A			; STORE A
					;
	CMPA	#%00000000		; NORMAL TERMINATION CASE
	BNE	NOTNORT
	SWI
	FCB	25			; OUTPUT MESSAGE
	FCC	 "NORMAL TERMINATION"
	FCB	$00			; Line terminator
	JMP	EXITCI			; EXIT
					;
NOTNORT:					
	CMPA	#%01000000		; ABNORMAL TERMINATION OF COMMAND CASE
	BNE	NOTABNORT					
	SWI
	FCB	25			; OUTPUT MESSAGE
	FCC	 "ABNORMAL TERMINATION"
	FCB	$00			; Line terminator
	JMP	EXITCI			; EXIT
					;
NOTABNORT:
	CMPA	#%11000000		; ABNORMAL TERMINATION OF COMMAND CASE
	BNE	NOTMSGRC
	SWI
	FCB	25			; OUTPUT MESSAGE
	FCC	 "READY CHANGED"
	FCB	$00			; Line terminator
	JMP	EXITCI			; EXIT
NOTMSGRC:				
	SWI
	FCB	25			; OUTPUT MESSAGE
	FCC	 "INVALID COMMAND"
	FCB	$00			; Line terminator
					;
EXITCI:
	PULS	A			; RESTORE A
	JSR	PRINTRESULTS		; PRINT RESULTS OF COMMAND					;
	RTS				;
	
;__DELAYHSEC__________________________________________________________________________________________________________________________ 
;
; DELAY FOR 1/2 SECOND
;________________________________________________________________________________________________________________________________
;		
DELAYHSEC:
	PSHS	X
	LDX	#$FFFF
DELAY:
	DEX
	CPX	#$0000
	BNE	DELAY
	PULS	X
	RTS

;__ERRORT__________________________________________________________________________________________________________________________ 
;
; ERROR HANDLING
;________________________________________________________________________________________________________________________________
;			
ERRORT:
	PULS	A
ERRORT1:	
	SWI
	FCB	25			; OUTPUT MESSAGE
	FCC	 "ERROR"
	FCB	$00			; Line terminator

					;
ERRCLR:	
	LDAA	>FDATA			; CLEAR THE JUNK OUT OF DATA REGISTER
	LDAA	>FMSR			; CHECK WITH RQM
	ANDA	#$80			; IF STILL NOT READY, READ OUT MORE JUNK
	BEQ	ERRCLR			;
	LDAA	#$FF			; RTSURN ERROR CODE -1
					;
	RTS

;__SENDINT__________________________________________________________________________________________________________________________ 
;
; SENSE INTERRUPT COMMAND
;________________________________________________________________________________________________________________________________
;			
SENDINT:
	LDAA	#$08			; SENSE INTERRUPT COMMAND
	JSR	PFDATA			; SEND IT
	JSR	GFDATA			; GET RESULTS
	STAA	ST0			; STORE THAT
	ANDA	#$C0			; MASK OFF INTERRUPT STATUS BITS
	CMPA	#$80			; CHECK IF INVALID COMMAND
	BEQ	ENDSENDINT		; YES, EXIT
	JSR	GFDATA			; GET ANOTHER (STATUS CODE 1)
	STAA	ST1			; SAVE THAT
	LDAA	ST0			; GET FIRST ONE
	ANDA	#$C0			; MASK OFF ALL BUT INTERRUPT CODE 00 IS NORMAL
ENDSENDINT:
	RTS				;ANYTHING ELSE IS AN ERROR

	
;__GFDATA__________________________________________________________________________________________________________________________ 
;
; GET DATA FROM FLOPPY CONTROLLER
;
; TRANSFERS ARE SYNCHONIZED BYT MSR D7 <RQM> AND D6 <DIO>
;	RQM  DIO
;	0	0	BUSY
;	1	0	WRITE TO DATA REGISTER PERMITTED
;	1	1	BYTE FOR READ BY HOST PENDING
;	0	1	BUSY
;
;________________________________________________________________________________________________________________________________
;		
GFDATA:
	LDAA	>FMSR			; READ STATUS BYTE
	BPL	GFDATA			; LOOP WHILE BUSY
	ANDA	#%01000000		; ANY DATA FOR US?
	BNE	GFDATA1			;
	JSR	ERRORT1			; IF WRITE EXPECTED RUN ERRORRT
GFDATA1:	
	LDAA	>FDATA			; READ DATA
	RTS
	
	
*__FILL_MEM__________________________________________________________________________________________
*
*  FILL MEMORY BLOCK
*     
*____________________________________________________________________________________________________				
FILL_MEM:
		STAA    ,X+			;
		DEY				;
		CMPY    #$0000			;
		BNE	FILL_MEM		;
		RTS				;
		

*__DUMP__________________________________________________________________________________________________________________________ 
*
*	Print a Memory Dump (LOW)
*________________________________________________________________________________________________________________________________
*
DUMP_BUFFER:
		STY	TEMPW1			; STORE END
		STX	TEMPW			; STORE START 
		SWI				;
		FCB	22			; OUTPUT CRLF
BLKRD:		
		LDD	TEMPW			;
		SWI
		FCB	27			; PRINT START LOCATION
		SWI				;
		FCB	21			; PRINT SPACE
		LDY	#$10			; SET FOR 16 LOCS
NXTONE:
		LDAA	,X+			; GET BYTE
		SWI				;
		FCB	28			; PRINT VALUE
		SWI				;
		FCB	21			; PRINT SPACE
UPDH:	
		DEY				; DEC. LOC COUNT
		BNE	NXTONE			; IF LINE NOT DONE
						; NOW PRINT 'DECODED' DATA TO RIGHT OF DUMP
PCRLF:
		SWI				;
		FCB	21			; PRINT SPACE
		LDY	#$10			; SET FOR 16 LOCS
		LDX	TEMPW			; GET BACK START
PCRLF0:
		LDAA	,X+			; GET BYTE
		CMPA	#$20			; SEE IF A 'DOT'
		BGT	PDOT			; O.K. TO GET
		LDAA	#$2E			; LOAD A DOT	
PDOT:
		SWI				
		FCB	33			; PRINT IT
		DEY				; DEC. LOC COUNT		
		BNE	PCRLF0			; IF LINE NOT DONE
		SWI				
		FCB	22			; PRINT CRLF
		CPX	TEMPW1			;
		BGT	DUMP_END		;
		STX	TEMPW			;
CONTD:
		JMP	BLKRD			;

DUMP_END:	
		RTS				;
	
TEMPW:
		FCW	$01			;		
TEMPW1:		
		FCW	$01			;						

		
		

;__HEXIN__________________________________________________________________________________________________________________________ 
;
;	GET ONE BYTE OF HEX DATA FROM CONSOLE RETURN IN A
;________________________________________________________________________________________________________________________________
;
HEXIN:
	LDY	#KEYBUF
	LDB	#$10
	SWI
	FCB	3
	SWI	
	FCB	7
	STAB	KEYBUF
	SWI
	FCB	24			; OUTPUT MESSAGE
	FCC	 "VALUE:"		;
	FCB	$00			; Line terminator
	LDAA	KEYBUF
	SWI
	FCB	28
	SWI
	FCB	22
	RTS

	
TEMP:
	FCB	00
FLATCH_STORE:
	FCB	00
;
; DISK COMMAND BLOCK
;
CMD:	FCB	0			; COMMAND READ OR WRITE,
UNIT:	FCB	0			; PHYSICAL DRIVE 0->3
TRACK:	FCB	0			; PHYSICAL TRACK 0->256
HEAD:	FCB	0			; HEAD SEL 0 OR 1
SECTOR:	FCB	1			; PHYSICAL SECTOR, ALWAYS 1 TO MAX SECTOR
DENS:	FCB	2			; DENSITY
EOTSEC:	FCB	09			; LAST SECTOR OF TRACK
GAP:	FCB	$1B			; VALUE FOR IRG <GAP3>
SECSIZ:	FCB	$80			; HOW MANY BYTES TO TRANSFER/4
DTL:	FCB	$FF			; SIZE OF SECTOR
;
MIN:	FCB	MINI			; LATCH BIT PATTERN FOR FDC9229 MINITRUE
D:	FCB	$E5			; FILLER BYTE FOR FORMAT
FMTGAP:	FCB	$54			; GAP FOR FORMAT
PRE:	FCB	PRECOMP			; LATCH BIT PATTERN FOR FDC9229 PRECOMP125NS
;
; STATUS RESULT STORAGE
;
ST0:	FCB	0			; STORE STATUS 0
ST1:	FCB	0			; ST1
ST2:	FCB	0			; ST2
SCYL:	FCB	0			; TRACK
SHEAD:	FCB	0			; HEAD 0 OR 1
SREC:	FCB	0			; SECTOR
SNBIT:	FCB	0			; DENSITY

	
KEYBUF:  	FCC "                                                                                "
SECTOR_BUFFER:		RMB	$0200

	.END


