*__TESTVDU____________________________________________________________________________________________
*
*
*  TESTVDU
*     Test 6809 Bus Bridge and VDU interface
*____________________________________________________________________________________________________
; constants

OSRAM		EQU       $0000
OSEND		EQU       $CBFF
OSUTIL		EQU       $C000


DATAP: 		EQU $F150 ; VDP Data port 
CMDP: 		EQU $F151 ; VDP Command port $99 works on all MSX models 
ACRP:		EQU $F154


		ORG       $0000

*____________________________________________________________________________________________________


		SWI
		FCB	25			; OUTPUT MESSAGE
		FCC	'START SGC TEST PROGRAM'
		FCB	$00			; Line terminator


		LDAA 	#$FF
		STAA 	ACRP
	
; Let's set VDP write address to $0000 
		LDAA	#$00
		STAA 	CMDP 
		LDAA	#$40 
		STAA 	CMDP 

; Now let's clear first 16Kb of VDP memory 
		LDAB	#$00 
		LDX	#$3FFF 
CLEAR: 
		STAB	DATAP
		DEX
		NOP
		NOP
		NOP
		NOP
		CPX	#$0000
		BNE	CLEAR

; Now it is time to set up VDP registers: 
;---------------------------------------- 
; Register 0 to $0 
; 
; Set mode selection bit M3 (maybe also M4 & M5) to zero and 
; disable external video & horizontal interrupt 
		LDAA 	#$00
		LDAB 	#$80 
		STAA	CMDP
		STAB	CMDP
;---------------------------------------- 
; Register 1 to $50 
; 
; Select 40 column mode, enable screen and disable vertical interrupt 

		LDAA #$50 
		INCB 
		STAA	CMDP
		STAB	CMDP
;---------------------------------------- 
; Register 2 to $0 
; 
; Set pattern name table to $0000 

		LDAA	#$00
		INCB 
		STAA	CMDP
		STAB	CMDP
;---------------------------------------- 
; Register 3 is ignored as 40 column mode does not need color table 
; 
		INCB 
;---------------------------------------- 
; Register 4 to $1 
; Set pattern generator table to $800 

		INCA 
		INCB 
		STAA	CMDP
		STAB	CMDP

;---------------------------------------- 
; Registers 5 (Sprite attribute) & 6 (Sprite pattern) are ignored 
; as 40 column mode does not have sprites 

		INCB 
		INCB 
;---------------------------------------- 
; Register 7 to $F0 
; Set colors to white on black 

		LDAA 	#$F1 
		INCB 
		STAA	CMDP
		STAB	CMDP
;---------------------------------------- 

; Let's set VDP write address to $808 so, that we can write 
; character set to memory 
; (No need to write SPACE it is clear char already) 
		LDAA 	#$08 
		STAA	CMDP
		LDAA	#$48 
		STAA	CMDP

; Let's copy character set 
		LDX 	#CHARS 
		LDAB 	#CHARS_END-CHARS 
COPYCHARS: 
		LDAA	,X
		STAA 	DATAP 
		INX
		NOP ; Let's wait 8 clock cycles just in case VDP is not quick enough. 
		NOP 
		NOP
		NOP
		DECB
		CMPB	#$00
		BNE	COPYCHARS 

; Let's set write address to start of name table 
		LDAA	#$00
		STAA	CMDP
		LDAA	#$40 
		STAA	CMDP

; Let's put characters to screen 
		LDX	#ORDER 
		LDAB	#ORDER_END-ORDER 
COPYORDER: 
		LDAA	,X
		STAA 	DATAP
		INX
		NOP 
		NOP 
		NOP
		NOP
		DECB
		CMPB	#$00
		BNE	COPYORDER 

; The end 						;
	SWI
		FCB	25			; OUTPUT MESSAGE
		FCC	'END SCG TEST PROGRAM'
		FCB	$00			; Line terminator
		SWI
		FCB	$00			; EXIT PROGRAM



; Character set: 
; -------------- 
ORDER: 
	FCB 1,2,3,3,4,0,5,4,6,3,7 
ORDER_END: 

CHARS: 

; H 
	FCB %10001000 
	FCB %10001000 
	FCB %10001000 
	FCB %11111000 
	FCB %10001000 
	FCB %10001000 
	FCB %10001000 
	FCB %00000000 
; e 
	FCB %00000000 
	FCB %00000000 
	FCB %01110000 
	FCB %10001000 
	FCB %11111000 
	FCB %10000000 
	FCB %01110000 
	FCB %00000000 
; l 
	FCB %01100000 
	FCB %00100000 
	FCB %00100000 
	FCB %00100000 
	FCB %00100000 
	FCB %00100000 
	FCB %01110000 
	FCB %00000000 
; o 
	FCB %00000000 
	FCB %00000000 
	FCB %01110000 
	FCB %10001000 
	FCB %10001000 
	FCB %10001000 
	FCB %01110000 
	FCB %00000000 
; W 
	FCB %10001000 
	FCB %10001000 
	FCB %10001000 
	FCB %10101000 
	FCB %10101000 
	FCB %11011000 
	FCB %10001000 
	FCB %00000000 

; r 
	FCB %00000000 
	FCB %00000000 
	FCB %10110000 
	FCB %11001000 
	FCB %10000000 
	FCB %10000000 
	FCB %10000000 
	FCB %00000000 
; d 
	FCB %00001000 
	FCB %00001000 
	FCB %01101000 
	FCB %10011000 
	FCB %10001000 
	FCB %10011000 
	FCB %01101000 
	FCB %00000000 
CHARS_END: 

	.END
	