*__TESTKB09__________________________________________________________________________________________
*
*
*  TEST09
*     Read PIO attached Matrix Keyboard, debounce and return scancode 
*____________________________________________________________________________________________________
; constants

OSRAM	EQU	$0000
OSEND	EQU	$CBFF
OSUTIL	EQU	$C000

PORTA	EQU 	$F01F
PORTB	EQU 	$F010
PORTC	EQU 	$F02F	

DDRA	EQU 	$F013
DDRB	EQU 	$F012
DDRC	EQU 	$F023


	ORG	$0000

	SWI
	FCB	25			; OUTPUT MESSAGE
	FCC	'Begin Keyboard Test Program'
	FCB	$00			; Line terminator


	JSR	mTerm_Init		; Init PIO for mTerm
	LDX	#CPUUP			; SET POINTER TO DATA BUFFER
	JSR	SEGDISPLAY		; DISPLAY 


Loop:
	JSR	KB_Get			; Get Key from KB
	CMPA	#$17			; IS boot?
	BEQ	Exit			; YES, EXIT
	STAA	DISPLAYBUF		; STORE A IN DISPLAY BUFFER
	LDX	#DISPLAYBUF		; SET POINTER TO DATA BUFFER
	JSR	HEXDISPLAY		; DISPLAY DIGIT ON 7 SEG

	SWI	
	FCB	28
	SWI
	FCB	25			; OUTPUT MESSAGE
	FCC	'<-- SCAN CODE'
	FCB	$00			; Line terminator

	JMP	Loop
Exit:
	SWI
	FCB	0

	RTS	




*__mTerm_Init________________________________________________________________________________________
*
*  Setup PIO, Port A=Out, Port B=In, Port C=Out 
*     
*____________________________________________________________________________________________________
mTerm_Init:
	LDAA	#$FF
	STAA	DDRA
	STAA	DDRC
	LDAA	#$00
	STAA	DDRB
	RTS

*__KB_Get____________________________________________________________________________________________
*
*  Get a Single Key and Decode
*     
*____________________________________________________________________________________________________
KB_Get:

KB_Get_Loop:				; WAIT FOR KEY
	JSR	KB_Scan			;  Scan KB Once
	CMPA	#$00			;  Null?
	BEQ 	KB_Get_Loop		;  Loop while not zero
	PSHS	A
	LDA	#$4F			;  Scan All Col Lines
	STAA 	PORTC			;  Send to Column Lines
        JSR    	KB_Scan_Delay		;  Delay to allow lines to stabilize
KB_Clear_Loop:				; WAIT FOR KEY TO CLEAR
	LDAA	PORTB			;  Get Rows
	CMPA	#$00 			;  Anything Pressed?
	BNE	KB_Clear_Loop		;  Yes, Exit.
	PULS	A			;  Restore A	
	LDAB	#$00			;
	LDX	#KB_Decode		;  Point to beginning of Table	
KB_Get_LLoop:
	CMPA	,X+			;
	BEQ	KB_Get_Done		;  Found, Done
	INCB				;  B + 1	
	BNE	KB_Get_LLoop		;  Not Found, Loop until EOT			
KB_Get_Done:
	TFR	B,A			;  Result Into A
	RTS
KB_TEMP:
	FCB	$00			; KB WORK AREA


*__KB_Scan____________________________________________________________________________________________
*
*  SCan Keyboard Matrix for an input
*     
*____________________________________________________________________________________________________
KB_Scan:

	LDAA    #$00
	STAA	KB_TEMP			;  
	LDAA	#$41			;  Scan Col One
	STAA 	PORTC			;  Send to Column Lines
        JSR     KB_Scan_Delay		;  Delay to allow lines to stabilize
	LDAA	PORTB			;  Get Rows
	CMPA	#$00 			;  Anything Pressed?
	BNE	KB_Scan_Found		;  Yes, Exit.

	LDAA    #$40
	STAA	KB_TEMP			;  
	LDAA	#$42			;  Scan Col Two
	STAA 	PORTC			;  Send to Column Lines
        JSR 	KB_Scan_Delay		;  Delay to allow lines to stabilize
	LDAA	PORTB			;  Get Rows
	CMPA	#$00 			;  Anything Pressed?
	BNE	KB_Scan_Found		;  Yes, Exit.

	LDAA    #$80
	STAA	KB_TEMP			;  
	LDAA	#$44			;  Scan Col Three
	STAA 	PORTC			;  Send to Column Lines
        JSR  	KB_Scan_Delay		;  Delay to allow lines to stabilize
	LDAA	PORTB			;  Get Rows
	CMPA	#$00 			;  Anything Pressed?
	BNE	KB_Scan_Found		;  Yes, Exit.

	LDAA    #$C0
	STAA	KB_TEMP			;  
	LDAA	#$48			;  Scan Col Four
	STAA 	PORTC			;  Send to Column Lines
        JSR	KB_Scan_Delay		;  Delay to allow lines to stabilize
	LDAA	PORTB			;  Get Rows
	CMPA	#$00 			;  Anything Pressed?
	BNE	KB_Scan_Found		;  Yes, Exit.

	LDAA	#$40			;  Turn off All Columns
	STAA	PORTC			;  Send to Column Lines
	LDAA	#$00			;  RETURN NULL
	RTS				;  Exit

KB_Scan_Found:
	ANDA	#$3F			;  Clear Top two Bits
	ORA	KB_TEMP			;  Add in Row Bits 
	PSHS	A			;  Store Value
	LDAA	#20			;
	JSR	MS_DELAY		;
KB_Scan_DEBOUNCE:
	LDAA	PORTB			;  Get VALUE
	CMPA	#$00 			;  Anything Pressed?
	BNE	KB_Scan_DEBOUNCE	;  Yes, Loop.
	LDAA	#$40			;  Turn off All Columns
	STAA	PORTC			;  Send to Column Lines
	PULS	A			;  Restore Value
	RTS

PAUSE:
KB_Scan_Delay:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	RTS

*__MS_DELAY___________________________________________________________________________________________
*
*  DELAY FOR (A) MILLISECONDS (A/2 @ 2MHZ)
*     
*____________________________________________________________________________________________________	
MS_DELAY:
	PSHS	B
	PSHS	CC
DLY1:
	LDAB	#$C3
DLY:
	DECB
	BNE	DLY
	DECA
	BNE	DLY1
	PULS	CC
	PULS	B
	RTS
	


*__HEXDISPLAY________________________________________________________________________________________
*
*  Display contents of DISPLAYBUF in decoded Hex bits 0-3 are displayed dig, bit 7 is DP
*     
*____________________________________________________________________________________________________
HEXDISPLAY:
	PSHS	A			; STORE A
	PSHS	B			; STORE B
	LDAB	#$07	
	ABX
	LDAB	#$08			; SET DIGIT COUNT
	LDAA	#$40			; set Control port 7218 to off
	STAA	PORTC			; output
	JSR 	PAUSE			; wait
	LDAA	#$F0			; set control to 1111 (Data Coming, Hex Decode,NO Decode, Normal)
	STAA	PORTA			; output to port
	LDAA	#$80			; Strobe write pulse with Control=1
	STAA	PORTC			; output to port
	JSR 	PAUSE			; wait
	LDAA	#$40			; set Control port 7218 to off
	STAA	PORTC			; output
HEXDISPLAY_LP:		
	LDAA	,X			; GET DISPLAY DIGIT
	JSR	DECODEDISPLAY		; DECODE DISPLAY
	STAA	PORTA			; OUT TO PORTA
	LDAA	#$00			; SET WRITE STROBE
	STAA	PORTC			; OUT TO PORTC
	JSR	PAUSE			; DELAY
	LDAA	#$40			; SET CONTROL PORT OFF
	STAA	PORTC			; OUT TO PORTC
	JSR	PAUSE			; WAIT
	DEX				; INC POINTER
	DECB				;
	CMPB	#$00
	BNE	HEXDISPLAY_LP		; LOOP FOR NEXT DIGIT
	PULS	B			; RESTORE B
	PULS	A			; RESTORE A
	RTS

*__DECODEDISPLAY_____________________________________________________________________________________
*
*  Display contents of DISPLAYBUF in decoded Hex bits 0-3 are displayed dig, bit 7 is DP
*     
*____________________________________________________________________________________________________
DECODEDISPLAY:
	PSHS	B			; STORE B
	PSHS	X			; STORE X
	LDX	#SEGDECODE		; POINT X TO DECODE TABLE
	TAB				;
	LDAA	B,X			; GET VALUE
	PULS	X			; RESTORE HL
	PULS	B			; RESTORE BC
	RTS


*__SEGDISPLAY________________________________________________________________________________________
*
*  Display contents of DISPLAYBUF in RAW dig, bit 7 is DP
*     
*____________________________________________________________________________________________________
SEGDISPLAY:
	PSHS	A			; STORE A
	PSHS	B			; STORE B
	LDAB	#$07	
	ABX
	LDAB	#$08			; SET DIGIT COUNT
	LDAA	#$40			; set Control port 7218 to off
	STAA	PORTC			; output
	JSR 	PAUSE			; wait
	LDAA	#$F0			; set control to 1111 (Data Coming, Hex Decode,NO Decode, Normal)
	STAA	PORTA			; output to port
	LDAA	#$80			; Strobe write pulse with Control=1
	STAA	PORTC			; output to port
	JSR 	PAUSE			; wait
	LDAA	#$40			; set Control port 7218 to off
	STAA	PORTC			; output
SEGDISPLAY_LP:		
	LDAA	,X			; GET DISPLAY DIGIT
	DEX
	STAA	PORTA			; OUT TO PORTA
	LDA	#$00			; SET WRITE STROBE
	STAA	PORTC			; OUT TO PORTC
	JSR	PAUSE			; DELAY
	LDAA	#$40			; SET CONTROL PORT OFF
	STAA	PORTC			; OUT TO PORTC
	JSR	PAUSE			; WAIT
	DECB				; INC POINTER
	CMPB	#$00			;
	BNE	SEGDISPLAY_LP		; LOOP FOR NEXT DIGIT
	PULS	B			; RESTORE B
	PULS	A			; RESTORE A
	RTS


*_KB Decode Table__________________________________________________________________________________________________________
* 
*
KB_Decode:
*                0  1   2   3   4   5   6   7   8   9   A   B   C   D   E   F
	FCB	$41,$02,$42,$82,$04,$44,$84,$08,$48,$88,$10,$50,$90,$20,$60,$A0
*               FW  BK  CL  EN  DP  EX  GO  BO
	FCB	$01,$81,$C1,$C2,$C4,$C8,$D0,$E0
*
* F-Keys,
* PR = PORT READ
* PW = PORT WRITE
* CL = Clear
* EN = Enter
* DP = Deposit (into mem)
* EX = Examine (Mem)
* GO = GO
* BO = Boot
*_________________________________________________________________________________________________________________________

*_Text Strings____________________________________________________________________________________________________________
* 

DISPLAYBUF:
	FCB 	00,00,00,00,00,00,00,00
CPUUP:
	FCB 	$84,$EE,$BB,$80,$BB,$EE,$CB,$84

SEGDECODE:
	FCB	$FB,$B0,$ED,$F5,$B6,$D7,$DF,$F0,$FF,$F7,$FE,$9F,$CB,$BD,$CF,$CE,$80,$84
*_________________________________________________________________________________________________________________________




