	.msfirst
;__R09SADS__________________________________________________________________________________________
;
;	MINI ROM MONITOR FOR THE N8VEM 6809 HOST PROCESSOR (WITH I/O BOARD, STAND ALONE, DSKY)
;
;	WRITTEN BY: DAN WERNER -- 06/26/2010
;	based on the ROM by Andrew Lynch
;
;__________________________________________________________________________________________________
;
;


BROM 	EQU	1		LET DEVICE DRIVERS KNOW CODE IS IN ROM
;
; DATA CONSTANTS
;__________________________________________________________________________________________________
;REGISTER		IO PORT		; FUNCTION


DRIVE	EQU	0		DRIVE ID (ADDRESS)
NCYL	EQU	1		NUMBER OF CYLINDERS
NHEAD	EQU	2		NUMBER OF HEADS
NSEC	EQU	3		NUMBER OF SECTORS/TRACK
CYL	EQU	4		CURRENT CYLINDER
HEAD	EQU	5		CURRENT HEAD
SEC	EQU	6		CURRENT SECTOR

*
* HARDWARE I/O ADDRESSES
*
PORTA	EQU 	$F01F
PORTB	EQU 	$F010
PORTC	EQU 	$F02F	

DDRA	EQU 	$F013
DDRB	EQU 	$F012
DDRC	EQU 	$F023


	ORG	$F800


;__________________________________________________________________________________________________
;
; 	INITIALIZE 6809
;__________________________________________________________________________________________________	
MAIN:
	LDS	#STACK			; RESET STACK POINTER
	CLRA			        ; set direct page register to 0
	TFR	A,DPR			;
	CLRA				; CLEAR ACCUMULATOR A



;__FRONT_PANEL_STARTUP___________________________________________________________________________________________________________ 
;
;	START UP THE SYSTEM WITH THE FRONT PANEL INTERFACE
;	
;________________________________________________________________________________________________________________________________
;
	JSR    	MTERM_INIT		; INIT PIO FOR MTERM
FRONTPANELLOOP:	

	LDX	#CPUUP			; SET POINTER TO DATA BUFFER
	JSR	SEGDISPLAY		; DISPLAY 
FRONTPANELLOOP1:		
	JSR	KB_GET			; GET KEY FROM KB

	CMPA	#$14			; IS DEPOSIT?
	LBEQ	DODEPOSIT		; YES, JUMP
	CMPA	#$15			; IS EXAMINE?
	LBEQ	DOEXAMINE		; YES, JUMP
	CMPA	#$16			; IS GO?
	LBEQ	DOGO			; YES, JUMP
	CMPA	#$17			; IS BO?
	LBEQ	DOBOOTMENU		; YES, JUMP

	BRA	FRONTPANELLOOP1		; LOOP
EXIT:
	RTS	


;__DOBOOTMENU____________________________________________________________________________________________________________________ 
;
;	PERFORM BOOT FRONT PANEL ACTION
;________________________________________________________________________________________________________________________________
;
DOBOOTMENU:

	LDX	#BOOT			; SET POINTER TO DATA BUFFER
	JSR	SEGDISPLAY		; DISPLAY 
	JSR	KB_GET			; GET KEY FROM KB

	CMPA	#$00			; IS DEPOSIT?
	LBEQ	BOOTF			; YES, JUMP
	CMPA	#$01			; IS EXAMINE?
	LBEQ	BOOTH			; YES, JUMP
	BRA	FRONTPANELLOOP		; YES, JUMP



;__DOGO__________________________________________________________________________________________________________________________ 
;
;	PERFORM GO FRONT PANEL ACTION
;________________________________________________________________________________________________________________________________
;
DOGO:
	JSR 	GETADDR			; GET ADDRESS INTO HL
	PSHS	X			;
	RTS				; GO THERE!



;__DODEPOSIT________________________________________________________________________________________________________________________ 
;
;	PERFORM DEPOSIT FRONT PANEL ACTION
;________________________________________________________________________________________________________________________________
;
DODEPOSIT:
	JSR 	GETADDR			; GET ADDRESS INTO HL	
DODEPOSIT1:	
	PSHS 	X			; STORE X FOR LATER USE 
	PSHS	X			; STORE X FOR LOW BYTE DISPLAY
	PSHS	X			; MOVE X TO D
	PULS	D			;
DEPOSITLOOP:
	ANDA	#$F0			; CLEAR LOW NIBBLE
	LSRA				; SHIFT HIGH TO LOW NIBBLE
	LSRA				;
	LSRA				;
	LSRA				;
	STAA	DISPLAYBUF+7		; DISPLAY
	PULS	D			; RESTORE D AND MOVE BACK TO STACK
	PSHS	D			;
	ANDA	#$0F			; CLEAR HIGH NIBBLE
	STAA	DISPLAYBUF+6		; DISPLAY
	ANDA	#$F0			; CLEAR LOW NIBBLE
	LSRB				; SHIFT HIGH TO LOW NIBBLE
	LSRB				;
	LSRB				;
	LSRB				;
	STAB	DISPLAYBUF+5		; DISPLAY
	PULS	D			; RESTORE VALUE
	ANDB	#$0F			; CLEAR HIGH NIBBLE
	STAB	DISPLAYBUF+4		; DISPLAY
	LDAA	#$10			; CLEAR DIGITS ON DISPLAY
	STAA	DISPLAYBUF+3		;
	STAA	DISPLAYBUF+2		;
	JSR	GETVALUE		; GET VALUE TO STORE
	PULS	X			; RESTORE STORAGE ADDRESS
	STAA	,X			; STORE VALUE			
DEPOSITGETKEY:
	JSR	KB_GET			; GET KEY FROM KB
	CMPA	#$12			; [CL] PRESSED, EXIT
	LBEQ	DEPOSITEXIT		;
	CMPA	#$13			; [EN] PRESSED, INC ADDRESS AND LOOP
	LBEQ	DEPOSITFW		; 
	CMPA	#$14			; [DE] PRESSED, PROMPT FOR NEW ADDRESS
	BEQ	DODEPOSIT		;
	BRA	DEPOSITGETKEY		; NO VALID KEY, LOOP
DEPOSITFW:
	INX				; INC ADDRESS AND GET NEXT VALUE
	BRA 	DODEPOSIT1		;	
DEPOSITEXIT:
	JMP	FRONTPANELLOOP		; GO BACK TO MAIN LOOP



;__DOEXAMINE________________________________________________________________________________________________________________________ 
;
;	PERFORM EXAMINE FRONT PANEL ACTION
;________________________________________________________________________________________________________________________________
;
DOEXAMINE:
	JSR 	GETADDR			; GET ADDRESS INTO X
DOEXAMINE1:	
	PSHS	X			; MOVE X TO D
	PULS	D			;
EXAMINELOOP:
	ANDA	#$F0			; CLEAR LOW NIBBLE
	LSRA				; SHOW HIGH NIBBLE IN DISP 7
	LSRA				;
	LSRA				;
	LSRA				;
	STAA	DISPLAYBUF+7		;
	PULS	D			; RESTORE VALUE TO D AND PUSH BACK TO STACK
	PSHS	D			;
	ANDA	#$0F			; CLEAR HIGH NIBBLE
	STAA	DISPLAYBUF+6		; DISPLAY LOW NIBBLE IN DISP 6
	ANDB	#$F0
	LSRB				; SHOW HIGH NIBBLE IN DISP 5
	LSRB				;
	LSRB				;
	LSRB				;
	STAB	DISPLAYBUF+5		;
	PULS	D			; RESTORE VALUE TO D
	PSHS	D			; STORE VALUE FROM D
	ANDB	#$0F			; CLEAR HIGH NIBBLE
	STAB	DISPLAYBUF+4		; DISPLAY LOW NIBBLE IN DISP 6
	LDAA	#$10			; CLEAR OUT DISP 2 & 3
	STAA	DISPLAYBUF+3		;
	STAA	DISPLAYBUF+2		;
	LDAA	,X			; GET VALUE FROM ADDRESS IN X
	ANDA	#$F0			;
	LSRA				; DISPLAY HIGH NIB IN DISPLAY 1
	LSRA				;
	LSRA				;
	LSRA				;
	STAA	DISPLAYBUF+1		;
	LDAA	,X			; GET VALUE FROM ADDRESS IN X                                   
	ANDA	#$0F			; CLEAR OUT HIGH NIBBLE
	STAA	DISPLAYBUF		; DISPLAY LOW NIBBLE IN DISPLAY 0
	LDX	DISPLAYBUF		; POINT TO DISPLAY BUFFER
	JSR	HEXDISPLAY		; DISPLAY BUFFER ON DISPLAYS
	PULS	X			; RESTORE HL
EXAMINEGETKEY:
	JSR	KB_GET			; GET KEY FROM KB
	CMPA	#$12			; [CL] PRESSED, EXIT
	LBEQ	EXAMINEEXIT		;
	CMPA	#$13			; [EN] PRESSED, INC ADDRESS AND LOOP
	LBEQ	EXAMINEFW		; 
	CMPA	#$15			; [DE] PRESSED, PROMPT FOR NEW ADDRESS
	BEQ	DOEXAMINE		;
	BRA	EXAMINEGETKEY		; NO VALID KEY, LOOP
EXAMINEFW:
	INX				; X++
	BRA 	DOEXAMINE1		;	
EXAMINEEXIT:
	JMP	FRONTPANELLOOP		;


;__GETADDR_______________________________________________________________________________________________________________________ 
;
;	GET ADDRESS FROM FRONT PANEL
;________________________________________________________________________________________________________________________________
;
GETADDR:
	PSHS	D			; STORE D
	BRA	GETADDRCLEAR		; 
GETADDR1:
	LDX	#ADDR			; DISPLAY PROMPT
	JSR	SEGDISPLAY		; 
GETADDRLOOP:
	JSR	KB_GET			; GET KEY
	CMPA	#$10			;
	LBMI	GETADDRNUM		; NUMBER PRESSED, STORE IT
	CMPA	#$13			; EN PRESSED, DONE
	LBEQ	GETADDRDONE		;
	CMPA	#$12			; CLEAR PRESSED, CLEAR
	LBEQ	GETADDRCLEAR		; 
	BRA	GETADDRLOOP		; INVALID KEY, LOOP
GETADDRDONE:
	LDAA	DISPLAYBUF+1		; GET DIGIT IN DISPLAY 1
	ASLA				; ROTATE IT TO HIGH NIBBLE
	ASLA				;
	ASLA				;
	ASLA				;
	STAA	TEMPW			; STORE IT IN "A"	
	LDAB	DISPLAYBUF		; GET DIGIT IN DISPLAY 0
	ANDB	#$0F			; CLEAR HIGH NIBBLE
	ADDB	TEMPW
	LDAA	DISPLAYBUF+3		; GET DIGIT IN DISPLAY 3
	ASLA				; ROTATE IT TO HIGH NIBBLE
	ASLA				;
	ASLA				;
	ASLA				;
	STAA	TEMPW			;
	LDAA	DISPLAYBUF+2		; GET DIGIT IN DISPLAY 2	
	ANDA	#$0F			; CLEAR HIGH NIBBLE
	ADDA	TEMPW	
	PSHS	D			;
	PULS	X			;
	LDAA	#$10			; CLEAR OUT DISPLAYS 0,1,2 & 3
	STAA	DISPLAYBUF		;
	STAA	DISPLAYBUF+1		;
	STAA	DISPLAYBUF+2		;
	STAA	DISPLAYBUF+3		;	
	PULS	D,PC			; RESTORE D & RETURN
GETADDRNUM:
	PSHS	A			; STORE A
	LDAA	DISPLAYBUF+2		; SHIFT BYTES IN DISPLAY BUF TO THE LEFT
	STAA    DISPLAYBUF+3		;
	LDAA	DISPLAYBUF+1		;	
	STAA	DISPLAYBUF+2		;
	LDAA	DISPLAYBUF		;	
	STAA	DISPLAYBUF+1		;
	PULS	A			; DISPLAY KEYSTROKE IN RIGHT MOST DISPLAY (0)
	STAA	DISPLAYBUF		;
	BRA	GETADDRDISP		;
GETADDRCLEAR:
	LDAA	#$12			; CLEAR OUT DISPLAYS 0,1,2 & 3
	STAA	DISPLAYBUF		;
	STAA	DISPLAYBUF+1		;
	STAA	DISPLAYBUF+2		;
	STAA	DISPLAYBUF+3		;	
GETADDRDISP:
	LDAA	DISPLAYBUF		; ENCODE DIGITS IN DISPLAY BUFFER TO DISPLAY
	JSR 	DECODEDISPLAY		;
	STAA	ADDR			;
	LDAA	DISPLAYBUF+1		;
	JSR 	DECODEDISPLAY		;
	STAA	ADDR+1			;
	LDAA	DISPLAYBUF+2		;
	JSR 	DECODEDISPLAY		;
	STAA	ADDR+2			;
	LDAA	DISPLAYBUF+3		;
	JSR 	DECODEDISPLAY		;
	STAA	ADDR+3			;
	JMP	GETADDR1		;





;__GETVALUE______________________________________________________________________________________________________________________ 
;
;	GET VALUE FROM FRONT PANEL
;________________________________________________________________________________________________________________________________
;
GETVALUE:
	PSHS	B			; STORE B
	LDAA	#$12			;
	STAA	DISPLAYBUF		;
	STAA	DISPLAYBUF+1		;
GETVALUE1:
	JSR	HEXDISPLAY		; 	
GETVALUELOOP:
	JSR	KB_GET			;	
	CMPA	#$10			;
	BMI	GETVALUENUM		; NUMBER PRESSED, STORE IT
	CMPA	#$13			; EN PRESSED, DONE
	LBEQ	GETVALUEDONE		;
	CMPA	#$12			; CLEAR PRESSED, CLEAR
	LBEQ	GETVALUECLEAR		; 
	BRA	GETVALUELOOP		; INVALID KEY, LOOP
GETVALUEDONE:
	LDAA	DISPLAYBUF+1		;
	ASLA				;
	ASLA				;
	ASLA				;
	ASLA				;
	STAA	TEMPW			;
	LDAB	DISPLAYBUF		;	
	ANDB	#$0F			;
	ADDB	TEMPW			;
	LDAA	#$10			;
	STAA	DISPLAYBUF		;
	STAA	DISPLAYBUF+1		;
	TBA				;
	PULS	B,PC			; RESTORE B		
GETVALUENUM:
	STAA	TEMPW			;
	LDAA	DISPLAYBUF		;	
	STAA	DISPLAYBUF+1		;
	LDAA	TEMPW			;
	STAA	DISPLAYBUF+0		;
	BRA	GETVALUE1		;
GETVALUECLEAR:

	
;__MTERM_INIT________________________________________________________________________________________
;
;  SETUP 8255, MODE 0, PORT A=OUT, PORT B=IN, PORT C=OUT/OUT 
;     
;____________________________________________________________________________________________________
MTERM_INIT:
	LDAA	#$FF			;
	STAA	DDRA			;
	STAA	DDRC			;
	LDAA	#$00			;
	STAA	DDRB			;
	RTS
*__KB_Get____________________________________________________________________________________________
*
*  Get a Single Key and Decode
*     
*____________________________________________________________________________________________________
KB_Get:
	PSHS	X			;
KB_Get_Loop:				; WAIT FOR KEY
	JSR	KB_Scan			;  Scan KB Once
	CMPA	#$00			;  Null?
	BEQ 	KB_Get_Loop		;  Loop while not zero
	PSHS	A
	LDA	#$4F			;  Scan All Col Lines
	STAA 	PORTC			;  Send to Column Lines
        JSR    	KB_Scan_Delay		;  Delay to allow lines to stabilize
KB_Clear_Loop:				; WAIT FOR KEY TO CLEAR
	LDAA	PORTB			;  Get Rows
	CMPA	#$00 			;  Anything Pressed?
	BNE	KB_Clear_Loop		;  Yes, Exit.
	PULS	A			;  Restore A	
	LDAB	#$00			;
	LDX	#KB_Decode		;  Point to beginning of Table	
KB_Get_LLoop:
	CMPA	,X+			;
	BEQ	KB_Get_Done		;  Found, Done
	INCB				;  B + 1	
	BNE	KB_Get_LLoop		;  Not Found, Loop until EOT			
KB_Get_Done:
	TFR	B,A			;  Result Into A
	PULS	X,PC			;



*__KB_Scan____________________________________________________________________________________________
*
*  SCan Keyboard Matrix for an input
*     
*____________________________________________________________________________________________________
KB_Scan:

	LDAA    #$00			;
	STAA	KB_TEMP			;  
	LDAA	#$41			;  Scan Col One
	STAA 	PORTC			;  Send to Column Lines
        JSR     KB_Scan_Delay		;  Delay to allow lines to stabilize
	LDAA	PORTB			;  Get Rows
	CMPA	#$00 			;  Anything Pressed?
	BNE	KB_Scan_Found		;  Yes, Exit.

	LDAA    #$40			;
	STAA	KB_TEMP			;  
	LDAA	#$42			;  Scan Col Two
	STAA 	PORTC			;  Send to Column Lines
        JSR 	KB_Scan_Delay		;  Delay to allow lines to stabilize
	LDAA	PORTB			;  Get Rows
	CMPA	#$00 			;  Anything Pressed?
	BNE	KB_Scan_Found		;  Yes, Exit.

	LDAA    #$80			;
	STAA	KB_TEMP			;  
	LDAA	#$44			;  Scan Col Three
	STAA 	PORTC			;  Send to Column Lines
        JSR  	KB_Scan_Delay		;  Delay to allow lines to stabilize
	LDAA	PORTB			;  Get Rows
	CMPA	#$00 			;  Anything Pressed?
	BNE	KB_Scan_Found		;  Yes, Exit.

	LDAA    #$C0
	STAA	KB_TEMP			;  
	LDAA	#$48			;  Scan Col Four
	STAA 	PORTC			;  Send to Column Lines
        JSR	KB_Scan_Delay		;  Delay to allow lines to stabilize
	LDAA	PORTB			;  Get Rows
	CMPA	#$00 			;  Anything Pressed?
	BNE	KB_Scan_Found		;  Yes, Exit.

	LDAA	#$40			;  Turn off All Columns
	STAA	PORTC			;  Send to Column Lines
	LDAA	#$00			;  RETURN NULL
	RTS				;  Exit

KB_Scan_Found:
	ANDA	#$3F			;  Clear Top two Bits
	ORA	KB_TEMP			;  Add in Row Bits 
	PSHS	A			;  Store Value
	LDAA	#20			;
	JSR	MS_DELAY		;
KB_Scan_DEBOUNCE:
	LDAA	PORTB			;  Get VALUE
	CMPA	#$00 			;  Anything Pressed?
	BNE	KB_Scan_DEBOUNCE	;  Yes, Loop.
	LDAA	#$40			;  Turn off All Columns
	STAA	PORTC			;  Send to Column Lines
	PULS	A,PC			;  Restore Value

PAUSE:
KB_Scan_Delay:
	NOP				;
	NOP				;
	NOP				;
	NOP				;
	NOP				;
	NOP				;
	NOP				;
	NOP				;
	NOP				;
	NOP				;
	RTS

*__MS_DELAY___________________________________________________________________________________________
*
*  DELAY FOR (A) MILLISECONDS (A/2 @ 2MHZ)
*     
*____________________________________________________________________________________________________	
MS_DELAY:
	PSHS	B,CC			;
DLY1:					;
	LDAB	#$C3			;
DLY:					;
	DECB				;
	BNE	DLY			;
	DECA				;
	BNE	DLY1			;
	PULS	B,CC,PC			;
	


*__HEXDISPLAY________________________________________________________________________________________
*
*  Display contents of DISPLAYBUF in decoded Hex bits 0-3 are displayed dig, bit 7 is DP
*     
*____________________________________________________________________________________________________
HEXDISPLAY:
	PSHS	D,X			; STORE D & X
	LDX	#DISPLAYBUF+7
	LDAB	#$08			; SET DIGIT COUNT
	LDAA	#$40			; set Control port 7218 to off
	STAA	PORTC			; output
	BSR 	PAUSE			; wait
	LDAA	#$F0			; set control to 1111 (Data Coming, Hex Decode,NO Decode, Normal)
	STAA	PORTA			; output to port
	LDAA	#$80			; Strobe write pulse with Control=1
	STAA	PORTC			; output to port
	BSR 	PAUSE			; wait
	LDAA	#$40			; set Control port 7218 to off
	STAA	PORTC			; output
HEXDISPLAY_LP:		
	LDAA	,X			; GET DISPLAY DIGIT
	JSR	DECODEDISPLAY		; DECODE DISPLAY
	STAA	PORTA			; OUT TO PORTA
	LDAA	#$00			; SET WRITE STROBE
	STAA	PORTC			; OUT TO PORTC
	BSR	PAUSE			; DELAY
	LDAA	#$40			; SET CONTROL PORT OFF
	STAA	PORTC			; OUT TO PORTC
	BSR	PAUSE			; WAIT
	DEX				; INC POINTER
	DECB				;
	CMPB	#$00
	BNE	HEXDISPLAY_LP		; LOOP FOR NEXT DIGIT
	PULS	D,X,PC			; RESTORE D,X AND RETURN

*__DECODEDISPLAY_____________________________________________________________________________________
*
*  Display contents of DISPLAYBUF in decoded Hex bits 0-3 are displayed dig, bit 7 is DP
*     
*____________________________________________________________________________________________________
DECODEDISPLAY:
	PSHS	B,X			; STORE B & X
	LDX	#SEGDECODE		; POINT X TO DECODE TABLE
	TAB				;
	LDAA	B,X			; GET VALUE
	PULS	B,X,PC			; RESTORE B & X, AND RETURN


*__SEGDISPLAY________________________________________________________________________________________
*
*  Display contents of DISPLAYBUF in RAW dig, bit 7 is DP
*     
*____________________________________________________________________________________________________
SEGDISPLAY:
	PSHS	D			; STORE D
	LDAB	#$07	
	ABX
	LDAB	#$08			; SET DIGIT COUNT
	LDAA	#$40			; set Control port 7218 to off
	STAA	PORTC			; output
	BSR 	PAUSE			; wait
	LDAA	#$F0			; set control to 1111 (Data Coming, Hex Decode,NO Decode, Normal)
	STAA	PORTA			; output to port
	LDAA	#$80			; Strobe write pulse with Control=1
	STAA	PORTC			; output to port
	JSR 	PAUSE			; wait
	LDAA	#$40			; set Control port 7218 to off
	STAA	PORTC			; output
SEGDISPLAY_LP:		
	LDAA	,X			; GET DISPLAY DIGIT
	DEX
	STAA	PORTA			; OUT TO PORTA
	LDA	#$00			; SET WRITE STROBE
	STAA	PORTC			; OUT TO PORTC
	JSR	PAUSE			; DELAY
	LDAA	#$40			; SET CONTROL PORT OFF
	STAA	PORTC			; OUT TO PORTC
	JSR	PAUSE			; WAIT
	DECB				; INC POINTER
	CMPB	#$00			;
	BNE	SEGDISPLAY_LP		; LOOP FOR NEXT DIGIT
	PULS	D,PC			; RESTORE 


;__________________________________________________________________________________________________
;
; 	BOOT FROM FLOPPY, TRACK 78 & 79, H 0 & 1
;__________________________________________________________________________________________________	
	
BOOTF:
	JSR	SETUPDRIVE		; INIT FLOPPY DRIVER
	LDU	#$1000			; SETUP DISK CONTROL BLOCK
	LDAA	#$01			; SET DRIVE ONE
	STAA	DRIVE,U			; 
	LDAA	#$02			; SET NUMBER OF HEADS
	STAA	NHEAD,U			;
	LDAA	#$09			; SET NUMBER OF SECTORS PER TRACK
	STAA	NSEC,U			;
	LDAA	#80			; SET NUMBER OF TRACKS PER DISK
	STAA	NCYL,U			;
	LDAA	#78			; SET STARTING TRACK
	STAA	CYL,U			;
	CLRA				; START ON HEAD '0'
	STAA	HEAD,U			;
	STAA	SEC,U			; START ON SECTOR '0'
	JSR	SETTRACK		;
	LDX	#$C700			; LOAD CUBIX TO $C700 
	JMP 	DOBOOT			; DO IT!

;__________________________________________________________________________________________________
;
; 	BOOT FROM HDD, TRACK $FD & $FE, H 0 
;__________________________________________________________________________________________________	
BOOTH:
	JSR	IDE_SOFT_RESET		; INIT IDE DRIVER
	LDU	#$1000			; SETUP DISK CONTROL BLOCK
	LDAA	#$00			; SET DRIVE 0
	STAA	DRIVE,U			;
	LDAA	#$01			; SET NUMBER OF HEADS
	STAA	NHEAD,U			;		
	LDAA	#$FF			; SET NUMBER OF SECTORS
	STAA	NSEC,U			;
	LDAA	#$FF			; SET NUMBER OF TRACKS
	STAA	NCYL,U			;
	LDAA	#$FD			; START ON TRACK $FD
	STAA	CYL,U			;
	CLRA				; START ON HEAD 0
	STAA	HEAD,U			;
	STAA	SEC,U			; START ON SECTOR 0
	LDX	#$C700			; LOAD CUBIX TO $C700
	JMP 	DOBOOT			; DO IT!

	
			
DOBOOT:
	IFD	BDSKY			; IF DSKY ENABLED, DISPLAY PROGRESS ON DSKY
	JSR	SEGDISPLAY		;
	ENDIF				;
	LDAA	DRIVE,U			; IF DRIVE = 1 
	BNE	BOOTFL			;  NO, READ FLOPPY SECTOR
	JSR	IDE_READ_SECTOR		; YES, READ IDE SECTOR
	JMP 	BOOTCONT		; CONTINUE
BOOTFL:		
	PSHS	X			; STORE CURRENT STORAGE LOCATION
	JSR	READFL			; READ FLOPPY SECTOR
	CMPA	#$03			; IS ERROR?
	BHS	BOOTRETRY		; YES, RETRY READ
	PULS	D			; PULL STORAGE LOCATION
	ADDD	#$0200			; ADVANCE STORAGE LOCATION BY SECTOR SIZE
	PSHS	D			; MOVE BACK TO X
	PULS	X			;
BOOTCONT:
	CPX	#$F000			; ARE WE DONE?
	BHS	BOOTDONE		; YES, EXIT 
	LDAA	SEC,U			; NO, INC CURRENT SECTOR
	INCA				;
	STAA	SEC,U			; STORE IT
	CMPA	NSEC,U			; AT END OF TRACK?
	BNE	DOBOOT			; NO, LOOP
	CLRA				; YES, GO BACK TO SECTOR 0
	STAA	SEC,U			; 
	LDAA	HEAD,U			; INC HEAD NUMBER
	INCA				;
	STAA	HEAD,U			;
	CMPA	NHEAD,U			; AT LAST HEAD?
	BNE	DOBOOT			; NO, LOOP
	CLRA				; YES, GO BACK TO HEAD 0
	STAA	SEC,U			;
	STAA	HEAD,U			;
	LDAA	CYL,U			; INC TRACK NUMBER
	INCA				;
	STAA	CYL,U			;
	CMPA	NCYL,U			; AT LAST TRACK?
	BNE	DOBOOT			; NO, LOOP
		
BOOTDONE:
	JMP	$C808			; JUMP TO OS ENTRY POINT
BOOTRETRY:	
					;  ** IF ERROR, RECALIBRATE DRIVE HEAD **
	LDAA	CYL,U			; STORE CURRENT TRACK
	PSHS	A			;
	CLRA				; SEEK TO TRACK 0
	STAA	CYL,U			;
	JSR	SETTRACK		;
	PULS	A			; RESTORE CURRENT TRACK
	STAA	CYL,U			;
	JSR	SETTRACK		; SEEK BACK TO CURRENT TRACK
	PULS	X			; RESTORE CURRENT LOAD ADDRESS
	BRA	DOBOOT			; RESUME BOOT OPERATION

		
;__________________________________________________________________________________________________________	
	
	
	include CUBIXOS\CUBIDE.asm	IDE I/O DRIVERS
	include CUBIXOS\CUBFLP.asm	FLOPPY I/O DRIVERS
	
		


;
;__TEXT_STRINGS_________________________________________________________________________________________________________________ 
;
;	SYSTEM TEXT STRINGS
;_____________________________________________________________________________________________________________________________
;
CPUUP:
	FCB 	$84,$EE,$BB,$80,$BB,$EE,$CB,$84
ADDR:
	FCB 	$00,$00,$00,$00,$8C,$BD,$BD,$FE
BOOT:
	FCB 	$00,$00,$80,$80,$94,$9D,$9D,$9F

;_KB DECODE TABLE__________________________________________________________________________________________________________
; 
;
KB_DECODE:
;                0  1   2   3   4   5   6   7   8   9   A   B   C   D   E   F
	FCB	$41,$02,$42,$82,$04,$44,$84,$08,$48,$88,$10,$50,$90,$20,$60,$A0
;               FW  BK  CL  EN  DP  EX  GO  BO
	FCB	$01,$81,$C1,$C2,$C4,$C8,$D0,$E0
;
; F-KEYS,
; FW = FORWARD
; BK = BACKWARD
; CL = CLEAR
; EN = ENTER
; DP = DEPOSIT (INTO MEM)
; EX = EXAMINE (MEM)
; GO = GO
; BO = BOOT
;_________________________________________________________________________________________________________________________
;_HEX 7_SEG_DECODE_TABLE__________________________________________________________________________________________________
; 
; 0,1,2,3,4,5,6,7,8,9,A,B,C,D,E,F, ,-
; AND WITH 7FH TO TURN ON DP 
;_________________________________________________________________________________________________________________________
SEGDECODE:
	FCB	$FB,$B0,$ED,$F5,$B6,$D7,$DF,$F0,$FF,$F7,$FE,$9F,$CB,$BD,$CF,$CE,$80,$84,$00,$EE,$9D
	

	
; DATA
RESTAB	FCB	3,0,2,0,0,3,4,1

;
;__WORK_AREA___________________________________________________________________________________________________________________ 
;
;	RESERVED RAM FOR MONITOR WORKING AREA
;_____________________________________________________________________________________________________________________________
;
DISPLAYBUF:	EQU	$2131
TEMPW		EQU	$212E




STACK	EQU	$2100		; STACK POINTER

; REGISTERS FOR GO
SP	EQU	$0108		; S-HIGH
	
; END REGISTERS FOR GO
CKSM	EQU	$010A		; CHECKSUM
BYTECT	EQU	$010B		; BYTE COUNT
XHI	EQU	$010C		; XREG HIGH
XLOW	EQU	$010D		; XREG LOW

KB_TEMP	EQU	$2130		; KB WORK AREA


* CUBIX WITH NO VDU SPACE
*	org	$FFF2
*	FCW	$E75C
*	FCW	$E758
*	FCW	$E764
*	FCW	$E760
*	FCW	$E754
*	FCW	$E768
* CUBIX WITH VDU SPACE	
	org	$FFF2
	FCW	$DE5C
	FCW	$DE58
	FCW	$DE64
	FCW	$DE60
	FCW	$DE54
	FCW	$DE68

 	ORG	$FFFE		; SET RESET VECTOR TO MAIN PROGRAM
RESETV	FCW	MAIN

	END
