	.msfirst
;__R09SASE__________________________________________________________________________________________
;
;	MINI ROM MONITOR FOR THE N8VEM 6809 HOST PROCESSOR (WITH I/O BOARD, STAND ALONE,SERIAL)
;
;	WRITTEN BY: DAN WERNER -- 06/26/2010
;	based on the ROM by Andrew Lynch
;
;__________________________________________________________________________________________________
;
;
BROM 	EQU	1			LET DEVICE DRIVERS KNOW CODE IS IN ROM
*BDSKY	EQU	1			USE DSKY TO DISPLAY SECTOR INF
;
; DATA CONSTANTS
;__________________________________________________________________________________________________
;REGISTER		IO PORT		; FUNCTION


DRIVE	EQU	0			DRIVE ID (ADDRESS)
NCYL	EQU	1			NUMBER OF CYLINDERS
NHEAD	EQU	2			NUMBER OF HEADS
NSEC	EQU	3			NUMBER OF SECTORS/TRACK
CYL	EQU	4			CURRENT CYLINDER
HEAD	EQU	5			CURRENT HEAD
SEC	EQU	6			CURRENT SECTOR


	ORG	$F800


;__________________________________________________________________________________________________
;
; 	INITIALIZE 6809
;__________________________________________________________________________________________________	
MAIN:
	LDS	#STACK			; RESET STACK POINTER
	CLRA			        ; set direct page register to 0
	TFR	A,DPR			;
	CLRA				; CLEAR ACCUMULATOR A
	JSR	SERIALINIT		; INIT SERIAL PORT
	LDX	#INITMESSAGE		; POINT TO INITIAL MESSAGE
	JSR	DISPLAY_STRING		; DISPLAY THE MESSAGE
						
;__CONTRL_________________________________________________________________________________________
;
; 	MONITOR MAIN LOOP
;__________________________________________________________________________________________________
CONTRL:
	JSR	DISPLAY_CRLF		; DISPLAY CRLF						
	LDAA	#'>'			; CARRIAGE RETURN
	JSR	WRSER1			; OUTPUT CHARACTER
	JSR	IOF_CONINW		;
	JSR	WRSER1			; OUTPUT CHAR TO CONSOLE
					;					
	CMPA	#'D'			; IS DUMP MEMORY?
	BEQ	DUMP			;					
	CMPA	#'L'			; IS LOAD?
	BEQ	MLOAD			; YES, JUMP
	CMPA	#'M'			; IS CHANGE?
	BEQ	CHANGE			; YES, JUMP
	CMPA	#'P'			; IS PRINT?
	BEQ	PRINT			; YES, JUMP
	CMPA	#'G'			; IS GO?
	BEQ	GO			; YES JUMP
	CMPA	#'B'			; IS BOOT?
	BEQ	BOOT			; YES JUMP
					;
					; COMMAND NOT FOUND ISSUE ERROR
	LDAA	#'?'			; PRINT '?'
	JSR	WRSER1			; OUTPUT CHARACTER
	JSR	DISPLAY_CRLF		; DISPLAY CRLF						
	BRA	CONTRL			; RECEIVE NEXT CHARACTER	

MLOAD:
	JMP	LOAD	

;__BOOT____________________________________________________________________________________________
;
; 	PROMPT USER FOR BOOT DEVICE & LAUNCH BOOT CODE
;__________________________________________________________________________________________________			
BOOT:
	LDX	#BOOTMESSAGE		; DISPLAY BOOT MESSAGE
	JSR	DISPLAY_STRING		;
	JSR	DISPLAY_CRLF		; DISPLAY CRLF						
	LDAA	#':'			; CARRIAGE RETURN
	JSR	WRSER1			; OUTPUT CHARACTER
	JSR	IOF_CONINW		; GET USER INPUT
	JSR	WRSER1			; OUTPUT CHAR TO CONSOLE
					;					
	CMPA	#'F'			; USER SELECT FLOPPY?
	LBEQ	BOOTF			; YES, BOOT FLOPPY			
	CMPA	#'H'			; USER SELECT HDD?
	LBEQ	BOOTH			; YES, BOOT HDD
	BRA	CONTRL			; INVALID USER INPUT, LOOP TO BEGINNING

;__DUMP____________________________________________________________________________________________
;
; 	PROMPT USER FOR START AND END ADDRESSES, THEN DUMP MEMORY
;__________________________________________________________________________________________________					
DUMP:
	JSR 	OUTS			; PRINT A SPACE
	JSR	BADDR			; GET STARTING ADDRESS INTO X
	PSHS	X			; STORE X
	JSR	OUTS			; PRINT A SPACE
	JSR	BADDR			; GET ENDING ADDRESS INTO X
	PULS	X			; RESTORE X (ENDING ADDRESS STILL IN XHI)
	JSR	DISPLAY_CRLF		; PRINT A CRLF
DUMP_LOOP:	
	JSR	DUMP_LINE		; DUMP ONE LINE
	CMPX	XHI			; ARE WE AT THE END?
	BMI	DUMP_LOOP		; NO, LOOP
	BRA	CONTRL			; RETURN TO MAIN LOOP	

;__GO______________________________________________________________________________________________
;
; 	PROMPT USER FOR ADDRESS, THEN TRANSFER EXECUTION
;__________________________________________________________________________________________________					
GO:
	JSR	BADDR			; GET ADDRESS
	JSR	OUTS			; PRINT SPACE
	LDX	XHI			; LOAD X WITH ADDRESS
	JMP	$0000,X			; JUMP TO ADDRESS

;__CHANGE__________________________________________________________________________________________
;
; CHANGE MEMORY(M AAAA DD NN)
;__________________________________________________________________________________________________					
CHANGE:
	JSR	BADDR			; BUILD ADDRESS
	JSR	OUTS			; PRINT SPACE
	JSR	OUT2HS			; PRINT CURRENT BYTE AT ADDRESS POINTED TO BY X, THEN SPACE
	JSR	BYTE			; GET BYTE FROM KEYBOARD
	DEX				; GO BACK TO ADDRESS
	STAA,X				; STORE BYTE
	CMPA,X				; IF MEMORY DID NOT CHANGE
	BNE	LOAD19			;    SINAL ERROR
	JMP	CONTRL			; RETURN TO MAIN LOOP

;__PRINT____________________________________________________________________________________________
;
; PRINT CONTENTS OF STACK
;___________________________________________________________________________________________________					
PRINT:
	STS	SP			; STORE STACK POINTER
	LDX	SP			; RESTORE STACK POINTER TO X
	LDAB	#$09			; PRINT $09 BYTES
PRINT2:					;
	JSR	OUT2HS			; OUT 2 HEX & SPACE
	DECB				; B--
	BNE	PRINT2			; DONE? IF NO DO MORE
	JMP	CONTRL			; DONE? IF YES RETURN TO MAIN LOOP
			
;__LOAD_____________________________________________________________________________________________
;
; LOAD A MOTOROLA FORMAT HEX FILE (.S19) TO MEMORY
;___________________________________________________________________________________________________					

LOAD:
	JSR	IOF_CONINW		; GET INPUT CHAR
	CMPA	#'S'			; IS S?
	BNE	LOAD			; FIRST CHAR NOT (S)
	JSR	IOF_CONINW		; READ CHAR
	CMPA	#'9'			; IS 9?
	BEQ	LOAD21			; YUP, DONE
	CMPA	#'1'			; IS '1'?
	BNE	LOAD			; SECOND CHAR NOT (1), LOOP
	CLR	CKSM			; ZERO CHECKSUM
	JSR	BYTE			; READ BYTE
	SUBA	#$02			;
	STAA	BYTECT			; BYTE COUNT
	BSR	BADDR			; BUILD ADDRESS
					; STORE DATA
LOAD11:
	JSR	BYTE			; READ BYTE 
	DEC	BYTECT			; BYTE COUNT = BYTE COUNT -1
	BEQ	LOAD15			; ZERO BYTE COUNT
	STAA,X				; STORE DATA
	INX				; INC STORAGE ADDRESS
	BRA	LOAD11			; LOOP
	
LOAD15:
	INC	CKSM			; END OF LINE, BUMP CHECKSUM
	BEQ	LOAD			; CHECK FOR NEXT LINE
LOAD19:
	LDAA	#'?'			; REPORT AN ERROR
	JSR	WRSER1			;
LOAD21:
C1	JMP	CONTRL			; RETURN TO MAIN LOOP
	

;__DUMP_LINE________________________________________________________________________________________
;
; DUMP A HEX LINE TO THE CONSOLE
;___________________________________________________________________________________________________					
DUMP_LINE:
	JSR	OUTADDR			; PRINT CURRENT ADDRESS
	JSR	OUTS			; PRINT SPACE
	PSHS	X			; STORE ADDRESS
	LDAB	#$10			; SET COUNTER TO PRINT 16 BYTES	
DUMP_LINE_LOOP:	
	JSR	OUT2HS			; OUT 2 HEX & SPACE
	DECB				; DEC COUNTER
	BNE	DUMP_LINE_LOOP		; DONE? IF NO DO MORE
	PULS	X			; RESTORE ADDRESS
	JSR	OUTS			; PRINT SPACE
	LDAA	#':'			; PRINT ':'
	JSR	WRSER1			; 
	LDAB	#$10			; SET COUNTER TO PRINT 16 CHARS			
DUMP_LINE_LOOPA:		
	LDAA	0,X			; GET BYTE
	CMPA	#32			;  CHECK TO SEE IF BYTE IS ASCII PRINTABLE
	BMI	DUMP_LINE_INVALID	; 
	CMPA	#127			;
	BPL	DUMP_LINE_INVALID	;
	JSR	WRSER1			; YES, IT CAN BE PRINTED, SO PRINT IT
	JMP	DUMP_LINE_VALID		; SKIP OVER INVALID PRINTING
DUMP_LINE_INVALID:			;	
	LDA	#'.'			; NOT VALID CHAR, PRINT '.'
	JSR	WRSER1			;
DUMP_LINE_VALID:			;
	INX				; BUMP ADDRESS	
	DECB				; DEC COUNTER
	BNE	DUMP_LINE_LOOPA		; DONE? IF NO DO MORE	
	JSR	DISPLAY_CRLF		; PRINT CR LF
	RTS				;

	
;__INHEX____________________________________________________________________________________________
;
; INPUT HEX CHARACTER
;___________________________________________________________________________________________________					
INHEX:
	JSR	IOF_CONINW		; GET BYTE FROM CONSOLE
	PSHS	A			; STORE IT
	JSR	WRSER1			; ECHO IT TO CONSOLE
	PULS	A			; RESTORE IT
	CMPA	#$30			; IS A VALID HEX DIGIT (0-9 A,B,C,D,E,F)
	BMI	C1			; NOT HEX
	CMPA	#$39			;
	BLE	IN1HG			; 0-9, GOOD DIGIT
	CMPA	#$41			;
	BMI	C1			; NOT HEX
	CMPA	#$46			;
	BGT	C1			; NOT HEX
	SUBA	#$07			; A-F, SUBTRACT 7 THEN GOOD DIGIT
IN1HG:					;
	RTS				;

	
;__BADDR____________________________________________________________________________________________
;	
; BUILD ADDRESS
;___________________________________________________________________________________________________					
BADDR:
	BSR	BYTE			; READ 2 FRAMES
	STAA	XHI			; STORE HIGH BYTE
	BSR	BYTE			; 
	STAA	XLOW			; STORE LOW BYTE
	LDX	XHI			; (X) ADDRESS WE BUILT
	RTS				;

;__BYTE_____________________________________________________________________________________________
;	
; INPUT BYTE (TWO FRAMES)
;___________________________________________________________________________________________________						
BYTE:
	BSR	INHEX			; GET HEX CHAR
	ASLA				; ROTATE TO HIGH NIBBLE
	ASLA				;
	ASLA				;
	ASLA				;
	TAB				; B=A
	BSR	INHEX			; GET HEX CHAR
	ANDA	#$0F			; MASK TO 4 BITS
	ABA				; A=A+B
	TAB				; B=A
	ADDB	CKSM			; ADD TO CHECKSUM (IN CASE LOADING)
	STAB	CKSM			; STORE CHECKSUM
	RTS				;


;__OUTHL____________________________________________________________________________________________
;	
; OUTPUT HEX NUMBER (LEFT DIGIT)
;___________________________________________________________________________________________________						

OUTHL:
	LSRA				; SHIFT HIGH BITS TO LOW BITS
	LSRA				;
	LSRA				;
	LSRA				;

;__OUTHR____________________________________________________________________________________________
;	
; OUTPUT HEX NUMBER (RIGHT DIGIT)
;___________________________________________________________________________________________________							
OUTHR:					;
	ANDA	#$0F			; FILTER OUT HIGH BITS
	ADDA	#$30			; CHANGE TO ASCII
	CMPA	#$39			; IF 0-9, GO AHEAD AND OUTPUT
	BLS	OUTHR1			;
	ADDA	#$07			; IF A-F ADD 7 THEN OUTPUT
OUTHR1:	
	JMP	WRSER1			; WRITE TO CONSOLE

;__OUT2H____________________________________________________________________________________________
;	
; OUTPUT 8 BIT HEX VALUE OF ADDRESS X
;___________________________________________________________________________________________________								
OUT2H:
	LDAA	0,X			; OUTPUT 2 HEX CHAR
	BSR	OUTHL			; OUT LEFT HEX CHAR
	LDAA	0,X			;
	BSR	OUTHR			; OUT RIGHT HEX CHAR
	INX				; BUMP X
	RTS				;

;__OUTADDR__________________________________________________________________________________________
;	
; OUTPUT 16 BIT HEX ADDRESS X
;___________________________________________________________________________________________________										
OUTADDR:
	PSHS	X		; STORE X
	PULS	A		; GET HIGH BYTE IN A
	PSHS	A		; PUT IT BACK
	BSR	OUTHL		; OUT LEFT HEX CHAR
	PULS	A		; GET HIGH BYTE
	BSR	OUTHR		; OUT RIGHT HEX CHAR
	PULS	A		; GET LOW BYTE
	PSHS	A		; PUT IT BACK
	BSR	OUTHL		; OUT LEFT HEX CHAR
	PULS	A		; GET LOW BYTE
	BSR	OUTHR		; OUT RIGHT HEX CHAR
	RTS			;

;__OUT2HS____________________________________________________________________________________________
;	
; OUTPUT 8 BIT HEX VALUE OF ADDRESS X AND A SPACE
;___________________________________________________________________________________________________										
OUT2HS:
	BSR	OUT2H		; OUTPUT 2 HEX CHAR + SPACE
OUTS:
	LDAA	#$20		; SPACE
	JMP	WRSER1		;

	
;__________________________________________________________________________________________________
;
; 	BOOT FROM FLOPPY, TRACK 78 & 79, H 0 & 1
;__________________________________________________________________________________________________	
	
BOOTF:
	JSR	SETUPDRIVE		; INIT FLOPPY DRIVER
	LDU	#$1000			; SETUP DISK CONTROL BLOCK
	LDAA	#$01			; SET DRIVE ONE
	STAA	DRIVE,U			; 
	LDAA	#$02			; SET NUMBER OF HEADS
	STAA	NHEAD,U			;
	LDAA	#$09			; SET NUMBER OF SECTORS PER TRACK
	STAA	NSEC,U			;
	LDAA	#80			; SET NUMBER OF TRACKS PER DISK
	STAA	NCYL,U			;
	LDAA	#78			; SET STARTING TRACK
	STAA	CYL,U			;
	CLRA				; START ON HEAD '0'
	STAA	HEAD,U			;
	STAA	SEC,U			; START ON SECTOR '0'
	JSR	SETTRACK		;
	LDX	#$C700			; LOAD CUBIX TO $C700 
	JMP 	DOBOOT			; DO IT!

;__________________________________________________________________________________________________
;
; 	BOOT FROM HDD, TRACK $FD & $FE, H 0 
;__________________________________________________________________________________________________	
BOOTH:
	JSR	IDE_SOFT_RESET		; INIT IDE DRIVER
	LDU	#$1000			; SETUP DISK CONTROL BLOCK
	LDAA	#$00			; SET DRIVE 0
	STAA	DRIVE,U			;
	LDAA	#$01			; SET NUMBER OF HEADS
	STAA	NHEAD,U			;		
	LDAA	#$FF			; SET NUMBER OF SECTORS
	STAA	NSEC,U			;
	LDAA	#$FF			; SET NUMBER OF TRACKS
	STAA	NCYL,U			;
	LDAA	#$FD			; START ON TRACK $FD
	STAA	CYL,U			;
	CLRA				; START ON HEAD 0
	STAA	HEAD,U			;
	STAA	SEC,U			; START ON SECTOR 0
	LDX	#$C700			; LOAD CUBIX TO $C700
	JMP 	DOBOOT			; DO IT!

	
			
DOBOOT:
	IFD	BDSKY			; IF DSKY ENABLED, DISPLAY PROGRESS ON DSKY
	JSR	SEGDISPLAY		;
	ENDIF				;
	LDAA	DRIVE,U			; IF DRIVE = 1 
	BNE	BOOTFL			;  NO, READ FLOPPY SECTOR
	JSR	IDE_READ_SECTOR		; YES, READ IDE SECTOR
	JMP 	BOOTCONT		; CONTINUE
BOOTFL:		
	PSHS	X			; STORE CURRENT STORAGE LOCATION
	JSR	READFL			; READ FLOPPY SECTOR
	CMPA	#$03			; IS ERROR?
	BHS	BOOTRETRY		; YES, RETRY READ
	PULS	D			; PULL STORAGE LOCATION
	ADDD	#$0200			; ADVANCE STORAGE LOCATION BY SECTOR SIZE
	PSHS	D			; MOVE BACK TO X
	PULS	X			;
BOOTCONT:
	CPX	#$F000			; ARE WE DONE?
	BHS	BOOTDONE		; YES, EXIT 
	LDAA	SEC,U			; NO, INC CURRENT SECTOR
	INCA				;
	STAA	SEC,U			; STORE IT
	CMPA	NSEC,U			; AT END OF TRACK?
	BNE	DOBOOT			; NO, LOOP
	CLRA				; YES, GO BACK TO SECTOR 0
	STAA	SEC,U			; 
	LDAA	HEAD,U			; INC HEAD NUMBER
	INCA				;
	STAA	HEAD,U			;
	CMPA	NHEAD,U			; AT LAST HEAD?
	BNE	DOBOOT			; NO, LOOP
	CLRA				; YES, GO BACK TO HEAD 0
	STAA	SEC,U			;
	STAA	HEAD,U			;
	LDAA	CYL,U			; INC TRACK NUMBER
	INCA				;
	STAA	CYL,U			;
	CMPA	NCYL,U			; AT LAST TRACK?
	BNE	DOBOOT			; NO, LOOP
		
BOOTDONE:
	JMP	$C808			; JUMP TO OS ENTRY POINT
BOOTRETRY:	
					;  ** IF ERROR, RECALIBRATE DRIVE HEAD **
	LDAA	CYL,U			; STORE CURRENT TRACK
	PSHS	A			;
	CLRA				; SEEK TO TRACK 0
	STAA	CYL,U			;
	JSR	SETTRACK		;
	PULS	A			; RESTORE CURRENT TRACK
	STAA	CYL,U			;
	JSR	SETTRACK		; SEEK BACK TO CURRENT TRACK
	PULS	X			; RESTORE CURRENT LOAD ADDRESS
	BRA	DOBOOT			; RESUME BOOT OPERATION

	
;__DISPLAY_CRLF_____________________________________________________________________________________
;	
; SEND CR & LF TO CONSOLE
;___________________________________________________________________________________________________										
		
DISPLAY_CRLF:	
	LDAA	#$0D			; PRINT CR
	JSR	WRSER1			; OUTPUT CHARACTER
	LDAA	#$0A			; PRINT LF
	JSR	WRSER1			; OUTPUT CHARACTER
	RTS	

;__DISPLAY_STRING___________________________________________________________________________________
;	
; SEND STRING POINTED TO BY X TO CONSOLE
;___________________________________________________________________________________________________										
	
DISPLAY_STRING:	
	LDAA	,X			; GET CHAR
	BEQ	DISPLAY_STRING_END	; IF NULL, EXIT
	JSR	WRSER1			; OUTPUT CHARACTER
	INX				; BUMP INDEX
	BRA	DISPLAY_STRING		; LOOP
DISPLAY_STRING_END:			;
	RTS				;
	
;__IOF_CONINW_______________________________________________________________________________________
;	
; GET CHAR FROM CONSOLE
;___________________________________________________________________________________________________										
	
IOF_CONINW:				;
	JSR	RDSER1			; READ FROM SERIAL DRIVER
	CMPA	#$FF			; WAS A KEY HIT?
	BEQ	IOF_CONINW		; NO, LOOP
	RTS
	
	
	include CUBIXOS\CUBIDE.asm	IDE I/O DRIVERS
	include CUBIXOS\CUBSER.asm	SERIAL I/O DRIVERS
	include CUBIXOS\CUBFLP.asm	FLOPPY I/O DRIVERS

	IFD	BDSKY
	include CUBIXOS\CUBDSKY.asm	DSKY I/O DRIVERS
	ENDIF
	
INITMESSAGE	FCB	$0D,$0A,$0D,$0A
		FCC	'N8VEM 6809 ROM MONITOR READY.'
		FCB	$0D,$0A,$00
		
BOOTMESSAGE	FCB	$0D,$0A
		FCC	'BOOT FROM (F)LOPPY OR (H)DD'
		FCB	$0D,$0A,$00
		

; DATA
RESTAB	FCB	3,0,2,0,0,3,4,1


STACK	EQU	$2100		; STACK POINTER

; REGISTERS FOR GO
SP	EQU	$0108		; S-HIGH
	
; END REGISTERS FOR GO
CKSM	EQU	$010A		; CHECKSUM
BYTECT	EQU	$010B		; BYTE COUNT
XHI	EQU	$010C		; XREG HIGH
XLOW	EQU	$010D		; XREG LOW

* CUBIX WITH NO VDU SPACE
*	org	$FFF2
*	FCW	$E75C
*	FCW	$E758
*	FCW	$E764
*	FCW	$E760
*	FCW	$E754
*	FCW	$E768
* CUBIX WITH VDU SPACE	
	org	$FFF2
	FCW	$DE5C
	FCW	$DE58
	FCW	$DE64
	FCW	$DE60
	FCW	$DE54
	FCW	$DE68

	ORG	$FFFE		; SET RESET VECTOR TO MAIN PROGRAM
RESETV	FCW	MAIN

	END
