	.Z80
;
; ADD CONDITIONAL ASSEMBLY INSTRUCTIONS HERE EITHER  EQU TRUE OR .EQU FALSE
; ALL CONDITIONAL ASSEMBLY GROUPS START WITH CONDXXXX:
; DEFAULT IS TRUE IE THE ORIGINAL INSTRUCTIONS EG IF TSR IS THE ORIGINAL CODE
; SO TO ADD A NEW GROUP SET THE NAME TO FALSE ELSE SET IT TO TRUE FOR THE OLD CODE
FALSE:		 EQU 0
TRUE:		 EQU 1

; LIST OF CONDITIONAL ASSEMBLY INSTRUCTIONS

CONDIDESOFT:	 EQU	TRUE	; IF NO IDE DRIVE, HAS A SIGNIFICANT DELAY ON SOFT BOOT (TRUE) OR QUICK (FALSE)
CONDSHORTMSG	 EQU	TRUE	; TRUE FOR ORIGINAL WARM BOOT SIGNON, FALSE FOR SHORTER ONE WITH LESS <CR>
CONDSUPERSUB	 EQU	TRUE	; TRUE FOR NO SUPERSUB AUTOEXEC, FALSE TO RUN SUPERSUB AUTOEXEC
CONDABONLY    	 EQU    TRUE   ; TRUE FOR ORIGINAL, FALSE TO ONLY HAVE DRIVE A AND B

CONDUSEVDU	 EQU    FALSE   ; TRUE FOR USE VDU CARD, FALSE TO USE SERIAL PORT (FOR CONSOLE)
CONDUSEFLOPPY	 EQU    FALSE   ; TRUE FOR USE FLOPPY, FALSE FOR NO FLOPPY DRIVE
CONDUSEATAPI	 EQU    FALSE   ; TRUE FOR USE ZIP DISK, FALSE FOR NO ZIP DISK

; POINTERS TO VDU ROUTINES IN HIGH ROM BANK (NOT NEEDED IF NOT USING VDU CARD)

VDU_INIT	 EQU	0100H
IS_KBHIT	 EQU  	0395H
GET_KEY		 EQU	039CH
CHARIN		 EQU	011BH
PR_OUTCHAR	 EQU	0CD6H

;


;


;
;**************************************************************
;*
;*        C B I O S  F O R
;*
;*  T E S T   P R O T O T Y P E
;*
;*  BY ANDREW LYNCH, WITH INPUT FROM MANY SOURCES
;*
;**************************************************************
;
;	SKELETAL CBIOS FOR FIRST LEVEL OF CP/M 2 0 ALTERATION
;             WITH MODS FOR CP/M  ROMDISK AND RAMDISK 
;
;             ENTIRELY IN 8080 MNEUMONICS (SO ASM CAN BE USED)
;             BUT ASSUMES A Z80! (REMOVE)
;
MSIZE	 EQU	59			;CP/M VERSION MEMORY SIZE IN KILOBYTES
;
;	"BIAS" IS ADDRESS OFFSET FROM 3400H FOR MEMORY SYSTEMS
;	THAN 16K (REFERRED TO AS "B" THROUGHOUT THE TEXT) 
;
BIAS:	 EQU (MSIZE-20)*1024
CCP:	 EQU 3400H+BIAS		; BASE OF CCP
BDOS:	 EQU CCP+806H		; BASE OF BDOS
BIOS:	 EQU CCP+1600H		; BASE OF BIOS
CDISK:	 EQU 0004H		; CURRENT DISK NUMBER 0=A,...,15=P
IOBYTE:	 EQU 3			; I/O DEFINITION BYTE.

     		 ORG   BIOS

; IOBYTE ALREADY DEFINED IN CPM22 ABOVE, LINE 0017
;IOBYTE	 EQU	0003H			;INTEL I/O BYTE
;
;	CONSTANTS

END:		 EQU 0FFH
CR		 EQU	0DH
LF		 EQU	0AH

; TEST PROTOTYPE SPECIFIC HARDWARE IO PORT ADDRESSES AND MEMORY LOCATIONS

UART:		 EQU 68H		; BASE IO ADDRESS OF UART
MPCL_RAM:	 EQU 78H		; BASE IO ADDRESS OF RAM MEMORY PAGER CONFIGURATION LATCH
MPCL_ROM:	 EQU 7CH		; BASE IO ADDRESS OF ROM MEMORY PAGER CONFIGURATION LATCH

ROMSTART_CPM:	 EQU 0A00H		; WHERE THE CCP+BDOS+BIOS IS STORED IN ROM
RAMTARG_CPM:	 EQU 0D000H		; WHERE THE CCP+BDOS+BIOS STARTS IN RAM (ENTRY POINT)
MOVSIZ_CPM:	 EQU 2BFFH		; CCP, BDOS
CCPSIZ_CPM:	 EQU 0800H		; CCP 0800h BYTES IN LENGTH
;
RTC      	equ 70h

RTC_DOUT 	equ 80h ; 74574 RTC/SD output bits
RTC_CLK  	equ 40h
RTC_DIR  	equ 20h
RTC_CE   	equ 10h
SD_CS    	equ 04h ; NPN inverter, positive logic.
SD_CLK   	equ 02h
SD_DOUT  	equ 01h

RTC_DIN  	equ 01h ; 74125 RTC/SD input bits
SD_DIN   	equ 80h
;

;	 ORG	BIOS			;ORIGIN OF THIS PROGRAM
NSECTS:	 EQU ($-CCP)/128	; WARM START SECTOR COUNT

;
;	JUMP VECTOR FOR INDIVIDUAL SUBROUTINES
	JP	BOOT		; COLD START
WBOOTE:	JP	WBOOT		; WARM START
	JP	CONST		; CONSOLE STATUS
	JP	CONIN		; CONSOLE CHARACTER IN
	JP	CONOUT		; CONSOLE CHARACTER OUT
	JP	LIST		; LIST CHARACTER OUT (NULL ROUTINE)
	JP	PUNCH		; PUNCH CHARACTER OUT (NULL ROUTINE)
	JP	READER		; READER CHARACTER OUT (NULL ROUTINE)
	JP	HOME		; MOVE HEAD TO HOME POSITION
	JP	SELDSK		; SELECT DISK
	JP	SETTRK		; SET TRACK NUMBER
	JP	SETSEC		; SET SECTOR NUMBER
	JP	SETDMA		; SET DMA ADDRESS
	JP	READ		; READ DISK
	JP	WRITE		; WRITE DISK
	JP	LISTST		; RETURN LIST STATUS (NULL ROUTINE)
	JP	SECTRN		; SECTOR TRANSLATE
;
;   FIXED DATA TABLES FOR ALL DRIVES
;   0= FLOPPY DISK, 1=RAMDISK, 2=IDE, 3=ATAPI, AND 4=HDPART4
;   5= 1MBDISK

;   DISK PARAMETER HEADER FOR DISK 00
DPBASE:	 DW 0000,0000
	 DW 0000,0000
	 DW DIRBF,DPBLK0
	 DW CHK00,ALL00
;   DISK PARAMETER HEADER FOR DISK 01
	 DW 0000,0000
	 DW 0000,0000
	 DW DIRBF,DPBLK1
	 DW CHK01,ALL01

;   DISK PARAMETER HEADER FOR DISK 02
	 DW 0000,0000
	 DW 0000,0000
	 DW DIRBF,DPBLK2
	 DW CHK02,ALL02
;   DISK PARAMETER HEADER FOR DISK 03
	 DW 0000,0000
	 DW 0000,0000
	 DW DIRBF,DPBLK3
	 DW CHK03,ALL03
;   DISK PARAMETER HEADER FOR DISK 04
	 DW 0000,0000
	 DW 0000,0000
	 DW DIRBF,DPBLK4
	 DW CHK04,ALL04
;   DISK PARAMETER HEADER FOR DISK 05
	 DW 0000,0000
	 DW 0000,0000
	 DW DIRBF,DPBLK5
	 DW CHK05,ALL05
;   DISK PARAMETER HEADER FOR DISK 06
	 DW 0000,0000
	 DW 0000,0000
	 DW DIRBF,DPBLK6
	 DW CHK06,ALL06

;

DPBLK0:				; DISK PARAMETER BLOCK (FLOPPY DISK 720KB)
SPT_0:	 DW  36			; 36 SECTORS OF 128 BYTES PER 4.5K TRACK
BSH_0:	 DB  4			; BLOCK SHIFT FACTOR (SIZE OF ALLOCATION BLOCK)
BLM_0:	 DB  15			; PART OF THE ALLOCATION BLOCK SIZE MATH
EXM_0:	 DB  0			; DEFINES SIZE OF EXTENT (DIRECTORY INFO)
DSM_0:	 DW  350		; BLOCKSIZE [2048] * NUMBER OF BLOCKS + 1 = DRIVE SIZE
DRM_0:	 DW  127		; NUMBER OF DIRECTORY ENTRIES
AL0_0:	 DB  11000000b		; BIT MAP OF SPACE ALLOCATED TO DIRECTORY
AL1_0:	 DB  00000000b		; DIRECTORY CAN HAVE UP TO 16 BLOCKS ALLOCATED
CKS_0:	 DW  32			; SIZE OF DIRECTORY CHECK [0 IF NON REMOVEABLE]
OFF_0:	 DW  4			; FIRST 4 TRACKS TRACKS RESERVED (18K FOR SYSTEM)
				; 
DPBLK1:				; DISK PARAMETER BLOCK (RAMDISK 512K, 448K USABLE)
SPT_1:	 DW  256		; 256 SECTORS OF 128 BYTES PER 32K TRACK
BSH_1:	 DB  4			; BLOCK SHIFT FACTOR (SIZE OF ALLOCATION BLOCK)
BLM_1:	 DB  15			; PART OF THE ALLOCATION BLOCK SIZE MATH
EXM_1:	 DB  1			; DEFINES SIZE OF EXTENT (DIRECTORY INFO)
DSM_1:	 DW  225		; BLOCKSIZE [2048] * NUMBER OF BLOCKS + 1 = DRIVE SIZE
DRM_1:	 DW  255		; NUMBER OF DIRECTORY ENTRIES
AL0_1:	 DB  11110000b		; BIT MAP OF SPACE ALLOCATED TO DIRECTORY
AL1_1:	 DB  00000000b		; DIRECTORY CAN HAVE UP TO 16 BLOCKS ALLOCATED
CKS_1:	 DW  0			; SIZE OF DIRECTORY CHECK [0 IF NON REMOVEABLE]
OFF_1:	 DW  1			; 1 TRACK RESERVED [FIRST 32K OF RAM]
				;
DPBLK2:				; DISK PARAMETER BLOCK (IDE HARD DISK 8MB)
;SPT_2:	 DW  32 		; 256 SECTORS OF 128 BYTES PER 32K TRACK
;BSH_2:	 DB  6			; BLOCK SHIFT FACTOR (SIZE OF ALLOCATION BLOCK)
;BLM_2:	 DB  63 		; PART OF THE ALLOCATION BLOCK SIZE MATH
;EXM_2:	 DB  3			; DEFINES SIZE OF EXTENT (DIRECTORY INFO)
;DSM_2:	 DW  1023		; BLOCKSIZE [4096] * NUMBER OF BLOCKS + 1 = DRIVE SIZE
;DRM_2:	 DW  255		; NUMBER OF DIRECTORY ENTRIES
;AL0_2:	 DB  128		; BIT MAP OF SPACE ALLOCATED TO DIRECTORY
;AL1_2:	 DB  00000000b		; DIRECTORY CAN HAVE UP TO 16 BLOCKS ALLOCATED
;CKS_2:	 DW  0			; SIZE OF DIRECTORY CHECK [0 IF NON REMOVEABLE]
;OFF_2:	 DW  2			; TRACKS (32K) RESERVED FOR SYSTEM AND OTHER PARTITIONS
SPT_2:	 DW  256 		; 256 SECTORS OF 128 BYTES PER 32K TRACK
BSH_2:	 DB  5			; BLOCK SHIFT FACTOR (SIZE OF ALLOCATION BLOCK)
BLM_2:	 DB  31 		; PART OF THE ALLOCATION BLOCK SIZE MATH
EXM_2:	 DB  1			; DEFINES SIZE OF EXTENT (DIRECTORY INFO)
DSM_2:	 DW  2047		; BLOCKSIZE [4096] * NUMBER OF BLOCKS + 1 = DRIVE SIZE
DRM_2:	 DW  511		; NUMBER OF DIRECTORY ENTRIES
AL0_2:	 DB  11110000b		; BIT MAP OF SPACE ALLOCATED TO DIRECTORY
AL1_2:	 DB  00000000b		; DIRECTORY CAN HAVE UP TO 16 BLOCKS ALLOCATED
CKS_2:	 DW  0			; SIZE OF DIRECTORY CHECK [0 IF NON REMOVEABLE]
OFF_2:	 DW  4			; TRACKS (32K) RESERVED FOR SYSTEM AND OTHER PARTITIONS

				;
DPBLK3:				; DISK PARAMETER BLOCK (ATAPI DRIVE 8MB)
SPT_3:	 DW  256		; 256 SECTORS OF 128 BYTES PER 32K TRACK
BSH_3:	 DB  5			; BLOCK SHIFT FACTOR (SIZE OF ALLOCATION BLOCK)
BLM_3:	 DB  31			; PART OF THE ALLOCATION BLOCK SIZE MATH
EXM_3:	 DB  1			; DEFINES SIZE OF EXTENT (DIRECTORY INFO)
DSM_3:	 DW  2047		; BLOCKSIZE [4096] * NUMBER OF BLOCKS + 1 = DRIVE SIZE
DRM_3:	 DW  511		; NUMBER OF DIRECTORY ENTRIES
AL0_3:	 DB  11110000b		; BIT MAP OF SPACE ALLOCATED TO DIRECTORY
AL1_3:	 DB  00000000b		; DIRECTORY CAN HAVE UP TO 16 BLOCKS ALLOCATED
CKS_3:	 DW  0			; SIZE OF DIRECTORY CHECK [0 IF NON REMOVEABLE]
OFF_3:	 DW  256		; 1 TRACK (32K) RESERVED FOR SYSTEM
				;
DPBLK4:				; DISK PARAMETER BLOCK (IDE HARD DISK 1024K)
SPT_4:	 DW  256		; 256 SECTORS OF 128 BYTES PER 32K TRACK
BSH_4:	 DB  5			; BLOCK SHIFT FACTOR (SIZE OF ALLOCATION BLOCK)
BLM_4:	 DB  31			; PART OF THE ALLOCATION BLOCK SIZE MATH
EXM_4:	 DB  1			; DEFINES SIZE OF EXTENT (DIRECTORY INFO)
DSM_4:	 DW  2047		; BLOCKSIZE [2048] * NUMBER OF BLOCKS + 1 = DRIVE SIZE
DRM_4:	 DW  511		; NUMBER OF DIRECTORY ENTRIES
AL0_4:	 DB  11110000b		; BIT MAP OF SPACE ALLOCATED TO DIRECTORY
AL1_4:	 DB  00000000b		; DIRECTORY CAN HAVE UP TO 16 BLOCKS ALLOCATED
CKS_4:	 DW  0			; SIZE OF DIRECTORY CHECK [0 IF NON REMOVEABLE]
OFF_4:	 DW  512		; 1 TRACK RESERVED [FIRST 32K OF PARTITION]
				;
DPBLK5:				; DISK PARAMETER BLOCK (ROMDISK 1MB) ** RESERVED FOR FUTURE EXPANSION 
SPT_5:	 DW  256		; 256 SECTORS OF 128 BYTES PER 32K TRACK
BSH_5:	 DB  4			; BLOCK SHIFT FACTOR (SIZE OF ALLOCATION BLOCK)
BLM_5:	 DB  15			; PART OF THE ALLOCATION BLOCK SIZE MATH
EXM_5:	 DB  1			; DEFINES SIZE OF EXTENT (DIRECTORY INFO)
DSM_5:	 DW  511		; BLOCKSIZE [2048] * NUMBER OF BLOCKS +1 =DRIVE SIZE
DRM_5:	 DW  255		; NUMBER OF DIRECTORY ENTRIES
AL0_5:	 DB  11110000b		; BIT MAP OF SPACE ALLOCATED TO DIRECTORY
AL1_5:	 DB  00000000b		; DIRECTORY CAN HAVE UP TO 16 BLOCKS ALLOCATED
CKS_5:	 DW  0			; SIZE OF DIRECTORY CHECK [0 IF NON REMOVEABLE]
OFF_5:	 DW  1			; 1 TRACK RESERVED [FIRST 32K OF ROM]
	
				;
DPBLK6:				;DISK PARAMETER BLOCK (ROMDISK 1MB) ** RESERVED FOR FUTURE EXPANSION *
SPT_6:	 DW 	16	 	; 16 SECTORS OF 128 BYTES PER 2K TRACK
BSH_6:	 DB 	3 		; BLOCK SHIFT FACTOR (SIZE OF ALLOCATION BLOCK)
BLM_6:	 DB 	7 		; PART OF THE ALLOCATION BLOCK SIZE MATH
EXM_6:	 DB 	1 		; DEFINES SIZE OF EXTENT (DIRECTORY INFO)
DSM_6:	 DW 	31 		; BLOCKSIZE [1024] * NUMBER OF BLOCKS + 1 = DRIVE SIZE
DRM_6:	 DW 	31 		; NUMBER OF DIRECTORY ENTRIES
AL0_6:	 DB 	10000000b  	; BIT MAP OF SPACE ALLOCATED TO DIRECTORY
AL1_6:	 DB 	00000000b  	; DIRECTORY CAN HAVE UP TO 16 BLOCKS ALLOCATED
CKS_6:	 DW 	0 	  	; SIZE OF DIRECTORY CHECK [0 IF NON REMOVEABLE]
OFF_6:	 DW 	10 	  	; FIRST 5 TRACKS TRACKS RESERVED (16K FOR SYSTEM)
				; SYSTEM IS ROM LOADER, CCP, BDOS, CBIOS, AND MONITOR
				;
				; IMPORTANT NOTE: TRACKS 000h - $04 OF 2K BYTES
				; EACH ARE MARKED WITH THE OFF_0 SET TO 5 AS 
				; SYSTEM TRACKS  USABLE ROM DRIVE SPACE
				; STARTING AFTER THE FIFTH TRACK (IE, TRACK 005h)
				; MOST LIKELY FIX TO THIS IS PLACING A DUMMY
				; FIRST 10K ROM CONTAINS THE ROM LOADER, MONITOR,
 				; CCP, BDOS, BIOS, ETC (5 TRACKS * 2K EACH)



;
;	END OF FIXED TABLES
;
;	INDIVIDUAL SUBROUTINES TO PERFORM EACH FUNCTION

BOOT:				; SIMPLEST CASE IS TO JUST PERFORM PARAMETER INITIALIZATION
				;
	LD	A,80H		; LOAD VALUE TO SWITCH OUT ROM
	OUT	(MPCL_ROM),A	; SWITCH OUT ROM, BRING IN LOWER 32K RAM PAGE
				;
				;
	LD	A,10000001b	; SWITCH IN FIRST 32K LOWER PAGE (FIRST TRACK)
	OUT	(MPCL_RAM),A	;
				; FORMATTING THE RAM IS SIMPLE AS CLEARING THE DIRECTORY AREA 
				; TO A VALUE OF E5H (THE FIRST 8K OF TRACK 1 OR THE RAMDISK) 
	LD	HL,0000H	; STARTING MEMORY ADDRESS OF TRACK 1, SECTOR 0 IN HL
	LD	BC,1FFFH	; 8K OF DIRECTORY SECTORS RESERVED (LENGTH IN BC)
	LD	A,0E5H		; INITIALIZING VALUE IN A 
	LD	E,L		;
	LD	D,H		;
	INC	DE		;
	LD	(HL),A		;
	LDIR			;
				;
	LD	A,80H		; LOAD VALUE TO SWITCH OUT ROM
	OUT	(MPCL_ROM),A	; SWITCH OUT ROM, BRING IN LOWER 32K RAM PAGE

	LD	A,00H		; ENSURE LOWEST RAM PAGE SELECTED
	OUT	(MPCL_RAM),A	; BRING IN LOWEST 32K RAM PAGE

	XOR	A		; ZERO IN THE ACCUM
	LD	(IOBYTE),A	; CLEAR THE IOBYTE
	LD	(CDISK),A	; SELECT DISK ZERO
	
	CALL	sdcard	 	; RESET THE SD CARD


	JP	GOCPM		; INITIALIZE AND GO TO CP/M

;
WBOOT:				; SIMPLEST CASE IS TO READ THE DISK UNTIL ALL SECTORS LOADED
				; WITH A ROMDISK WE SELECT THE ROM AND THE CORRECT PAGE [0]
				; THEN COPY THE CP/M IMAGE (CCP, BDOS, BIOS, MONITOR) TO HIGH RAM
				; LOAD ADDRESS 
				; FOR Z80 IT LOOKS LIKE THIS .. USING 8080 NEMONICS

	DI			; DISABLE INTERRUPT
	LD	SP,80H		; USE SPACE BELOW BUFFER FOR STACK
	IM	1		; SET INTERRUPT MODE 1

	XOR	A		; CHEAP ZERO IN ACC
	OUT	(MPCL_ROM),A	; SEND 0 TO ROM MAP PORT (SWITCH IN LOWER 32K ROM PAGE)

	XOR	A		; CHEAP ZERO IN ACC
	OUT	(MPCL_RAM),A	; SEND 0 TO RAM MAP PORT (SELECT LOWEST RAM PAGE)

		LD	HL,ROMSTART_CPM	; WHERE IN ROM CP/M IS STORED (FIRST BYTE)
		LD	DE,RAMTARG_CPM	; WHERE IN RAM TO MOVE MONITOR TO (FIRST BYTE)
		LD	BC,CCPSIZ_CPM	; NUMBER OF BYTES TO MOVE FROM ROM TO RAM
		LDIR


	EI			; ENABLE INTERRUPTS (ACCESS TO MONITOR WHILE
				; CP/M RUNNING)
	LD	A,80H		; LOAD VALUE TO SWITCH OUT ROM
	OUT	(MPCL_ROM),A	; SWITCH OUT ROM, BRING IN LOWER 32K RAM PAGE

	XOR	A		; CHEAP ZERO IN ACC
	OUT	(MPCL_RAM),A	; SEND 0 TO RAM MAP PORT (SELECT LOWEST RAM PAGE)


	 IF CONDSUPERSUB
		; DO NOTHING FOR ORIGINAL CODE
	 ELSE
		; CLEAR THE AUTOSUB BUFFER, DO ON A WARM BOOT
		XOR	A
		LD	(INBUFF+1),A	; SECOND BYTE IS ACTUAL LENGTH 

	 ENDIF

	; FALL THROUGH TO GOCPM ROUTINE

;	END OF LOAD OPERATION, SET PARAMETERS AND GO TO CP/M
GOCPM:
				; CPU RESET HANDLER
	LD	A,0C3H		; C3 IS A JMP INSTRUCTION
	LD	(0000H),A	; FOR JMP TO WBOOT
	LD	HL,WBOOTE	; WBOOT ENTRY POINT
	LD	(1),HL		; SET ADDRESS FIELD FOR JMP AT 0
;
				; CPU INTERRUPT HANDLER
	LD	A,0C3H		; C3 IS A JMP INSTRUCTION
	LD	(0038H),A	; FOR JMP TO WBOOT
	LD	HL,WBOOTE	; WBOOT ENTRY POINT
	LD	(1),HL		; SET ADDRESS FIELD FOR JMP AT 0
;
	LD	(5),A		; FOR JMP TO BDOS
	LD	HL,BDOS		; BDOS ENTRY POINT
	LD	(6),HL		; ADDRESS FIELD OF JUMP AT 5 TO BDOS
;
	LD	BC,80H		; DEFAULT DMA ADDRESS IS 80H
	CALL	SETDMA
;
	LD	HL,TXT_STARTUP_MSG ; PRINT STARTUP MESSAGE
	CALL	PRTMSG
;
	LD	A,(CDISK)	; GET CURRENT DISK NUMBER
	LD	C,A		; SEND TO THE CCP
	JP	CCP		; GO TO CP/M FOR FURTHER PROCESSING
;
;
;	SIMPLE I/O HANDLERS (MUST BE FILLED IN BY USER)
;	IN EACH CASE, THE ENTRY POINT IS PROVIDED, WITH SPACE RESERVED
;	TO INSERT YOUR OWN CODE
;

CONST:					; CONSOLE STATUS, RETURN 0FFH IF CHARACTER READY, 00H IF NOT
		IN	A,(UART + 05H)	; READ LINE STATUS REGISTER (UART5 = 068h + $05)
		AND	01H		; TEST IF DATA IN RECEIVE BUFFER
					; IS THERE A CHAR READY? 0=NO, 1=YES
		JP	Z,NOT_READY	;
		LD	A,0FFH		; YES, PUT 0FFh IN A AND RETURN
NOT_READY:				;
					; NO, LEAVE 000h IN A AND RETURN
		RET			;
CONIN:					; CONSOLE CHARACTER INTO REGISTER A
					;
		CALL	CONST		; IS A CHAR READY TO BE READ FROM UART?
		CP	00H		; 
		JP	Z,CONIN		; NO?  TRY AGAIN   
		IN	A,(UART)	; YES? READ THE CHAR FROM THE UART (UART0 = 068h + $00)
					; REGISTER AND PASS BACK TO USER
		RET			;
					;
CONOUT:					; CONSOLE CHARACTER OUTPUT FROM REGISTER C
		IN	A,(UART + 05H)	; READ LINE STATUS REGISTER
		AND	20H		; TEST IF UART IS READY TO SEND
		JP	Z,CONOUT	; IF NOT REPEAT
					;
		LD	A,C		; GET TO ACCUMULATOR
		OUT	(UART),A	; THEN WRITE THE CHAR TO UART (UART0 = 068h + $00)
		RET			;
					;
LIST:					;LIST CHARACTER FROM REGISTER C
	LD	A,C			;CHARACTER TO REGISTER A
	RET				;NULL SUBROUTINE
		;
LISTST:					;RETURN LIST STATUS (0 IF NOT READY, 1 IF READY)
	XOR	A			;0 IS ALWAYS OK TO RETURN
	RET				;
					;
					;
PUNCH:					;PUNCH CHARACTER FROM REGISTER C
	LD	A,C			;CHARACTER TO REGISTER A
	RET				;NULL SUBROUTINE
;
READER:					;READ CHARACTER INTO REGISTER A FROM READER DEVICE
	LD	A,C			;CHARACTER TO REGISTER A
	RET
;
;	I/O DRIVERS FOR THE DISK FOLLOW
;	FOR NOW, WE WILL SIMPLY STORE THE PARAMETERS AWAY FOR USE
;	IN THE READ AND WRITE SUBROUTINES
;

;
;   SELECT DISK GIVEN BY REGISTER C
;
SELDSK:	LD	HL,0000H	; ERROR RETURN CODE
	LD	A,C
	 IF CONDABONLY
		CP	07H		; MUST BE BETWEEN 0 AND 6
	 ELSE
		CP	02H		; IF NO IDE THEN ONLY DRIVE A AND B FOR THE MINI N8VEM SO 0 OR 1 ONLY
	 ENDIF
	RET	NC		; ORIGINAL CODE - RETURNS BUT GETS STUCK IN A LOOP
	LD	(DISKNO),A

;   DISK NUMBER IS IN THE PROPER RANGE
;   COMPUTE PROPER DISK PARAMETER HEADER ADDRESS
	LD	L,A		; L=DISK NUMBER 0,1,2,3,4
	LD	H,0		; HIGH ORDER ZERO
	ADD	HL,HL		; *2
	ADD	HL,HL		; *4
	ADD	HL,HL		; *8
	ADD	HL,HL		; *16 (SIZE OF EACH HEADER)
	LD	DE,DPBASE
	ADD	HL,DE		; HL= DPBASE(DISKNO*16)
	RET


;
HOME:				; MOVE TO THE TRACK 00 POSITION OF CURRENT DRIVE
				; TRANSLATE THIS CALL INTO A SETTRK CALL WITH PARAMETER 00
	LD	BC,0		; SELECT TRACK 0000
	

SETTRK:				; SET TRACK GIVEN BY REGISTER BC
	LD	H,B
	LD	L,C
	LD	(TRACK),HL
	RET
;
SETSEC:				; SET SECTOR GIVEN BY REGISTER BC
	LD	H,B
	LD	L,C
	LD	(SECTOR),HL
	RET
;
;   TRANSLATE THE SECTOR GIVEN BY BC USING THE
;   TRANSLATE TABLE GIVEN BY DE
; ONLY USED FOR FLOPPIES! FOR ROMDISK/RAMDISK IT'S 1:1
; DO THE NEXT ROUTINE IS A NULL (RETURNS THE SAME)
SECTRN:	
	LD	H,B
	LD	L,C
	RET
;
SETDMA:				; SET DMA ADDRESS GIVEN BY REGISTERS B AND C
	LD	L,C		; LOW ORDER ADDRESS
	LD	H,B		; HIGH ORDER ADDRESS
	LD	(DMAAD),HL	; SAVE THE ADDRESS
	RET
;________________________________________________________________________________________________________
;  DISK DRIVERS ..
;
; DRIVER NEED TO DO SEVERAL THINGS FOR ROM AND RAM DISKS 
;   - INTERRUPTS ARE NOT ALLOWED DURING LOW RAM/ROM ACCESS (DISABLE!)
;   -TRANSLATE TRACK AND SECTOR INTO A POINTER TO WHERE THE 128 BYTE 
;     SECTOR BEGINS IN THE RAM/ROM
;   -TRANSLATE THE DRIVE INTO A RAM/ROM SELECT, COMBINE WITH TRACK ADDRESS
;     AND SEND TO THE MAP PORT 
;   -COPY 128 BYTE FROM OR TO THE ROM/RAMDISK AND MEMORY POINTED TO BY THE DMA 
;     ADDRESS PREVIOUSLY STORED 
;   -RESTORE MAP PORT TO PRIOR CONDITION BEFOR READ/WRITE
;
;   - FIRST TRICK IS THAT WE MADE SECTORS 256 AS 256*128=32768   SO WE COPY 
;     THE LOW SECTOR ADDRESS TO THE LOW BYTE OF THE HL REGISTER AND THEN 
;     MULTIPLY BY 128  THIS RESULTS IN THE STARTING ADDRESS IN THE RAM OR ROM
;     (0000 -> 7F80H) 32K PAGE 
;
;    - TRICK TWO IS THE TRACK ADDRESS  EQUALS THE 32K PAGE ADDRESS AND IS A 
;      DIRECT SELECT THAT CAN BE COPIED TO THE MAP PORT D0 THROUGH D5   D7
;      SELECTS THE DRIVE (ROM OR RAM) 
;      THAT MEANS THE LOW BYTE OF TRACK CONTAINS THE D0-D5 VALUE AND 
;      DISKNO HAS THE DRIVE SELECTED   WE FIRST COPY DISKNO TO ACC
;      AND RIGHTSHIFT IT TO PLACE THAT IN BIT 7, WE THEN ADD THE LOW BYTE OF 
;      TRACK TO ACC AND THEN SEND THAT TO THE MAP PORT 
;
;      NOTE 1: A WRITE TO ROM SHOULD BE FLAGGED AS AN ERROR 
;      NOTE 2: RAM MUST START AS A "FORMATTED DISK"  IF BATTERY BACKED UP
;                   IT'S A DO ONCE AT COLD COLD START   IF NOT BATTERY BACKED U
;                   IT WILL HAVE TO BE DONE EVERY TIME THE SYSTEM IS POWERED 
;                   FORMATTING THE RAM IS SIMPLE AS CLEARING THE DIRECTORY AREA
;                   TO A VALUE OF E5H (THE FIRST 8K OF TRACK 1 OR THE RAMDISK) 
;                   IT COULD BE DONE AS A SIMPLE UTILITY PROGRAM STORED IN ROMD
;                   OR ANYTIME COLBOOT IS CALLED(LESS DESIREABLE) 
;
;     -WE NOW CAN COPY TO OR FROM AS CORRECT FOR THE DEVICE 128 BYTES (SECTOR)
;      TO OR FROM THE DMA ADDRESS  ALMOST!  SINCE ROM OR RAM IS BEING PAGED
;      WE HAVE TO COPY ANYTHING DETINED FOR BELOW 8000H TO A TEMP BUFFER THEN
;      HANDLE THE PAGING 
;        
;
;     - LAST STEP IS TO RESTORE THE MAP PORT TO POINT TO THE RAM (TRACK 0) SO T
;       MEMORY MAP IS ALL RAM AGAIN AND NOT POINTING INTO THE DATA AREAS OR THE
;       SINCE THE RAM 0TH PAGE IS NOMINALLY THE LOW 32K OF RAM IN THE SYSTEM WE
;       SEND A SIMPLE MVI A,80H ; OUT MPCL_ROM; MVI A,00H ; OUT MPCL_RAM 
;
;      - THE READ OR WRITE OPERATION IS DONE 
;
;   READ DISK
;    USES DE,DL, BC,  ACC FLAGS
;      Z80 COULD USE BLOCK MOVE [LDIR] BUT WRITTEN IN 8080 
;________________________________________________________________________________________________________

;__READ__________________________________________________________________________________________________
;
; 	PERFORM CP/M SECTOR READ
;________________________________________________________________________________________________________
READ:
	DI				; DISABLE INTERRUPTS
	LD	A,(DISKNO)		; GET DRIVE
	CP	00H			; "A"
	JP	Z,READ_RAM_DISK		; READ FROM 448K RAM DISK					; 
	CP	01H			; "B"
	JP	Z,READ_RAM_DISK		; READ FROM 448K RAM DISK
	CP	02H			; "C"
	JP	Z,sd_read		; READ FROM 8 MB IDE HARD DISK
	CP	03H			; "D"
	JP	Z,sd_read		; READ FROM 448K RAM DISK					; 
	CP	04H			; "E"
	JP	Z,sd_read		; READ FROM 1 MB IDE HARD DISK, PARTITION 4
	CP	05H			; "F"
	JP	Z,READ_RAM_DISK		; READ FROM 1M ROM DISK (UTILIZES SAME
					; ROUTINES AS RAM_DISK
					; "G"
					; READ FROM 22K EEPROM DISK , SO FALL THROUGH

;___READ_EEPROM_DISK_____________________________________________________________________________________
;
;	READ EEPROM DISK
;________________________________________________________________________________________________________
READ_EEPROM_DISK:
					; 
					; IF ROM, MAP TRACK/SECTOR TO VIRTUAL TRACK/SECTOR
					; HANDLE READING FROM ROM HERE
					; 
					; PURPOSE OF THIS ROUTINE IS TO MAP 32K ROM PART
					; TRACK/SECTOR MAP (2K TRACK SIZE MADE OF 16 128
					; BYTE SECTORS EACH) ONTO WHAT THE RAM/ROM SECTOR
					; READ ROUTINES ARE EXPECTING (32K TRACK SIZE MADE
					; OF 256 128 BYTE SECTORS EACH)   THE ROUTINE 
					; CONVERTS 4 BIT TRACK # AND 4 BIT SECTOR #
					; INTO A VIRTUAL 1 TRACK, 256 SECTOR ACCESS
	LD	HL,(TRACK)		; TRACK # IS UPPER 4 BITS OF SECTOR ADDRESS
	ADD	HL,HL			; SHIFT BITS LEFT 1 (*2)
	ADD	HL,HL			; SHIFT BITS LEFT 1 (*4)
	ADD	HL,HL			; SHIFT BITS LEFT 1 (*8)
	ADD	HL,HL			; SHIFT BITS LEFT 1 (*16)
	LD	B,H			; PUT UPPER 4 BITS OF SECTOR ADDRESS IN BC
	LD	C,L			; (B IS UPPER BYTE AND C IS LOWER BYTE)
					; BC NOW CONTAINS THE UPDATED TRACK #
	LD	HL,(SECTOR)		; SECTOR # IS LOWER 4 BITS OF SECTOR ADDRESS
	ADD	HL,BC			; VIRTUAL SECTOR = (UPDATED TRACK #) + SECTOR #
	LD	(V_SECTOR),HL		; STORE VIRTUAL SECTOR #
					; NOW CONTINUE READING ROM WITH REGULAR RAM
					; SETUP FOR READ OF RAM OR ROM DISK
	LD	HL,(V_SECTOR)		;
	ADD	HL,HL			; SHIFT BITS LEFT 1 (*2)
	ADD	HL,HL			; SHIFT BITS LEFT 1 (*4)
	ADD	HL,HL			; SHIFT BITS LEFT 1 (*8)
	ADD	HL,HL			; SHIFT BITS LEFT 1 (*16)
	ADD	HL,HL			; SHIFT BITS LEFT 1 (*32)
	ADD	HL,HL			; SHIFT BITS LEFT 1 (*64)
	ADD	HL,HL			; SHIFT BITS LEFT 1 (*128)
	LD	(SECST),HL		; SAVE SECTOR STARTING ADDRESS
					; SET PAGER WITH DRIVE (0) AND TRACK (0)
	LD	A,00H			; SWITCH IN ROM PAGE 
	OUT	(MPCL_ROM),A		; SEND TO PORT MAPPER
	LD	(PAGER),A		; SAVE COPY (JUST BECAUSE)	
	LD	HL,TMPBUF		; LOAD HL WITH TEMP BUF ADDRESS
	LD	E,L			;
	LD	D,H			; GET IT INTO DE
	LD	HL,(SECST)		; GET ROM/RAM ADDRESS
	CALL	COPY_CPM_SECTOR		;
	CALL	RPAGE			; SET PAGE TO CP/M RAM
	LD	HL,(DMAAD)		; LOAD HL WITH DMA ADDRESS
	LD	E,L			;
	LD	D,H			; GET IT INTO DE
	LD	HL,TMPBUF		; GET ROM/RAM ADDRESS
	CALL	COPY_CPM_SECTOR		;
	LD	A,(DISKNO)		; STORE CURRENT DRIVE IN BUFFER
	LD	(CUDISK),A		;
	LD	A,00H			;
	EI				; RE-ENABLE INTERRUPTS
	RET			

;___READ_RAM_DISK_________________________________________________________________________________________
;
;	READ RAM DISK
;________________________________________________________________________________________________________
READ_RAM_DISK:				;
					; IF RAM, PROCEED WITH NORMAL TRACK/SECTOR READ
	CALL	SECPAGE			; SETUP FOR READ OF RAM OR ROM DISK
	CALL	PAGERB			; SET PAGER WITH DRIVE AND TRACK
	LD	HL,TMPBUF		; LOAD HL WITH TEMP BUF ADDRESS
	LD	E,L			;
	LD	D,H			; GET IT INTO DE
	LD	HL,(SECST)		; GET ROM/RAM ADDRESS
	CALL	COPY_CPM_SECTOR		; MOVE SECTOR TO TMPBUF
	CALL	RPAGE			; SET PAGE TO CP/M RAM
	LD	HL,(DMAAD)		; LOAD HL WITH DMA ADDRESS					;
	LD	E,L			;
	LD	D,H			; GET IT INTO DE
	LD	HL,TMPBUF		; GET ROM/RAM ADDRESS
	CALL	COPY_CPM_SECTOR		; MOVE SECTOR FROM TMPBUF TO DMA AREA
	LD	A,(DISKNO)		; STORE CURRENT DRIVE IN BUFFER
	LD	(CUDISK),A		;
	LD	A,00H			;
	EI				; RE-ENABLE INTERRUPTS
	RET
	


;___WRITE______________________________________________________________________________________________
;
;   HANDLE CP/M WRITE CALL
;
;________________________________________________________________________________________________________
WRITE:
	DI				; DISABLE INTERRUPTS
	LD	A,(DISKNO)		; GET DRIVE
	CP	00H			; FIND OUT WHICH DRIVE IS BEING REQUESTED
	JP	Z,WRITE_RAM_DISK 	; WRITE TO 448K RAM DISK
	CP	01H			; 
	JP	Z,WRITE_RAM_DISK 	; WRITE TO 448K RAM DISK
	CP	02H			;
	JP	Z,sd_write		; WRITE TO 8 MB IDE HARD DISK, PARTITION 2
	CP	03H			;
	JP	Z,sd_write  	 	; WRITE TO 448K RAM DISK
	CP	04H			;
	JP	Z,sd_write       	; WRITE TO 1 MB IDE HARD DISK, PARTITION 4


;___RDONLY______________________________________________________________________________________________
;
;   HANDLE WRITE TO READ ONLY
;
;   SENDS A MESSAGE TO TERMINAL THAT ROM DRIVE IS NOT WRITEABLE
;   DOES A PAUSE THEN RETURNS TO CPM WITH ERROR FLAGGED  THIS IS
;   DONE TO ALLOW A POSSIBLE GRACEFUL EXIT (SOME APPS MAY PUKE) 
;________________________________________________________________________________________________________
RDONLY:
	LD	HL,TXT_RO_ERROR		; SET HL TO START OF ERROR MESSAGE
	CALL	PRTMSG			; PRINT ERROR MESSAGE
	LD	A,01H			; SEND BAD SECTOR ERROR BACK
					; BDOS WILL ALSO PRINT ITS OWN ERROR MESSAGE
	RET

;___WRITE_RAM_DISK_____________________________________________________________________________________
;
;	WRITE RAM DISK
;________________________________________________________________________________________________________
WRITE_RAM_DISK:
	LD	HL,TMPBUF		; LOAD HL WITH TEMP BUF ADDRESS
	LD	E,L			;
	LD	D,H			; GET IT INTO DE
	LD	HL,(DMAAD)		; GET DMA ADDRESS
	CALL	COPY_CPM_SECTOR		;
	CALL	SECPAGE			; GET RAM PAGE WRITE ADDRESS
	CALL	PAGERB			; SET PAGER WITH DRIVE AND TRACK
	LD	HL,(SECST)		; LOAD HL WITH DMA ADDRESS (WHERE TO WRITE TO)
	LD	E,L			;
	LD	D,H			; GET IT INTO DE
	LD	HL,TMPBUF		; GET TEMP BUFFER ADDRESS
	CALL	COPY_CPM_SECTOR		;
	CALL	RPAGE			; SET BACK TO RAM
	LD	A,(DISKNO)		; STORE CURRENT DRIVE IN BUFFER
	LD	(CUDISK),A		;
	LD	A,00H			;
	EI				; RE-ENABLE INTERRUPTS
	RET
	

;___PRTMSG_______________________________________________________________________________________________
;
;	PRINT MESSAGE POINTED TO BY HL ON CONSOLE DEVICE
;________________________________________________________________________________________________________		
PRTMSG:
	LD	A,(HL)			; GET CHARACTER TO A
	CP	END			; TEST FOR END BYTE
	JP	Z,PRTMSG1		; JUMP IF END BYTE IS FOUND
	LD	C,A			; PUT CHAR TO PRINT VALUE IN REG C FOR CONOUT
	CALL	CONOUT			; SEND CHARACTER TO CONSOLE FROM REG C
	INC	HL			; INC POINTER, TO NEXT CHAR
	JP	PRTMSG			; TRANSMIT LOOP
PRTMSG1:
	RET


;___SECPAGE_______________________________________________________________________________________________
;
;	UTILITY ROUTINE FOR SECTOR TO PAGE ADDRESS
;________________________________________________________________________________________________________		
SECPAGE:
	LD	HL,(SECTOR)		; GET SECTOR INTO HL
	ADD	HL,HL			; SHIFT BITS 1 TO LEFT (*2)
	ADD	HL,HL			; SHIFT BITS 1 TO LEFT (*4)
	ADD	HL,HL			; SHIFT BITS 1 TO LEFT (*8)
	ADD	HL,HL			; SHIFT BITS 1 TO LEFT (*16)
	ADD	HL,HL			; SHIFT BITS 1 TO LEFT (*32)
	ADD	HL,HL			; SHIFT BITS 1 TO LEFT (*64)
	ADD	HL,HL			; SHIFT BITS 1 TO LEFT (*128)
	LD	(SECST),HL		; SAVE SECTOR STARTING ADDRESS
	RET
	
;___PAGERB_______________________________________________________________________________________________
;
;	PAGER BYTE CREATION
;    	ASSEMBLES DRIVE AND TRACK AND SENDS IT TO PAGER PORT
;________________________________________________________________________________________________________		
PAGERB:	
	LD	HL,(TRACK)		; LOAD TRACK INTO HL
	LD	A,(DISKNO)		; LOAD DISK INTO A
	CP	05H			; IS ROM?
	JP	Z,ROMD			; READ FROM 1M ROM DISK
	CP	06H			; IS ROM?
	JP	Z,ROMD			; READ FROM 22K ROM DISK
	AND	1			; MASK FOR 1 BIT OF DRIVE SELECT 
	RRCA				; MOVE BIT 0 TO BIT 7
	OR	L			; OR L WITH ACC TO COMBINE TRACK AND DRIVE
	OUT	(MPCL_RAM),A		; SEND TO RAM PORT MAPPER
	LD	(PAGER),A		; SAVE COPY (JUST BECAUSE)
	RET				;
ROMD:					;
	LD	A,05H			;
	AND	1			; MASK FOR 1 BIT OF DRIVE SELECT 
	RRCA				; MOVE BIT 0 TO BIT 7
	OR	L			; OR L WITH ACC TO COMBINE TRACK AND DRIVE
	AND	7FH			; STRIP OFF BIT 7 (ROM_ENABLE BIT)
	OUT	(MPCL_ROM),A		; SEND TO ROM PORT MAPPER
	LD	(PAGER),A		; SAVE COPY (JUST BECAUSE)
	LD	(DB_PAGER),A		; SAVE COPY (JUST BECAUSE) (DEBUG)
	RET

;___RPAGE_______________________________________________________________________________________________
;
;	RESET PAGER BACK TO RAM   
;________________________________________________________________________________________________________		
RPAGE:
	LD	A,80H			; DESELECT ROM PAGE
	OUT	(MPCL_ROM),A		; SELECT RAM
	LD	A,00H			; SET TO RAM, TRACK 0
	OUT	(MPCL_RAM),A		; SELECT RAM
	LD	(PAGER),A		; SAVE COPY OF PAGER BYTE
	RET

;___COPY_CPM_SECTOR______________________________________________________________________________________
;
; 	COPIES ONE CPM SECTOR FROM ONE MEMORY ADDRESS TO ANOTHER
;	INPUT
;  		 DE SOURCE ADDRESS
;		 HL TARGET ADDRESS
; 	USES C REGISTER
;________________________________________________________________________________________________________		
COPY_CPM_SECTOR:
	LD	BC,128			; BC IS COUNTER FOR FIXED SIZE TRANSFER (128 BYTES)
	LDIR				; TRANSFER
	RET

;__DELAY24__________________________________________________________________________________________________________________________ 
;
; 	DELAY 24US
;________________________________________________________________________________________________________________________________
;
	
DELAY24:	
					; JP= 10T	
	PUSH	IX			; 15T
	POP	IX			; 14T
	PUSH	IX			; 15T
	POP	IX			; 14T
DELAY12:
	PUSH	IX			; 15T
	POP	IX			; 14T
	RET				; 10T



;__DELAYHSEC__________________________________________________________________________________________________________________________ 
;
; DELAY FOR 1/2 SECOND
;________________________________________________________________________________________________________________________________
;		
DELAYHSEC:
	LD	HL,00000H		; 65536
DELDM:
	NOP				; (4 T) 
	NOP				; (4 T)
	NOP				; (4 T)
	NOP				; (4 T)
	DEC	L			; (6 T)
	JP	NZ,DELDM		; (10 T) 24 T  8 MICROSECONDS AT 4 MHZ
	DEC	H			; (6 T)
	JP	NZ,DELDM		; (10 T) (8 US * 256) * 256  524288 US   5 SECONDS
	RET

	
;
;
;     LEES SDCARD
;

CMD0   equ 040h |  0 ; resets the card
CMD9   equ 040h |  9 ; read CSD
CMD10  equ 040h | 10 ; read CID
CMD16  equ 040h | 16 ; set R/W block
CMD17  equ 040h | 17 ; read block
CMD24  equ 040h | 24 ; write block
CMD55  equ 040h | 55 ; next command is ACMDxx
ACMD41 equ 040h | 41 ; send host capacity support, init card

sdcard:
	call sd_init
	jr nz, no_sd
	ld hl, msgsd
        call PRTMSG
       	ld de, (sd_bytes+2)  ; print sd size in bytes
	ld hl, (sd_bytes+0)
	call print_dword
        ld hl,msgsde
        call PRTMSG
        ret
        
no_sd   ld hl,msgnosd
	call PRTMSG
	ret
	

msgnosd	DB	LF, CR
	DB	"NO SD-CARD FOUND"
	DB	LF, CR			; LINE FEED AND CARRIAGE RETURN
	DB	END			; LINE TERMINATOR
msgsd   DB	LF, CR
	db      "SD CARD FOUND SIZE: "
        db      END
msgsde  db      " BYTES"
        db      LF, CR
        db      END
        
sd_init:
 	ld b, 255
 	call sd_wiggle
 	call sd_select      ; ignore busy condition
 	call sd_init_1
 	jp sd_done
 
sd_select:
 	call sd_fini
 
 	or SD_CS            ; select, still idle data
 	out (RTC), a
 	ret                 ; af b trashed
 
sd_fini:
 	ld b, 17            ; clock low high low high ... low, 8 pulses
 	
sd_wiggle:
 	ld a, SD_DOUT       ; unselected, idle data
L1:
 	out (RTC), a
 	xor SD_CLK
 	djnz L1
 	ret                 ; af b trashed

sd_put:                 ; byte from a
	ld c, a
	ld b, 8
L3:	ld a, 2             ; was SD_CS >> 1 maar klopt niet in rasm    ; 7 msbits
	rl c
	rla                 ; SD_DOUT is RTC.0
	out (RTC), a        ; clock is low
	or SD_CLK
	out (RTC), a        ; rising clock edge
	djnz L3
	and ~SD_CLK
	out (RTC), a        ; leave with clock low
	ret                 ; af bc trashed

sd_get:                 ; byte to a
	ld b, 8
L2:
	in a, (RTC)
	rla                 ; SD_DIN is RTC.7
	rl c
	ld a, SD_CS | SD_DOUT | SD_CLK
	out (RTC), a
	and ~SD_CLK
	out (RTC), a
	djnz L2

	ld a, c
	ret                 ; af bc trashed

; command in a, includes fixed msbits
; arg32 in dehl
; z return, if R1 (in a) is 0

sd_command_no_arg:
	ld hl, 0

sd_command_word_arg:  ; fits in HL
	ld de, 0

sd_command:           ; command in a, dword arg in dehl

	call sd_put       ; command includes fixed 01 startbits

	ld a, d           ; arg
	call sd_put
	ld a, e
	call sd_put
	ld a, h
	call sd_put
	ld a, l
	call sd_put

	ld a, 095h        ; crc7 only valid for initial CMD0
	call sd_put       ; DOUT ends up idle because of the stopbit

	ld hl, 22000      ; XXX timeout XTAL dependent
L4:
	call sd_get       ; R1 response, when msbit is clear
	or a              ; zero and sign valid
	ret p             ; R1 in a. z if ok

	dec hl
	bit 7, h          ; until HL wraps negative
	jr z, L4
	ret               ; 0x80 | ? in a, nz

; command response R1
; 0x00 ok
; or bitfield
; 0x01 idle state
; 0x02 erase reset
; 0x04 illegal command
; 0x08 command crc error
; 0x10 erase sequence error
; 0x20 address error
; 0x40 parameter error
; 0x80 timeout (other bits meaningless)
;
; packet token
; 0xFF none yet
; 0xFE ok
; or bitfield
; 0x01 error
; 0x02 controller error
; 0x04 media ecc failed
; 0x08 out of range
; 0x10 card is locked

sd_wait_token:
	ld hl, 22000      ; XXX timeout XTAL dependent
L5:
	call sd_get       ; token is first non-FF
	cp 0FFh
	ret nz            ; token in a

	dec hl
	bit 7, h          ; until HL wraps negative
	jr z, L5
	ret               ; FF in a

sd_wait_busy:
	ld hl, 22000      ; XXX timeout XTAL dependent
L6:
	call sd_get       ; 8 clocks. data output activates after 1 clock
	inc a             ; FF is not busy
	ret z             ; z, ok. a=0

	dec hl            ; else busy or something
	bit 7, h          ; until HL wraps negative
	jr z, L6
	ret               ; nz, timeout
 	

 ; z return if ok
 ; idle, ready, size, set block size
 
sd_init_1:
 	ld a, CMD0            ; GO_IDLE_STATE
 	call sd_command_no_arg
 	cp 001h
 	ret nz                ; not "idle"
 
sd_notready:
 	ld a, CMD55           ; APP_CMD
 	call sd_command_no_arg
 	and ~001h
 	ret nz                ; not "idle" nor "ok"
 
 	ld a, ACMD41          ; SD_SEND_OP_COND. arg 0x40000000 is HCS
 	call sd_command_no_arg
 	cp 001h
 	jr z, sd_notready     ; wait, while idle
 	or a
 	ret nz                ; not ok
 
 	ld a, CMD9            ; SEND_CSD
 	call sd_command_no_arg
 	ret nz                ; not ok
 
 	call sd_wait_token    ; packet start or FF if timed out
 	cp 0FEh
 	ret nz                ;  or error
 
 	ld hl, tmpbuf         ; XXX
 	ld e, 16+2            ; including crc16
L7:
 	call sd_get
 	ld (hl), a
 	inc hl
 	dec e
 	jr nz, L7             ; do 16+2 bytes
 
 	; CSD in tmpbuf. calculate size. sigh.
 
 	ld ix, tmpbuf
 
 	; c_size = ix[8] + ix[7] * 256 + (ix[6] & 0x03) * 65536
 	; c_size >>= 6
 	; 12 bits
 
 	ld l, (ix+8)
 	ld h, (ix+7)
 	ld a, (ix+6)
 	and 3
 	add hl, hl
 	rla
 	add hl, hl
 	rla
 	ld l, h
 	ld h, a
 	ld de, 0
 	inc hl                ; dehl = c_size + 1
 
 	; c_size_mult = ix[10] + (ix[9] & 0x03) * 256
 	; c_size_mult >>= 7
 	; 3 bits
 
 	ld a, (ix+10)
 	rla
 	ld a, (ix+9)
 	rla
 	and 7
 	add a, 2              ; a = c_size_mult + 2
 
 	; blocks = (c_size + 1) << (c_size_mult + 2)
 
 	call sl_dehl_a    ; dehl <<= a
 
 	; blsft = ix[5] & 0x0F
 	; 4 bits
 
 	; block = 1 << blsft
 	; bytes = blocks << blsft
 
 	ld a, (ix+5)
 	and 0Fh               ; a = blsft
 	call sl_dehl_a
 
 	ld (sd_bytes+0), hl   ; XXX overflows at 4GB
 	ld (sd_bytes+2), de
 
 	; finally to CPM sectors, /= 128
 
 	ld a, l
 	ld l, h
 	ld h, e
 	ld e, d
 	ld d, 0
 	rla
 	adc hl, hl
 	rl e
 	rl d                  ; number of CPM sectors in dehl
 
 	ld a, CMD16           ; SET_BLOCKLEN
 	ld hl, 128
 	call sd_command_word_arg
 	ret                   ; z or nz
 
 ; dehl <<= a, a is 0...31
 
sl_dehl_a_1:
 	add hl, hl
 	rl e
 	rl d
 	
sl_dehl_a:
 	dec a
 	jp p, sl_dehl_a_1
 	ret

sd_done:
	push af
	call sd_fini
	call rtc_unselect       ; /CS high, clock and dout low
	pop af
	jp nz, rw_fail
	xor a
	ei
	ret 	


sd_write_block:
	ld a, CMD24           ; WRITE_BLOCK
	call sd_command       ; dehl byteaddress
	ret nz                ; not "ok"

	ld a, 0FEh            ; packet start token
	call sd_put

	ld hl, (DMAAD)
	ld e, 128             ; loop counter
L8:
	ld a, (hl)            ; data
	inc hl
	call sd_put
	dec e
	jr nz, L8             ; do the sector

	ld a, 0FFh
	call sd_put           ; crc16
	ld a, 0FFh
	call sd_put           ; crcs are not used

	; xxx0___1
	;     010   accepted
	;     101   crc error
	;     110   write error XXX is not reporting _this_ block.

	call sd_wait_token    ; data response or FF if timed out
	and 01Fh
	cp  005h              ; "data accepted" ?
	ret

	; write will (?) really start only after 8 more clocks.
	; unselect does an extra get, so not a problem.

;	cp  00Bh              ; "transmission crc error" ?
;	jr z, retry           ; do it again

; byte offset in dehl
; z return if ok

sd_read_block:
	ld a, CMD17           ; READ_SINGLE_BLOCK
	call sd_command       ; dehl byteaddress
	ret nz                ; not "ok"

	call sd_wait_token    ; packet start or FF if timed out
	cp 0FEh
	ret nz                ;  or error

	ld hl, (DMAAD)
	ld e, 128             ; loop counter
L9:
	call sd_get           ; data
	ld (hl), a
	inc hl
	dec e
	jr nz, L9             ; do the sector

	call sd_get           ; crc16
	ld h, a
	call sd_get           ;  in HL
	ld l, a               ; crcs are not used

	xor a                 ; zero, no carry
	ret

sd_setup:
	call sd_select
	call sd_wait_busy     ; nz if timed out, z a=0 if ok
	ret nz

	; A is 0 from sd_wait_busy.
	; byte address to dehl from TRACK, SECTOR
	; when spt 256 and sector 128

	ld hl, (sectorx) ; sector to h, zero to l
	ld de, (TRACK)   ; adehl (TRACK << 16) | (SECTOR << 8) | 0

	IF 0

	srl d
	rr e
	rr h
	rr l               ; dehl sector * 128
	xor a              ; z, ok. cannot overflow

	ELSE

	; XXX XXX XXX XXX easy way out

	add hl, hl
	rl e
	rl d               ; dehl sector * 512
	adc a, a           ; z, if ok

	ENDIF

	ret

sd_write:
	call sd_setup          ; select, wait busy, calculate byte offset
	call z, sd_write_block
	jr sd_done

sd_read:
	call sd_setup
	call z, sd_read_block	
	jp sd_done

rtc_unselect:
	xor a
	out (RTC), a
	ret

rw_fail:
	ld a, 1
	ret
	

; print DEHL in decimal,
; beautifying with apostrophes every 3 digits

print_dword:
	ld ix, tmpbuf + 32  ; collect digits in reverse
	ld (ix), 0
	ld b, 4             ; single quote after every 3 digits

p_dw_1:
	djnz L72
	dec ix
	ld (ix), 27h        ; single quote
	ld b, 3             ; every 3 digits
L72:
	push bc
	ld b, 32            ; 32 bit number
	ld c, 256-10           ; divide by 10
	xor a
L70:
	adc hl, hl
	rl e
	rl d
	rla
	add a, c
	jr c, L71
	sub c
L71:
	djnz L70            ; flags not changed
	pop bc

	adc hl, hl
	rl e
	rl d

	add a, '0'          ; remainder
	dec ix
	ld (ix), a

	ld a, l             ; quotient still nonzero ?
	or h
	or e
	or d
	jr nz, p_dw_1

	push ix
	pop hl
	jr boomsg

;----------------------------------------------------------------------
; polling the uart, ttyout does an unconditional EI.
; THRE is waited for before and _after_ each character.

boomsg_1:
	out (UART), a
	inc hl
boomsg:
	in a, (UART + 5)
	bit 5,a
	jr z, boomsg
	ld a, (hl)
	or a
	jr nz, boomsg_1
	ret

		 ;	******* TEXT STRINGS *******

TXT_RO_ERROR:
	 DB CR,LF
	 DB "ERROR: WRITE TO READ ONLY DISK"
	 DB END


TXT_STARTUP_MSG:

	 IF 	CONDSHORTMSG

		 DB CR,LF
		 DB "CP/M-80 VERSION 2.2C FOR THE "
		 DB "N8VEM - With SD-CARD"
		 DB CR,LF
		 DB END

	 ELSE

		 DB "CP/M V2.2C"
		 DB END

	 ENDIF


;
;	THE REMAINDER OF THE CBIOS IS RESERVED UNINITIALIZED
;	DATA AREA, AND DOES NOT NEED TO BE A PART OF THE
;	SYSTEM MEMORY IMAGE (THE SPACE MUST BE AVAILABLE,
;	HOWEVER, BETWEEN "BEGDAT" AND "ENDDAT") 
;

FLATCH_STORE:
		 DB	00


TRACK:		 DW 0				; TWO BYTES FOR TRACK # (LOGICAL)
PTRACK:		 DW 0				; TWO BYTES FOR TRACK # (PHYSICAL)
FTRACK:		 DW 0				; TWO BYTES FOR TRACK # (HEAD LOCATION)

PAGER:		 DB 1				; COPY OF PAGER BYTE
DB_PAGER:
		 DB 0FFH			; COPY OF PAGER BYTE (DEBUG)
sectorx: 	 ds 1                           ; always zero
SECTOR:		 DW 0				; TWO BYTES FOR SECTOR # (LOGICAL)
PSECTOR: 	 DW 0				; TWO BYTES FOR SECTOR # (PHYSICAL)
V_SECTOR: 	 EQU PSECTOR			; TWO BYTES FOR VIRTUAL SECTOR #
SECST:		 DW 0				; SECTOR IN ROM/RAM START ADDRESS
DMAAD:		 DW 0				; DIRECT MEMORY ADDRESS
DISKNO:		 DB 0				; DISK NUMBER 0-15
LBA_TARGET_LO:
		 DW 0				; IDE HD PARTITION TARGET SECTOR (LOW 16 BITS)
LBA_TARGET_HI:
		 DW 0				; IDE HD PARTITION TARGET SECTOR (HI 16 BITS, 12 USED)
IDEDEVICE:
		 DB 0				; ATAPI DEVICE SELECTION FLAG

IDE_LBA0:
		 DB 0				; SET LBA 0:7
IDE_LBA1:
		 DB 0				; SET LBA 8:15
IDE_LBA2:
		 DB 0				; SET LBA 16:23
IDE_LBA3:
		 DB 0				; LOWEST 4 BITS USED ONLY TO ENABLE LBA MODE 
SECTOR_INDEX:
		 DB 1				; WHERE 128 BYTE CP/M SECTOR IS IN 512 BYTE IDE HD SECTOR
;
;	SCRATCH RAM AREA FOR BDOS USE
BEGDAT:		 EQU $				; BEGINNING OF DATA AREA

sd_bytes:	dw 0,0  ; dword. overflows at 4GB
tmpbuf:  	ds 128  ; XXX


DIRBF:		 DS 128				; SCRATCH DIRECTORY AREA
ALL00:		 DS 65				; ALLOCATION VECTOR 0  (DSM/8 = 1 BIT PER BLOCK)  44
ALL01:		 DS 33				; ALLOCATION VECTOR 1 (225/8)
ALL02:		 DS 256				; ALLOCATION VECTOR 2 (511/8)
ALL03:		 DS 256				; ALLOCATION VECTOR 3 (511/8)
ALL04:		 DS 65				; ALLOCATION VECTOR 4 (497/8)
ALL05:		 DS 65				; ALLOCATION VECTOR 4 (495/8)
ALL06:		 DS 65				; ALLOCATION VECTOR 4 (495/8)
CHK00:		 DS 5				; NOT USED FOR FIXED MEDIA
CHK01:		 DS 0				; NOT USED FOR FIXED MEDIA
CHK02:		 DS 0				; NOT USED FOR FIXED MEDIA
CHK03:		 DS 128				; NOT USED FOR FIXED MEDIA
CHK04:		 DS 0				; NOT USED FOR FIXED MEDIA
CHK05:		 DS 0				; NOT USED FOR FIXED MEDIA
CHK06:		 DS 0				; NOT USED FOR FIXED MEDIA
;
CUDISK:		 DS 1				; CURRENT PHYSICAL DISK ID IN BUFFER
CUSECTOR:					; CURRENT PHYSICAL DISK SECTOR IN BUFFER
		 DW 1	
CUTRACK:					; CURRENT PHYSICAL DISK TRACK IN BUFFER
		 DW 2
SECTOR_BUFFER:
		 DS 520				; STORAGE FOR 512 BYTE IDE HD SECTOR
TMPBUF:	 EQU SECTOR_BUFFER
ENDDAT:	 EQU $					; END OF DATA AREA
DATSIZ:	 EQU $-BEGDAT				; SIZE OF DATA AREA








	 ORG 0FDFFH
LASTBYTE:	 DB 00H

	 END
