;----------------------------------------------------------------------
; copy bios, verify and jump
;
; XXX DS1210 bbram chip:
;  if battery is below 2v,
;  second memory cycle is blocked.
;  where do refresh cycles go ? IR ? so they do no harm ?
;  XXX 125 msec recovery at powerup

	include "memory.inc"

	org 0             ; in rom bank 0. cpu /RESET cleared BANK latch
reset:
bad_ram:              ; retry if bios copy fails
	ld sp, 0          ; top of ram
	di

	ld hl, 0          ; quarter of a second, for DS1210 to wake up.
delay:
	nop
	nop
	dec l
	jr nz, delay
	dec h
	jr nz, delay

	jp over

	org 37h
	halt              ; no telling what /HALT output does...

	org 38h           ; RST 7
	jp reset          ; if FF executed by accident

over:
	IF 1

	ld hl, RAM_BIOS-1 ; byte in ram
	ld (hl), 1        ; first memory cycle via DS1210 (if one exists)
	ld (hl), 0        ; second is blocked if battery under 2v

	ENDIF

	ld hl, ROM_BIOS
	ld de, RAM_BIOS
	ld bc, 10000h - RAM_BIOS
	ldir

	ld bc, 10000h - RAM_BIOS
	dec hl            ; verify backwards
L1:
	dec de
	ld a, (de)
	cpd               ; did it stick ?
	jr nz, bad_ram    ; no
	jp pe, L1

	ld a, (RAM_BIOS-1) ; 1 = battery error
	ld b, 0            ; coming from rom
	ex de, hl          ; RAM_BIOS to hl
	jp (hl)

;----------------------------------------------------------------------
	org 63h
	jp reset          ; for bootstrap/bios conversation ?

	org 66h           ; NMI
	jp reset          ; might strike before RAM_ENB is set

	org 70h
	db "mozambique", 0, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh
