;----------------------------------------------------------------------
; CCP imitation

	include "cpm.inc"

LINES equ 24
COLS  equ 80

	org 0DC00h   ; XXX
tpa_end:         ; everything above (hmm...) is for transient load
	ds 256
cstack:
bss:

buffer:
	ds 128

	ds 2         ; RDBUFF structure
line:
	ds 127       ;  or from SUBMIT
	ds 1         ; always \0

fcb:
	ds 36
sub_fcb:
	ds 36

batch: ds 1      ; FF while reading $$$.SUB

argc: ds 1
argv:
arg0: ds 2
arg1: ds 2
arg2: ds 2

row:    ds 1
column: ds 1

;----------------------------------------------------------------------
bss_end:
	ld hl, TPA
	ld de, bss_end
	ld bc, end - bss_end
	ldir
	jp over
over:
	ld sp, cstack
	call cksum      ; XXX do this at compile time ?
	cpl
	ld (ckbyte), a
tstack:             ; everything above (hmm...) is transient stack
;----------------------------------------------------------------------
start:
	ld hl, bss
	ld bc, bss_end - bss
	call bzero

	ld hl, sub_file       ; $$$.SUB
	ld de, sub_fcb
	call make_fcb_fn

	ld a, OPENFIL
	call dos_sub
	cp 4                  ; carry if successful open
	sbc a, a              ; FF if
	ld (batch), a

command:
	ld sp, cstack

	call restore_user
	call return_carriage

	call input            ; batch or prompt
	call newline
	call split_args
	or a                  ; argc ?
	call nz, execute

	jr command

return_carriage:
	ld a, (column)        ; count row/col to pause DIR/TYPE
	or a
	call nz, newline
	xor a
	ld (row), a
	ret

;----------------------------------------------------------------------

input:
	ld a, (batch)
	or a
	jr z, prompt

	ld de, line-1
	call setbuf           ; XXX requires large line_buffer

	ld a, (sub_fcb+15)    ; read last sector to line:
	dec a
	ld (sub_fcb+32), a

	ld a, READSEQ
	call dos_sub
	or a
	jr nz, batch_done     ; includes eof

	ld hl, sub_fcb+15     ; drop last sector
	dec (hl)
	dec hl
	ld (hl), 0            ; XXX what was this byte ?

	ld a, CLOSEFIL
	call dos_sub
	cp 4
	jr nc, batch_done     ; else would execute forever

	ld a, '$'
	call putc
	ld hl, line           ; echo to console
	call puts
	ret                   ; go execute line

batch_done:
	xor a
	ld (batch), a

	ld a, DELFILE
	call dos_sub          ; and fall to prompt
	call newline

prompt:
	ld a, GETCRNT
	call dos
	add a, 'A'
	call putc             ; drive letter

	call get_user
	or a
	call nz, put_num      ; user, unless 0

	ld a, '>'
	call putc             ; and >

	ld a, 80              ; XXX MAXLINE
	ld de, line-2
	ld (de), a
	ld a, RDBUFF
	jp dos                ; line-editor, nice.

wait_key:
	ld a, GETCON
	call dos              ; wait for key
	cp 3                  ;  ^C
	jp z, command         ;  aborts to prompt.
	jp toupper

interactive:
	ld a, (batch)
	or a
	ret nz                ; SUB execution does not care
	ld a, GETIOB
	call dos
	and 3                 ; CON:
	ret                   ; z if TTY:

;----------------------------------------------------------------------

newline:
	ld a, 0Ah
putc:
	and 7Fh

	push hl
	ld hl, column
	inc (hl)              ; column++
	cp 0Ah                ; newline ?
	jr nz, L67
	ld a, 0Dh
	call putc             ; add CR
	ld (hl), 0

	ld hl, row
	inc (hl)              ; row++
	ld a, (hl)
	cp LINES              ; screen full ?
	jr c, L66
	ld (hl), 0            ; rewind row

	call interactive
	call z, wait_key
L66:
	ld a, 0Ah
L67:
	pop hl

	ld e, a
	ld a, OUTCON
	jp dos

;----------------------------------------------------------------------
; line-2 is RDBUFF structure
; or line-1 is from SUBMIT

split_args:
	ld a, (line-1)        ; length
	cp 128
	jp nc, WBOOT          ; XXX if never happens
	ld hl, line
	call add_hl_a
	ld c, 0               ; argc in c
	ld (hl), c            ; \0 terminate
	push hl               ; remember line end

	ld de, line
	call pick_word      ; command
	ld (arg0), hl

	pop hl              ; line end
	push bc
	push de
	and a
	sbc hl, de          ; tail length
	ld c, l
	ld b, h             ;  in bc
	inc bc              ; copy \0 too
	ld h, ' '           ; XXX
	inc l               ; XXX
	ld (0080h), hl
	ld hl, 0082h
	ex de, hl           ; command tail to hl
	ldir

	pop de
	pop bc
	call pick_word      ;  pick arguments
	ld (arg1), hl

	call pick_word
	ld (arg2), hl

	call pick_word      ; check for 4th, unused by builtins, arg
	ld a, c
	ld (argc), a
	ret

;----------------------------------------------------------------------
; skip blanks, remember beginning of word or \0,
; skip the word and cut, count words in c

pick_1:
	inc de
pick_word:
	ld a, (de)
	cp ' '
	jr z, pick_1     ; skip while blank
	ld l, e
	ld h, d          ; "" if at end
	or a
	ret z

	inc c            ; argc++
pick_2:
	call toupper
	ld (de), a
	inc de
	ld a, (de)
	or a
	ret z            ; no blanks after last word
	cp ' '
	jr nz, pick_2
	xor a
	ld (de), a
	inc de           ; past the cut
	ret

;----------------------------------------------------------------------

huh:
	call err_1
	db "?", 0

error:
	call return_carriage
	ld hl, fcb
	call print_d_fcb
	ld a, ' '
	call putc
err_1:
	pop hl
	call puts
	jp command        ; rewinds stack and such

print_d_fcb:
	ld a, (hl)       ; 0 or 1...16
	inc hl
	or a
	jr z, print_fcb
	add a, 'A'-1
	call putc
	ld a, ':'
	call putc

print_fcb:
	ld b, 8
	call L60
	ld b, 3
	ld a, '.'
	call putc
L60:
	ld a, (hl)
	inc hl
	cp ' '
	call nz, putc     ; XXX
	djnz L60
	ret

dos_open:
	ld a, OPENFIL
dos_file:
	ld de, fcb
	call dos
	cp 4            ; 0-3 is success
	ccf             ; carry clear if so
	ret

exist:
	call make_fcb   ; filename in hl

	ld a, GETFST
	jr dos_file

dos_read:
	ld a, READSEQ
	call dos_file
	cp 1
	ret z           ; eof, z nc
	ccf             ; ok, nz nc
	ret             ; error, nz c

restore_user:
	ld hl, user
	ld e, (hl)
	inc e
	ret z           ; no need to restore
	ld (hl), 0FFh
	dec e
	jr set_user

get_user:
	ld e, 0FFh
set_user:
	ld a, GETUSER
	jr dos

select_drive:
	sub 'A'
	jp c, huh
	cp 16
	jp nc, huh

	ld e, a
	ld a, SETDSK
	jr dos

setbuf:
	ld a, PUTDMA

dos:
	push hl
	push bc
	ld c, a
	call BDOS
	ex de, hl       ; de in, de out if needed
	pop bc
	pop hl
	ret

dos_sub:
	ld de, sub_fcb
	jr dos

;----------------------------------------------------------------------

puts_1:
	call putc
puts:
	ld a, (hl)
	inc hl
	or a
	jr nz, puts_1
	ret

put_num:               ; a to console in decimal, no leading zeroes
	ld hl, buffer + 5
	ld (hl), 0
L16:
	ld bc, 0AFFh
L17:
	inc c
	sub b
	jr nc, L17

	add a, 10+'0'
	dec hl
	ld (hl), a
	ld a, c
	or a
	jr nz, L16
	jp puts

get_num:           ; decimal 0...65535 from (hl+) to de
	ld de, 0
L50:
	push hl
	ld l, e
	ld h, d
	add hl, hl
	add hl, hl
	add hl, de
	add hl, hl
	ex de, hl
	pop hl

	ld a, (hl)
	sub '0'
	ret c          ; carry set if not a number
	cp 10
	ccf
	ret c

	add a, e
	ld e, a
	ld a, 0
	adc a, d
	ld d, a

	inc hl
	ld a, (hl)
	or a
	jr nz, L50
	ret

add_hl_a:
	add a, l
	ld l, a
	ret nc
	inc h
	ret

bzero:
	xor a
memset:
	ld (hl), a
	ld e, l
	ld d, h
	inc de
	dec bc
	ldir
	ret

toupper:
	cp 'a'
	ret c
	cp 'z'+1
	ret nc
	xor 20h
	ret

;----------------------------------------------------------------------
; XXX crazy

make_fcb:
	push hl    ; filename in
	ld hl, fcb
	push hl
	ld bc, 36
	call bzero

	pop de     ; fcb
	pop hl     ; filename

make_fcb_fn:
	ld a, (hl)        ; drive letter ?
	or a
	jr z, L1          ; nothing
	inc hl
	ld a, (hl)
	dec hl
	cp ':'
	ld a, 0           ; 0. default drive
	jr nz, L1
	ld a, (hl)        ; or named drive
	sub 'A'
	cp 16
	jp nc, huh
	inc a             ; A=1
	inc hl
	inc hl
L1:
	ld (de), a
	inc de

	ld b, 8
	call L3           ; filename

	ld b, 3           ; and typ
L2:
	ld a, (hl)        ; to one past dot, or to \0
	inc hl
	cp '.'
	jr z, L3          ; past dot.
	or a
	jr nz, L2         ; discard until
	dec hl            ; back at \0

L3:
	ld c, ' '         ; pad with spaces
L4:
	ld a, (hl)
	cp '.'
	jr z, L5          ; dot. stop
	cp ' '+1
	jr c, L5          ; space or below. stop
	cp '*'
	jr nz, L6         ; accept
	ld c, '?'         ; change padding AND this char to ?
	inc hl            ; undo next dec hl
L5:
	dec hl            ; stay within
	ld a, c           ; blank or question mark
L6:
	inc hl
	ld (de), a
	inc de
	djnz L4
	ret

;----------------------------------------------------------------------

builtins:
	db "DIR", 0
	dw cmd_dir

	db "TYPE", 0
	dw cmd_type

	db "USER", 0
	dw cmd_user

	db "REN", 0
	dw cmd_ren

	db "ERA", 0
	dw cmd_era

	db "SAVE", 0
	dw cmd_save

	db "IOBYTE", 0
	dw cmd_iobyte

	db 0            ; mark end of builtins

sub_file:
	db "$$$.SUB", 0

yesno:
	db "Erase [yN] ? ", 0

com_typ:
	db "COM"

;----------------------------------------------------------------------
; IOBYTE xx:xx:xx:xx

cmd_iobyte:
	ld a, GETIOB
	call dos
	ld l, a
	ld b, 4
Liob:
	ld h, '0' >> 2
	add hl, hl
	add hl, hl
	ld a, h
	call putc
	dec b
	ret z
	ld a, ':'
	call putc
	jr Liob

;----------------------------------------------------------------------
; USER n                      Change user area (n=0 to 15)  (ver 2.x)

cmd_user:
	cp 2
	jr z, L70        ; set
	jp nc, huh       ; extra arguments

	call get_user
	jp put_num       ; newline from command:
L70:
	ld hl, (arg1)
	call get_num     ; to de
	jp c, huh
	jp set_user      ; user=e

;----------------------------------------------------------------------
; DIR                         Display file directory, current drive
; DIR d:                      Display file directory, designated drive
; DIR filename.typ            Search for file name, current drive
; DIR *.typ                   Display all files of named type, curr drive
; DIR filename.*              Display all types of designated filename
; DIR x????.*                 Display all filenames 5 characters long and
;							  starting with letter x

cmd_dir:
	ld hl, (arg1)
	call make_fcb

	ld hl, fcb+1
	ld bc, 8+3
	ld a, ' '         ; all blanks ?
L8:
	cpi
	jr nz, L9         ; no
	jp pe, L8

	ld a, '?'
	ld hl, fcb+1
	ld bc, 8+3
	call memset       ; make wildcard, but keep possible drive
L9:

	ld a, GETFST
	ld hl, 0              ; count them
dnext:
	call dos_file
	ret c                 ; failure. take as 'no more files'

	inc hl
	push hl

	rrca                  ; 0-3 to quarter in 128 byte io buffer
	rrca
	rrca
	ld hl, buffer
	call add_hl_a         ; directory entry image

	IF 0

	ld de, 1+8+1          ; SYS/DIR bit in 2nd typ character
	ex de, hl
	add hl, de
	bit 7, (hl)           ;  hidden ?
	ex de, hl
	jr nz, L64            ; skip those

	ENDIF

	inc hl                ; XXX skip drive letters
	call print_fcb
L65:
	ld a, (column)
	cp 16 * 4 + 1       ; 5 times 16, but no blanks after 5th name
	jr nc, L68          ; wrap now
	and 15
	jr z, L64           ; reached column 16*x
	ld a, ' '
	call putc
	jr L65              ; keep padding
L68:
	call newline
L64:
	ld a, GETNXT
	pop hl
	jr dnext

;----------------------------------------------------------------------
; ERA filename.typ            Erase named file, current drive
; ERA *.*                     Erase all files, curr drv, ver 2.x curr user
; ERA *.typ                   Erase all files, current drive
; ERA d:filename.typ          Erase named file, designated drive
; ERA filename.*              Erase all types of named file, current drive

cmd_era:
	cp 2
	jp nz, huh

	ld hl, (arg1)
	call make_fcb

	ld hl, fcb+1
	ld bc, 8+3
	ld a, '?'
	cpir
	jr nz, no_ask

	call interactive
	jr nz, no_ask

	call cmd_dir
	ld a, h
	or l
	jr nz, not_empty

	ld hl, fcb
	call print_d_fcb
not_empty:
	call return_carriage

	ld hl, yesno
	call puts
	call wait_key
	cp 'Y'
	ret nz

	ld hl, (arg1)    ; did dir mangle it ?
	call make_fcb
no_ask:

	ld a, DELFILE
	call dos_file
	jp c, no_file
	ret

;----------------------------------------------------------------------
; REN nuname.typ=olname.typ   Rename file, current drive
; REN d:nuname.typ=olname.typ Rename file, designated drive

cmd_ren:
	cp 3
	jp nz, huh

	ld hl, (arg2)
	call exist
	jp c, no_file

	ld hl, (arg1)
	call exist
	jp nc, file_exists

	ld hl, (arg2)
	call make_fcb

	ld hl, (arg1)
	ld de, fcb+16
	call make_fcb_fn

	ld a, RENFILE         ; 0-3
	call dos_file
	ret nc

	jp huh

;----------------------------------------------------------------------
; TYPE filename.typ           Display ASCII file, current drive
; TYPE d:filename.typ         Display ASCII file, designated drive

cmd_type:
	cp 2
	jp nz, huh

	ld hl, (arg1)
	call make_fcb
	call dos_open
	jp c, no_file

tmore:
	call dos_read
	ret z
	jp c, read_error

	ld hl, buffer
	ld b, 128
tprint:
	ld a, (hl)
	inc hl
	cp 1Ah
	ret z                ; ^Z
	call putc
	djnz tprint

	jr tmore

;----------------------------------------------------------------------
; SAVE n filename.typ         Save as named file, current drive
; SAVE n d:filename.typ       Save as named file, designated drive
;							  n pages (page = 256 bytes) starting at 100H
;
; SAVE 0 creates an empty file
; SAVE 256 writes 64kB (page 0 at end)

cmd_save:
	cp 3
	jp nz, huh

	ld hl, (arg1)
	call get_num        ; page count to de
	jp c, huh

	ex de, hl
	add hl, hl
	push hl             ; save sector count

	ld hl, (arg2)
	call exist
	jp nc, file_exists

	ld a, FCREATE
	call dos_file
	jp c, no_file

	ld hl, TPA
	pop bc              ; sector count back
	jr save_start

save_more:
	ld e, l
	ld d, h
	call setbuf

	ld a, WRTSEQ       ; 0 is OK
	call dos_file
	or a
	jr nz, save_done

	ld de, 128
	add hl, de

	dec bc
save_start:
	ld a, b
	or c
	jr nz, save_more

save_done:
	ld a, CLOSEFIL
	call dos_file
	jr c, write_error

	ld a, b             ; broke loop with error ?
	or c
	ret z       ; else fall thru

write_error:
	call error
	db "write error", 0

;----------------------------------------------------------------------

no_file:
	call error
	db "?", 0

file_exists:
	call error
	db "exists", 0

read_error:
	call error
	db "read error", 0

;----------------------------------------------------------------------

load:
	call dos_open  ; fcb has been filled already
	jr nc, load_it

	call get_user
	or a
	jr z, try_1    ; user already 0

	ld (user), a   ; restored before jp TPA or after bombing to prompt

	ld e, 0        ; try user 0
	call set_user

	call dos_open
	jr nc, load_it

try_1:
	ld hl, fcb
	ld a, (hl)
	or a
	jr nz, try_2   ; drive was specified

	ld a, 1
	ld (hl), a     ; try A0: XXX should be configurable

	call dos_open
	jr nc, load_it

try_2:
	ld hl, (arg0)
	call puts
	jp huh


; XXX with more thought,
; could load slightly larger programs,
; forcing a warm boot afterwards.

load_it:
	ld hl, TPA

load_more:
	ld e, l
	ld d, h
	call setbuf

	call dos_read
	ret z              ; if z, also nc.
	jr c, read_error

	ld de, 128
	add hl, de

	ld de, (-(tpa_end - 128)) & 0FFFFh ; XXX
	ex de, hl
	add hl, de
	ex de, hl
	jr nc, load_more

	call error
	db "too big", 0

;----------------------------------------------------------------------

execute:
	ld de, buffer
	call setbuf

	ld de, builtins
L41:
	ld hl, (arg0)
L42:
	ld a, (de)
	inc de
	cp (hl)
	inc hl
	jr nz, L44       ; not this one, skip to next table entry
	or a
	jr nz, L42       ; compare until both at \0

	ex de, hl
	ld e, (hl)
	inc hl
	ld d, (hl)
	ex de, hl
	ld a, (argc)
jp_hl:
	jp (hl)          ; builtin
L43:
	ld a, (de)
	inc de
L44:
	or a
	jr nz, L43       ; skip to \0 in table
	inc de
	inc de           ; skip address

	ld a, (de)       ; "" ends table
	or a
	jr nz, L41

	; unknown

	ld hl, (arg0)    ; just X: ?
	ld e, (hl)
	inc hl
	ld a, (hl)
	inc hl
	sub ':'
	or (hl)
	ld a, e
	jp z, select_drive

	; transient

	ld hl, 5Ch
	ld bc, 36
	call bzero

	ld de, 5Ch
	ld hl, (arg1)
	call make_fcb_fn

	ld de, 6Ch
	ld hl, (arg2)
	call make_fcb_fn

	ld hl, (arg0)
	call make_fcb

	ld hl, com_typ
	ld de, fcb+9
	ld bc, 3
	ldir

	call load
	call restore_user

	ld de, 0080h
	call setbuf

	ld sp, tstack
	call TPA

	; return from transient

	ld sp, cstack
	call cksum
	inc a
	jp z, start

	rst 0         ; WBOOT

cksum:
	ld hl, start
	ld bc, end - start
	xor a
cksum_1:
	add a, (hl)
	cpi
	jp pe, cksum_1
	ret

user:   db 0FFh    ; == none. used by load/restore_user
ckbyte: db 0       ; start ... end checksum zero

end:
