
	include "cpm.inc"
	org TPA

	ld (stack), sp
	ld sp, stack

	ld c, 10           ; try 9 times
redo:
	dec c
	jr z, giveup

	ld hl, tim
	ld b, 6
loop:
	call reader
	jr z, redo         ; 12 digits expected
	ld (hl), a
	inc hl
	call reader
	jr z, redo
	ld (hl), a
	inc hl
	inc hl             ; skip punctuation
	djnz loop

	call reader
	jr nz, redo        ; and then the ^Z

	ld de, message
	ld c, PRTSTR
	call BDOS

giveup:
	ld sp, (stack)
	ret

reader:
	push hl
	push bc
	ld c, GETRDR
	call BDOS
	pop bc
	pop hl
	cp 1Ah          ; is ^Z ?
	ret

;----------------------------------------------------------------------

message:
	db "The time is "
tim:
	db "yy.mm.dd HH:MM:SS"
	db 0Dh, 0Ah, "$"

	ds 256
stack:
	ds 2

