
	include "cpm.inc"
	org TPA

	ld sp, stack

	ld de, usage

	ld a, (80h)        ; command tail
	cp 3
	jr nz, stop

	ld a, (83h)
	cp ':'
	jr nz, stop

	ld a, (82h)
	ld (nosuch), a
	ld (error), a
	ld (ok), a

	sub 'A'
	jr c, stop
	cp 16
	jr nc, stop

	ld c, a            ; disk number
	ld e, BIOS_SELDSK
	call bios
	ld a, l
	or h
	ld de, nosuch
	jr z, stop         ; no such disk

	ld de, 10          ; dpb from dph
	add hl, de
	ld e, (hl)
	inc hl
	ld d, (hl)
	ex de, hl

	ld de, 13          ; off from dpb
	add hl, de
	ld c, (hl)
	inc hl
	ld b, (hl)         ; first directory track in bc

	ld e, BIOS_SETTRK
	call bios

	ld bc, buffer
	ld e, BIOS_SETDMA
	call bios

loop:
	ld bc, (sector)    ; sector 0 is first
	ld e, BIOS_SETSEC
	call bios

	ld c, 1            ; a directory write
	ld e, BIOS_WRITE
	call bios
	or a
	ld de, error
	jr nz, stop        ; write error

	ld hl, sector
	inc (hl)
	jr nz, loop        ; write sectors up to and including 255

	ld de, ok
stop:
	ld c, PRTSTR
	call BDOS
	jp WBOOT

bios:
	ld d, 0
	ld hl, (WBOOT+1)
	add hl, de
	add hl, de
	add hl, de
	jp (hl)

;----------------------------------------------------------------------

disk:
	db 0
sector:
	dw 0

usage:
	db "Usage: dirzap C:", 0Dh, 0Ah, "$"
nosuch:
	db "X: is missing", 0Dh, 0Ah, "$"
error:
	db "X: write error", 0Dh, 0Ah, "$"
ok:
	db "X: directory zapped", 0Dh, 0Ah, "$"

buffer:
	db 0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h ; 128 bytes
	db 0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h
	db 0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h
	db 0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h
	db 0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h
	db 0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h
	db 0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h
	db 0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h
	db 0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h
	db 0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h
	db 0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h
	db 0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h
	db 0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h
	db 0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h
	db 0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h
	db 0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h

	ds 256
stack:

