
PPI      equ 60h
UART     equ 68h
RTC      equ 70h
GPO      equ 78h ; aka MPCL_RAM
BANK     equ 7Ch ; aka MPCL_ROM, but controls now both ram and rom

PPI_A    equ PPI+0
PPI_B    equ PPI+1
PPI_C    equ PPI+2
PPI_CTRL equ PPI+3

UART_DAT equ UART+0
UART_IER equ UART+1
UART_IIR equ UART+2
UART_FCR equ UART+2
UART_LCR equ UART+3
UART_MCR equ UART+4
UART_LSR equ UART+5
UART_MSR equ UART+6
UART_DLL equ UART+0
UART_DLH equ UART+1

RTC_DOUT equ 80h ; 74574 RTC/SD output bits
RTC_CLK  equ 40h
RTC_DIR  equ 20h
RTC_CE   equ 10h
SD_CS    equ 04h ; NPN inverter, positive logic.
SD_CLK   equ 02h
SD_DOUT  equ 01h

RTC_DIN  equ 01h ; 74125 RTC/SD input bits
SD_DIN   equ 80h

RAM_ENB  equ 80h  ; 74273 BANK msbit
BANK_TPA equ 0FEh ; TPA+system in 2 last banks

UART_XTAL equ 3686400 ; Hz
XTAL      equ 3686400 ; Hz

;XTAL      equ 4096000 ; Hz
;XTAL      equ 4000000
;XTAL      equ 4194304

