
	include "cpm.inc"
	org TPA

	ld (stack), sp
	ld sp, stack

	ld a, (80h)
	call foo
	ld a, (81h)
	call foo
	ld a, (82h)
	call foo
	ld a, (83h)
	call foo

	ld sp, (stack)
	ret

foo:
	push af
	rra
	rra
	rra
	rra
	call wren
	pop af
wren:
	and 0Fh
	cp 10
	jr c, cc
	add a, 7
cc:
	add a, '0'
	ld e, a
	ld c, OUTCON
	call BDOS
	ret

bar:
	ld de, fcb
	ld c, OPENFIL
	call BDOS
	ld de, not_found
	cp 4
	jr nc, stop       ; 4 or more

	ld de, fcb
	ld c, FILESIZE
	call BDOS

;	ld de, size_trouble
;	cp 4
;	jr nc, stop       ; 4 or more

	ld de, (fcb_nsect-1) ; 255 sectors should cover it
	ld e, 0
	srl d
	rr e              ; *= 128 XXX partial sector at end ?

	ld hl, (BDOS+1)
	and a
	sbc hl, de        ; ptr
	push hl           ; entry to stack

more:
	push hl           ; ptr

	ex de, hl
	ld c, PUTDMA
	call BDOS

	ld de, fcb
	ld c, READSEQ
	call BDOS
	ld de, read_error

	pop hl            ; ptr back

	cp 1
	ret z             ; eof. return, to entry
	jr nc, stop       ; not ok

	ld de, 128
	add hl, de        ; ptr += 128
	jr more

stop:
	ld c, PRTSTR
	call BDOS

	jp WBOOT

;----------------------------------------------------------------------

not_found:
	db "A:CCP.BIN: cannot open", 0Dh, 0Ah, "$"
read_error:
	db "A:CCP.BIN: read error", 0Dh, 0Ah, "$"

fcb:
	db 1, "CCP     BIN", 0,0,0,0
	dw 0,0,0,0,0,0,0,0
	db 0
fcb_nsect:
	dw 0
	db 0

;----------------------------------------------------------------------

	ds 256
stack:
	ds 2
