;----------------------------------------------------------------------
; XMODEM receive file
; XXX timeout depends on XTAL

	include "cpm.inc"
	org TPA

buffer equ 8000h        ; XXX out of banked area

	ld (stack), sp
	ld sp, stack

	call find_bios

	ld de, usage
	ld hl, 80h
	ld a, (hl)
	cp 2                 ; at least " x" argument
	jr c, exit

	inc hl
	inc hl
	ld de, fcb
	call make_fcb

	ld de, buffer
	ld c, PUTDMA
	call BDOS

	ld de, fcb
	ld c, FCREATE
	call BDOS           ; create file
	cp 4                ; 0-3 is success
	jr nc, error

	ld de, prompt
	ld c, PRTSTR
	call BDOS

	call receive        ; file contents

	ld de, fcb
	ld c, CLOSEFIL
	call BDOS
	or a
	jr nz, error

	ld c, ACK
	call putc

	ld de, ok
exit:
	ld c, PRTSTR
	call BDOS           ; sorry or ok

	ld sp, (stack)
	ret

abort:
error:
	ld de, sorry
	jr exit

;----------------------------------------------------------------------

SOH equ 1
ETX equ 3
EOT equ 4
ACK equ 6
NAK equ 15h
CAN equ 18h

receive:
	xor a
	ld (blknum), a

	ld (timosp), sp

flush:
	call getc
timeout:
	ld sp, (timosp)

nakit:
	ld c, NAK
reply:
	call putc

	call getc           ; SOH
	cp EOT
	ret z               ; or EOT.
	cp ETX
	jr z, abort         ; accept ^C at this point
	cp SOH
	jr nz, flush        ; out of sync

	call getc           ; block number
	ld h, a
	call getc           ;  and complement
	cpl
	cp h
	jr nz, flush        ; out of sync

	push hl             ; remember block number

	ld hl, buffer
	ld b, 128
	ld c, 0             ; checksum
loop:
	call getc
	ld (hl), a
	inc hl
	add a, c            ; accumulate checksum
	ld c, a
	djnz loop           ; get 128 bytes

	pop hl              ; block number back to h

	call getc
	cp c                ; checksum match ?
	jr nz, flush        ; out of sync

	ld a, (blknum)      ; expected block
	dec a
	cp h                ; this one is
	jr z, ackit         ;  previous. accept but no save
	inc a
	cp h
	jr nz, nakit        ; not the expected either
	inc a
	ld (blknum), a      ; next please

	ld de, fcb
	ld c, WRTSEQ
	call BDOS
	or a
	jr nz, error        ; disk error

ackit:
	ld c, ACK
	jr reply

;----------------------------------------------------------------------

find_bios:
	ld de, (WBOOT+1)        ; bios console calls

	ld hl, 3 * BIOS_CONST
	add hl, de
	ld (fi+1), hl

	ld hl, 3 * BIOS_CONIN
	add hl, de
	ld (pi+1), hl

	ld hl, 3 * BIOS_CONOUT
	add hl, de
	ld (po+1), hl
	ret

putc:
	push bc
	push hl
po:
	call 0          ; BIOS_CONOUT
	pop hl
	pop bc
	ret

getc:
	push bc
	push hl

	ld bc, 30000    ; one second XXX XTAL
wait:
	push bc
fi:
	call 0          ; BIOS_CONST
	pop bc
	jr nz, pi

	dec bc
	bit 7, b
	jr z, wait

	jp timeout      ; stack rewound
pi:
	call 0          ; BIOS_CONIN
	pop hl
	pop bc
	ret

;----------------------------------------------------------------------

make_fcb:
	inc hl            ; drive letter ?
	ld a, (hl)
	dec hl
	cp ':'
	ld a, 0           ; default drive
	jr nz, L1
	ld a, (hl)
	sub 'A' - 1       ; or named drive
	inc hl
	inc hl
L1:
	ld (de), a
	inc de

	ld c, '.'
	ld b, 8
	call L4           ; filename

	ld a, (hl)
	cp c              ; dot ?
	jr nz, L2
	inc hl
L2:
	ld c, 0
	ld b, 3
	call L4           ; typ

	ld b, 36 - 12
	xor a
L3:
	ld (de), a
	inc de
	djnz L3
	ret

L4:
	ld a, (hl)
	inc hl
	cp ' '+1
	jr c, L5          ; space or below, stop here
	cp c
	jr nz, L6         ; not a dot. accept it
L5:
	dec hl            ; stay within
	ld a, ' '         ; blank pad
L6:
	ld (de), a
	inc de
	djnz L4
	ret

;----------------------------------------------------------------------

usage:
	db "Usage: receive filename", 0Dh, 0Ah, "$"
prompt:
	db "Send file with XMODEM or press ^C", 0Dh, 0Ah, "$"
sorry:
	db 0Dh, 0Ah, "problems", 0Dh, 0Ah, "$"
ok:
	db 0Dh, 0Ah, "receive ok", 0Dh, 0Ah, "$"

;----------------------------------------------------------------------

blknum:
	ds 1

timosp:
	ds 2

fcb:
	ds 1
	ds 8
	ds 3
	ds 4      ; record,extent,etc
	ds 16
	ds 8      ; XXX a word and what else ?

	ds 256
stack:
	ds 2

