;----------------------------------------------------------------------
; show or change the 8MB SD slot visible in D: drive

	include "cpm.inc"
	org TPA

	ld c, 3            ; disk number XXX
	ld e, BIOS_SELDSK
	call bios
	ld a, l
	or h
	ld de, nosuch
	jr z, stop         ; no such disk

	ld de, 10          ; dpb from dph
	add hl, de
	ld e, (hl)
	inc hl
	ld d, (hl)
	ex de, hl

	ld de, 13+1        ; off msbyte from dpb
	add hl, de

	ld a, (80h)        ; command tail
	cp 2
	jr nz, show

	ld a, (82h)
	sub '0'
	jr c, show
	cp 10
	jr nc, show

	add a, 1           ; first slot is c:, skip it
	ld (hl), a         ; off changed
show:
	ld a, (hl)
	sub 1              ; "slot 0" is second 8MB
	add a, '0'
	ld (which), a      ; show the slot

	ld de, ok
stop:
	ld c, PRTSTR
	call BDOS

	rst 0              ; disk reset needed after stealth seldsk

bios:
	ld hl, (WBOOT+1)
	ld d, 0
	add hl, de
	add hl, de
	add hl, de
	jp (hl)

;----------------------------------------------------------------------

slot:
	db 0

nosuch:
	db "D: is missing", 0Dh, 0Ah, "$"

ok:
	db "D: slot ",
which:
	db "X", 0Dh, 0Ah, "$"

