;----------------------------------------------------------------------
; write
; to romdisk system tracks
; from files
; bootstrap.bin
; bios.bin
; cpm.bin

	include "cpm.inc"
	org TPA

	ld (stack), sp
	ld sp, stack

	ld bc, 0            ; XXX
	ld hl, name_boot
	call update

	ld bc, 200h         ; XXX
	ld hl, name_bios
	call update

	ld bc, 1000h        ; XXX
	ld hl, name_cpm
	call update

exit:
	ld sp, (stack)
	ret

;----------------------------------------------------------------------
; hl filename
; bc rom byte offset (7 lsbits assumed zero)

update:
	ld a, c          ; bc /= 128
	ld c, b
	ld b, 0
	rla
	rl c
	rl b
	ld (sector), bc

	push hl
	call puts
	ld a, ':'
	call putc
	ld a, ' '
	call putc

	pop hl
	ld de, fcb
	call make_fcb

	ld a, RSTDSK
	call dos

	; read sequentially from file

	ld a, OPENFIL
	call file
	cp 4                ; 0-3 is success
	jr nc, no_file

	ld hl, 8000h        ; XXX
	ld b, 0
rd:
	ld e, l
	ld d, h
	ld a, PUTDMA
	call dos

	ld a, READSEQ
	call file
	cp 1
	jr z, eof
	jr nc, panic         ; read error

	ld de, 128
	add hl, de
	inc b
	jr rd
eof:
	ld a, b
	ld (nsect), a
	or a
	jr z, panic         ; zero length ?

	; write to track 0

	ld c, 0
	call seldsk
	ld a, h
	or l
	jr z, panic         ; A: does not exist ?

	ld bc, 0
	call settrk

	ld hl, 8000h        ; XXX
	ld bc, (sector)
wr:
	push hl
	push bc
	ld c, l
	ld b, h
	call setbuf
	pop bc
	push bc
	call setsec

	call write
	pop bc
	pop hl
	or a
	jr nz, panic       ; not eeprom ?

	ld de, 128
	add hl, de
	inc bc

	ld a, (nsect)
	dec a
	ld (nsect), a
	jr nz, wr

	ld hl, ok
	jr retu
no_file:
	ld hl, missing
retu:
	call puts
	call newline
	ret                ; missing file is benign error

panic:
	ld hl, problems
	call puts
	call newline
	jp exit

;----------------------------------------------------------------------

file:
	ld de, fcb
dos:
	push hl
	push bc
	ld c, a
	call BDOS
	ex de, hl
	pop bc
	pop hl
	ret

newline:
	ld a, 0Dh
	call putc
	ld a, 0Ah
putc:
	ld e, a
	ld a, OUTCON
	call dos
	ret

puts_1:
	call putc
	inc hl
puts:
	ld a, (hl)
	or a
	jr nz, puts_1
	ret

;----------------------------------------------------------------------

seldsk:
	ld de, 3 * BIOS_SELDSK
	jr bios

settrk:
	ld de, 3 * BIOS_SETTRK
	jr bios

setsec:
	ld de, 3 * BIOS_SETSEC
	jr bios

setbuf:
	ld de, 3 * BIOS_SETDMA
	jr bios

write:
	ld de, 3 * BIOS_WRITE

bios:
	ld hl, (WBOOT+1)
	add hl, de
	jp (hl)

;----------------------------------------------------------------------

make_fcb:
	inc hl            ; drive letter ?
	ld a, (hl)
	dec hl
	cp ':'
	ld a, 0           ; default drive
	jr nz, L1
	ld a, (hl)
	sub 'A' - 1       ; or named drive
	inc hl
	inc hl
L1:
	ld (de), a
	inc de

	ld c, '.'
	ld b, 8
	call L4           ; filename

	ld a, (hl)
	cp c              ; dot ?
	jr nz, L2
	inc hl
L2:
	ld c, 0
	ld b, 3
	call L4           ; typ

	ld b, 36 - 12
	xor a
L3:
	ld (de), a
	inc de
	djnz L3
	ret

L4:
	ld a, (hl)
	inc hl
	cp ' '+1
	jr c, L5          ; space or below, stop here
	cp c
	jr nz, L6         ; not a dot. accept it
L5:
	dec hl            ; stay within
	ld a, ' '         ; blank pad
L6:
	ld (de), a
	inc de
	djnz L4
	ret

;----------------------------------------------------------------------

name_boot:
	db "B:BOOTSTRA.BIN", 0
name_bios:
	db "B:BIOS.BIN", 0
name_cpm:
	db "B:CPM.BIN", 0

ok:
	db "ok", 0
missing:
	db "missing", 0
problems:
	db "problems", 0

;----------------------------------------------------------------------

sector:
	ds 2
nsect:
	ds 1

fcb:
	ds 1
	ds 8
	ds 3
	ds 4      ; record,extent,etc
	ds 16
	ds 8      ; XXX a word and what else ?

	ds 256
stack:
	ds 2
