	title	"N8VEM Monitor, Version 0.3"
	page	49
	.Z80
ENDFIL	EQU	1		;FILL FULL MONITOR AREA
;*******************************************************
;*	N8VEM Monitor
;*	Andrew Lynch
;*	Based on work by Andrew Lynch and James Moxham
;*	Version 0.3 - Bill Beech NJ7P - 4 Mar 09
;*******************************************************

;	I/O ADDRESSES

IO_Y0:	EQU	60H
IO_Y1:	EQU	68H
IO_Y2:	EQU	70H
IO_Y3:	EQU	78H

;	82C55 PIO

PIO1A:	EQU	IO_Y0+0		;PORT A
PIO1B:	EQU	IO_Y0+1		;PORT B
PIO1C:	EQU	IO_Y0+2		;PORT C
PIO1CT:	EQU	IO_Y0+3		;CONTROL PORT

;	16C450 UART

UART0:	EQU	IO_Y1+0		;DATA IN/OUT
UART1:	EQU	IO_Y1+1		;CHECK RX
UART2:	EQU	IO_Y1+2		;INTERRUPTS
UART3:	EQU	IO_Y1+3		;LINE CONTROL
UART4:	EQU	IO_Y1+4		;MODEM CONTROL
UART5:	EQU	IO_Y1+5		;LINE STATUS
UART6:	EQU	IO_Y1+6		;MODEM STATUS
UART7:	EQU	IO_Y1+7		;SCRATCH REG.

;	MEMORY PAGE LATCHS

RAMPAG:	EQU	IO_Y3		;RAM CONTROL PORT
ROMPAG:	EQU	IO_Y3+4		;ROM CONTROL PORT


;	MEMORY CONSTANTS	

STACK:	EQU	0FFFFH		;INITIAL STACK
CPMRAM:	EQU	0E600H		;CPM COLD BOOT ENTRY
MONRAM:	EQU	0FC00H		;MONITOR COLD START ENTRY

;	CHARACTER CONSTANTS

END:	EQU	0FFH		;END OF STRING
CR:	EQU	00DH
LF:	EQU	00AH
ESC:	EQU	01BH		;ASCII ESCAPE

;	MAIN PROGRAM

	ORG	MONRAM
	
START:	LD	SP,STACK	;SET SP
	CALL	INIT		;INITIALIZE UART & PIO
	LD	HL,RDYTXT
	CALL	MSG

;	COMMAND DECODE

CHEK:	LD	SP,STACK	;SET SP
	CALL	CRLFA		;NLTXT
	CALL	KIN		;GET COMMAND
	CP	'C'		;CPM BOOT?
	JP	Z,GOCPM
	CP	'D'		;DUMP MEMORY?
	JP	Z,DUMP
	CP	'E'		;EXAMINE?
	JP	Z,EXAM
	CP	'F'		;FILL MEMORY?
	JP	Z,FILL
	CP	'H'		;HEX LOAD?
	JP	Z,HXLOAD
	CP	'I'		;INPUT PORT?
	JP	Z,PIN
	CP	'J'		;JUMP?
	JP	Z,GOTO
	CP	'K'		;KEYBOARD LOOP?
	JP	Z,KLOP
	CP	'M'		;MOVE MEMORY?
	JP	Z,MOVE
	CP	'O'		;OUTPUT PORT?
	JP	Z,POUT
	LD	HL,ERRTXT	;ERROR MESSAGE
	CALL	MSG
	JR	CHEK
	
;	BOOT CP/M COMMAND

GOCPM:	JP	CPMRAM		; CP/M COLD BOOT ENTRY POINT

;	DUMP MEMORY COMMAND

DUMP:	CALL	CRLF		;GOOD COMMAND
	CALL	GETADR		;GET START ADDRESS
	PUSH	HL
	CALL	SPACE
	CALL	GETADR		;GET END ADDRESS
	INC	HL		;ADD ONE MORE FOR LATER COMPARE
	EX	DE,HL		;PUT END ADDRESS IN DE
	POP	HL		;GET BACK START
	LD	A,L		;FORCE 16-BYTE BOUNDARY
	AND	0F0H
	LD	L,A
DUMP1:	CALL	CRLF	
BLKRD:	CALL	PUTADR		;PRINT START LOCATION
	LD	C,16		;SET FOR 16 LOCS
	PUSH	HL		;SAVE STARTING HL
NXTONE:	LD 	A,(HL)		;GET BYTE
	CALL	PUTBYT		;PRINT IT
	CALL	SPACE
UPDH:	INC	HL		;POINT NEXT
	DEC	C		;DEC. LOC COUNT
	JR	NZ,NXTONE	;IF LINE NOT DONE

;NOW PRINT 'DECODED' DATA TO RIGHT OF DUMP

PCRLF:	CALL	SPACE		;SPACE IT
	LD	C,16		;SET FOR 16 CHARS
	POP	HL		;GET BACK START
PCRLF0:	LD	A,(HL)		;GET BYTE
	AND	080H		;SEE IF A 'DOT'
	JR	NZ,DOT
	LD	A,(HL)		;GET BYTE
	AND	060H		;SEE IF A 'DOT'
	LD	A,(HL)		;O.K. TO GET
	JR	NZ,PDOT
DOT:	LD	A,2EH		;LOAD A DOT	
PDOT:	CALL	COUT		;PRINT IT
	INC	HL
	LD	A,D
	CP	H
	JR	NZ,UPDH1
	LD	A,E
	CP	L
	JP	Z,CHEK

;IF BLOCK NOT DUMPED, DO NEXT CHARACTER OR LINE
	
UPDH1:	DEC	C		;DEC. CHAR COUNT
	JR	NZ,PCRLF0	;DO NEXT
CONTD:	CALL	CRLF
	JP	BLKRD
	
;	EXAMINE MEMORY COMMAND

EXAM:	CALL	CRLF		;GOOD COMMAND
	CALL	GETADR		;GET ADDRESS
EXAM1:	CALL	CRLF		;OUTPUT ADDRESS AND VALUE
DHLD:	CALL	PUTAD
ECK:	CALL	KIN		;GET USER INPUT
	INC	HL		;NEXT LOCATION
	CP	' '		;SHOW NEXT
	JR	Z,EXAM1
	DEC	HL		;BACK TO CURRENT
	CP	'R'
	JR	NZ,SEEP
	JP	(HL)
SEEP:	CP	'P'		;IS IT A "P" (y/n)
	JR	NZ,ECK		;IF YES GO PROGRAM
	
;	FILL MEMORY COMMAND

FILL:	CALL	CRLF		;GOOD COMMAND
	CALL	GETADR		;GET START ADDRESS
	PUSH	HL
	CALL	SPACE
	CALL	GETADR		;GET END ADDRESS
	PUSH	HL
	CALL	SPACE
	CALL	GETBYT		;GET FILL VALUE
	LD	C,A
	PUSH	BC
	POP	BC		;FILL BYTE
	POP	DE		;END
	POP	HL		;START
FILL1:	LD	(HL),C		;STORE BYTE
	INC     HL		;STEP ADDRESS
	LD	A,E		;DONE?
	SUB     L
	LD	B,A
	LD	A,D
	SUB     H
	OR	B
	JP	NZ,FILL1	;NO
	JP	CHEK		;BACK TO COMMAND LOOP
	
;	HEX LOAD COMMAND

HXLOAD:	CALL	CRLF		; SHOW READY
HXLOAD0:CALL	KIN		; GET THE FIRST CHARACTER, EXPECTING A ':'
HXLOAD1:CP	':'		; IS IT COLON ':'? START OF LINE OF INTEL HEX FILE
	JR	NZ,HXLOADERR	; IF NOT, MUST BE ERROR, ABORT ROUTINE

	LD	E,0		; FIRST TWO CHARACTERS IS THE RECORD LENGTH FIELD

	CALL	GETBYT		; GET US TWO CHARACTERS INTO BC, CONVERT IT TO A BYTE <A>
	CALL	HXCHKSUM	; UPDATE HEX CHECK SUM

	LD	D,A		; LOAD RECORD LENGTH COUNT INTO D

	CALL	GETBYT		; GET NEXT TWO CHARACTERS, MEMORY LOAD ADDRESS <H>
	CALL	HXCHKSUM	; UPDATE HEX CHECK SUM

	LD	H,A		; PUT VALUE IN H REGISTER.

	CALL	GETBYT		; GET NEXT TWO CHARACTERS, MEMORY LOAD ADDRESS <L>
	CALL	HXCHKSUM	; UPDATE HEX CHECK SUM

	LD	L,A		; PUT VALUE IN L REGISTER.

	CALL	GETBYT		; GET NEXT TWO CHARACTERS, RECORD FIELD TYPE
	CALL	HXCHKSUM	; UPDATE HEX CHECK SUM

	CP	1		; RECORD FIELD TYPE 00 IS DATA, 01 IS END OF FILE
	JR	NZ,HXLOAD2	; MUST BE THE END OF THAT FILE

	CALL	GETBYT		; GET NEXT TWO CHARACTERS, ASSEMBLE INTO BYTE
	CALL	HXCHKSUM	; UPDATE HEX CHECK SUM

	LD	A,E		; RECALL THE CHECKSUM BYTE
	AND	A		; IS IT ZERO?
        JP      Z,HXLOADEXIT	; MUST BE O.K., GO BACK FOR SOME MORE, ELSE
	JR	HXLOADERR	; CHECKSUMS DON'T ADD UP, ERROR OUT
		
HXLOAD2:
	LD	A,D		; RETRIEVE LINE CHARACTER COUNTER	
	AND	A		; ARE WE DONE WITH THIS LINE?
	JR	Z,HXLOAD3	; GET TWO MORE ASCII CHARACTERS, BUILD A BYTE AND CHECKSUM
	CALL	GETBYT		; GET NEXT TWO CHARS, CONVERT TO BYTE IN A, CHECKSUM IT
	CALL	HXCHKSUM	; UPDATE HEX CHECK SUM
	LD	(HL),A		; CHECKSUM OK, MOVE CONVERTED BYTE IN A TO MEMORY LOCATION
	INC	HL		; INCREMENT POINTER TO NEXT MEMORY LOCATION	
	DEC	D		; DECREMENT LINE CHARACTER COUNTER
	JR	HXLOAD2		; AND KEEP LOADING INTO MEMORY UNTIL LINE IS COMPLETE
		
HXLOAD3:
	CALL	GETBYT		; GET TWO CHARS, BUILD BYTE AND CHECKSUM
	CALL	HXCHKSUM	; UPDATE HEX CHECK SUM
	LD	A,E		; CHECK THE CHECKSUM VALUE
	AND	A		; IS IT ZERO?
	JR	Z,HXLOADAGAIN	; IF THE CHECKSUM IS STILL OK, CONTINUE ON, ELSE

HXLOADERR:
	LD	HL,CKSTXT	; GET "CHECKSUM ERROR" MESSAGE
	CALL	MSG		; PRINT MESSAGE FROM (HL) AND TERMINATE THE LOAD
	JP	HXLOADEXIT	; RETURN TO NLTXT

HXCHKSUM:
	LD	C,A		; BUILD THE CHECKSUM
	LD	A,E
	SUB	C		; THE CHECKSUM SHOULD ALWAYS EQUAL ZERO WHEN CHECKED
	LD	E,A		; SAVE THE CHECKSUM BACK WHERE IT CAME FROM
	LD	A,C		; RETRIEVE THE BYTE AND GO BACK
	RET			; BACK TO CALLER

HXLOADAGAIN:
	CALL	KIN		; CATCH THE TRAILING CARRIAGE RETURN
	JP	HXLOAD0		; LOAD ANOTHER LINE OF DATA

HXLOADEXIT:
	CALL	KIN		; CATCH ANY STRAY TRAILING CHARACTERS
	JP	CHEK		; RETURN TO NLTXT
	
;	INPUT PORT COMMAND

PIN:	CALL	CRLF
	CALL	GETBYT		;GET PORT
	LD	C,A		;SAVE PORT
	CALL	SPACE
	IN	A,(C)		;GET DATA
	CALL	PUTBYT		;DISPLAY IT
	JP	CHEK
			
;	JUMP COMMAND

GOTO:	CALL	CRLF		;GOOD COMMAND
	CALL	GETADR		;GET ADDRESS
	JP	(HL)		;JUMP

;	KEYBOARD LOOP COMMAND

KLOP:	CALL	KIN
	JR	KLOP

;	OUTPUT PORT COMMAND

POUT:	CALL	CRLF
	CALL	GETBYT		;GET PORT
	LD	C,A		;SAVE PORT
	CALL	SPACE
	CALL	GETBYT		;GET DATA
OUTIT:	OUT	(C),A		;OUTPUT IT
	JP	CHEK


;	MEMORY MOVE COMMAND

MOVE:	LD	C,03
	CALL	CRLF		;GOOD COMMAND
	CALL	GETADR		;GET START ADDRESS
	PUSH	HL
	CALL	SPACE
	CALL	GETADR		;GET END ADDRESS
	PUSH	HL
	CALL	SPACE
	CALL	GETADR		;GET DESTINATION ADDRESS
	PUSH	HL
	POP	DE		;DEST
	POP	BC		;END
	POP	HL		;SOURCE
	PUSH    HL
	LD	A,L		;2 COMPLEMENT OF SOURCE ADDRESS
	CPL
	LD	L,A
	LD	A,H
	CPL
	LD	H,A
	INC	HL
	ADD	HL,BC		;GET LENGTH
	LD	C,L
	LD	B,H
	POP     HL		;SOURCE       
	LDIR			;MOVE IT
	JP	CHEK		;BACK TO COMMAND LOOP

;	SUBROUTINES
              
;	GET CHARACTER & MAKE UPPER-CASE

KIN:	IN	A,(UART5)	;RX READY?
	BIT	0,A
	JP	Z,KIN		;NO
	IN	A,(UART0)	;GET CHARACTER
	AND	7FH		;STRIP PARITY
	CP	ESC		;ESC?
	JR	NZ,KIN1		;NO
	JP	CHEK		;BACK TO COMMAND LOOP
KIN1:	CALL	COUT		;ECHO CHARACTER
	CP	'a'		;KEEP NUMBERS, CONTROLS
	RET	C		;AND UPPER CASE
	CP	7BH		;SEE IF NOT LOWER CASE
	RET	NC
	AND	5FH		;MAKE UPPER CASE
	RET

;	GET ADDRESS INTO HL

GETADR:	CALL	GETBYT		;GET K.B. AND MAKE HEX
	LD	H,A		;THATS THE HI BYTE
	CALL	GETBYT		;DO HEX AGAIN
	LD	L,A		;THATS THE LOW BYTE
	RET			;GO BACK WITH ADDRESS  

;	GET BYTE INTO A

GETBYT:	PUSH	BC		;SAVE BC REGS.
	CALL	NIBL		;DO A NIBBLE
	RLC	A		;MOVE FIRST BYTE UPPER NIBBLE  
	RLC	A
	RLC	A
	RLC	A
	LD	B,A		;SAVE ROTATED BYTE
	CALL	NIBL		;DO NEXT NIBBLE
	OR	B		;COMBINE NIBBLES IN ACC.
	POP	BC		;RESTORE BC
	RET			;DONE  

NIBL:	CALL	KIN		;GET K.B. DATA
	CP	40H		;TEST FOR ALPHA
	JR	NC,ALPH
	AND	0FH		;GET THE BITS
	RET

ALPH:	AND	0FH		;GET THE BITS
	ADD	A,9		;MAKE IT HEX A-F
	RET

;	PRINT HL & THE BYTE (HL) IN HEX

PUTAD:	CALL	PUTADR		;GO PRINT HL
	CALL	SPACE		;PRINT A SPACE
	LD	A,(HL)		;GET THE DATA

;	PRINT THE ADDRESS IN HL

PUTADR:	LD	A,H
	CALL	PUTBYT
	LD	A,L
	CALL	PUTBYT
	CALL	SPACE
	RET

;	PRINT A IN HEX

PUTBYT:	PUSH	AF		;SAVE LOW NIBBLE
	RRC	A		;GETHIGH NIBBLE
	RRC	A
	RRC	A
	RRC	A
	CALL	PUTNIB		;OUTPUT IT
	POP	AF		
PUTNIB:	AND	0FH		;STRIP OFF HIGH BYTE
	ADD	A,'0'		;MAKE IT PRINTABLE
	CP	':'
	JR	C,COUT
	ADD	A,7

;	PUT CHARACTER

COUT:	PUSH	AF		;SAVE CHARACTER
COUT1:	IN	A,(UART5)	;TX READY?
	BIT	5,A
	JP	Z,COUT1		;NO
	POP	AF		;GET CHARACTER
	OUT	(UART0),A	;OUTPUT CHARACTER
	RET

;	PRINT CARRIAGE RETURN & LINE FEED

CRLF:	PUSH	HL
	LD	HL,NLTXT
	CALL	MSG
	POP	HL
	RET

;	PRINT A SPACE

SPACE:	PUSH	AF
	LD	A,' '
	CALL	COUT
	POP	AF
	RET

;	PRINT PROMPT

CRLFA:	PUSH	HL
	LD	HL,CMDTXT
	CALL	MSG
	POP	HL
	RET

;	PRINT STRING

MSG:	LD	A,(HL)		;GET CHARACTER
	CP	END		;END OF STRING?
	RET	Z		;YES
	PUSH	AF
MSG1:	IN	A,(UART5)	;TX READY?
	BIT	5,A
	JR	Z,MSG1		;NO
	POP	AF
	OUT	(UART0),A	;OUTPUT CHAR
	INC	HL		;INCREMENT STRING POINTER
	JR	MSG
	
;	INITITIALIZE UART

INIUART:LD	A,80H
	OUT	(UART3),A	;SET DLAB FLAG
	LD	A,12		;= 1,843,200 / ( 16 x 9600 )
	OUT	(UART0),A	;Set BAUD rate 9600
	XOR	A
	OUT	(UART1),A
	LD	A,03H
	OUT	(UART3),A	;Set 8 n 1
	RET

;	INITIALIZE PIO

INIPIO:	LD	A,10001001b	;A=OUT, B=OUT,C=IN
	OUT	(PIO1CT),A
	XOR	A		;ALL PINS LOW
	OUT	(PIO1A),A
	OUT	(PIO1B),A
	RET


;	INIT

INIT:	CALL	INIUART	
	CALL	INIPIO	
	XOR	A		;SELECT RAM PAGE 0
	OUT	(RAMPAG),A
	LD	A,080H		;TURM OFF ROM
	OUT	(ROMPAG),A
	RET

;	STRINGS CONSTANTS

NLTXT:	DB	CR,LF,END

CMDTXT:	DB	CR,LF,'>',END

RDYTXT:	DB	CR,LF
	DB	"N8VEM Monitor"
	DB	CR,LF,END

ERRTXT:	DB	CR,LF
	DB	"Unknown command"
	DB	END

CKSTXT:	DB	CR,LF
	DB	"Checksum error"
	DB	END

	IF	ENDFIL
	ORG	MONRAM+03FFH
	DB	055H
	ENDIF
	END
