	.Z80
;	Converted by T2R
;___DANGEN_____________________________________________________________________________________________________________
;
;  COPY THE SYSTEM TO THE BOOT SECTORS OF AN IDE HDD
;
;  CREATED BY : 	DAN WERNER 09 12.2009
;
;
;__HARDWARE_INTERFACES________________________________________________________________________________________________________________ 
;
;IDE REGISTER		IO PORT		; FUNCTION
IDELO		 EQU	020h		; DATA PORT (LOW BYTE)
IDEERR		 EQU	021h		; READ: ERROR REGISTER; WRITE: PRECOMP
IDESECTC	 EQU	022h		; SECTOR COUNT
IDESECTN	 EQU	023h		; SECTOR NUMBER
IDECYLLO	 EQU	024h		; CYLINDER LOW
IDECYLHI	 EQU	025h		; CYLINDER HIGH
IDEHEAD		 EQU	026h		; DRIVE/HEAD
IDESTTS		 EQU	027h		; READ: STATUS; WRITE: COMMAND
IDEHI		 EQU	028h		; DATA PORT (HIGH BYTE)
IDECTRL		 EQU	02Eh		; READ: ALTERNATIVE STATUS; WRITE; DEVICE CONTROL
IDEADDR		 EQU	02Fh		; DRIVE ADDRESS (READ ONLY)

;
;
;__CONSTANTS_________________________________________________________________________________________________________________________ 
;	
CR:		 EQU	0DH		; ASCII CARRIAGE RETURN CHARACTER
LF:		 EQU	0AH		; ASCII LINE FEED CHARACTER
ESC:		 EQU	1BH		; ASCII ESCAPE CHARACTER
BS:		 EQU	08H		; ASCII BACKSPACE CHARACTER

CPMSTART	 EQU	0D400H		; START OF CP/M
DISKBLOCKS:	 EQU	21		; NUMBER OF DISK BLOCKS

;
;
;
;__MAIN_PROGRAM_____________________________________________________________________________________________________________________ 
;
	 ORG	00100h			; FOR DEBUG IN CP/M (AS .COM)

	
	
BOOTIDEPRI:
	LD	A,00H			;
	LD	(IDEDEVICE),A		; SET PRIMARY DEVICE
	JR	BOOTIDE			;
BOOTIDESEC:
	LD	A,10H			;
	LD	(IDEDEVICE),A		; SET SECONDARY DEVICE
BOOTIDE:
	CALL	IDE_SOFT_RESET		;
	LD	DE,0000H		; SET SECTOR HIGH WORD TO 00H
	LD	HL,0003H		; SET SECTOR LOW WORD TO 03H
	LD	IX,CPMSTART		; SET TOP OF CP/M
	LD	B,DISKBLOCKS		; SET NUMBER OF SECTORS TO LOAD
BOOTIDELOOP:
	PUSH	BC			;
	PUSH	HL			;
	CALL	IDE_WRITE_SECTOR	; WRITE A SECTOR
	POP	HL			;
	INC	HL			; POINT TO NEXT SECTOR
	POP	BC			;
	DJNZ	BOOTIDELOOP		; LOOP

	LD	DE,MSG_END		;
	LD	C,09H			; CP/M WRITE END STRING TO CONSOLE CALL
	CALL	0005H			;
					;
	LD	C,00H			; CP/M SYSTEM RESET CALL
	CALL	0005H			; RETURN TO PROMPT

	
	
		
	
;___IDE_WRITE_SECTOR_____________________________________________________________________________________
;
;	WRITE IDE SECTOR
;________________________________________________________________________________________________________			
IDE_WRITE_SECTOR:
	CALL	IDE_WAIT_BUSY_READY 	; MAKE SURE DRIVE IS READY TO PROCEED
	RET	NC			; ERROR, RETURN
	CALL	IDE_SETUP_LBA		; TELL DRIVE WHAT SECTOR IS REQUIRED
	LD	A,30H			;
	OUT	(IDESTTS),A		; 030h = IDE 'WRITE SECTOR' COMMAND 
	CALL	IDE_WAIT_BUSY_READY	;
	RET	NC			; ERROR, RETURN
	CALL	IDE_TEST_ERROR		; ENSURE NO ERROR WAS REPORTED
	RET	NC			; ERROR, RETURN
	CALL	IDE_WAIT_BUFFER		; WAIT FOR BUFFER READY SIGNAL FROM DRIVE
	RET	NC			; ERROR, RETURN
	CALL	IDE_WRITE_BUFFER 	; SEND 256 WORDS TO DRIVE'S BUFFER
	CALL	IDE_WAIT_BUSY_READY 	; MAKE SURE DRIVE IS READY TO PROCEED
	RET	NC			; ERROR, RETURN
	CALL	IDE_TEST_ERROR		; ENSURE NO ERROR WAS REPORTED
	RET	NC			; ERROR, RETURN
	SCF				; CARRY = 1 ON RETURN = OPERATION OK
	RET		

;___IDE_SOFT_RESET_______________________________________________________________________________________
;
;	RESET IDE CHANNEL
;________________________________________________________________________________________________________			
IDE_SOFT_RESET:
	LD	A,000000110b		; NO INTERRUPTS, RESET DRIVE = 1
	OUT	(IDECTRL),A		;
	LD	A,000000010b		; NO INTERRUPTS, RESET DRIVE = 0
	OUT	(IDECTRL),A		;
	CALL	IDE_WAIT_BUSY_READY	;THIS TAKES A COUPLE OF SECONDS
	RET	


;___IDE_WAIT_BUSY_READY___________________________________________________________________________________
;
;	WAIT FOR IDE CHANNEL TO BE READY
;________________________________________________________________________________________________________			
IDE_WAIT_BUSY_READY:
	LD	DE,0			; CLEAR DE
IDE_WBSY:				;
	LD	B,5			; SETUP TIMEOUT
IDE_DLP:				;
	DEC	B			;
	JP	NZ,IDE_DLP		;
	INC	DE			;
	LD	A,D			;
	OR	E			;
	JP	Z,IDE_TO		;
	IN	A,(IDESTTS)		; READ ERROR REG
	AND	011000000b		; MASK OFF BUSY AND RDY BITS
	XOR	001000000b		; WE WANT BUSY(7) TO BE 0 AND RDY(6) TO BE 1
	JP	NZ,IDE_WBSY		;
	SCF				; CARRY 1 = OK
	RET
IDE_TO:
	XOR	A			; CARRY 0 = TIMED OUT
	RET
	
;___IDE_TEST_ERROR_______________________________________________________________________________________
;
;	CHECK FOR IDE ERROR CONDITION
;________________________________________________________________________________________________________			
IDE_TEST_ERROR:
	SCF				;
	IN	A,(IDESTTS)		;
	LD	B,A			; 
	AND	000000001b		; TEST ERROR BIT
	SCF				; 
	RET	Z			;
	LD	A,B			; 
	AND	000100000b		;
	SCF				;
	JP	NZ,IDE_ERR		; TEST WRITE ERROR BIT
	IN	A,(IDEERR)		; READ ERROR FLAGS
IDE_ERR:
	OR	A			; CARRY 0 = ERROR
	RET				; IF A = 0, IDE BUSY TIMED OUT

;___IDE_WAIT_BUFFER_______________________________________________________________________________________
;
;	WAIT FOR DATA BUFFER READY
;________________________________________________________________________________________________________			
IDE_WAIT_BUFFER:
	LD	DE,0			;
IDE_WDRQ:				;
	LD	B,5			;
IDE_BLP:				;
	DEC	B			;
	JP	NZ,IDE_BLP		;	
	INC	DE			;
	LD	A,D			;
	OR	E			;
	JP	Z,IDE_TO2		;
	IN	A,(IDESTTS)		; WAIT FOR DRIVE'S 512 BYTE READ BUFFER 
	AND	000001000b		; TO FILL (OR READY TO FILL)
	JP	Z,IDE_WDRQ		;
	SCF				; CARRY 1 = OK
	RET				;
IDE_TO2:				;
	XOR	A			; CARRY 0 = TIMED OUT
	RET				;


;___IDE_WRITE_BUFFER_______________________________________________________________________________________
;
;	WRITE TO IDE BUFFER
;________________________________________________________________________________________________________			
IDE_WRITE_BUFFER:
	LD	B,0			; 256 WORDS (512 BYTES PER SECTOR)
IDEBUFWT:				;
	INC	IX			;
	LD	A,(IX)			;
	DEC	IX			;
	OUT	(IDEHI),A		; SET UP HIGH LATCHED BYTE BEFORE
	LD	A,(IX)			;
	OUT	(IDELO),A		; WRITING WORD WITH WRITE TO LOW BYTE
	INC	IX			;
	INC	IX			;
	DEC	B			;
	JP	NZ,IDEBUFWT		;
	RET		
	
;___IDE_SETUP_LDA________________________________________________________________________________________
;
;	SETUP IDE DRIVE FOR LDA OPERATION
;________________________________________________________________________________________________________			
IDE_SETUP_LBA:
	LD	A,L			; LOAD LBA REGISTER 0 WITH SECTOR ADDRESS TO READ
	LD	(IDE_LBA0),A		;
	LD	A,H			; LOAD LBA REGISTER 1 WITH SECTOR ADDRESS TO READ
	LD	(IDE_LBA1),A		;
	LD	A,0000H		 	; LOAD LBA REGISTER 2 WITH SECTOR ADDRESS TO READ
	LD	(IDE_LBA2),A		;
	AND	000001111b		; ONLY LOWER FOUR BITS ARE VALID
	ADD	A,011100000b		; ENABLE LBA BITS 5:7=111 IN IDE_LBA3
	LD	(IDE_LBA3),A		;
					; READ IDE HD SECTOR
	LD	A,1			;
	OUT	(IDESECTC),A		; SET SECTOR COUNT = 1	
					;	
	LD	A,(IDE_LBA0)		;
	OUT	(IDESECTN),A		; SET LBA 0:7
					;
	LD	A,(IDE_LBA1)		;
	OUT	(IDECYLLO),A		; SET LBA 8:15
					;
	LD	A,(IDE_LBA2)		;
	OUT	(IDECYLHI),A		; SET LBA 16:23
					;
	LD	A,(IDEDEVICE)		; SELECTS DEVICE
	LD	C,A			;				
	LD	A,(IDE_LBA3)		;
	AND	000001111b		; LOWEST 4 BITS USED ONLY
	OR	011100000b		; TO ENABLE LBA MODE
	OR	C			;
	OUT	(IDEHEAD),A		; SET LBA 24:27 + BITS 5:7=111
	RET	


IDEDEVICE:
		 DB 0			; ATAPI DEVICE SELECTION FLAG
IDE_LBA0:
		 DB 0			; SET LBA 0:7
IDE_LBA1:
		 DB 0			; SET LBA 8:15
IDE_LBA2:
		 DB 0			; SET LBA 16:23
IDE_LBA3:
		 DB 0			; LOWEST 4 BITS USED ONLY TO ENABLE LBA MODE 

MSG_END:
	 DB	LF, CR			; LINE FEED AND CARRIAGE RETURN
	 db  	"END DANGEN."
	 DB	LF, CR			; LINE FEED AND CARRIAGE RETURN
	 DB	"$"			; LINE TERMINATOR


	 END
