;	Converted by T2R
;------------------------------------------------------------------------------
; TEST PROTOTYPE IDE HARD DISK PARTITION #2 FORMAT PROGRAM
; BY ANDREW LYNCH
; USING IDE CIRCUIT FROM HANS SUMMERS
; 16 APR 2007
;------------------------------------------------------------------------------

; DATA CONSTANTS

; IDE REGISTER		IO PORT		; FUNCTION
IDELO		 EQU	020h		; DATA PORT (LOW BYTE)
IDEERR		 EQU	021h		; READ: ERROR REGISTER; WRITE: PRECOMP
IDESECTC	 EQU	022h		; SECTOR COUNT
IDESECTN	 EQU	023h		; SECTOR NUMBER
IDECYLLO	 EQU	024h		; CYLINDER LOW
IDECYLHI	 EQU	025h		; CYLINDER HIGH
IDEHEAD		 EQU	026h		; DRIVE/HEAD
IDESTTS		 EQU	027h		; READ: STATUS; WRITE: COMMAND
IDEHI		 EQU	028h		; DATA PORT (HIGH BYTE)
IDECTRL		 EQU	02Eh		; READ: ALTERNATIVE STATUS; WRITE; DEVICE CONTROL
IDEADDR		 EQU	02Fh		; DRIVE ADDRESS (READ ONLY)

CR		 EQU	00Dh		; CARRIAGE RETURN CHARACTER
LF		 EQU	00Ah		; LINE FEED CHARACTER
END		 EQU	'$'		; LINE TERMINATOR FOR CP/M STRINGS

SECTORS		 EQU	020h		; NUMBER OF BLOCKS RESERVED FOR DIRECTORY


; MAIN PROGRAM BEGINS HERE

	 ORG	00100h
;*      INPUT		: HL = START ADDRESS BLOCK
;*			: BC = LENGTH OF BLOCK
;			: A = VALUE TO FILL WITH

	
	LXI	H,IDE_SECTOR_BUFFER	; INITIALIZE SECTOR BUFFER TO KNOWN VALUE 0E5h
	LXI	B,00200h			; IDE HD SECTOR SIZE IS 512 BYTES
	MVI	A,0E5h			; FILL DIRECTORY BLOCKS WITH EMPTY DIRECTORY ENTRIES
	CALL	FILL_MEM		

	LXI	D,MSG_START
	MVI	C,09H			; CP/M WRITE START STRING TO CONSOLE CALL
	CALL	0005H

	CALL	IDE_SOFT_RESET		; RESET IDE DRIVE TO BEGIN TEST

;	CALL	IDE_GET_ID		; GET IDE HD IDENTIFICATION
					; NOTE: HD IDE DATA STORED AT MEMORY LOCATION
					; IDE_SECTOR_BUFFER AND REQUIRES MONITOR TO
					; INSPECT CONTENTS


					; INITIALIZE STARTING LBA SECTOR ON IDE HD
	LXI	H,0FC00h			; INITIALIZE LBA OFFSET SECTOR LO WORD 
	SHLD	LBA_OFFSET_LO

	LXI	H,00000h			; INITIALIZE LBA OFFSET SECTOR HI WORD
	SHLD	LBA_OFFSET_HI


; GENERIC FOR-NEXT LOOP ALGORITHM
;
	MVI	A,040h			; SET A=0 INDEX COUNTER OF FOR LOOP
					; FIRST SECTOR OF DIRECTORY IS ON TRACK 1 SINCE
					; TRACK 0 IS RESERVED FOR SYSTEM PER DPB DEFINITION
					; 040h FIRST SECTOR OF TRACK 1
FOR_LOOP:
	PUSH	PSW			; SAVE ACCUMULATOR AS IT IS THE INDEX COUNTER IN FOR LOOP
;					; OUTER LOOP IS 0 -> # OF DIRECTORY BLOCKS

	MOV	L,A
	MVI	H,000h			; STORE RESULT IN HL
	ADI	030h

	LDA	LBA_OFFSET_LO		; 16 BIT ADD OF LBA_OFFSET_LO WITH HL
	ADD	L
	STA	LBA_TARGET_LO
	LDA	LBA_OFFSET_LO+1
	ADC	H
	STA	LBA_TARGET_LO+1		; STORE OVERFLOW BIT IN CARRY

	LXI	H,00000h
	LDA	LBA_OFFSET_HI		; 16 BIT ADD WITH CARRY OF LBA_OFFSET_HI WITH 00000h
	ADC	L
	STA	LBA_TARGET_HI
	LDA	LBA_OFFSET_HI+1
	ADC	H
	STA	LBA_TARGET_HI+1

	LDA	LBA_TARGET_LO		; LOAD LBA REGISTER 0 WITH SECTOR ADDRESS TO READ
	STA	IDE_LBA0 
	LDA	LBA_TARGET_LO+1		; LOAD LBA REGISTER 1 WITH SECTOR ADDRESS TO READ
	STA	IDE_LBA1
	LDA	LBA_TARGET_HI		; LOAD LBA REGISTER 2 WITH SECTOR ADDRESS TO READ
	STA	IDE_LBA2
	LDA	LBA_TARGET_HI+1		; LOAD LBA REGISTER 3 WITH SECTOR ADDRESS TO READ
	ANI	000001111b		; ONLY LOWER FOUR BITS ARE VALID
	ADI	011100000b		; ENABLE LBA BITS 5:7=111 IN IDE_LBA3
	STA	IDE_LBA3

	CALL	IDE_WRITE_SECTOR	; WRITE THE IDE HARD DISK SECTOR WITH EMPTY DIRECTORY ENTRIES

; NEED TO ADD ERROR CHECKING HERE, CARRY FLAG IS SET IF IDE_WRITE_SECTOR SUCCESSFUL!

	JC	WRITE_OK		; NO ERROR IF IDE_GET_ID RETURNS CARRY SET
	LDA	0FFh			; ERROR_CODE DEFAULTS TO FALSE ($00), 
	STA	ERROR_CODE		; ANY ERROR WILL MAKE IT TRUE (0FFh)

WRITE_OK:
	POP	PSW			; RECOVER ACCUMULATOR AS IT IS THE INDEX COUNTER IN FOR LOOP
	INR	A			; INCREMENT A IN FOR LOOP (A=A+1)
	CPI	040h+SECTORS		; IS A < NUMBER OF SECTORS PER BLOCK ?
	JNZ	FOR_LOOP		; NO, DO FOR LOOP AGAIN

	LDA	ERROR_CODE		; WAS AN ERROR DETECTED DURING FORMAT?
	ORA	A			; SET FLAGS
	JZ	EXIT			; IF NONE, JUMP TO EXIT 
					; ELSE, PRINT ERROR MESSAGE

	LXI	D,MSG_ERROR
	MVI	C,09H			; CP/M WRITE ERROR STRING TO CONSOLE CALL
	CALL	0005H

EXIT:
	LXI	D,MSG_END
	MVI	C,09H			; CP/M WRITE END STRING TO CONSOLE CALL
	CALL	0005H

	MVI	C,00H			; CP/M SYSTEM RESET CALL
	CALL	0005H			; RETURN TO PROMPT

; MAIN PROGRAM ENDS HERE

;------------------------------------------------------------------------------
;- IDE ROUTINES FOR Z80 PROJECT BY PHIL RUSTON 2005 ---------------------------
; MODIFIED BY ANDREW LYNCH FOR TEST PROTOTYPE
;------------------------------------------------------------------------------
		
IDE_READ_SECTOR:

	CALL	IDE_WAIT_BUSY_READY	;MAKE SURE DRIVE IS READY TO PROCEED
	RNC
	CALL	IDE_SETUP_LBA		;TELL DRIVE WHAT SECTOR IS REQUIRED
	MVI	A,020h			
	OUT	IDESTTS			;020h = IDE 'READ SECTOR' COMMAND 

IDE_SREX:
	CALL	IDE_WAIT_BUSY_READY	;MAKE SURE DRIVE IS READY TO PROCEED
	RNC
	CALL	IDE_TEST_ERROR		;ENSURE NO ERROR WAS REPORTED
	RNC
	CALL	IDE_WAIT_BUFFER		;WAIT FOR FULL BUFFER SIGNAL FROM DRIVE
	RNC

	CALL	IDE_READ_BUFFER		;GRAB THE 256 WORDS FROM THE BUFFER
	STC				;CARRY = 1 ON RETURN = OPERATION OK
	RET
		
;-----------------------------------------------------------------------------

IDE_WRITE_SECTOR:

	CALL	IDE_WAIT_BUSY_READY	;MAKE SURE DRIVE IS READY TO PROCEED
	RNC
	CALL	IDE_SETUP_LBA		;TELL DRIVE WHAT SECTOR IS REQUIRED
	MVI	A,030h			
	OUT	IDESTTS			;030h = IDE 'WRITE SECTOR' COMMAND 
	CALL	IDE_WAIT_BUSY_READY
	RNC
	CALL	IDE_TEST_ERROR		;ENSURE NO ERROR WAS REPORTED
	RNC
	CALL	IDE_WAIT_BUFFER		;WAIT FOR BUFFER READY SIGNAL FROM DRIVE
	RNC
	CALL	IDE_WRITE_BUFFER	;SEND 256 WORDS TO DRIVE'S BUFFER
	CALL	IDE_WAIT_BUSY_READY	;MAKE SURE DRIVE IS READY TO PROCEED
	RNC
	CALL	IDE_TEST_ERROR		;ENSURE NO ERROR WAS REPORTED
	RNC
	STC				;CARRY = 1 ON RETURN = OPERATION OK
	RET

;-----------------------------------------------------------------------------

IDE_GET_ID:
	
	CALL	IDE_WAIT_BUSY_READY
	RNC
	MVI	A,010100000b
	OUT	IDEHEAD			;SELECT MASTER DEVICE
	CALL	IDE_WAIT_BUSY_READY
	RNC
	MVI	A,0ECh			
	OUT	IDESTTS			;0ECh = IDE 'ID DRIVE' COMMAND 
	CALL	IDE_WAIT_BUSY_READY	;MAKE SURE DRIVE IS READY TO PROCEED
	RNC
	CALL	IDE_TEST_ERROR		;ENSURE NO ERROR WAS REPORTED
	RNC
	CALL	IDE_WAIT_BUFFER		;WAIT FOR FULL BUFFER SIGNAL FROM DRIVE
	RNC
	CALL	IDE_READ_BUFFER_BE	;GRAB THE 256 WORDS FROM THE BUFFER
	STC				;CARRY = 1 ON RETURN = OPERATION OK
	RET

;-----------------------------------------------------------------------------

IDE_SOFT_RESET:

	MVI	A,000000110b		;NO INTERRUPTS, RESET DRIVE = 1
	OUT	IDECTRL
	MVI	A,000000010b		;NO INTERRUPTS, RESET DRIVE = 0
	OUT	IDECTRL
	CALL	IDE_WAIT_BUSY_READY
	RET

;--------------------------------------------------------------------------------
; IDE INTERNAL SUBROUTINES 
;--------------------------------------------------------------------------------

IDE_WAIT_BUSY_READY:
	
	LXI	D,0

IDE_WBSY:

	MVI	B,5

IDE_DLP:

	DCR	B
	JNZ	IDE_DLP

	INX	D
	MOV	A,D
	ORA	E

	JZ	IDE_TO

	IN	IDESTTS			;READ ERROR REG
	ANI	011000000b		;MASK OFF BUSY AND RDY BITS
	XRI	001000000b		;WE WANT BUSY(7) TO BE 0 AND RDY(6) TO BE 1

	JNZ	IDE_WBSY

	STC				;CARRY 1 = OK
	RET

IDE_TO:
	XRA	A			;CARRY 0 = TIMED OUT
	RET
	
;----------------------------------------------------------------------------

IDE_TEST_ERROR:
	
	STC
	IN	IDESTTS
	MOV	B,A			;NEW
	ANI	000000001b		;TEST ERROR BIT
	STC				;NEW
	RZ

	MOV	A,B			;NEW
	ANI	000100000b
	STC
	JNZ	IDE_ERR			;TEST WRITE ERROR BIT
	
	IN	IDEERR			;READ ERROR FLAGS

IDE_ERR:
	ORA	A			;CARRY 0 = ERROR
	RET				;IF A = 0, IDE BUSY TIMED OUT

;-----------------------------------------------------------------------------
	
IDE_WAIT_BUFFER:
	
	LXI	D,0

IDE_WDRQ:
	MVI	B,5

IDE_BLP:
	DCR	B
	JNZ	IDE_BLP

	INX	D
	MOV	A,D
	ORA	E
	JZ	IDE_TO2

	IN	IDESTTS			;WAIT FOR DRIVE'S 512 BYTE READ BUFFER 
	ANI	000001000b		;TO FILL (OR READY TO FILL)
	JZ	IDE_WDRQ

	STC				;CARRY 1 = OK
	RET

IDE_TO2:
	XRA	A			;CARRY 0 = TIMED OUT
	RET

;------------------------------------------------------------------------------

IDE_READ_BUFFER_BE:

	PUSH	H
	LXI	H,IDE_SECTOR_BUFFER
	MVI	B,0			;256 WORDS (512 BYTES PER SECTOR)

IDEBUFRD_BE:

	IN	IDELO			;LOW BYTE OF WORD FIRST	
	INX	H
	MOV	M,A
	DCX	H
	IN	IDEHI			;THEN HIGH BYTE OF WORD
	MOV	M,A
	INX	H
	INX	H
	DCR	B
	JNZ	IDEBUFRD_BE

	POP	H
	RET
	
;------------------------------------------------------------------------------

IDE_READ_BUFFER:

	PUSH	H
	LXI	H,IDE_SECTOR_BUFFER
	MVI	B,0			;256 WORDS (512 BYTES PER SECTOR)

IDEBUFRD:
	IN	IDELO			;LOW BYTE OF WORD FIRST	
	MOV	M,A
	IN	IDEHI			;THEN HIGH BYTE OF WORD
	INX	H
	MOV	M,A
	INX	H
	DCR	B
	JNZ	IDEBUFRD

	POP	H
	RET

;-----------------------------------------------------------------------------

IDE_WRITE_BUFFER:

	PUSH	H
	LXI	H,IDE_SECTOR_BUFFER
	MVI	B,0			;256 WORDS (512 BYTES PER SECTOR)

IDEBUFWT:

	INX	H
	MOV	A,M
	DCX	H
	OUT	IDEHI			;SET UP HIGH LATCHED BYTE BEFORE
	MOV	A,M
	OUT	IDELO			;WRITING WORD WITH WRITE TO LOW BYTE
	INX	H
	INX	H
	DCR	B
	JNZ	IDEBUFWT

	POP	H
	RET
	
;-----------------------------------------------------------------------------

IDE_SETUP_LBA:
	
	MVI	A,1			
	OUT	IDESECTC		;SET SECTOR COUNT = 1	

	LDA	IDE_LBA0
	OUT	IDESECTN		;SET LBA 0:7

	LDA	IDE_LBA1
	OUT	IDECYLLO		;SET LBA 8:15

	LDA	IDE_LBA2
	OUT	IDECYLHI		;SET LBA 16:23

	LDA	IDE_LBA3
	ANI	000001111b		;LOWEST 4 BITS USED ONLY
	ORI	011100000b		;TO ENABLE LBA MODE
	OUT	IDEHEAD			;SET LBA 24:27 + BITS 5:7=111
	RET
	
;******************************************************************
;*	FILL_MEM
;*	FUNCTION	: FILL MEMORY WITH A VALUE
;*      INPUT		: HL = START ADDRESS BLOCK
;*			: BC = LENGTH OF BLOCK
;			: A = VALUE TO FILL WITH
;*	USES		: DE, BC
;*	OUTPUT		:
;*	CALLS		: 
;*	TESTED		: 13 FEB 2007
;******************************************************************

FILL_MEM:

;; THIS CODE SNIPPET WILL SHOW ONE METHOD TO FILL A BLOCK
;; OF MEMORY WITH A SINGLE DATA BYTE USING Z80 ASSEMBLY
;; LANGUAGE 

;;--------------------------------------------------

					;; HL = START ADDRESS OF BLOCK
					;; DE = HL + 1
	MOV	E,L
	MOV	D,H

	INX	D
					;; INITIALISE FIRST BYTE OF BLOCK
					;; WITH DATA BYTE (&00)
					;; WITH DATA BYTE IN A
	MOV	M,A
	
					;; BC = LENGTH OF BLOCK IN BYTES
					;; HL+BC-1 = END ADDRESS OF BLOCK

					;; FILL MEMORY
LDIR:	MOV A,M
	STAX D
	INX D
	INX H
	DCX B
	MOV A,B
	ORA C
	JNZ LDIR

	RET				;; RETURN TO CALLER

;;--------------------------------------------------



;; FOR EACH ITERATION OF THE LDIR COMMAND:
;;
;; 1  THIS COMMAND WILL COPY THE BYTE FROM THE MEMORY 
;; ADDRESS POINTED TO BY HL TO THE MEMORY ADDRESS POINTED TO BY DE 
;; I E. (DE) = (HL).
;; 2  THEN HL AND DE WILL BE INCREMENTED. BC WILL BE DECREMENTED.
;;
;;
;; FOR THE FIRST BYTE:
;; 
;; HL = START
;; DE = START+1
;; BC = LENGTH
;; (HL)=0
;; 
;; FOR THE SECOND BYTE:
;; 
;; HL = START + 1 (INITIALISED TO 0 BY THE PREVIOUS ITERATION)
;; DE = START + 2
;; BC = LENGTH - 1
;;
;; FOR THE THIRD BYTE:
;;
;; HL = START + 2 (INITIALISED TO 0 BY THE PREVIOUS ITERATION)
;; DE = START + 3
;; BC = LENGTH - 2
;;
;; ETC ...

;-----------------------------------------------------------------------------

; TEXT CONSTANTS

MSG_START:
	 db  	"START IDE TEST PROGRAM"
	 DB	LF, CR			; LINE FEED AND CARRIAGE RETURN
	 DB	END			; LINE TERMINATOR

MSG_ERROR:
	 db  	"ERROR"
	 DB	LF, CR			; LINE FEED AND CARRIAGE RETURN
	 DB	END			; LINE TERMINATOR

MSG_D1:
	 db  	"PASSED IDE_WAIT_BUSY_READY"
	 DB	LF, CR			; LINE FEED AND CARRIAGE RETURN
	 DB	END			; LINE TERMINATOR

MSG_END:
	 db  	"END IDE TEST PROGRAM"
	 DB	LF, CR			; LINE FEED AND CARRIAGE RETURN
	 DB	END			; LINE TERMINATOR

; DATA MEMORY RESERVED RANGES FOR VARIABLES AND SECTOR BUFFER

ERROR_CODE:		 DB	000h	; ASSUME SUCCESS UNLESS TOLD OTHERWISE
IDE_LBA0:		 DS	001h	;SET LBA 0:7
IDE_LBA1:		 DS	001h	;SET LBA 8:15
IDE_LBA2:		 DS	001h	;SET LBA 16:23
IDE_LBA3:		 DS	001h	;LOWEST 4 BITS USED ONLY 
					;TO ENABLE LBA MODE 
					;SET LBA 24:27 + BITS 5:7=111
LBA_OFFSET_LO		 DW		; IDE HD PARTITION STARTING SECTOR (LOW 16 BITS)
LBA_OFFSET_HI		 DW		; IDE HD PARTITION STARTING SECTOR (HI 16 BITS, 12 USED)
LBA_TARGET_LO		 DW		; IDE HD PARTITION TARGET SECTOR (LOW 16 BITS)
LBA_TARGET_HI		 DW		; IDE HD PARTITION TARGET SECTOR (HI 16 BITS, 12 USED)
IDE_SECTOR_BUFFER:	 DS	00200h

	 END
