	.Z80
;	Converted by T2R
;------------------------------------------------------------------------------
; TEST PROTOTYPE IDE HARD DISK TEST PROGRAM
; BY ANDREW LYNCH
; USING IDE CIRCUIT FROM HANS SUMMERS
; 5 APR 2007
;------------------------------------------------------------------------------

; DATA CONSTANTS

; IDE REGISTER		IO PORT		; FUNCTION
IDELO		 EQU	020h		; DATA PORT (LOW BYTE)
IDEERR		 EQU	021h		; READ: ERROR REGISTER; WRITE: PRECOMP
IDESECTC	 EQU	022h		; SECTOR COUNT
IDESECTN	 EQU	023h		; SECTOR NUMBER
IDECYLLO	 EQU	024h		; CYLINDER LOW
IDECYLHI	 EQU	025h		; CYLINDER HIGH
IDEHEAD		 EQU	026h		; DRIVE/HEAD
IDESTTS		 EQU	027h		; READ: STATUS; WRITE: COMMAND
IDEHI		 EQU	028h		; DATA PORT (HIGH BYTE)
IDECTRL		 EQU	02Eh		; READ: ALTERNATIVE STATUS; WRITE; DEVICE CONTROL
IDEADDR		 EQU	02Fh		; DRIVE ADDRESS (READ ONLY)

CR		 EQU	00Dh		; CARRIAGE RETURN CHARACTER
LF		 EQU	00Ah		; LINE FEED CHARACTER
END		 EQU	'$'		; LINE TERMINATOR FOR CP/M STRINGS


; MAIN PROGRAM BEGINS HERE

	 ORG	00100h
;*      INPUT		: HL = START ADDRESS BLOCK
;*			: BC = LENGTH OF BLOCK
;			: A = VALUE TO FILL WITH

	
	LD	HL,IDE_SECTOR_BUFFER	; INITIALIZE SECTOR BUFFER TO KNOWN VALUE 000h
	LD	BC,00200h
	LD	A,000h
	CALL	FILL_MEM

	LD	DE,MSG_START
	LD	C,09H			; CP/M WRITE START STRING TO CONSOLE CALL
	CALL	0005H

	CALL	IDE_SOFT_RESET		; RESET IDE DRIVE TO BEGIN TEST

	CALL	IDE_GET_ID		; GET IDE HD IDENTIFICATION
					; NOTE: HD IDE DATA STORED AT MEMORY LOCATION
					; IDE_SECTOR_BUFFER AND REQUIRES MONITOR TO
					; INSPECT CONTENTS
	
	JR	C,EXIT			; NO ERROR IF IDE_GET_ID RETURNS CARRY SET
					; ELSE, PRINT ERROR MESSAGE

	LD	DE,MSG_ERROR
	LD	C,09H			; CP/M WRITE ERROR STRING TO CONSOLE CALL
	CALL	0005H

EXIT:
	LD	DE,MSG_END
	LD	C,09H			; CP/M WRITE END STRING TO CONSOLE CALL
	CALL	0005H

	LD	C,00H			; CP/M SYSTEM RESET CALL
	CALL	0005H			; RETURN TO PROMPT

; MAIN PROGRAM ENDS HERE

;------------------------------------------------------------------------------
;- IDE ROUTINES FOR Z80 PROJECT BY PHIL RUSTON 2005 ---------------------------
; MODIFIED BY ANDREW LYNCH FOR TEST PROTOTYPE
;------------------------------------------------------------------------------
		
IDE_READ_SECTOR:

	CALL	IDE_WAIT_BUSY_READY	;MAKE SURE DRIVE IS READY TO PROCEED
	RET	NC
	CALL	IDE_SETUP_LBA		;TELL DRIVE WHAT SECTOR IS REQUIRED
;	LD	A,010010111b		;KB IRQMASK=1,/CS1=1,/CS0=0,A0:A2=7
;	OUT	(IDE_CONTROL_PORT),A	
	LD	A,020h			
;	OUT	(IDE_PORT_LO),A		;020h = IDE 'READ SECTOR' COMMAND 
	OUT	(IDESTTS),A		;020h = IDE 'READ SECTOR' COMMAND 

IDE_SREX:
	CALL	IDE_WAIT_BUSY_READY	;MAKE SURE DRIVE IS READY TO PROCEED
	RET	NC
	CALL	IDE_TEST_ERROR		;ENSURE NO ERROR WAS REPORTED
	RET	NC
	CALL	IDE_WAIT_BUFFER		;WAIT FOR FULL BUFFER SIGNAL FROM DRIVE
	RET	NC
	CALL	IDE_READ_BUFFER		;GRAB THE 256 WORDS FROM THE BUFFER
	SCF				;CARRY = 1 ON RETURN = OPERATION OK
	RET
		
;-----------------------------------------------------------------------------


IDE_WRITE_SECTOR:

	CALL	IDE_WAIT_BUSY_READY	;MAKE SURE DRIVE IS READY TO PROCEED
	RET	NC
	CALL	IDE_SETUP_LBA		;TELL DRIVE WHAT SECTOR IS REQUIRED
;	LD	A,010010111b		;KB IRQMASK=1,/CS1=1,/CS0=0,A0:A2=7
;	OUT	(IDE_CONTROL_PORT),A	
	LD	A,030h			
;	OUT	(IDE_PORT_LO),A		;030h = IDE 'WRITE SECTOR' COMMAND 
	OUT	(IDESTTS),A		;030h = IDE 'WRITE SECTOR' COMMAND 
	CALL	IDE_WAIT_BUSY_READY
	RET	NC
	CALL	IDE_TEST_ERROR		;ENSURE NO ERROR WAS REPORTED
	RET	NC
	CALL	IDE_WAIT_BUFFER		;WAIT FOR BUFFER READY SIGNAL FROM DRIVE
	RET	NC
	CALL	IDE_WRITE_BUFFER	;SEND 256 WORDS TO DRIVE'S BUFFER
	CALL	IDE_WAIT_BUSY_READY	;MAKE SURE DRIVE IS READY TO PROCEED
	RET	NC
	CALL	IDE_TEST_ERROR		;ENSURE NO ERROR WAS REPORTED
	RET	NC
	SCF				;CARRY = 1 ON RETURN = OPERATION OK
	RET

;-----------------------------------------------------------------------------


IDE_GET_ID:
	
	CALL	IDE_WAIT_BUSY_READY
	RET	NC
;	LD	A,010010110b		;KB IRQMASK=1,/CS1=1,/CS0=0,A0:A2=6
;	OUT	(IDE_CONTROL_PORT),A	
	LD	A,010100000b
;	OUT	(IDE_PORT_LO),A		;SELECT MASTER DEVICE
	OUT	(IDEHEAD),A		;SELECT MASTER DEVICE
	CALL	IDE_WAIT_BUSY_READY
	RET	NC
;	LD	A,010010111b		;KB IRQMASK=1,/CS1=1,/CS0=0,A0:A2=7
;	OUT	(IDE_CONTROL_PORT),A	
	LD	A,0ECh			
;	OUT	(IDE_PORT_LO),A		;0ECh = IDE 'ID DRIVE' COMMAND 
	OUT	(IDESTTS),A		;0ECh = IDE 'ID DRIVE' COMMAND 
	JR	IDE_SREX

;-----------------------------------------------------------------------------

IDE_SOFT_RESET

;	LD	A,010001110b		;KB IRQMASK=1,/CS1=0,/CS0=1,A0:A2=6
;	OUT	(IDE_CONTROL_PORT),A	;SELECT 2ND STATUS/RESET/IRQ REGISTER
	LD	A,000000110b		;NO INTERRUPTS, RESET DRIVE = 1
;	OUT	(IDE_PORT_LO),A
	OUT	(IDECTRL),A
	LD	A,000000010b		;NO INTERRUPTS, RESET DRIVE = 0
;	OUT	(IDE_PORT_LO),A
	OUT	(IDECTRL),A
	CALL	IDE_WAIT_BUSY_READY
	RET


;--------------------------------------------------------------------------------
; IDE INTERNAL SUBROUTINES 
;--------------------------------------------------------------------------------


IDE_WAIT_BUSY_READY:
	
;	LD	A,010010111b		;KB IRQMASK=1, /CS1=1,/CS0=0, A0:A2=7
;	OUT	(IDE_CONTROL_PORT),A	;SELECT STATUS REGISTER
	LD	DE,0

IDE_WBSY:
	LD	B,5

IDE_DLP:
	DJNZ	IDE_DLP
	INC	DE
	LD	A,D
	OR	E
	JR	Z,IDE_TO
;	IN	A,(IDE_PORT_LO)		;READ ERROR REG
	IN	A,(IDESTTS)		;READ ERROR REG
	AND	011000000b		;MASK OFF BUSY AND RDY BITS
	XOR	001000000b		;WE WANT BUSY(7) TO BE 0 AND RDY(6) TO BE 1
	JR	NZ,IDE_WBSY
	SCF				;CARRY 1 = OK
	RET

IDE_TO:
	XOR	A			;CARRY 0 = TIMED OUT
	RET
	
;----------------------------------------------------------------------------

IDE_TEST_ERROR:
	
	SCF
;	LD	A,010010111b		;KB IRQMASK=1,/CS1=1,/CS0=0,A0:A2=7
;	OUT	(IDE_CONTROL_PORT),A	
;	IN	A,(IDE_PORT_LO)
	IN	A,(IDESTTS)
	BIT	0,A			;TEST ERROR BIT
	RET	Z
	BIT	5,A
	JR	NZ,IDE_ERR		;TEST WRITE ERROR BIT
;	LD	A,010010001b		;KB IRQMASK=1, /CS1=1,/CS0=0, A0:A2=1
;	OUT	(IDE_CONTROL_PORT),A	;RETURN ERROR CODE IN A
;	IN	A,(IDE_PORT_LO)		;READ ERROR FLAGS
	IN	A,(IDEERR)		;READ ERROR FLAGS

IDE_ERR:
	OR	A			;CARRY 0 = ERROR
	RET				;IF A = 0, IDE BUSY TIMED OUT

;-----------------------------------------------------------------------------
	
IDE_WAIT_BUFFER:
	
;	LD	A,010010111b		;KB IRQMASK=1, /CS1=1,/CS0=0, A0:A2=7
;	OUT	(IDE_CONTROL_PORT),A	;SET TO READ STATUS REGISTER	
	LD	DE,0

IDE_WDRQ:
	LD	B,5

IDE_BLP:
	DJNZ	IDE_BLP
	INC	DE
	LD	A,D
	OR	E
	JR	Z,IDE_TO2
;	IN	A,(IDE_PORT_LO)		;WAIT FOR DRIVE'S 512 BYTE READ BUFFER 
	IN	A,(IDESTTS)		;WAIT FOR DRIVE'S 512 BYTE READ BUFFER 
	BIT	3,A			;TO FILL (OR READY TO FILL)
	JR	Z,IDE_WDRQ
	SCF				;CARRY 1 = OK
	RET

IDE_TO2:
	XOR	A			;CARRY 0 = TIMED OUT
	RET

;------------------------------------------------------------------------------

IDE_READ_BUFFER:

	PUSH	IX
	LD	IX,IDE_SECTOR_BUFFER
;	LD	A,010010000b		;KB IRQMASK=1,/CS1=1,/CS0=0,A0:A2=0
;	OUT	(IDE_CONTROL_PORT),A
	LD	B,0			;256 WORDS (512 BYTES PER SECTOR)

IDEBUFRD:
;	IN	A,(IDE_PORT_LO)		;LOW BYTE OF WORD FIRST	
	IN	A,(IDELO)		;LOW BYTE OF WORD FIRST	
	LD	(IX+1),A
;	IN	A,(IDE_PORT_HI)		;THEN HIGH BYTE OF WORD
	IN	A,(IDEHI)		;THEN HIGH BYTE OF WORD
	LD	(IX+0),A
	INC	IX
	INC	IX
	DJNZ	IDEBUFRD
	POP	IX
	RET
	
;-----------------------------------------------------------------------------

IDE_WRITE_BUFFER:

	PUSH	IX
	LD	IX,IDE_SECTOR_BUFFER
;	LD	A,010010000b		;KB IRQMASK=1,/CS1=1,/CS0=0,A0:A2=0
;	OUT	(IDE_CONTROL_PORT),A
	LD	B,0			;256 WORDS (512 BYTES PER SECTOR)

IDEBUFWT:
	LD	A,(IX)			
;	OUT	(IDE_PORT_HI),A		;SET UP HIGH LATCHED BYTE BEFORE
	OUT	(IDEHI),A		;SET UP HIGH LATCHED BYTE BEFORE
	LD	A,(IX+1)
;	OUT	(IDE_PORT_LO),A		;WRITING WORD WITH WRITE TO LOW BYTE
	OUT	(IDELO),A		;WRITING WORD WITH WRITE TO LOW BYTE
	INC	IX
	INC	IX
	DJNZ	IDEBUFWT
	POP	IX
	RET
	
;-----------------------------------------------------------------------------

IDE_SETUP_LBA:
	
;	LD	A,010010010b		;KB IRQMASK=1,/CS1=1,/CS0=0,A0:A2=2
;	OUT	(IDE_CONTROL_PORT),A	
	LD	A,1			
;	OUT	(IDE_PORT_LO),A		;SET SECTOR COUNT = 1	
	OUT	(IDESECTC),A		;SET SECTOR COUNT = 1	

;	LD	A,010010011b		;KB IRQMASK=1,/CS1=1,/CS0=0,A0:A2=3
;	OUT	(IDE_CONTROL_PORT),A	
	LD	A,(IDE_LBA0)
;	OUT	(IDE_PORT_LO),A		;SET LBA 0:7
	OUT	(IDESECTN),A		;SET LBA 0:7

;	LD	A,010010100b		;KB IRQMASK=1,/CS1=1,/CS0=0,A0:A2=4
;	OUT	(IDE_CONTROL_PORT),A	
	LD	A,(IDE_LBA1)
;	OUT	(IDE_PORT_LO),A		;SET LBA 8:15
	OUT	(IDECYLLO),A		;SET LBA 8:15

;	LD	A,010010101b		;KB IRQMASK=1,/CS1=1,/CS0=0,A0:A2=5
;	OUT	(IDE_CONTROL_PORT),A	
	LD	A,(IDE_LBA2)
;	OUT	(IDE_PORT_LO),A		;SET LBA 16:23
	OUT	(IDECYLHI),A		;SET LBA 16:23

;	LD	A,010010110b		;KB IRQMASK=1,/CS1=1,/CS0=0,A0:A2=6
;	OUT	(IDE_CONTROL_PORT),A	
	LD	A,(IDE_LBA3)
	AND	000001111b		;LOWEST 4 BITS USED ONLY
	OR	011100000b		;TO ENABLE LBA MODE
;	OUT	(IDE_PORT_LO),A		;SET LBA 24:27 + BITS 5:7=111
	OUT	(IDEHEAD),A		;SET LBA 24:27 + BITS 5:7=111
	RET
	
;******************************************************************
;*	FILL_MEM
;*	FUNCTION	: FILL MEMORY WITH A VALUE
;*      INPUT		: HL = START ADDRESS BLOCK
;*			: BC = LENGTH OF BLOCK
;			: A = VALUE TO FILL WITH
;*	USES		: DE, BC
;*	OUTPUT		:
;*	CALLS		: 
;*	TESTED		: 13 FEB 2007
;******************************************************************


FILL_MEM:

;; THIS CODE SNIPPET WILL SHOW ONE METHOD TO FILL A BLOCK
;; OF MEMORY WITH A SINGLE DATA BYTE USING Z80 ASSEMBLY
;; LANGUAGE 

;;--------------------------------------------------

					;; HL = START ADDRESS OF BLOCK
;	LD	HL,&4000

					;; DE = HL + 1
	LD	E,L
	LD	D,H
	INC	DE

					;; INITIALISE FIRST BYTE OF BLOCK
					;; WITH DATA BYTE (&00)
					;; WITH DATA BYTE IN A
;	LD	(HL),&00
	LD	(HL),A
	
					;; BC = LENGTH OF BLOCK IN BYTES
					;; HL+BC-1 = END ADDRESS OF BLOCK

;	LD	BC,&4000	

					;; FILL MEMORY
	LDIR

	RET				;; RETURN TO CALLER

;;--------------------------------------------------



;; FOR EACH ITERATION OF THE LDIR COMMAND:
;;
;; 1  THIS COMMAND WILL COPY THE BYTE FROM THE MEMORY 
;; ADDRESS POINTED TO BY HL TO THE MEMORY ADDRESS POINTED TO BY DE 
;; I E. (DE) = (HL).
;; 2  THEN HL AND DE WILL BE INCREMENTED. BC WILL BE DECREMENTED.
;;
;;
;; FOR THE FIRST BYTE:
;; 
;; HL = START
;; DE = START+1
;; BC = LENGTH
;; (HL)=0
;; 
;; FOR THE SECOND BYTE:
;; 
;; HL = START + 1 (INITIALISED TO 0 BY THE PREVIOUS ITERATION)
;; DE = START + 2
;; BC = LENGTH - 1
;;
;; FOR THE THIRD BYTE:
;;
;; HL = START + 2 (INITIALISED TO 0 BY THE PREVIOUS ITERATION)
;; DE = START + 3
;; BC = LENGTH - 2
;;
;; ETC ...






	
;-----------------------------------------------------------------------------

; TEXT CONSTANTS

MSG_START:
	 db  	"START IDE TEST PROGRAM"
	 DB	LF, CR			; LINE FEED AND CARRIAGE RETURN
	 DB	END			; LINE TERMINATOR

MSG_ERROR:
	 db  	"ERROR"
	 DB	LF, CR			; LINE FEED AND CARRIAGE RETURN
	 DB	END			; LINE TERMINATOR

MSG_D1:
	 db  	"PASSED IDE_WAIT_BUSY_READY"
	 DB	LF, CR			; LINE FEED AND CARRIAGE RETURN
	 DB	END			; LINE TERMINATOR

MSG_END:
	 db  	"END IDE TEST PROGRAM"
	 DB	LF, CR			; LINE FEED AND CARRIAGE RETURN
	 DB	END			; LINE TERMINATOR

; DATA MEMORY RESERVED RANGES FOR VARIABLES AND SECTOR BUFFER

IDE_LBA0:		 DS	001h	;SET LBA 0:7
IDE_LBA1:		 DS	001h	;SET LBA 8:15
IDE_LBA2:		 DS	001h	;SET LBA 16:23
IDE_LBA3:		 DS	001h	;LOWEST 4 BITS USED ONLY 
					;TO ENABLE LBA MODE 
					;SET LBA 24:27 + BITS 5:7=111
IDE_SECTOR_BUFFER:	 DS	00200h

	 END
