; ASSEMBLER ASIDE 1.14
; DTEST - Test Routines for CompuPro Disk Controller.
; DISK TEST
; COMPUPRO
; 0akland Airport
; Oak land , California 94611
; Copyright 1981, CompuPro Corporation.
; This product is a program product of CompuPro and is supplied for use with the
; Version number: 1.1B Version date: April 13, 1981 


BEGIN:     EQU       0100H
;Assembly Constants
FDPORT:    EQU       0C0H      ; Base port address for Controller
FDCS:      EQU       FDPORT    ; Status register
FDCD:      EQU       FDPORT+1  ; Data register
FDMA:      EQU       FDPORT+2  ; DMA address (when write)
INTS:      EQU       FDPORT+2  ; Status Register (when read)
SER:       EQU       FDPORT+3  ; Serial port
;Controller function definitions Specify (00) command
F_RTK:    =         02         ; Read track
F_SPEC:   =         03         ; Specify
F_DSTS:   =         04         ; Drive status
F_RDAT:   =         06         ; Read sector KM
F_DRDT:   =         46H        ; Read sector MFM
F_WRAT:   =         05         ; Write sector FM
F_WRDT:   =         45H        ; Write sector MFM
F_RECA:   =         07         ; Recalibrate
F_RSTS:   =         08         ; Read status
F_SEEK:   =         0FH        ; Seek
SRT:      =         16-8       ; = Shugart 800s (8 ms)
;                   16-3       : = Shugart 850s (3 ms)
;                   16-3       ; - Remex (3 ms)
HUT:      =         240/16     ; Head unload = 240 ms
HLT:      =         (35+1)/2   ; Head load = 35 ms
ND:       =         00         ; Set DMA mode
;JUMP TABLE FOR ROUTINES
;These routines are callable subroutines
;require parameters passed in the "A" and "C" registers
          ORG       BEGIN
START:    
          JP        DDMA      ; Load DMA address
          JP        DSPEC     ; Specity drive stat
          JP        RCAL      ; Recalibrate (treck 00)
          JP        DSEEK     ; Seek a treck
          JP        READS     ; Read sector (FM)
          JP        DREADS    ; Read sector (MFM)
          JP        WRS       ; Write sector (FM)
          JP        DWRS      ; Write sector (MFM)
;DMA address load routine using 16 bit value in HL register for the 24 bit DMA
DDMA: 
          LD        A,0       ; Extended address
          OUT       (FDMA),A  ; Output
          LD        A,H       ; High byte
          OUT       (FDMA),A  ; Output
          LD        A,L       ; Low byte
          OUT       (FDMA),A  ; Output
          RET

;Drive Specify Command
DSPEC:    
          LD        B,LSPEC   ; 3 byte command
          LD        DE,SPEC   ; Point to command bytes
SPEC1:    
          IN        A,(FDCS)  ; Get status
          AND       0C0H      ;
          CP        80H       ;
          JP        NZ,SPEC1  ; If no master ready bit
          LD        A,(DE)    ; Load command byte
          OUT       (FDCD),A  ; To controller
          INC       DE        ; Next byte
          DEC       B         ; Dec. counter
          JP        NZ,SPEC1  ; If more bytes
          RET

;Recalibrate drive (seek track 0)
RCAL:     
          LD        B,LRECAL  ; 2 byte command
          LD        DE,RECAL  ; Point to command bytes
RCAL1:    
          IN        A,(FDCS)  ; Get status
          AND       0C0H      ;
          CP        80H       ;
          JP        NZ,RCAL1  ; If no master ready bit
          LD        A,(DE)    ; Load command byte
          OUT       (FDCD),A  ; To controller
          INC       DE        ;
          DEC       B         ;
          JP        NZ,RCAL1  ; If more bytes
          RET

;Seek a Track with cylinder number in "A"
 
DSEEK:    LD        B,LSEEK   ; 3 byte command
          LD        DE,SEEK   ; Point to command bytes
          LD        (CYLD),A  ; Store cylinder ,
SEEK1:    
          IN        A,(FDCS)  ; Check status
          AND       0C0H      ;
          CP        80H       ;
          JP        NZ,SEEK1  ; If not ready
          LD        A,(DE)    ; Load command byte
          OUT       (FDCD),A  ; To controller
          INC       DE        ;
          DEC       B         ;
          JP        NZ,SEEK1  ; If more bytes
          RET
                           ;
;FM Sector read command with sector in "A" and cylinder in "C"
READS:    
          LD        B,LREAD   ; BYTE COMMAND
          LD        DE,READ   ; Point to command bytes
          LD        (RSEC),A  ; Store sector number
          LD        A,C       ;
          LD        (RSCYL),A ; Store cylinder number
READ1:                        ;
          IN        A,(FDCS)  ; Check status
          OR        A         ;
          JP        P,READ1   ; If no master ready bit
          LD        A,(DE)    ; Load command byte
          OUT       (FDCD),A  ; To controller
          INC       DE        ;
          DEC       B         ;
          JP        NZ,READ1  ; If more bytes
READ2:    
          IN        A,(INTS)  ; Check interrupt status
          OR        A         ; For read complete
          JP        P,READ2   ; If not complete
READ3:    
          IN        A,(FDCS)  ; In status
          OR        A
          JP        P,READ3   ; If not ready
          IN        A,(FDCD)  ; Read result byte ST0
          SUB       40H       ; Strip
          LD        L,A       ; Save
READ4:    
          IN        A,(FDCS)  ; In status
          OR        A         ;
          JP        P,READ4   ; If not ready
          IN        A,(FDCD)  ; Read result byte ST1
          SUB       80H       ; Strip
          LD        H,A       ; Save
          LD        B,7-2     ; 5 more bytes)
READ5:    
          IN        A,(FDCS)  ; in status
          OR        A         ;
          JP        P,READ5   ; If not ready
          IN        A,(FDCD)  ; Read result byte
          DEC       B         ;
          JP        NZ,READ5  ; WAIT, UNTIL ALL DONE
          LD        A,L       ; Check results
          OR        H         ;
          RET       Z         ; Return no error
          SCF                 ; set carry
          RET                 ; Return from error

;MFM Sector read command with sector in "A" and cylinder in "C"
DREADS:    
          LD        B,DLREAD  ; 9 BYTE COMMAND
          LD        DE,DREAD  ; Point to command bytes
          LD        (DRSEC),A ; Store sector number
          LD        A,C       ;
          LD        (DCYL),A  ; Store cylinder number
DREAD1:                       ;
          IN        A,(FDCS)  ; Check status
          OR        A         ;
          JP        P,DREAD1  ; If no master ready bit
          LD        A,(DE)    ; Load command byte
          OUT       (FDCD),A  ; To controller
          INC       DE        ;
          DEC       B         ;
          JP        NZ,DREAD  ; If more bytes
          JP        READ2     ;

;FM Sector write command with sector in "A" cylinder number in "C"
WRS:      
          LD        B,LWR     ; 9 byte command
          LD        DE,WR     ; Point to command bytes
          LD        (WSEC),A  ; Store sector number
          LD        A,C       ;
          LD        (WSCYL),A ; Store cylinder number
WR1:      
          IN        A,(FDCS)  ; Check status
          OR        A         ;
          JP        P,WR1     ; If no master ready bit
          LD        A,(DE)    ; Load command byte          
          OUT       (FDCD),A  ; To controller
          INC       DE        ;
          DEC       B         ;
          JP        NZ,WR1    ; if more bytes
          JP        READ1     ;  

;MFM Sector write command with sector in "A" and cylinder in "C"
DWRS:     
          LD        B,DLWR    ; 9 byte command
          LD        DE,DWR    ; Point to command bytes
          LD        (DWSEC),A ; Store sector number
          LD        A,C
          LD        (DWRCYL),A  ; Store cylinder number
DWR1:     
          IN        A,(FDCS)  ; Check status
          OR        A
          JP        P,DWR1    ; If no master ready bit
          LD        A,(DE)    ; Load command byte
          OUT       (FDCD),A  ; To controller
          INC       DE        ;
          DEC       B         ;
          JP        NZ,DWR1   ; It more bytes
          JP        READ2

;**************************************************************************
; Function data for controller
SPEC:    DEFB       F_SPEC ; Specify command
         DEFB       (srt shl 4)+hut  ;; VFD     4+SRT,4.HUT
         DEFB       (hlt shl 1)+nd   ;; VFD     7.HLT,1.ND

;**************************************************************************
; ACT ASSEMBLER 
;
;SPEC    DB      F$SPEC
;;+      VFD     4\SRT,4\HUT
;        db      (srt shl 4)+hut
;;+      VFD     7\HLT,l\ND
;        db      (hdlt shl 1)+nd
;LSPEC   equ     $-SPEC
;
;
;**************************************************************************
LSPEC:    =         $-SPEC    ;
RECAL:    DEFB      F_RECA,0  ; Recalibrate command
LRECAL:   =         $-RECAL   ;
SEEK:     DEFB      F_SEEK    ; Seek command
          DEFB      0         ;
CYLD:     DEFB      0         ;
LSEEK:    =         $-SEEK    ;
READ:     DEFB      F_RDAT    ; Read commaed (FM)
          DEFB      0         ; hds,ds1,ds0
RSCYL:    DEFB      0         ; C cylinder info
          DEFB      0         ; Head
RSEC:     DEFB      1         ; Record (first sector)
          DEFB      0         ; N 128 BYTE SECTOR
          DEFB      25        ; EOT (last sectors)
          DEFB      7         ; GPL
          DEFB      128       ; DTL
LREAD:    =         $-READ    ;
DREAD:    DEFB      F_DRDT    ; Read command (MFM)
          DEFB      0         ; hds,ds1,ds0
DCYL:     DEFB      2         ; C = cylinder info
          DEFB      0         ; Head 
DRSEC:    DEFB      1         ; Record (first sector)
          DEFB      3         ; N 1024 BYTE SECTOR
          DEFB      7         ; EOT (last sectors)          
          DEFB      35H       ; GPL 
          DEFB      0         ; DTL
DLREAD:   =         $-DREAD   ;
WR:       DEFB      F_WRAT    ; Write command (FM)
          DEFB      0         ; hds,ds1,ds0       
WSCYL:    DEFB      0         ; C = cylinder info Hds,ds1,ds0
          DEFB      0         ; Head
WSEC:     DEFB      1         ; Record (first sector)
          DEFB      0         ; N 128 BYTE SECTOR
          DEFB      25        ; EOT (last sectors)
          DEFB      7         ; GPL
          DEFB      128       ; DTL
LWR:      =         $-WR      ;
DWR:      DEFB      F_WRDT    ; Write command (MFM)
          DEFB      0         ; hds,ds1,ds0              
DWRCYL:   DEFB      2         ; C = cylinder info
          DEFB      0         ; Head      
DWSEC:    DEFB      1         ; Record (first sector)
          DEFB      3         ; N 1024 BYTE SECTOR
          DEFB      7         ; EOT (last sectors)
          DEFB      35H       ; GPL
          DEFB      0         ; DTL

DLWR:     =         $-DWR     ;

          END
          
