;***********************************
;*	Z80 Test Prototype
;*	LOAD MONITOR FROM ROM INTO RAM AND EXECUTE Program
;*	Andrew Lynch
;*	lynchaj@yahoo.com
;*	15 Feb 2007
;***********************************


;********************* CONSTANTS ****************************************

RAMTOP:		.EQU	$FFFF	; HIGHEST ADDRESSABLE MEMORY LOCATION
MONSTART:	.EQU	$8000	; START OF MONITOR
RAMBOTTOM:	.EQU	$8000	; Beginning of Upper 32K RAM page
END:		.EQU	$FF	; Mark END OF TEXT
CR:		.EQU	0DH	; ASCII carriage return character
LF:		.EQU	0AH	; ASCII line feed character
ESC:		.EQU	1BH	; ASCII escape character

ROMSTART_MON:	.EQU	$0100	; Where the Monitor is stored in ROM
RAMTARG_MON:	.EQU	$8000	; Where the Monitor starts in RAM (entry point)
MOVSIZ_MON:	.EQU	$1000	; Monitor is 2KB in length

ROMSTART_CPM:	.EQU	$1200	; Where the CCP+BDOS+BIOS is stored in ROM
RAMTARG_CPM:	.EQU	$D400	; Where the CCP+BDOS+BIOS starts in RAM (entry point)
MOVSIZ_CPM:	.EQU	$2A00	; CCP, BDOS, + BIOS is 6-7KB in length

Monitor_Entry	.EQU	$8000	; Monitor Entry Point (May change)



;*******************************************************************
;*	START AFTER RESET
;*	Function	: ready system, load monitor into RAM and start
;*******************************************************************

	.ORG	$0000
	DI			; Disable interrupt
	LD	SP,RAMTOP	; Set stack pointer to top off ram
	IM	1		; Set interrupt mode 1

	LD	HL,ROMSTART_MON	; where in rom Monitor is stored (first byte)
        LD	DE,RAMTARG_MON	; where in ram to move Monitor to (first byte)
	LD	BC,MOVSIZ_MON	; number of bytes to move from ROM to RAM
	LDIR			; Perform Block Copy of Monitor to Upper RAM page

	LD	HL,ROMSTART_CPM	; where in rom CP/M is stored (first byte)
        LD	DE,RAMTARG_CPM	; where in ram to move Monitor to (first byte)
	LD	BC,MOVSIZ_CPM	; number of bytes to move from ROM to RAM
	LDIR			; Perform Block Copy of CP/M to Upper RAM page

	EI			; enable interrupts (access to Monitor while CP/M running)
	JP	$MONSTART	; jump to Start of Monitor


;************************************************************************
;*	MASKABLE INTERRUPT-PROGRAM
;*	Function	:
;*	Input		:
;*	Output		: 
;*	uses		: 
;*	calls		: none
;*	info		:
;*	tested		: 2 Feb 2007
;************************************************************************

	.ORG	$0038		; Int mode 1
;	DI			; disable
	JP	$Monitor_Entry	; Go to Monitor
;	EI			; enable again
	RETI			; return from interrupt


;************************************************************************
;*	NONMASKABLE INTERRUPT-PROGRAM
;*	Function	:
;*	Input		:
;*	Output		: none
;*	uses		: 
;*	calls		: none
;*	info		:
;*	tested		: 2 Feb 2007
;************************************************************************

	.ORG	$0066		; HERE IS THE NMI ROUTINE
	RETI

	.ORG	$00FF
FLAG	.db	$FF

.END
